/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned.rss.expanded.decoders;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.rss.expanded.decoders.BlockParsedResult;
import com.dcloud.zxing2.oned.rss.expanded.decoders.CurrentParsingState;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedChar;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedInformation;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedNumeric;
import com.dcloud.zxing2.oned.rss.expanded.decoders.DecodedObject;
import com.dcloud.zxing2.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final BitArray information;
    private final CurrentParsingState current;
    private final StringBuilder buffer;

    GeneralAppIdDecoder(BitArray bitArray) {
        StringBuilder stringBuilder;
        CurrentParsingState currentParsingState;
        Object object = currentParsingState;
        currentParsingState = new CurrentParsingState();
        v1.current = object;
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        v1.buffer = object;
        v1.information = bitArray;
    }

    private boolean isStillNumeric(int n5) {
        int n6;
        if (n5 + 7 > this.information.getSize()) {
            return n5 + 4 <= this.information.getSize();
        }
        for (int i5 = n5; i5 < (n6 = n5 + 3); ++i5) {
            if (!this.information.get(i5)) continue;
            return true;
        }
        return this.information.get(n6);
    }

    private DecodedNumeric decodeNumeric(int n5) throws FormatException {
        int n6 = n5 + 7;
        if (n6 > this.information.getSize()) {
            if ((n5 = this.extractNumericValueFromBitArray(n5, 4)) == 0) {
                return new DecodedNumeric(this.information.getSize(), 10, 10);
            }
            int n7 = this.information.getSize();
            return new DecodedNumeric(n7, n5 - 1, 10);
        }
        int n8 = this.extractNumericValueFromBitArray(n5, 7) - 8;
        int n9 = n8 / 11;
        n5 = n8 % 11;
        return new DecodedNumeric(n6, n9, n5);
    }

    static int extractNumericValueFromBitArray(BitArray bitArray, int n5, int n6) {
        int n7 = 0;
        for (int i5 = 0; i5 < n6; ++i5) {
            if (!bitArray.get(n5 + i5)) continue;
            n7 |= 1 << n6 - i5 - 1;
        }
        return n7;
    }

    private DecodedInformation parseBlocks() throws FormatException {
        BlockParsedResult blockParsedResult;
        boolean bl;
        int n5;
        do {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            n5 = generalAppIdDecoder.current.getPosition();
            if (generalAppIdDecoder.current.isAlpha()) {
                blockParsedResult = this.parseAlphaBlock();
                bl = blockParsedResult.isFinished();
                continue;
            }
            if (this.current.isIsoIec646()) {
                blockParsedResult = this.parseIsoIec646Block();
                bl = blockParsedResult.isFinished();
                continue;
            }
            blockParsedResult = this.parseNumericBlock();
            bl = blockParsedResult.isFinished();
        } while ((n5 != this.current.getPosition() || bl) && !bl);
        return blockParsedResult.getDecodedInformation();
    }

    private BlockParsedResult parseNumericBlock() throws FormatException {
        while (true) {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillNumeric(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            Object object = generalAppIdDecoder2.decodeNumeric(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(((DecodedObject)object).getNewPosition());
            if (((DecodedNumeric)object).isFirstDigitFNC1()) {
                if (((DecodedNumeric)object).isSecondDigitFNC1()) {
                    DecodedInformation decodedInformation;
                    object = decodedInformation;
                    decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                } else {
                    DecodedInformation decodedInformation;
                    DecodedInformation decodedInformation2 = decodedInformation;
                    DecodedObject decodedObject = object;
                    GeneralAppIdDecoder generalAppIdDecoder3 = this;
                    int n5 = generalAppIdDecoder3.current.getPosition();
                    object = generalAppIdDecoder3.buffer.toString();
                    int n6 = ((DecodedNumeric)decodedObject).getSecondDigit();
                    decodedInformation = new DecodedInformation(n5, (String)object, n6);
                    object = decodedInformation2;
                }
                return new BlockParsedResult((DecodedInformation)object, true);
            }
            this.buffer.append(((DecodedNumeric)object).getFirstDigit());
            if (((DecodedNumeric)object).isSecondDigitFNC1()) {
                DecodedInformation decodedInformation;
                object = decodedInformation;
                decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)object, true);
            }
            this.buffer.append(((DecodedNumeric)object).getSecondDigit());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isNumericToAlphaNumericLatch(generalAppIdDecoder.current.getPosition())) {
            GeneralAppIdDecoder generalAppIdDecoder4 = this;
            generalAppIdDecoder4.current.setAlpha();
            generalAppIdDecoder4.current.incrementPosition(4);
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseIsoIec646Block() throws FormatException {
        while (true) {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillIsoIec646(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedObject decodedObject = generalAppIdDecoder2.decodeIsoIec646(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(decodedObject.getNewPosition());
            if (((DecodedChar)decodedObject).isFNC1()) {
                DecodedInformation decodedInformation;
                decodedObject = decodedInformation;
                decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)decodedObject, true);
            }
            this.buffer.append(((DecodedChar)decodedObject).getValue());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isAlphaOr646ToNumericLatch(generalAppIdDecoder.current.getPosition())) {
            GeneralAppIdDecoder generalAppIdDecoder3 = this;
            generalAppIdDecoder3.current.incrementPosition(3);
            generalAppIdDecoder3.current.setNumeric();
        } else {
            GeneralAppIdDecoder generalAppIdDecoder4 = this;
            if (generalAppIdDecoder4.isAlphaTo646ToAlphaLatch(generalAppIdDecoder4.current.getPosition())) {
                if (this.current.getPosition() + 5 < this.information.getSize()) {
                    this.current.incrementPosition(5);
                } else {
                    this.current.setPosition(this.information.getSize());
                }
                this.current.setAlpha();
            }
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseAlphaBlock() {
        while (true) {
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillAlpha(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedObject decodedObject = generalAppIdDecoder2.decodeAlphanumeric(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(decodedObject.getNewPosition());
            if (((DecodedChar)decodedObject).isFNC1()) {
                DecodedInformation decodedInformation;
                decodedObject = decodedInformation;
                decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)decodedObject, true);
            }
            this.buffer.append(((DecodedChar)decodedObject).getValue());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isAlphaOr646ToNumericLatch(generalAppIdDecoder.current.getPosition())) {
            GeneralAppIdDecoder generalAppIdDecoder3 = this;
            generalAppIdDecoder3.current.incrementPosition(3);
            generalAppIdDecoder3.current.setNumeric();
        } else {
            GeneralAppIdDecoder generalAppIdDecoder4 = this;
            if (generalAppIdDecoder4.isAlphaTo646ToAlphaLatch(generalAppIdDecoder4.current.getPosition())) {
                if (this.current.getPosition() + 5 < this.information.getSize()) {
                    this.current.incrementPosition(5);
                } else {
                    this.current.setPosition(this.information.getSize());
                }
                this.current.setIsoIec646();
            }
        }
        return new BlockParsedResult(false);
    }

    private boolean isStillIsoIec646(int n5) {
        if (n5 + 5 > this.information.getSize()) {
            return false;
        }
        int n6 = this.extractNumericValueFromBitArray(n5, 5);
        if (n6 >= 5 && n6 < 16) {
            return true;
        }
        if (n5 + 7 > this.information.getSize()) {
            return false;
        }
        n6 = this.extractNumericValueFromBitArray(n5, 7);
        if (n6 >= 64 && n6 < 116) {
            return true;
        }
        if (n5 + 8 > this.information.getSize()) {
            return false;
        }
        int n7 = this.extractNumericValueFromBitArray(n5, 8);
        return n7 >= 232 && n7 < 253;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DecodedChar decodeIsoIec646(int n5) throws FormatException {
        char c6;
        int n6 = this.extractNumericValueFromBitArray(n5, 5);
        if (n6 == 15) {
            return new DecodedChar(n5 + 5, '$');
        }
        if (n6 >= 5 && n6 < 15) {
            int n7 = n5 + 5;
            return new DecodedChar(n7, (char)(n6 + 43));
        }
        n6 = this.extractNumericValueFromBitArray(n5, 7);
        if (n6 >= 64 && n6 < 90) {
            int n8 = n5 + 7;
            return new DecodedChar(n8, (char)(n6 + 1));
        }
        if (n6 >= 90 && n6 < 116) {
            int n9 = n5 + 7;
            return new DecodedChar(n9, (char)(n6 + 7));
        }
        switch (this.extractNumericValueFromBitArray(n5, 8)) {
            default: {
                throw FormatException.getFormatInstance();
            }
            case 252: {
                c6 = ' ';
                break;
            }
            case 251: {
                c6 = '_';
                break;
            }
            case 250: {
                c6 = '?';
                break;
            }
            case 249: {
                c6 = '>';
                break;
            }
            case 248: {
                c6 = '=';
                break;
            }
            case 247: {
                c6 = '<';
                break;
            }
            case 246: {
                c6 = ';';
                break;
            }
            case 245: {
                c6 = ':';
                break;
            }
            case 244: {
                c6 = '/';
                break;
            }
            case 243: {
                c6 = '.';
                break;
            }
            case 242: {
                c6 = '-';
                break;
            }
            case 241: {
                c6 = ',';
                break;
            }
            case 240: {
                c6 = '+';
                break;
            }
            case 239: {
                c6 = '*';
                break;
            }
            case 238: {
                c6 = ')';
                break;
            }
            case 237: {
                c6 = '(';
                break;
            }
            case 236: {
                c6 = '\'';
                break;
            }
            case 235: {
                c6 = '&';
                break;
            }
            case 234: {
                c6 = '%';
                break;
            }
            case 233: {
                c6 = '\"';
                break;
            }
            case 232: {
                c6 = '!';
            }
        }
        char c7 = c6;
        return new DecodedChar(n5 + 8, c7);
    }

    private boolean isStillAlpha(int n5) {
        if (n5 + 5 > this.information.getSize()) {
            return false;
        }
        int n6 = this.extractNumericValueFromBitArray(n5, 5);
        if (n6 >= 5 && n6 < 16) {
            return true;
        }
        if (n5 + 6 > this.information.getSize()) {
            return false;
        }
        int n7 = this.extractNumericValueFromBitArray(n5, 6);
        return n7 >= 16 && n7 < 63;
    }

    private DecodedChar decodeAlphanumeric(int n5) {
        int n6 = this.extractNumericValueFromBitArray(n5, 5);
        if (n6 == 15) {
            return new DecodedChar(n5 + 5, '$');
        }
        if (n6 >= 5 && n6 < 15) {
            int n7 = n5 + 5;
            return new DecodedChar(n7, (char)(n6 + 43));
        }
        int n8 = this.extractNumericValueFromBitArray(n5, 6);
        if (n8 >= 32 && n8 < 58) {
            int n9 = n8;
            n8 = n5 + 6;
            return new DecodedChar(n8, (char)(n9 + 33));
        }
        switch (n8) {
            default: {
                throw new IllegalStateException("Decoding invalid alphanumeric value: " + n8);
            }
            case 62: {
                n8 = 47;
                break;
            }
            case 61: {
                n8 = 46;
                break;
            }
            case 60: {
                n8 = 45;
                break;
            }
            case 59: {
                n8 = 44;
                break;
            }
            case 58: {
                n8 = 42;
            }
        }
        return new DecodedChar(n5 + 6, (char)n8);
    }

    private boolean isAlphaTo646ToAlphaLatch(int n5) {
        int n6;
        if (n5 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i5 = 0; i5 < 5 && (n6 = i5 + n5) < this.information.getSize(); ++i5) {
            if (!(i5 == 2 ? !this.information.get(n5 + 2) : this.information.get(n6))) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaOr646ToNumericLatch(int n5) {
        int n6 = n5 + 3;
        if (n6 > this.information.getSize()) {
            return false;
        }
        while (n5 < n6) {
            if (this.information.get(n5)) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int n5) {
        int n6;
        if (n5 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i5 = 0; i5 < 4 && (n6 = i5 + n5) < this.information.getSize(); ++i5) {
            if (!this.information.get(n6)) continue;
            return false;
        }
        return true;
    }

    String decodeAllCodes(StringBuilder stringBuilder, int n5) throws NotFoundException, FormatException {
        Object object = null;
        while (true) {
            String string2;
            if ((string2 = FieldParser.parseFieldsInGeneralPurpose(((DecodedInformation)(object = this.decodeGeneralPurposeField(n5, (String)object))).getNewString())) != null) {
                stringBuilder.append(string2);
            }
            string2 = ((DecodedInformation)object).isRemaining() ? String.valueOf(((DecodedInformation)object).getRemainingValue()) : null;
            if (n5 == ((DecodedObject)object).getNewPosition()) {
                return stringBuilder.toString();
            }
            n5 = ((DecodedObject)object).getNewPosition();
            object = string2;
        }
    }

    int extractNumericValueFromBitArray(int n5, int n6) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, n5, n6);
    }

    DecodedInformation decodeGeneralPurposeField(int n5, String string2) throws FormatException {
        this.buffer.setLength(0);
        if (string2 != null) {
            this.buffer.append(string2);
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        generalAppIdDecoder.current.setPosition(n5);
        Object object = generalAppIdDecoder.parseBlocks();
        if (object != null && ((DecodedInformation)object).isRemaining()) {
            DecodedInformation decodedInformation = object;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            int n6 = generalAppIdDecoder2.current.getPosition();
            object = generalAppIdDecoder2.buffer.toString();
            int n7 = decodedInformation.getRemainingValue();
            return new DecodedInformation(n6, (String)object, n7);
        }
        return new DecodedInformation(this.current.getPosition(), this.buffer.toString());
    }
}

