/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] nArray) {
        int n5 = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(nArray));
        if (n5 != -1) {
            return n5;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(nArray);
    }

    private static int[] sampleBitCounts(int[] nArray) {
        float f5 = PDF417Common.getBitCountSum(nArray);
        int[] nArray2 = new int[8];
        int n5 = 0;
        int n6 = 0;
        for (int i5 = 0; i5 < 17; ++i5) {
            int n7;
            float f6 = f5 / 34.0f + (float)i5 * f5 / 17.0f;
            int n8 = nArray[n5];
            if ((float)(n6 + n7) <= f6) {
                n6 += n8;
                ++n5;
            }
            nArray2[n5] = nArray2[n5] + 1;
        }
        return nArray2;
    }

    private static int getDecodedCodewordValue(int[] nArray) {
        int n5 = PDF417CodewordDecoder.getBitValue(nArray);
        if (PDF417Common.getCodeword(n5) == -1) {
            return -1;
        }
        return n5;
    }

    private static int getBitValue(int[] nArray) {
        long l5 = 0L;
        for (int i5 = 0; i5 < nArray.length; ++i5) {
            for (int i6 = 0; i6 < nArray[i5]; ++i6) {
                l5 <<= 1;
                long l6 = i5 % 2 == 0 ? 1 : 0;
                l5 |= l6;
            }
        }
        return (int)l5;
    }

    private static int getClosestDecodedValue(int[] nArray) {
        int n5 = PDF417Common.getBitCountSum(nArray);
        int n6 = 8;
        float[] fArray = new float[8];
        for (int i5 = 0; i5 < n6; ++i5) {
            fArray[i5] = (float)nArray[i5] / (float)n5;
        }
        float f5 = Float.MAX_VALUE;
        n5 = -1;
        n6 = 0;
        while (true) {
            float[][] fArray2 = RATIOS_TABLE;
            if (n6 >= RATIOS_TABLE.length) break;
            float f6 = 0.0f;
            float[] fArray3 = fArray2[n6];
            for (int i6 = 0; i6 < 8; ++i6) {
                float f7;
                float f8 = fArray3[i6] - fArray[i6];
                f6 += f8 * f8;
                if (f7 >= f5) break;
            }
            if (f6 < f5) {
                int n7 = PDF417Common.SYMBOL_TABLE[n6];
                f5 = f6;
                n5 = n7;
            }
            ++n6;
        }
        return n5;
    }

    static {
        int n5 = 0;
        while (true) {
            int[] nArray = PDF417Common.SYMBOL_TABLE;
            if (n5 >= PDF417Common.SYMBOL_TABLE.length) break;
            int n6 = nArray[n5];
            int n7 = n6 & 1;
            for (int i5 = 0; i5 < 8; ++i5) {
                int n8;
                float f5 = 0.0f;
                while ((n8 = n6 & 1) == n7) {
                    f5 += 1.0f;
                    n6 >>= 1;
                }
                n7 = 7 - i5;
                PDF417CodewordDecoder.RATIOS_TABLE[n5][n7] = f5 / 17.0f;
                n7 = n8;
            }
            ++n5;
        }
    }
}

