/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.renderer.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.util.DanmakuUtils;

public class DanmakusRetainer {
    private IDanmakusRetainer rldrInstance = null;
    private IDanmakusRetainer lrdrInstance = null;
    private IDanmakusRetainer ftdrInstance = null;
    private IDanmakusRetainer fbdrInstance = null;

    public DanmakusRetainer(boolean alignBottom) {
        this.alignBottom(alignBottom);
    }

    public void alignBottom(boolean alignBottom) {
        this.rldrInstance = alignBottom ? new AlignBottomRetainer() : new AlignTopRetainer();
        IDanmakusRetainer iDanmakusRetainer = this.lrdrInstance = alignBottom ? new AlignBottomRetainer() : new AlignTopRetainer();
        if (this.ftdrInstance == null) {
            this.ftdrInstance = new FTDanmakusRetainer();
        }
        if (this.fbdrInstance == null) {
            this.fbdrInstance = new AlignBottomRetainer();
        }
    }

    public void fix(BaseDanmaku danmaku, IDisplayer disp, Verifier verifier) {
        int type = danmaku.getType();
        switch (type) {
            case 1: {
                this.rldrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 6: {
                this.lrdrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 5: {
                this.ftdrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 4: {
                this.fbdrInstance.fix(danmaku, disp, verifier);
                break;
            }
            case 7: {
                danmaku.layout(disp, 0.0f, 0.0f);
            }
        }
    }

    public void clear() {
        if (this.rldrInstance != null) {
            this.rldrInstance.clear();
        }
        if (this.lrdrInstance != null) {
            this.lrdrInstance.clear();
        }
        if (this.ftdrInstance != null) {
            this.ftdrInstance.clear();
        }
        if (this.fbdrInstance != null) {
            this.fbdrInstance.clear();
        }
    }

    public void release() {
        this.clear();
    }

    private static class AlignBottomRetainer
    extends FTDanmakusRetainer {
        protected Danmakus mVisibleDanmakus = new Danmakus(2);

        private AlignBottomRetainer() {
        }

        @Override
        public void fix(BaseDanmaku drawItem, IDisplayer disp, Verifier verifier) {
            if (drawItem.isOutside()) {
                return;
            }
            boolean shown = drawItem.isShown();
            float topPos = shown ? drawItem.getTop() : -1.0f;
            int lines = 0;
            boolean willHit = !shown && !this.mVisibleDanmakus.isEmpty();
            boolean isOutOfVerticalEdge = false;
            if (topPos < 0.0f) {
                topPos = (float)disp.getHeight() - drawItem.paintHeight;
            }
            BaseDanmaku removeItem = null;
            BaseDanmaku firstItem = null;
            if (!shown) {
                this.mCancelFixingFlag = false;
                IDanmakuIterator it = this.mVisibleDanmakus.iterator();
                while (!this.mCancelFixingFlag && it.hasNext()) {
                    ++lines;
                    BaseDanmaku item = it.next();
                    if (item == drawItem) {
                        removeItem = null;
                        willHit = false;
                        break;
                    }
                    if (firstItem == null && (firstItem = item).getBottom() != (float)disp.getHeight()) break;
                    if (topPos < 0.0f) {
                        removeItem = null;
                        break;
                    }
                    willHit = DanmakuUtils.willHitInDuration(disp, item, drawItem, drawItem.getDuration(), drawItem.getTimer().currMillisecond);
                    if (!willHit) {
                        removeItem = item;
                        break;
                    }
                    topPos = item.getTop() - drawItem.paintHeight;
                }
                if (isOutOfVerticalEdge = this.isOutVerticalEdge(false, drawItem, disp, topPos, firstItem, null)) {
                    topPos = (float)disp.getHeight() - drawItem.paintHeight;
                    willHit = true;
                    lines = 1;
                } else {
                    if (topPos >= 0.0f) {
                        willHit = false;
                    }
                    if (removeItem != null) {
                        --lines;
                    }
                }
            }
            if (verifier != null && verifier.skipLayout(drawItem, topPos, lines, willHit)) {
                return;
            }
            if (isOutOfVerticalEdge) {
                this.clear();
            }
            drawItem.layout(disp, drawItem.getLeft(), topPos);
            if (!shown) {
                this.mVisibleDanmakus.removeItem(removeItem);
                this.mVisibleDanmakus.addItem(drawItem);
            }
        }

        @Override
        protected boolean isOutVerticalEdge(boolean overwriteInsert, BaseDanmaku drawItem, IDisplayer disp, float topPos, BaseDanmaku firstItem, BaseDanmaku lastItem) {
            return topPos < 0.0f || firstItem != null && firstItem.getBottom() != (float)disp.getHeight();
        }

        @Override
        public void clear() {
            this.mCancelFixingFlag = true;
            this.mVisibleDanmakus.clear();
        }
    }

    private static class FTDanmakusRetainer
    extends AlignTopRetainer {
        private FTDanmakusRetainer() {
        }

        @Override
        protected boolean isOutVerticalEdge(boolean overwriteInsert, BaseDanmaku drawItem, IDisplayer disp, float topPos, BaseDanmaku firstItem, BaseDanmaku lastItem) {
            return topPos + drawItem.paintHeight > (float)disp.getHeight();
        }
    }

    private static class AlignTopRetainer
    implements IDanmakusRetainer {
        protected Danmakus mVisibleDanmakus = new Danmakus(1);
        protected boolean mCancelFixingFlag = false;

        private AlignTopRetainer() {
        }

        @Override
        public void fix(BaseDanmaku drawItem, IDisplayer disp, Verifier verifier) {
            if (drawItem.isOutside()) {
                return;
            }
            float topPos = 0.0f;
            int lines = 0;
            boolean shown = drawItem.isShown();
            boolean willHit = !shown && !this.mVisibleDanmakus.isEmpty();
            boolean isOutOfVertialEdge = false;
            BaseDanmaku removeItem = null;
            if (!shown) {
                this.mCancelFixingFlag = false;
                IDanmakuIterator it = this.mVisibleDanmakus.iterator();
                BaseDanmaku insertItem = null;
                BaseDanmaku firstItem = null;
                BaseDanmaku lastItem = null;
                BaseDanmaku minRightRow = null;
                boolean overwriteInsert = false;
                while (!this.mCancelFixingFlag && it.hasNext()) {
                    ++lines;
                    BaseDanmaku item = it.next();
                    if (item == drawItem) {
                        insertItem = item;
                        lastItem = null;
                        shown = true;
                        willHit = false;
                        break;
                    }
                    if (firstItem == null) {
                        firstItem = item;
                    }
                    if (drawItem.paintHeight + item.getTop() > (float)disp.getHeight()) {
                        overwriteInsert = true;
                        break;
                    }
                    if (minRightRow == null) {
                        minRightRow = item;
                    } else if (minRightRow.getRight() >= item.getRight()) {
                        minRightRow = item;
                    }
                    willHit = DanmakuUtils.willHitInDuration(disp, item, drawItem, drawItem.getDuration(), drawItem.getTimer().currMillisecond);
                    if (!willHit) {
                        insertItem = item;
                        break;
                    }
                    lastItem = item;
                }
                boolean checkEdge = true;
                if (insertItem != null) {
                    topPos = lastItem != null ? lastItem.getBottom() : insertItem.getTop();
                    if (insertItem != drawItem) {
                        removeItem = insertItem;
                        shown = false;
                    }
                } else if (overwriteInsert && minRightRow != null) {
                    topPos = minRightRow.getTop();
                    checkEdge = false;
                    shown = false;
                } else if (lastItem != null) {
                    topPos = lastItem.getBottom();
                    willHit = false;
                } else if (firstItem != null) {
                    topPos = firstItem.getTop();
                    removeItem = firstItem;
                    shown = false;
                } else {
                    topPos = 0.0f;
                }
                if (checkEdge) {
                    isOutOfVertialEdge = this.isOutVerticalEdge(overwriteInsert, drawItem, disp, topPos, firstItem, lastItem);
                }
                if (isOutOfVertialEdge) {
                    topPos = 0.0f;
                    willHit = true;
                    lines = 1;
                } else if (removeItem != null) {
                    --lines;
                }
                if (topPos == 0.0f) {
                    shown = false;
                }
            }
            if (verifier != null && verifier.skipLayout(drawItem, topPos, lines, willHit)) {
                return;
            }
            if (isOutOfVertialEdge) {
                this.clear();
            }
            drawItem.layout(disp, drawItem.getLeft(), topPos);
            if (!shown) {
                this.mVisibleDanmakus.removeItem(removeItem);
                this.mVisibleDanmakus.addItem(drawItem);
            }
        }

        protected boolean isOutVerticalEdge(boolean overwriteInsert, BaseDanmaku drawItem, IDisplayer disp, float topPos, BaseDanmaku firstItem, BaseDanmaku lastItem) {
            return topPos < 0.0f || firstItem != null && firstItem.getTop() > 0.0f || topPos + drawItem.paintHeight > (float)disp.getHeight();
        }

        @Override
        public void clear() {
            this.mCancelFixingFlag = true;
            this.mVisibleDanmakus.clear();
        }
    }

    public static interface IDanmakusRetainer {
        public void fix(BaseDanmaku var1, IDisplayer var2, Verifier var3);

        public void clear();
    }

    public static interface Verifier {
        public boolean skipLayout(BaseDanmaku var1, float var2, int var3, boolean var4);
    }
}

