/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.InvertedLuminanceSource;

public abstract class LuminanceSource {
    private final int width;
    private final int height;

    protected LuminanceSource(int n5, int n6) {
        this.width = n5;
        this.height = n6;
    }

    public abstract byte[] getRow(int var1, byte[] var2);

    public abstract byte[] getMatrix();

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean isCropSupported() {
        return false;
    }

    public LuminanceSource crop(int n5, int n6, int n7, int n8) {
        throw new UnsupportedOperationException("This luminance source does not support cropping.");
    }

    public boolean isRotateSupported() {
        return false;
    }

    public LuminanceSource invert() {
        return new InvertedLuminanceSource(this);
    }

    public LuminanceSource rotateCounterClockwise() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 90 degrees.");
    }

    public LuminanceSource rotateCounterClockwise45() {
        throw new UnsupportedOperationException("This luminance source does not support rotation by 45 degrees.");
    }

    public final String toString() {
        StringBuilder stringBuilder;
        int n5 = this.width;
        byte[] byArray = new byte[n5];
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.height * (n5 + 1));
        for (n5 = 0; n5 < this.height; ++n5) {
            byArray = this.getRow(n5, byArray);
            for (int i5 = 0; i5 < this.width; ++i5) {
                int n6 = byArray[i5] & 0xFF;
                n6 = n6 < 64 ? 35 : (n6 < 128 ? 43 : (n6 < 192 ? 46 : 32));
                stringBuilder2.append((char)n6);
            }
            stringBuilder2.append('\n');
        }
        return stringBuilder2.toString();
    }
}

