/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.client.result.ResultParser;
import com.dcloud.zxing2.client.result.VINParsedResult;
import java.util.regex.Pattern;

public final class VINResultParser
extends ResultParser {
    private static final Pattern IOQ = Pattern.compile("[IOQ]");
    private static final Pattern AZ09 = Pattern.compile("[A-Z0-9]{17}");

    private static boolean checkChecksum(CharSequence charSequence) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < charSequence.length()) {
            int n7 = n5;
            n5 = n6 + 1;
            n6 = n7 + VINResultParser.vinPositionWeight(n5) * VINResultParser.vinCharValue(charSequence.charAt(n6));
            int n8 = n5;
            n5 = n6;
            n6 = n8;
        }
        return charSequence.charAt(8) == VINResultParser.checkChar(n5 % 11);
    }

    private static int vinCharValue(char c6) {
        if (c6 >= 'A' && c6 <= 'I') {
            return c6 - 64;
        }
        if (c6 >= 'J' && c6 <= 'R') {
            return c6 - 73;
        }
        if (c6 >= 'S' && c6 <= 'Z') {
            return c6 - 81;
        }
        if (c6 >= '0' && c6 <= '9') {
            return c6 - 48;
        }
        throw new IllegalArgumentException();
    }

    private static int vinPositionWeight(int n5) {
        if (n5 >= 1 && n5 <= 7) {
            return 9 - n5;
        }
        if (n5 == 8) {
            return 10;
        }
        if (n5 == 9) {
            return 0;
        }
        if (n5 >= 10 && n5 <= 17) {
            return 19 - n5;
        }
        throw new IllegalArgumentException();
    }

    private static char checkChar(int n5) {
        if (n5 < 10) {
            return (char)(n5 + 48);
        }
        if (n5 == 10) {
            return 'X';
        }
        throw new IllegalArgumentException();
    }

    private static int modelYear(char c6) {
        if (c6 >= 'E' && c6 <= 'H') {
            return c6 - -1915;
        }
        if (c6 >= 'J' && c6 <= 'N') {
            return c6 - -1914;
        }
        if (c6 == 'P') {
            return 1993;
        }
        if (c6 >= 'R' && c6 <= 'T') {
            return c6 - -1912;
        }
        if (c6 >= 'V' && c6 <= 'Y') {
            return c6 - -1911;
        }
        if (c6 >= '1' && c6 <= '9') {
            return c6 - -1952;
        }
        if (c6 >= 'A' && c6 <= 'D') {
            return c6 - -1945;
        }
        throw new IllegalArgumentException();
    }

    private static String countryCode(CharSequence charSequence) {
        block30: {
            char c6;
            block27: {
                block28: {
                    block29: {
                        char c7 = charSequence.charAt(0);
                        c6 = charSequence.charAt(1);
                        if (c7 == '9') break block27;
                        if (c7 == 'S') break block28;
                        if (c7 == 'Z') break block29;
                        switch (c7) {
                            default: {
                                switch (c7) {
                                    default: {
                                        switch (c7) {
                                            default: {
                                                break block30;
                                            }
                                            case 'X': {
                                                if (c6 == '0' || c6 >= '3' && c6 <= '9') {
                                                    return "RU";
                                                }
                                                break block30;
                                            }
                                            case 'W': {
                                                return "DE";
                                            }
                                            case 'V': {
                                                if (c6 >= 'F' && c6 <= 'R') {
                                                    return "FR";
                                                }
                                                if (c6 >= 'S' && c6 <= 'W') {
                                                    return "ES";
                                                }
                                                break block30;
                                            }
                                        }
                                    }
                                    case 'M': {
                                        if (c6 >= 'A' && c6 <= 'E') {
                                            return "IN";
                                        }
                                        break block30;
                                    }
                                    case 'L': {
                                        return "CN";
                                    }
                                    case 'K': {
                                        if (c6 >= 'L' && c6 <= 'R') {
                                            return "KO";
                                        }
                                        break block30;
                                    }
                                    case 'J': {
                                        if (c6 >= 'A' && c6 <= 'T') {
                                            return "JP";
                                        }
                                        break block30;
                                    }
                                }
                            }
                            case '3': {
                                if (c6 >= 'A' && c6 <= 'W') {
                                    return "MX";
                                }
                                break block30;
                            }
                            case '2': {
                                return "CA";
                            }
                            case '1': 
                            case '4': 
                            case '5': {
                                return "US";
                            }
                        }
                    }
                    if (c6 >= 'A' && c6 <= 'R') {
                        return "IT";
                    }
                    break block30;
                }
                if (c6 >= 'A' && c6 <= 'M') {
                    return "UK";
                }
                if (c6 >= 'N' && c6 <= 'T') {
                    return "DE";
                }
                break block30;
            }
            if (c6 >= 'A' && c6 <= 'E' || c6 >= '3' && c6 <= '9') {
                return "BR";
            }
        }
        return null;
    }

    @Override
    public VINParsedResult parse(Result object) {
        VINParsedResult vINParsedResult;
        Object object2;
        block13: {
            if (((Result)object).getBarcodeFormat() != BarcodeFormat.CODE_39) {
                return null;
            }
            object2 = IOQ.matcher(((Result)object).getText()).replaceAll("").trim();
            if (!AZ09.matcher((CharSequence)object2).matches()) {
                return null;
            }
            try {
                if (VINResultParser.checkChecksum((CharSequence)object2)) break block13;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        object = ((String)object2).substring(0, 3);
        VINParsedResult vINParsedResult2 = vINParsedResult;
        VINParsedResult vINParsedResult3 = vINParsedResult;
        Object object3 = object2;
        Object object4 = object3;
        Object object5 = object3;
        Object object6 = object3;
        Object object7 = object3;
        Object object8 = object3;
        Object object9 = object;
        Object object10 = object2;
        Object object11 = object10;
        object2 = ((String)object10).substring(3, 9);
        String string2 = ((String)object11).substring(9, 17);
        String string3 = VINResultParser.countryCode((CharSequence)object9);
        String string4 = ((String)object5).substring(3, 8);
        int n5 = VINResultParser.modelYear(((String)object6).charAt(9));
        char c6 = ((String)object7).charAt(10);
        String string5 = ((String)object8).substring(11);
        vINParsedResult2((String)object4, (String)object, (String)object2, string2, string3, string4, n5, c6, string5);
        return vINParsedResult3;
    }
}

