/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 10;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    public WhiteRectangleDetector(BitMatrix bitMatrix) throws NotFoundException {
        BitMatrix bitMatrix2 = bitMatrix;
        int n5 = bitMatrix2.getWidth() / 2;
        int n6 = bitMatrix2.getHeight() / 2;
        this(bitMatrix2, 10, n5, n6);
    }

    public WhiteRectangleDetector(BitMatrix bitMatrix, int n5, int n6, int n7) throws NotFoundException {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = n6;
        int n13 = n6;
        int n14 = n5;
        this.image = bitMatrix;
        this.height = n11 = bitMatrix.getHeight();
        this.width = n5 = bitMatrix.getWidth();
        n6 = n14 / 2;
        this.leftInit = n10 = n13 - n6;
        this.rightInit = n9 = n12 + n6;
        this.upInit = n8 = n7 - n6;
        this.downInit = n6 = n7 + n6;
        if (n8 >= 0 && n10 >= 0 && n6 < n11 && n9 < n5) {
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint getBlackPointOnSegment(float f5, float f6, float f7, float f8) {
        float f9 = f8;
        float f10 = f5;
        int n5 = MathUtils.round(MathUtils.distance(f10, f6, f7, f8));
        f8 = n5;
        float f11 = (f7 - f10) / f8;
        f8 = (f9 - f6) / f8;
        for (int i5 = 0; i5 < n5; ++i5) {
            int n6;
            float f12 = i5;
            int n7 = MathUtils.round(f5 + f12 * f11);
            if (!this.image.get(n7, n6 = MathUtils.round(f6 + f12 * f8))) continue;
            float f13 = n7;
            return new ResultPoint(f13, n6);
        }
        return null;
    }

    private ResultPoint[] centerEdges(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        ResultPoint resultPoint5;
        ResultPoint resultPoint6;
        ResultPoint resultPoint7;
        ResultPoint resultPoint8;
        float f5;
        float f6 = resultPoint.getX();
        ResultPoint resultPoint9 = resultPoint4;
        ResultPoint resultPoint10 = resultPoint3;
        ResultPoint resultPoint11 = resultPoint2;
        float f7 = resultPoint.getY();
        float f8 = resultPoint11.getX();
        float f9 = resultPoint11.getY();
        float f10 = resultPoint10.getX();
        float f11 = resultPoint10.getY();
        float f12 = resultPoint9.getX();
        float f13 = resultPoint9.getY();
        if (f5 < (float)this.width / 2.0f) {
            ResultPoint resultPoint12;
            ResultPoint resultPoint13;
            ResultPoint resultPoint14;
            ResultPoint resultPoint15;
            ResultPoint resultPoint16 = resultPoint15;
            resultPoint15 = new ResultPoint(f12 -= 1.0f, f13 + 1.0f);
            ResultPoint resultPoint17 = resultPoint14;
            resultPoint14 = new ResultPoint(f8 += 1.0f, f9 + 1.0f);
            ResultPoint resultPoint18 = resultPoint13;
            f9 = f10 - 1.0f;
            resultPoint13 = new ResultPoint(f9, f11 - 1.0f);
            ResultPoint resultPoint19 = resultPoint12;
            float f14 = f7;
            f7 = f6 + 1.0f;
            resultPoint12 = new ResultPoint(f7, f14 - 1.0f);
            return new ResultPoint[]{resultPoint16, resultPoint17, resultPoint18, resultPoint19};
        }
        ResultPoint resultPoint20 = resultPoint8;
        resultPoint8 = new ResultPoint(f12 += 1.0f, f13 + 1.0f);
        ResultPoint resultPoint21 = resultPoint7;
        resultPoint7 = new ResultPoint(f8 += 1.0f, f9 - 1.0f);
        ResultPoint resultPoint22 = resultPoint6;
        f9 = f10 - 1.0f;
        resultPoint6 = new ResultPoint(f9, f11 + 1.0f);
        ResultPoint resultPoint23 = resultPoint5;
        float f15 = f7;
        f7 = f6 - 1.0f;
        resultPoint5 = new ResultPoint(f7, f15 - 1.0f);
        return new ResultPoint[]{resultPoint20, resultPoint21, resultPoint22, resultPoint23};
    }

    private boolean containsBlackPoint(int n5, int n6, int n7, boolean bl) {
        if (bl) {
            while (n5 <= n6) {
                if (this.image.get(n5, n7)) {
                    return true;
                }
                ++n5;
            }
        } else {
            while (n5 <= n6) {
                if (this.image.get(n7, n5)) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public ResultPoint[] detect() throws NotFoundException {
        v0 = this;
        var1_1 = v0.leftInit;
        var2_4 = v0.rightInit;
        var3_5 = v0.upInit;
        var4_8 = v0.downInit;
        var5_9 = 0;
        var6_10 = true;
        var7_13 = 0;
        var8_16 = 0;
        var9_18 = false;
        var10_23 = false;
        var11_28 = false;
        block0: while (var6_10) {
            var6_10 = false;
            var12_32 = true;
            while ((var12_32 || var8_16 == 0) && var2_4 < this.width) {
                var12_32 = this.containsBlackPoint(var3_5, var4_8, var2_4, false);
                if (var12_32) {
                    ++var2_4;
                    var6_10 = true;
                    var8_16 = 1;
                    continue;
                }
                if (var8_16 != 0) continue;
                ++var2_4;
            }
            if (var2_4 >= this.width) lbl-1000:
            // 4 sources

            {
                while (true) {
                    var5_9 = 1;
                    break block0;
                    break;
                }
            }
            var12_32 = true;
            while ((var12_32 || !var9_18) && var4_8 < this.height) {
                var12_32 = this.containsBlackPoint(var1_1, var2_4, var4_8, true);
                if (var12_32) {
                    ++var4_8;
                    var6_10 = true;
                    var9_18 = true;
                    continue;
                }
                if (var9_18) continue;
                ++var4_8;
            }
            if (var4_8 >= this.height) ** GOTO lbl-1000
            var12_32 = true;
            while ((var12_32 || !var10_23) && var1_1 >= 0) {
                var12_32 = this.containsBlackPoint(var3_5, var4_8, var1_1, false);
                if (var12_32) {
                    --var1_1;
                    var6_10 = true;
                    var10_23 = true;
                    continue;
                }
                if (var10_23) continue;
                --var1_1;
            }
            if (var1_1 < 0) ** GOTO lbl-1000
            var12_32 = true;
            while ((var12_32 || !var11_28) && var3_5 >= 0) {
                var12_32 = this.containsBlackPoint(var1_1, var2_4, var3_5, true);
                if (var12_32) {
                    --var3_5;
                    var6_10 = true;
                    var11_28 = true;
                    continue;
                }
                if (var11_28) continue;
                --var3_5;
            }
            if (var3_5 >= 0) ** break;
            ** continue;
            if (!var6_10) continue;
            var7_13 = 1;
        }
        if (var5_9 == 0 && var7_13 != 0) {
            var5_9 = var2_4 - var1_1;
            var6_11 = null;
            for (var7_13 = 1; var7_13 < var5_9 && (var6_11 = this.getBlackPointOnSegment(var6_12 = (float)var1_1, var8_17 = (float)(var4_8 - var7_13), var9_19 = (float)(var1_1 + var7_13), var10_24 = (float)var4_8)) == null; ++var7_13) {
            }
            if (var6_11 != null) {
                var7_14 = null;
                for (var8_16 = 1; var8_16 < var5_9 && (var7_14 = this.getBlackPointOnSegment(var7_15 = (float)var1_1, var9_20 = (float)(var3_5 + var8_16), var10_25 = (float)(var1_1 + var8_16), var11_29 = (float)var3_5)) == null; ++var8_16) {
                }
                if (var7_14 != null) {
                    var1_2 = null;
                    for (var8_16 = 1; var8_16 < var5_9 && (var1_2 = this.getBlackPointOnSegment(var1_3 = (float)var2_4, var9_21 = (float)(var3_5 + var8_16), var10_26 = (float)(var2_4 - var8_16), var11_30 = (float)var3_5)) == null; ++var8_16) {
                    }
                    if (var1_2 != null) {
                        var3_6 = null;
                        for (var8_16 = 1; var8_16 < var5_9 && (var3_6 = this.getBlackPointOnSegment(var3_7 = (float)var2_4, var9_22 = (float)(var4_8 - var8_16), var10_27 = (float)(var2_4 - var8_16), var11_31 = (float)var4_8)) == null; ++var8_16) {
                        }
                        if (var3_6 != null) {
                            return this.centerEdges(var3_6, var6_11, var1_2, var7_14);
                        }
                        throw NotFoundException.getNotFoundInstance();
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

