/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import com.dcloud.zxing2.datamatrix.decoder.BitMatrixParser;
import com.dcloud.zxing2.datamatrix.decoder.DataBlock;
import com.dcloud.zxing2.datamatrix.decoder.DecodedBitStreamParser;
import com.dcloud.zxing2.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    private void correctErrors(byte[] byArray, int n5) throws ChecksumException {
        int n6 = byArray.length;
        int[] nArray = new int[n6];
        for (int i5 = 0; i5 < n6; ++i5) {
            nArray[i5] = byArray[i5] & 0xFF;
        }
        int n7 = byArray.length - n5;
        try {
            this.rsDecoder.decode(nArray, n7);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n7 = 0; n7 < n5; ++n7) {
            byArray[n7] = (byte)nArray[n7];
        }
        return;
    }

    public DecoderResult decode(boolean[][] blArray) throws FormatException, ChecksumException {
        BitMatrix bitMatrix;
        int n5 = blArray.length;
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n5);
        for (int i5 = 0; i5 < n5; ++i5) {
            for (int i6 = 0; i6 < n5; ++i6) {
                if (!blArray[i5][i6]) continue;
                bitMatrix2.set(i6, i5);
            }
        }
        return this.decode(bitMatrix2);
    }

    public DecoderResult decode(BitMatrix dataBlockArray) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser((BitMatrix)dataBlockArray);
        dataBlockArray = bitMatrixParser.getVersion();
        dataBlockArray = DataBlock.getDataBlocks(bitMatrixParser.readCodewords(), (Version)dataBlockArray);
        int n5 = dataBlockArray.length;
        int n6 = 0;
        int n7 = dataBlockArray.length;
        for (int i5 = 0; i5 < n7; ++i5) {
            n6 += dataBlockArray[i5].getNumDataCodewords();
        }
        byte[] byArray = new byte[n6];
        for (n7 = 0; n7 < n5; ++n7) {
            DataBlock dataBlock = dataBlockArray[n7];
            byte[] byArray2 = dataBlock.getCodewords();
            int n8 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray2, n8);
            int n9 = 0;
            while (n9 < n8) {
                int n10 = n9++;
                int n11 = n10 * n5 + n7;
                byArray[n11] = byArray2[n10];
            }
        }
        return DecodedBitStreamParser.decode(byArray);
    }
}

