/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.datamatrix.encoder.Encoder;
import com.dcloud.zxing2.datamatrix.encoder.EncoderContext;
import com.dcloud.zxing2.datamatrix.encoder.HighLevelEncoder;

final class ASCIIEncoder
implements Encoder {
    ASCIIEncoder() {
    }

    private static char encodeASCIIDigits(char c6, char c7) {
        if (HighLevelEncoder.isDigit(c6) && HighLevelEncoder.isDigit(c7)) {
            return (char)((c6 - 48) * 10 + (c7 - 48) + 130);
        }
        throw new IllegalArgumentException("not digits: " + c6 + c7);
    }

    @Override
    public int getEncodingMode() {
        return 0;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        if (HighLevelEncoder.determineConsecutiveDigitCount(encoderContext.getMessage(), encoderContext.pos) >= 2) {
            encoderContext.writeCodeword(ASCIIEncoder.encodeASCIIDigits(encoderContext.getMessage().charAt(encoderContext.pos), encoderContext.getMessage().charAt(encoderContext.pos + 1)));
            encoderContext.pos += 2;
            return;
        }
        char c6 = encoderContext.getCurrentChar();
        int n5 = encoderContext.pos;
        n5 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), n5, this.getEncodingMode());
        if (n5 != this.getEncodingMode()) {
            switch (n5) {
                default: {
                    throw new IllegalStateException("Illegal mode: " + n5);
                }
                case 5: {
                    encoderContext.writeCodeword('\u00e7');
                    encoderContext.signalEncoderChange(5);
                    return;
                }
                case 4: {
                    encoderContext.writeCodeword('\u00f0');
                    encoderContext.signalEncoderChange(4);
                    return;
                }
                case 3: {
                    encoderContext.writeCodeword('\u00ee');
                    encoderContext.signalEncoderChange(3);
                    return;
                }
                case 2: {
                    encoderContext.writeCodeword('\u00ef');
                    encoderContext.signalEncoderChange(2);
                    return;
                }
                case 1: 
            }
            encoderContext.writeCodeword('\u00e6');
            encoderContext.signalEncoderChange(1);
            return;
        }
        if (HighLevelEncoder.isExtendedASCII(c6)) {
            encoderContext.writeCodeword('\u00eb');
            encoderContext.writeCodeword((char)(c6 - 127));
            ++encoderContext.pos;
            return;
        }
        encoderContext.writeCodeword((char)(c6 + '\u0001'));
        ++encoderContext.pos;
    }
}

