/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

import com.dcloud.zxing2.WriterException;

final class PDF417ErrorCorrection {
    private static final int[][] EC_COEFFICIENTS;

    private PDF417ErrorCorrection() {
    }

    static int getErrorCorrectionCodewordCount(int n5) {
        if (n5 >= 0 && n5 <= 8) {
            return 1 << n5 + 1;
        }
        throw new IllegalArgumentException("Error correction level must be between 0 and 8!");
    }

    static int getRecommendedMinimumErrorCorrectionLevel(int n5) throws WriterException {
        if (n5 > 0) {
            if (n5 <= 40) {
                return 2;
            }
            if (n5 <= 160) {
                return 3;
            }
            if (n5 <= 320) {
                return 4;
            }
            if (n5 <= 863) {
                return 5;
            }
            throw new WriterException("No recommendation possible");
        }
        throw new IllegalArgumentException("n must be > 0");
    }

    static String generateErrorCorrection(CharSequence charSequence, int n5) {
        StringBuilder stringBuilder;
        int n6 = PDF417ErrorCorrection.getErrorCorrectionCodewordCount(n5);
        char[] cArray = new char[n6];
        int n7 = charSequence.length();
        for (int i5 = 0; i5 < n7; ++i5) {
            int n8;
            int n9 = (charSequence.charAt(i5) + cArray[n8]) % 929;
            for (n8 = n6 - 1; n8 >= 1; --n8) {
                int n10 = 929 - n9 * EC_COEFFICIENTS[n5][n8] % 929;
                cArray[n8] = (char)((cArray[n8 - 1] + n10) % 929);
            }
            cArray[0] = (char)((929 - n9 * EC_COEFFICIENTS[n5][0] % 929) % 929);
        }
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder(n6);
        for (n5 = n6 - 1; n5 >= 0; --n5) {
            n6 = cArray[n5];
            if (n6 != 0) {
                cArray[n5] = (char)(929 - n6);
            }
            ((StringBuilder)charSequence).append(cArray[n5]);
        }
        return ((StringBuilder)charSequence).toString();
    }

    static {
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 27;
        nArray[1] = 917;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[4];
        nArray2 = nArray3;
        nArray3[0] = 522;
        nArray3[1] = 568;
        nArray3[2] = 723;
        nArray3[3] = 809;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[8];
        nArray2 = nArray4;
        nArray4[0] = 237;
        nArray4[1] = 308;
        nArray4[2] = 436;
        nArray4[3] = 284;
        nArray4[4] = 646;
        nArray4[5] = 653;
        nArray4[6] = 428;
        nArray4[7] = 379;
        nArrayArray[2] = nArray2;
        int[] nArray5 = new int[16];
        nArray2 = nArray5;
        nArray5[0] = 274;
        nArray5[1] = 562;
        nArray5[2] = 232;
        nArray5[3] = 755;
        nArray5[4] = 599;
        nArray5[5] = 524;
        nArray5[6] = 801;
        nArray5[7] = 132;
        nArray5[8] = 295;
        nArray5[9] = 116;
        nArray5[10] = 442;
        nArray5[11] = 428;
        nArray5[12] = 295;
        nArray5[13] = 42;
        nArray5[14] = 176;
        nArray5[15] = 65;
        nArrayArray[3] = nArray2;
        int[] nArray6 = new int[32];
        nArray2 = nArray6;
        nArray6[0] = 361;
        nArray2[1] = 575;
        nArray2[2] = 922;
        nArray2[3] = 525;
        nArray2[4] = 176;
        nArray2[5] = 586;
        nArray2[6] = 640;
        nArray2[7] = 321;
        nArray2[8] = 536;
        nArray2[9] = 742;
        nArray2[10] = 677;
        nArray2[11] = 742;
        nArray2[12] = 687;
        nArray2[13] = 284;
        nArray2[14] = 193;
        nArray2[15] = 517;
        nArray2[16] = 273;
        nArray2[17] = 494;
        nArray2[18] = 263;
        nArray2[19] = 147;
        nArray2[20] = 593;
        nArray2[21] = 800;
        nArray2[22] = 571;
        nArray2[23] = 320;
        nArray2[24] = 803;
        nArray2[25] = 133;
        nArray2[26] = 231;
        nArray2[27] = 390;
        nArray2[28] = 685;
        nArray2[29] = 330;
        nArray2[30] = 63;
        nArray2[31] = 410;
        nArrayArray[4] = nArray2;
        int[] nArray7 = new int[64];
        nArray2 = nArray7;
        nArray7[0] = 539;
        nArray2[1] = 422;
        nArray2[2] = 6;
        nArray2[3] = 93;
        nArray2[4] = 862;
        nArray2[5] = 771;
        nArray2[6] = 453;
        nArray2[7] = 106;
        nArray2[8] = 610;
        nArray2[9] = 287;
        nArray2[10] = 107;
        nArray2[11] = 505;
        nArray2[12] = 733;
        nArray2[13] = 877;
        nArray2[14] = 381;
        nArray2[15] = 612;
        nArray2[16] = 723;
        nArray2[17] = 476;
        nArray2[18] = 462;
        nArray2[19] = 172;
        nArray2[20] = 430;
        nArray2[21] = 609;
        nArray2[22] = 858;
        nArray2[23] = 822;
        nArray2[24] = 543;
        nArray2[25] = 376;
        nArray2[26] = 511;
        nArray2[27] = 400;
        nArray2[28] = 672;
        nArray2[29] = 762;
        nArray2[30] = 283;
        nArray2[31] = 184;
        nArray2[32] = 440;
        nArray2[33] = 35;
        nArray2[34] = 519;
        nArray2[35] = 31;
        nArray2[36] = 460;
        nArray2[37] = 594;
        nArray2[38] = 225;
        nArray2[39] = 535;
        nArray2[40] = 517;
        nArray2[41] = 352;
        nArray2[42] = 605;
        nArray2[43] = 158;
        nArray2[44] = 651;
        nArray2[45] = 201;
        nArray2[46] = 488;
        nArray2[47] = 502;
        nArray2[48] = 648;
        nArray2[49] = 733;
        nArray2[50] = 717;
        nArray2[51] = 83;
        nArray2[52] = 404;
        nArray2[53] = 97;
        nArray2[54] = 280;
        nArray2[55] = 771;
        nArray2[56] = 840;
        nArray2[57] = 629;
        nArray2[58] = 4;
        nArray2[59] = 381;
        nArray2[60] = 843;
        nArray2[61] = 623;
        nArray2[62] = 264;
        nArray2[63] = 543;
        nArrayArray[5] = nArray2;
        int[] nArray8 = new int[128];
        nArray2 = nArray8;
        nArray8[0] = 521;
        nArray2[1] = 310;
        nArray2[2] = 864;
        nArray2[3] = 547;
        nArray2[4] = 858;
        nArray2[5] = 580;
        nArray2[6] = 296;
        nArray2[7] = 379;
        nArray2[8] = 53;
        nArray2[9] = 779;
        nArray2[10] = 897;
        nArray2[11] = 444;
        nArray2[12] = 400;
        nArray2[13] = 925;
        nArray2[14] = 749;
        nArray2[15] = 415;
        nArray2[16] = 822;
        nArray2[17] = 93;
        nArray2[18] = 217;
        nArray2[19] = 208;
        nArray2[20] = 928;
        nArray2[21] = 244;
        nArray2[22] = 583;
        nArray2[23] = 620;
        nArray2[24] = 246;
        nArray2[25] = 148;
        nArray2[26] = 447;
        nArray2[27] = 631;
        nArray2[28] = 292;
        nArray2[29] = 908;
        nArray2[30] = 490;
        nArray2[31] = 704;
        nArray2[32] = 516;
        nArray2[33] = 258;
        nArray2[34] = 457;
        nArray2[35] = 907;
        nArray2[36] = 594;
        nArray2[37] = 723;
        nArray2[38] = 674;
        nArray2[39] = 292;
        nArray2[40] = 272;
        nArray2[41] = 96;
        nArray2[42] = 684;
        nArray2[43] = 432;
        nArray2[44] = 686;
        nArray2[45] = 606;
        nArray2[46] = 860;
        nArray2[47] = 569;
        nArray2[48] = 193;
        nArray2[49] = 219;
        nArray2[50] = 129;
        nArray2[51] = 186;
        nArray2[52] = 236;
        nArray2[53] = 287;
        nArray2[54] = 192;
        nArray2[55] = 775;
        nArray2[56] = 278;
        nArray2[57] = 173;
        nArray2[58] = 40;
        nArray2[59] = 379;
        nArray2[60] = 712;
        nArray2[61] = 463;
        nArray2[62] = 646;
        nArray2[63] = 776;
        nArray2[64] = 171;
        nArray2[65] = 491;
        nArray2[66] = 297;
        nArray2[67] = 763;
        nArray2[68] = 156;
        nArray2[69] = 732;
        nArray2[70] = 95;
        nArray2[71] = 270;
        nArray2[72] = 447;
        nArray2[73] = 90;
        nArray2[74] = 507;
        nArray2[75] = 48;
        nArray2[76] = 228;
        nArray2[77] = 821;
        nArray2[78] = 808;
        nArray2[79] = 898;
        nArray2[80] = 784;
        nArray2[81] = 663;
        nArray2[82] = 627;
        nArray2[83] = 378;
        nArray2[84] = 382;
        nArray2[85] = 262;
        nArray2[86] = 380;
        nArray2[87] = 602;
        nArray2[88] = 754;
        nArray2[89] = 336;
        nArray2[90] = 89;
        nArray2[91] = 614;
        nArray2[92] = 87;
        nArray2[93] = 432;
        nArray2[94] = 670;
        nArray2[95] = 616;
        nArray2[96] = 157;
        nArray2[97] = 374;
        nArray2[98] = 242;
        nArray2[99] = 726;
        nArray2[100] = 600;
        nArray2[101] = 269;
        nArray2[102] = 375;
        nArray2[103] = 898;
        nArray2[104] = 845;
        nArray2[105] = 454;
        nArray2[106] = 354;
        nArray2[107] = 130;
        nArray2[108] = 814;
        nArray2[109] = 587;
        nArray2[110] = 804;
        nArray2[111] = 34;
        nArray2[112] = 211;
        nArray2[113] = 330;
        nArray2[114] = 539;
        nArray2[115] = 297;
        nArray2[116] = 827;
        nArray2[117] = 865;
        nArray2[118] = 37;
        nArray2[119] = 517;
        nArray2[120] = 834;
        nArray2[121] = 315;
        nArray2[122] = 550;
        nArray2[123] = 86;
        nArray2[124] = 801;
        nArray2[125] = 4;
        nArray2[126] = 108;
        nArray2[127] = 539;
        nArrayArray[6] = nArray2;
        int[] nArray9 = new int[256];
        nArray2 = nArray9;
        nArray9[0] = 524;
        nArray2[1] = 894;
        nArray2[2] = 75;
        nArray2[3] = 766;
        nArray2[4] = 882;
        nArray2[5] = 857;
        nArray2[6] = 74;
        nArray2[7] = 204;
        nArray2[8] = 82;
        nArray2[9] = 586;
        nArray2[10] = 708;
        nArray2[11] = 250;
        nArray2[12] = 905;
        nArray2[13] = 786;
        nArray2[14] = 138;
        nArray2[15] = 720;
        nArray2[16] = 858;
        nArray2[17] = 194;
        nArray2[18] = 311;
        nArray2[19] = 913;
        nArray2[20] = 275;
        nArray2[21] = 190;
        nArray2[22] = 375;
        nArray2[23] = 850;
        nArray2[24] = 438;
        nArray2[25] = 733;
        nArray2[26] = 194;
        nArray2[27] = 280;
        nArray2[28] = 201;
        nArray2[29] = 280;
        nArray2[30] = 828;
        nArray2[31] = 757;
        nArray2[32] = 710;
        nArray2[33] = 814;
        nArray2[34] = 919;
        nArray2[35] = 89;
        nArray2[36] = 68;
        nArray2[37] = 569;
        nArray2[38] = 11;
        nArray2[39] = 204;
        nArray2[40] = 796;
        nArray2[41] = 605;
        nArray2[42] = 540;
        nArray2[43] = 913;
        nArray2[44] = 801;
        nArray2[45] = 700;
        nArray2[46] = 799;
        nArray2[47] = 137;
        nArray2[48] = 439;
        nArray2[49] = 418;
        nArray2[50] = 592;
        nArray2[51] = 668;
        nArray2[52] = 353;
        nArray2[53] = 859;
        nArray2[54] = 370;
        nArray2[55] = 694;
        nArray2[56] = 325;
        nArray2[57] = 240;
        nArray2[58] = 216;
        nArray2[59] = 257;
        nArray2[60] = 284;
        nArray2[61] = 549;
        nArray2[62] = 209;
        nArray2[63] = 884;
        nArray2[64] = 315;
        nArray2[65] = 70;
        nArray2[66] = 329;
        nArray2[67] = 793;
        nArray2[68] = 490;
        nArray2[69] = 274;
        nArray2[70] = 877;
        nArray2[71] = 162;
        nArray2[72] = 749;
        nArray2[73] = 812;
        nArray2[74] = 684;
        nArray2[75] = 461;
        nArray2[76] = 334;
        nArray2[77] = 376;
        nArray2[78] = 849;
        nArray2[79] = 521;
        nArray2[80] = 307;
        nArray2[81] = 291;
        nArray2[82] = 803;
        nArray2[83] = 712;
        nArray2[84] = 19;
        nArray2[85] = 358;
        nArray2[86] = 399;
        nArray2[87] = 908;
        nArray2[88] = 103;
        nArray2[89] = 511;
        nArray2[90] = 51;
        nArray2[91] = 8;
        nArray2[92] = 517;
        nArray2[93] = 225;
        nArray2[94] = 289;
        nArray2[95] = 470;
        nArray2[96] = 637;
        nArray2[97] = 731;
        nArray2[98] = 66;
        nArray2[99] = 255;
        nArray2[100] = 917;
        nArray2[101] = 269;
        nArray2[102] = 463;
        nArray2[103] = 830;
        nArray2[104] = 730;
        nArray2[105] = 433;
        nArray2[106] = 848;
        nArray2[107] = 585;
        nArray2[108] = 136;
        nArray2[109] = 538;
        nArray2[110] = 906;
        nArray2[111] = 90;
        nArray2[112] = 2;
        nArray2[113] = 290;
        nArray2[114] = 743;
        nArray2[115] = 199;
        nArray2[116] = 655;
        nArray2[117] = 903;
        nArray2[118] = 329;
        nArray2[119] = 49;
        nArray2[120] = 802;
        nArray2[121] = 580;
        nArray2[122] = 355;
        nArray2[123] = 588;
        nArray2[124] = 188;
        nArray2[125] = 462;
        nArray2[126] = 10;
        nArray2[127] = 134;
        nArray2[128] = 628;
        nArray2[129] = 320;
        nArray2[130] = 479;
        nArray2[131] = 130;
        nArray2[132] = 739;
        nArray2[133] = 71;
        nArray2[134] = 263;
        nArray2[135] = 318;
        nArray2[136] = 374;
        nArray2[137] = 601;
        nArray2[138] = 192;
        nArray2[139] = 605;
        nArray2[140] = 142;
        nArray2[141] = 673;
        nArray2[142] = 687;
        nArray2[143] = 234;
        nArray2[144] = 722;
        nArray2[145] = 384;
        nArray2[146] = 177;
        nArray2[147] = 752;
        nArray2[148] = 607;
        nArray2[149] = 640;
        nArray2[150] = 455;
        nArray2[151] = 193;
        nArray2[152] = 689;
        nArray2[153] = 707;
        nArray2[154] = 805;
        nArray2[155] = 641;
        nArray2[156] = 48;
        nArray2[157] = 60;
        nArray2[158] = 732;
        nArray2[159] = 621;
        nArray2[160] = 895;
        nArray2[161] = 544;
        nArray2[162] = 261;
        nArray2[163] = 852;
        nArray2[164] = 655;
        nArray2[165] = 309;
        nArray2[166] = 697;
        nArray2[167] = 755;
        nArray2[168] = 756;
        nArray2[169] = 60;
        nArray2[170] = 231;
        nArray2[171] = 773;
        nArray2[172] = 434;
        nArray2[173] = 421;
        nArray2[174] = 726;
        nArray2[175] = 528;
        nArray2[176] = 503;
        nArray2[177] = 118;
        nArray2[178] = 49;
        nArray2[179] = 795;
        nArray2[180] = 32;
        nArray2[181] = 144;
        nArray2[182] = 500;
        nArray2[183] = 238;
        nArray2[184] = 836;
        nArray2[185] = 394;
        nArray2[186] = 280;
        nArray2[187] = 566;
        nArray2[188] = 319;
        nArray2[189] = 9;
        nArray2[190] = 647;
        nArray2[191] = 550;
        nArray2[192] = 73;
        nArray2[193] = 914;
        nArray2[194] = 342;
        nArray2[195] = 126;
        nArray2[196] = 32;
        nArray2[197] = 681;
        nArray2[198] = 331;
        nArray2[199] = 792;
        nArray2[200] = 620;
        nArray2[201] = 60;
        nArray2[202] = 609;
        nArray2[203] = 441;
        nArray2[204] = 180;
        nArray2[205] = 791;
        nArray2[206] = 893;
        nArray2[207] = 754;
        nArray2[208] = 605;
        nArray2[209] = 383;
        nArray2[210] = 228;
        nArray2[211] = 749;
        nArray2[212] = 760;
        nArray2[213] = 213;
        nArray2[214] = 54;
        nArray2[215] = 297;
        nArray2[216] = 134;
        nArray2[217] = 54;
        nArray2[218] = 834;
        nArray2[219] = 299;
        nArray2[220] = 922;
        nArray2[221] = 191;
        nArray2[222] = 910;
        nArray2[223] = 532;
        nArray2[224] = 609;
        nArray2[225] = 829;
        nArray2[226] = 189;
        nArray2[227] = 20;
        nArray2[228] = 167;
        nArray2[229] = 29;
        nArray2[230] = 872;
        nArray2[231] = 449;
        nArray2[232] = 83;
        nArray2[233] = 402;
        nArray2[234] = 41;
        nArray2[235] = 656;
        nArray2[236] = 505;
        nArray2[237] = 579;
        nArray2[238] = 481;
        nArray2[239] = 173;
        nArray2[240] = 404;
        nArray2[241] = 251;
        nArray2[242] = 688;
        nArray2[243] = 95;
        nArray2[244] = 497;
        nArray2[245] = 555;
        nArray2[246] = 642;
        nArray2[247] = 543;
        nArray2[248] = 307;
        nArray2[249] = 159;
        nArray2[250] = 924;
        nArray2[251] = 558;
        nArray2[252] = 648;
        nArray2[253] = 55;
        nArray2[254] = 497;
        nArray2[255] = 10;
        nArrayArray[7] = nArray2;
        int[] nArray10 = new int[512];
        nArray2 = nArray10;
        nArray10[0] = 352;
        nArray2[1] = 77;
        nArray2[2] = 373;
        nArray2[3] = 504;
        nArray2[4] = 35;
        nArray2[5] = 599;
        nArray2[6] = 428;
        nArray2[7] = 207;
        nArray2[8] = 409;
        nArray2[9] = 574;
        nArray2[10] = 118;
        nArray2[11] = 498;
        nArray2[12] = 285;
        nArray2[13] = 380;
        nArray2[14] = 350;
        nArray2[15] = 492;
        nArray2[16] = 197;
        nArray2[17] = 265;
        nArray2[18] = 920;
        nArray2[19] = 155;
        nArray2[20] = 914;
        nArray2[21] = 299;
        nArray2[22] = 229;
        nArray2[23] = 643;
        nArray2[24] = 294;
        nArray2[25] = 871;
        nArray2[26] = 306;
        nArray2[27] = 88;
        nArray2[28] = 87;
        nArray2[29] = 193;
        nArray2[30] = 352;
        nArray2[31] = 781;
        nArray2[32] = 846;
        nArray2[33] = 75;
        nArray2[34] = 327;
        nArray2[35] = 520;
        nArray2[36] = 435;
        nArray2[37] = 543;
        nArray2[38] = 203;
        nArray2[39] = 666;
        nArray2[40] = 249;
        nArray2[41] = 346;
        nArray2[42] = 781;
        nArray2[43] = 621;
        nArray2[44] = 640;
        nArray2[45] = 268;
        nArray2[46] = 794;
        nArray2[47] = 534;
        nArray2[48] = 539;
        nArray2[49] = 781;
        nArray2[50] = 408;
        nArray2[51] = 390;
        nArray2[52] = 644;
        nArray2[53] = 102;
        nArray2[54] = 476;
        nArray2[55] = 499;
        nArray2[56] = 290;
        nArray2[57] = 632;
        nArray2[58] = 545;
        nArray2[59] = 37;
        nArray2[60] = 858;
        nArray2[61] = 916;
        nArray2[62] = 552;
        nArray2[63] = 41;
        nArray2[64] = 542;
        nArray2[65] = 289;
        nArray2[66] = 122;
        nArray2[67] = 272;
        nArray2[68] = 383;
        nArray2[69] = 800;
        nArray2[70] = 485;
        nArray2[71] = 98;
        nArray2[72] = 752;
        nArray2[73] = 472;
        nArray2[74] = 761;
        nArray2[75] = 107;
        nArray2[76] = 784;
        nArray2[77] = 860;
        nArray2[78] = 658;
        nArray2[79] = 741;
        nArray2[80] = 290;
        nArray2[81] = 204;
        nArray2[82] = 681;
        nArray2[83] = 407;
        nArray2[84] = 855;
        nArray2[85] = 85;
        nArray2[86] = 99;
        nArray2[87] = 62;
        nArray2[88] = 482;
        nArray2[89] = 180;
        nArray2[90] = 20;
        nArray2[91] = 297;
        nArray2[92] = 451;
        nArray2[93] = 593;
        nArray2[94] = 913;
        nArray2[95] = 142;
        nArray2[96] = 808;
        nArray2[97] = 684;
        nArray2[98] = 287;
        nArray2[99] = 536;
        nArray2[100] = 561;
        nArray2[101] = 76;
        nArray2[102] = 653;
        nArray2[103] = 899;
        nArray2[104] = 729;
        nArray2[105] = 567;
        nArray2[106] = 744;
        nArray2[107] = 390;
        nArray2[108] = 513;
        nArray2[109] = 192;
        nArray2[110] = 516;
        nArray2[111] = 258;
        nArray2[112] = 240;
        nArray2[113] = 518;
        nArray2[114] = 794;
        nArray2[115] = 395;
        nArray2[116] = 768;
        nArray2[117] = 848;
        nArray2[118] = 51;
        nArray2[119] = 610;
        nArray2[120] = 384;
        nArray2[121] = 168;
        nArray2[122] = 190;
        nArray2[123] = 826;
        nArray2[124] = 328;
        nArray2[125] = 596;
        nArray2[126] = 786;
        nArray2[127] = 303;
        nArray2[128] = 570;
        nArray2[129] = 381;
        nArray2[130] = 415;
        nArray2[131] = 641;
        nArray2[132] = 156;
        nArray2[133] = 237;
        nArray2[134] = 151;
        nArray2[135] = 429;
        nArray2[136] = 531;
        nArray2[137] = 207;
        nArray2[138] = 676;
        nArray2[139] = 710;
        nArray2[140] = 89;
        nArray2[141] = 168;
        nArray2[142] = 304;
        nArray2[143] = 402;
        nArray2[144] = 40;
        nArray2[145] = 708;
        nArray2[146] = 575;
        nArray2[147] = 162;
        nArray2[148] = 864;
        nArray2[149] = 229;
        nArray2[150] = 65;
        nArray2[151] = 861;
        nArray2[152] = 841;
        nArray2[153] = 512;
        nArray2[154] = 164;
        nArray2[155] = 477;
        nArray2[156] = 221;
        nArray2[157] = 92;
        nArray2[158] = 358;
        nArray2[159] = 785;
        nArray2[160] = 288;
        nArray2[161] = 357;
        nArray2[162] = 850;
        nArray2[163] = 836;
        nArray2[164] = 827;
        nArray2[165] = 736;
        nArray2[166] = 707;
        nArray2[167] = 94;
        nArray2[168] = 8;
        nArray2[169] = 494;
        nArray2[170] = 114;
        nArray2[171] = 521;
        nArray2[172] = 2;
        nArray2[173] = 499;
        nArray2[174] = 851;
        nArray2[175] = 543;
        nArray2[176] = 152;
        nArray2[177] = 729;
        nArray2[178] = 771;
        nArray2[179] = 95;
        nArray2[180] = 248;
        nArray2[181] = 361;
        nArray2[182] = 578;
        nArray2[183] = 323;
        nArray2[184] = 856;
        nArray2[185] = 797;
        nArray2[186] = 289;
        nArray2[187] = 51;
        nArray2[188] = 684;
        nArray2[189] = 466;
        nArray2[190] = 533;
        nArray2[191] = 820;
        nArray2[192] = 669;
        nArray2[193] = 45;
        nArray2[194] = 902;
        nArray2[195] = 452;
        nArray2[196] = 167;
        nArray2[197] = 342;
        nArray2[198] = 244;
        nArray2[199] = 173;
        nArray2[200] = 35;
        nArray2[201] = 463;
        nArray2[202] = 651;
        nArray2[203] = 51;
        nArray2[204] = 699;
        nArray2[205] = 591;
        nArray2[206] = 452;
        nArray2[207] = 578;
        nArray2[208] = 37;
        nArray2[209] = 124;
        nArray2[210] = 298;
        nArray2[211] = 332;
        nArray2[212] = 552;
        nArray2[213] = 43;
        nArray2[214] = 427;
        nArray2[215] = 119;
        nArray2[216] = 662;
        nArray2[217] = 777;
        nArray2[218] = 475;
        nArray2[219] = 850;
        nArray2[220] = 764;
        nArray2[221] = 364;
        nArray2[222] = 578;
        nArray2[223] = 911;
        nArray2[224] = 283;
        nArray2[225] = 711;
        nArray2[226] = 472;
        nArray2[227] = 420;
        nArray2[228] = 245;
        nArray2[229] = 288;
        nArray2[230] = 594;
        nArray2[231] = 394;
        nArray2[232] = 511;
        nArray2[233] = 327;
        nArray2[234] = 589;
        nArray2[235] = 777;
        nArray2[236] = 699;
        nArray2[237] = 688;
        nArray2[238] = 43;
        nArray2[239] = 408;
        nArray2[240] = 842;
        nArray2[241] = 383;
        nArray2[242] = 721;
        nArray2[243] = 521;
        nArray2[244] = 560;
        nArray2[245] = 644;
        nArray2[246] = 714;
        nArray2[247] = 559;
        nArray2[248] = 62;
        nArray2[249] = 145;
        nArray2[250] = 873;
        nArray2[251] = 663;
        nArray2[252] = 713;
        nArray2[253] = 159;
        nArray2[254] = 672;
        nArray2[255] = 729;
        nArray2[256] = 624;
        nArray2[257] = 59;
        nArray2[258] = 193;
        nArray2[259] = 417;
        nArray2[260] = 158;
        nArray2[261] = 209;
        nArray2[262] = 563;
        nArray2[263] = 564;
        nArray2[264] = 343;
        nArray2[265] = 693;
        nArray2[266] = 109;
        nArray2[267] = 608;
        nArray2[268] = 563;
        nArray2[269] = 365;
        nArray2[270] = 181;
        nArray2[271] = 772;
        nArray2[272] = 677;
        nArray2[273] = 310;
        nArray2[274] = 248;
        nArray2[275] = 353;
        nArray2[276] = 708;
        nArray2[277] = 410;
        nArray2[278] = 579;
        nArray2[279] = 870;
        nArray2[280] = 617;
        nArray2[281] = 841;
        nArray2[282] = 632;
        nArray2[283] = 860;
        nArray2[284] = 289;
        nArray2[285] = 536;
        nArray2[286] = 35;
        nArray2[287] = 777;
        nArray2[288] = 618;
        nArray2[289] = 586;
        nArray2[290] = 424;
        nArray2[291] = 833;
        nArray2[292] = 77;
        nArray2[293] = 597;
        nArray2[294] = 346;
        nArray2[295] = 269;
        nArray2[296] = 757;
        nArray2[297] = 632;
        nArray2[298] = 695;
        nArray2[299] = 751;
        nArray2[300] = 331;
        nArray2[301] = 247;
        nArray2[302] = 184;
        nArray2[303] = 45;
        nArray2[304] = 787;
        nArray2[305] = 680;
        nArray2[306] = 18;
        nArray2[307] = 66;
        nArray2[308] = 407;
        nArray2[309] = 369;
        nArray2[310] = 54;
        nArray2[311] = 492;
        nArray2[312] = 228;
        nArray2[313] = 613;
        nArray2[314] = 830;
        nArray2[315] = 922;
        nArray2[316] = 437;
        nArray2[317] = 519;
        nArray2[318] = 644;
        nArray2[319] = 905;
        nArray2[320] = 789;
        nArray2[321] = 420;
        nArray2[322] = 305;
        nArray2[323] = 441;
        nArray2[324] = 207;
        nArray2[325] = 300;
        nArray2[326] = 892;
        nArray2[327] = 827;
        nArray2[328] = 141;
        nArray2[329] = 537;
        nArray2[330] = 381;
        nArray2[331] = 662;
        nArray2[332] = 513;
        nArray2[333] = 56;
        nArray2[334] = 252;
        nArray2[335] = 341;
        nArray2[336] = 242;
        nArray2[337] = 797;
        nArray2[338] = 838;
        nArray2[339] = 837;
        nArray2[340] = 720;
        nArray2[341] = 224;
        nArray2[342] = 307;
        nArray2[343] = 631;
        nArray2[344] = 61;
        nArray2[345] = 87;
        nArray2[346] = 560;
        nArray2[347] = 310;
        nArray2[348] = 756;
        nArray2[349] = 665;
        nArray2[350] = 397;
        nArray2[351] = 808;
        nArray2[352] = 851;
        nArray2[353] = 309;
        nArray2[354] = 473;
        nArray2[355] = 795;
        nArray2[356] = 378;
        nArray2[357] = 31;
        nArray2[358] = 647;
        nArray2[359] = 915;
        nArray2[360] = 459;
        nArray2[361] = 806;
        nArray2[362] = 590;
        nArray2[363] = 731;
        nArray2[364] = 425;
        nArray2[365] = 216;
        nArray2[366] = 548;
        nArray2[367] = 249;
        nArray2[368] = 321;
        nArray2[369] = 881;
        nArray2[370] = 699;
        nArray2[371] = 535;
        nArray2[372] = 673;
        nArray2[373] = 782;
        nArray2[374] = 210;
        nArray2[375] = 815;
        nArray2[376] = 905;
        nArray2[377] = 303;
        nArray2[378] = 843;
        nArray2[379] = 922;
        nArray2[380] = 281;
        nArray2[381] = 73;
        nArray2[382] = 469;
        nArray2[383] = 791;
        nArray2[384] = 660;
        nArray2[385] = 162;
        nArray2[386] = 498;
        nArray2[387] = 308;
        nArray2[388] = 155;
        nArray2[389] = 422;
        nArray2[390] = 907;
        nArray2[391] = 817;
        nArray2[392] = 187;
        nArray2[393] = 62;
        nArray2[394] = 16;
        nArray2[395] = 425;
        nArray2[396] = 535;
        nArray2[397] = 336;
        nArray2[398] = 286;
        nArray2[399] = 437;
        nArray2[400] = 375;
        nArray2[401] = 273;
        nArray2[402] = 610;
        nArray2[403] = 296;
        nArray2[404] = 183;
        nArray2[405] = 923;
        nArray2[406] = 116;
        nArray2[407] = 667;
        nArray2[408] = 751;
        nArray2[409] = 353;
        nArray2[410] = 62;
        nArray2[411] = 366;
        nArray2[412] = 691;
        nArray2[413] = 379;
        nArray2[414] = 687;
        nArray2[415] = 842;
        nArray2[416] = 37;
        nArray2[417] = 357;
        nArray2[418] = 720;
        nArray2[419] = 742;
        nArray2[420] = 330;
        nArray2[421] = 5;
        nArray2[422] = 39;
        nArray2[423] = 923;
        nArray2[424] = 311;
        nArray2[425] = 424;
        nArray2[426] = 242;
        nArray2[427] = 749;
        nArray2[428] = 321;
        nArray2[429] = 54;
        nArray2[430] = 669;
        nArray2[431] = 316;
        nArray2[432] = 342;
        nArray2[433] = 299;
        nArray2[434] = 534;
        nArray2[435] = 105;
        nArray2[436] = 667;
        nArray2[437] = 488;
        nArray2[438] = 640;
        nArray2[439] = 672;
        nArray2[440] = 576;
        nArray2[441] = 540;
        nArray2[442] = 316;
        nArray2[443] = 486;
        nArray2[444] = 721;
        nArray2[445] = 610;
        nArray2[446] = 46;
        nArray2[447] = 656;
        nArray2[448] = 447;
        nArray2[449] = 171;
        nArray2[450] = 616;
        nArray2[451] = 464;
        nArray2[452] = 190;
        nArray2[453] = 531;
        nArray2[454] = 297;
        nArray2[455] = 321;
        nArray2[456] = 762;
        nArray2[457] = 752;
        nArray2[458] = 533;
        nArray2[459] = 175;
        nArray2[460] = 134;
        nArray2[461] = 14;
        nArray2[462] = 381;
        nArray2[463] = 433;
        nArray2[464] = 717;
        nArray2[465] = 45;
        nArray2[466] = 111;
        nArray2[467] = 20;
        nArray2[468] = 596;
        nArray2[469] = 284;
        nArray2[470] = 736;
        nArray2[471] = 138;
        nArray2[472] = 646;
        nArray2[473] = 411;
        nArray2[474] = 877;
        nArray2[475] = 669;
        nArray2[476] = 141;
        nArray2[477] = 919;
        nArray2[478] = 45;
        nArray2[479] = 780;
        nArray2[480] = 407;
        nArray2[481] = 164;
        nArray2[482] = 332;
        nArray2[483] = 899;
        nArray2[484] = 165;
        nArray2[485] = 726;
        nArray2[486] = 600;
        nArray2[487] = 325;
        nArray2[488] = 498;
        nArray2[489] = 655;
        nArray2[490] = 357;
        nArray2[491] = 752;
        nArray2[492] = 768;
        nArray2[493] = 223;
        nArray2[494] = 849;
        nArray2[495] = 647;
        nArray2[496] = 63;
        nArray2[497] = 310;
        nArray2[498] = 863;
        nArray2[499] = 251;
        nArray2[500] = 366;
        nArray2[501] = 304;
        nArray2[502] = 282;
        nArray2[503] = 738;
        nArray2[504] = 675;
        nArray2[505] = 410;
        nArray2[506] = 389;
        nArray2[507] = 244;
        nArray2[508] = 31;
        nArray2[509] = 121;
        nArray2[510] = 303;
        nArray2[511] = 263;
        nArrayArray[8] = nArray2;
        EC_COEFFICIENTS = nArrayArray;
    }
}

