/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http1;

import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.RealResponseBody;
import dc.squareup.okhttp3.internal.http.RequestLine;
import dc.squareup.okhttp3.internal.http.StatusLine;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ForwardingTimeout;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

public final class Http1Codec
implements HttpCodec {
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;
    private static final int HEADER_LIMIT = 262144;
    final OkHttpClient client;
    final StreamAllocation streamAllocation;
    final BufferedSource source;
    final BufferedSink sink;
    int state = 0;
    private long headerLimit = 262144L;

    public Http1Codec(OkHttpClient okHttpClient, StreamAllocation streamAllocation, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        this.client = okHttpClient;
        this.streamAllocation = streamAllocation;
        this.source = bufferedSource;
        this.sink = bufferedSink;
    }

    private String readHeaderLine() throws IOException {
        String string2 = this.source.readUtf8LineStrict(this.headerLimit);
        this.headerLimit -= (long)string2.length();
        return string2;
    }

    @Override
    public Sink createRequestBody(Request request, long l5) {
        if ("chunked".equalsIgnoreCase(request.header("Transfer-Encoding"))) {
            return this.newChunkedSink();
        }
        if (l5 != -1L) {
            return this.newFixedLengthSink(l5);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public void cancel() {
        RealConnection realConnection = ((Http1Codec)((Object)realConnection)).streamAllocation.connection();
        if (realConnection != null) {
            realConnection.cancel();
            return;
        }
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        Http1Codec http1Codec = string2;
        Request request2 = request;
        String string2 = RequestLine.get(request2, ((Http1Codec)((Object)string2)).streamAllocation.connection().route().proxy().type());
        http1Codec.writeRequest(request2.headers(), string2);
    }

    @Override
    public ResponseBody openResponseBody(Response response) throws IOException {
        Object object;
        Response response2 = response;
        Object object2 = ((Http1Codec)object).streamAllocation;
        ((StreamAllocation)object2).eventListener.responseBodyStart(((StreamAllocation)object2).call);
        object2 = response2.header("Content-Type");
        if (!HttpHeaders.hasBody(response2)) {
            object = ((Http1Codec)object).newFixedLengthSource(0L);
            object = Okio.buffer((Source)object);
            return new RealResponseBody((String)object2, 0L, (BufferedSource)object);
        }
        if ("chunked".equalsIgnoreCase(response.header("Transfer-Encoding"))) {
            object = ((Http1Codec)object).newChunkedSource(response.request().url());
            object = Okio.buffer((Source)object);
            return new RealResponseBody((String)object2, -1L, (BufferedSource)object);
        }
        long l5 = HttpHeaders.contentLength(response);
        if (l5 != -1L) {
            object = ((Http1Codec)object).newFixedLengthSource(l5);
            object = Okio.buffer((Source)object);
            return new RealResponseBody((String)object2, l5, (BufferedSource)object);
        }
        object = Okio.buffer(((Http1Codec)object).newUnknownLengthSource());
        return new RealResponseBody((String)object2, -1L, (BufferedSource)object);
    }

    public boolean isClosed() {
        return this.state == 6;
    }

    @Override
    public void flushRequest() throws IOException {
        this.sink.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.sink.flush();
    }

    public void writeRequest(Headers headers, String string2) throws IOException {
        if (this.state == 0) {
            this.sink.writeUtf8(string2).writeUtf8("\r\n");
            int n5 = headers.size();
            for (int i5 = 0; i5 < n5; ++i5) {
                this.sink.writeUtf8(headers.name(i5)).writeUtf8(": ").writeUtf8(headers.value(i5)).writeUtf8("\r\n");
            }
            this.sink.writeUtf8("\r\n");
            this.state = 1;
            return;
        }
        throw new IllegalStateException("state: " + this.state);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response.Builder readResponseHeaders(boolean bl) throws IOException {
        EOFException eOFException2;
        block6: {
            StatusLine statusLine;
            boolean bl2;
            int n5 = this.state;
            if (n5 != 1 && n5 != 3) {
                throw new IllegalStateException("state: " + this.state);
            }
            try {
                bl2 = bl;
                statusLine = StatusLine.parse(this.readHeaderLine());
            }
            catch (EOFException eOFException2) {
                break block6;
            }
            Response.Builder builder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.readHeaders());
            if (bl2 && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return builder;
            }
            this.state = 4;
            return builder;
        }
        IOException iOException = new IOException("unexpected end of stream on " + this.streamAllocation);
        iOException.initCause(eOFException2);
        throw iOException;
    }

    public Headers readHeaders() throws IOException {
        String string2;
        Headers.Builder builder;
        Headers.Builder builder2 = builder;
        builder = new Headers.Builder();
        while ((string2 = this.readHeaderLine()).length() != 0) {
            Internal.instance.addLenient(builder2, string2);
        }
        return builder2.build();
    }

    public Sink newChunkedSink() {
        if (this.state == 1) {
            this.state = 2;
            return new ChunkedSink();
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Sink newFixedLengthSink(long l5) {
        if (this.state == 1) {
            this.state = 2;
            return new FixedLengthSink(l5);
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Source newFixedLengthSource(long l5) throws IOException {
        if (this.state == 4) {
            this.state = 5;
            return new FixedLengthSource(l5);
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Source newChunkedSource(HttpUrl httpUrl) throws IOException {
        if (this.state == 4) {
            this.state = 5;
            return new ChunkedSource(httpUrl);
        }
        throw new IllegalStateException("state: " + this.state);
    }

    public Source newUnknownLengthSource() throws IOException {
        if (this.state == 4) {
            StreamAllocation streamAllocation = this.streamAllocation;
            if (streamAllocation != null) {
                this.state = 5;
                streamAllocation.noNewStreams();
                return new UnknownLengthSource();
            }
            throw new IllegalStateException("streamAllocation == null");
        }
        throw new IllegalStateException("state: " + this.state);
    }

    void detachTimeout(ForwardingTimeout forwardingTimeout) {
        Timeout timeout = forwardingTimeout.delegate();
        forwardingTimeout.setDelegate(Timeout.NONE);
        timeout.clearDeadline();
        timeout.clearTimeout();
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l5) throws IOException {
            if (!this.closed) {
                if (l5 == 0L) {
                    return;
                }
                ChunkedSink chunkedSink = this;
                chunkedSink.Http1Codec.this.sink.writeHexadecimalUnsignedLong(l5);
                chunkedSink.Http1Codec.this.sink.writeUtf8("\r\n");
                chunkedSink.Http1Codec.this.sink.write(buffer, l5);
                chunkedSink.Http1Codec.this.sink.writeUtf8("\r\n");
                return;
            }
            throw new IllegalStateException("closed");
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            ChunkedSink chunkedSink = this;
            chunkedSink.closed = true;
            chunkedSink.Http1Codec.this.sink.writeUtf8("0\r\n\r\n");
            chunkedSink.Http1Codec.this.detachTimeout(this.timeout);
            chunkedSink.Http1Codec.this.state = 3;
        }
    }

    private final class FixedLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private long bytesRemaining;

        FixedLengthSink(long l5) {
            this.timeout = new ForwardingTimeout(Http1Codec.this.sink.timeout());
            this.bytesRemaining = l5;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer buffer, long l5) throws IOException {
            if (!this.closed) {
                Util.checkOffsetAndCount(buffer.size(), 0L, l5);
                if (l5 <= this.bytesRemaining) {
                    FixedLengthSink fixedLengthSink = this;
                    fixedLengthSink.Http1Codec.this.sink.write(buffer, l5);
                    fixedLengthSink.bytesRemaining -= l5;
                    return;
                }
                throw new ProtocolException("expected " + this.bytesRemaining + " bytes but received " + l5);
            }
            throw new IllegalStateException("closed");
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            Http1Codec.this.sink.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.bytesRemaining <= 0L) {
                Http1Codec.this.detachTimeout(this.timeout);
                Http1Codec.this.state = 3;
                return;
            }
            throw new ProtocolException("unexpected end of stream");
        }
    }

    private class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        FixedLengthSource(long l5) throws IOException {
            this.bytesRemaining = l5;
            if (l5 == 0L) {
                this.endOfInput(true, null);
                return;
            }
        }

        @Override
        public long read(Buffer buffer, long l5) throws IOException {
            if (l5 >= 0L) {
                if (!this.closed) {
                    ProtocolException protocolException;
                    long l6 = this.bytesRemaining;
                    if (l6 == 0L) {
                        return -1L;
                    }
                    long l7 = super.read(buffer, Math.min(l6, l5));
                    if (l7 != -1L) {
                        this.bytesRemaining = l6 = this.bytesRemaining - l7;
                        if (l6 == 0L) {
                            this.endOfInput(true, null);
                            return l7;
                        }
                        return l7;
                    }
                    ProtocolException protocolException2 = protocolException;
                    protocolException2("unexpected end of stream");
                    this.endOfInput(false, protocolException2);
                    throw protocolException;
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l5);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }
    }

    private class ChunkedSource
    extends AbstractSource {
        private static final long NO_CHUNK_YET = -1L;
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        ChunkedSource(HttpUrl httpUrl) {
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
            this.url = httpUrl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readChunkSize() throws IOException {
            String string2;
            block4: {
                ChunkedSource chunkedSource;
                if (this.bytesRemainingInChunk != -1L) {
                    Http1Codec.this.source.readUtf8LineStrict();
                }
                try {
                    ChunkedSource chunkedSource2 = this;
                    chunkedSource2.bytesRemainingInChunk = chunkedSource2.Http1Codec.this.source.readHexadecimalUnsignedLong();
                    string2 = chunkedSource2.Http1Codec.this.source.readUtf8LineStrict().trim();
                    if (chunkedSource2.bytesRemainingInChunk < 0L || !string2.isEmpty() && !string2.startsWith(";")) break block4;
                    if (this.bytesRemainingInChunk != 0L) return;
                    chunkedSource = this;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProtocolException(numberFormatException.getMessage());
                }
                chunkedSource.hasMoreChunks = false;
                HttpHeaders.receiveHeaders(chunkedSource.Http1Codec.this.client.cookieJar(), this.url, Http1Codec.this.readHeaders());
                chunkedSource.endOfInput(true, null);
                return;
            }
            throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string2 + "\"");
        }

        @Override
        public long read(Buffer buffer, long l5) throws IOException {
            if (l5 >= 0L) {
                if (!this.closed) {
                    ProtocolException protocolException;
                    long l6;
                    if (!this.hasMoreChunks) {
                        return -1L;
                    }
                    long l7 = this.bytesRemainingInChunk;
                    if (l7 == 0L || l7 == -1L) {
                        ChunkedSource chunkedSource = this;
                        chunkedSource.readChunkSize();
                        if (!chunkedSource.hasMoreChunks) {
                            return -1L;
                        }
                    }
                    if ((l6 = super.read(buffer, Math.min(l5, this.bytesRemainingInChunk))) != -1L) {
                        this.bytesRemainingInChunk -= l6;
                        return l6;
                    }
                    ProtocolException protocolException2 = protocolException;
                    protocolException2("unexpected end of stream");
                    this.endOfInput(false, protocolException2);
                    throw protocolException;
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l5);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }
    }

    private class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        UnknownLengthSource() {
        }

        @Override
        public long read(Buffer buffer, long l5) throws IOException {
            if (l5 >= 0L) {
                if (!this.closed) {
                    if (this.inputExhausted) {
                        return -1L;
                    }
                    long l6 = super.read(buffer, l5);
                    if (l6 == -1L) {
                        this.inputExhausted = true;
                        this.endOfInput(true, null);
                        return -1L;
                    }
                    return l6;
                }
                throw new IllegalStateException("closed");
            }
            throw new IllegalArgumentException("byteCount < 0: " + l5);
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.inputExhausted) {
                this.endOfInput(false, null);
            }
            this.closed = true;
        }
    }

    private abstract class AbstractSource
    implements Source {
        protected final ForwardingTimeout timeout;
        protected boolean closed;
        protected long bytesRead;

        private AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1Codec.this.source.timeout());
            this.bytesRead = 0L;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(Buffer buffer, long l5) throws IOException {
            IOException iOException2;
            block5: {
                long l6;
                block4: {
                    try {
                        l6 = Http1Codec.this.source.read(buffer, l5);
                        if (l6 <= 0L) break block4;
                    }
                    catch (IOException iOException2) {}
                    long l7 = l6;
                    AbstractSource abstractSource = this;
                    AbstractSource abstractSource2 = abstractSource;
                    long l8 = abstractSource.bytesRead;
                    abstractSource2.bytesRead = l8 + l6;
                    return l7;
                    break block5;
                }
                return l6;
            }
            this.endOfInput(false, iOException2);
            throw iOException2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final void endOfInput(boolean bl, IOException iOException) throws IOException {
            Http1Codec http1Codec = Http1Codec.this;
            int n5 = http1Codec.state;
            if (n5 == 6) return;
            if (n5 != 5) throw new IllegalStateException("state: " + Http1Codec.this.state);
            http1Codec.detachTimeout(this.timeout);
            http1Codec = Http1Codec.this;
            http1Codec.state = 6;
            StreamAllocation streamAllocation = http1Codec.streamAllocation;
            if (streamAllocation == null) return;
            boolean bl2 = bl ^ true;
            long l5 = this.bytesRead;
            streamAllocation.streamFinished(bl2, http1Codec, l5, iOException);
        }
    }
}

