/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.InflaterSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Inflater;

public final class GzipSource
implements Source {
    private static final byte FHCRC = 1;
    private static final byte FEXTRA = 2;
    private static final byte FNAME = 3;
    private static final byte FCOMMENT = 4;
    private static final byte SECTION_HEADER = 0;
    private static final byte SECTION_BODY = 1;
    private static final byte SECTION_TRAILER = 2;
    private static final byte SECTION_DONE = 3;
    private int section = 0;
    private final BufferedSource source;
    private final Inflater inflater;
    private final InflaterSource inflaterSource;
    private final CRC32 crc;

    public GzipSource(Source source) {
        CRC32 cRC32;
        Object object = cRC32;
        cRC32 = new CRC32();
        ((GzipSource)((Object)inflater2)).crc = object;
        if (source != null) {
            InflaterSource inflaterSource;
            Inflater inflater;
            GzipSource gzipSource = inflater2;
            GzipSource gzipSource2 = inflater2;
            Inflater inflater2 = inflater;
            inflater = new Inflater(true);
            gzipSource2.inflater = inflater2;
            source = Okio.buffer(source);
            gzipSource.source = source;
            object = inflaterSource;
            inflaterSource = new InflaterSource((BufferedSource)source, inflater2);
            gzipSource.inflaterSource = object;
            return;
        }
        throw new IllegalArgumentException("source == null");
    }

    private void consumeHeader() throws IOException {
        this.source.require(10L);
        short s5 = this.source.buffer().getByte(3L);
        short s6 = (s5 >> 1 & 1) == 1 ? (short)1 : 0;
        if (s6 != 0) {
            this.updateCrc(this.source.buffer(), 0L, 10L);
        }
        short s7 = this.source.readShort();
        this.checkEqual("ID1ID2", 8075, s7);
        this.source.skip(8L);
        if ((s5 >> 2 & 1) == 1) {
            this.source.require(2L);
            if (s6 != 0) {
                this.updateCrc(this.source.buffer(), 0L, 2L);
            }
            long l5 = this.source.buffer().readShortLe();
            this.source.require(l5);
            if (s6 != 0) {
                this.updateCrc(this.source.buffer(), 0L, l5);
            }
            this.source.skip(l5);
        }
        if ((s5 >> 3 & 1) == 1) {
            long l6 = this.source.indexOf((byte)0);
            if (l6 != -1L) {
                if (s6 != 0) {
                    Buffer buffer = this.source.buffer();
                    long l7 = l6 + 1L;
                    this.updateCrc(buffer, 0L, l7);
                }
                this.source.skip(l6 + 1L);
            } else {
                throw new EOFException();
            }
        }
        if ((s5 >> 4 & 1) == 1) {
            long l8 = this.source.indexOf((byte)0);
            if (l8 != -1L) {
                if (s6 != 0) {
                    Buffer buffer = this.source.buffer();
                    long l9 = l8 + 1L;
                    this.updateCrc(buffer, 0L, l9);
                }
                this.source.skip(l8 + 1L);
            } else {
                throw new EOFException();
            }
        }
        if (s6 != 0) {
            s5 = this.source.readShortLe();
            s6 = (short)this.crc.getValue();
            this.checkEqual("FHCRC", s5, s6);
            this.crc.reset();
            return;
        }
    }

    private void consumeTrailer() throws IOException {
        GzipSource gzipSource = this;
        int n5 = gzipSource.source.readIntLe();
        int n6 = (int)gzipSource.crc.getValue();
        gzipSource.checkEqual("CRC", n5, n6);
        n5 = gzipSource.source.readIntLe();
        n6 = (int)gzipSource.inflater.getBytesWritten();
        gzipSource.checkEqual("ISIZE", n5, n6);
    }

    private void updateCrc(Buffer object, long l5, long l6) {
        int n5;
        int n6;
        object = ((Buffer)object).head;
        while (l5 >= (long)((n6 = ((Segment)object).limit) - (n5 = ((Segment)object).pos))) {
            l5 -= (long)(n6 - n5);
            object = ((Segment)object).next;
        }
        while (l6 > 0L) {
            Object object2 = object;
            int n7 = (int)((long)((Segment)object2).pos + l5);
            int n8 = (int)Math.min((long)(((Segment)object2).limit - n7), l6);
            this.crc.update(((Segment)object).data, n7, n8);
            l6 -= (long)n8;
            l5 = 0L;
            object = ((Segment)object).next;
        }
    }

    private void checkEqual(String string2, int n5, int n6) throws IOException {
        if (n6 == n5) {
            return;
        }
        Integer n7 = n6;
        Integer n8 = n5;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        objectArray[1] = n7;
        objectArray[2] = n8;
        throw new IOException(String.format("%s: actual 0x%08x != expected 0x%08x", objectArray2));
    }

    @Override
    public long read(Buffer buffer, long l5) throws IOException {
        if (l5 >= 0L) {
            if (l5 == 0L) {
                return 0L;
            }
            if (this.section == 0) {
                this.consumeHeader();
                this.section = 1;
            }
            if (this.section == 1) {
                long l6 = buffer.size;
                if ((l5 = this.inflaterSource.read(buffer, l5)) != -1L) {
                    this.updateCrc(buffer, l6, l5);
                    return l5;
                }
                this.section = 2;
            }
            if (this.section == 2) {
                GzipSource gzipSource = this;
                gzipSource.consumeTrailer();
                gzipSource.section = 3;
                if (!gzipSource.source.exhausted()) {
                    throw new IOException("gzip finished without exhausting source");
                }
            }
            return -1L;
        }
        throw new IllegalArgumentException("byteCount < 0: " + l5);
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        this.inflaterSource.close();
    }
}

