/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EscCharsetProber;
import org.mozilla.universalchardet.prober.MBCSGroupProber;

public class UniversalDetector {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final float MINIMUM_THRESHOLD = 0.2f;
    private InputState inputState;
    private boolean done;
    private boolean start;
    private boolean gotData;
    private byte lastChar;
    private String detectedCharset;
    private CharsetProber[] probers;
    private CharsetProber escCharsetProber;
    private CharsetListener listener;

    public UniversalDetector() {
        this(null);
    }

    public UniversalDetector(CharsetListener charsetListener) {
        this.listener = charsetListener;
        this.escCharsetProber = null;
        this.probers = new CharsetProber[1];
        this.reset();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String detectCharset(File object) throws IOException {
        Throwable throwable2;
        FileInputStream fileInputStream;
        block7: {
            int n5;
            UniversalDetector universalDetector;
            FileInputStream fileInputStream2;
            fileInputStream = fileInputStream2;
            fileInputStream2 = new FileInputStream((File)object);
            try {
                object = new byte[4096];
            }
            catch (Throwable throwable2) {
                break block7;
            }
            UniversalDetector universalDetector2 = universalDetector;
            {
                universalDetector = new UniversalDetector(null);
            }
            while ((n5 = fileInputStream.read((byte[])object)) > 0 && !universalDetector2.isDone()) {
                universalDetector2.handleData((byte[])object, 0, n5);
            }
            UniversalDetector universalDetector3 = universalDetector2;
            universalDetector3.dataEnd();
            String string2 = universalDetector3.getDetectedCharset();
            universalDetector2.reset();
            fileInputStream.close();
            return string2;
        }
        try {
            fileInputStream.close();
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throwable2.addSuppressed(throwable3);
        }
        throw throwable2;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    public void setListener(CharsetListener charsetListener) {
        this.listener = charsetListener;
    }

    public CharsetListener getListener() {
        return this.listener;
    }

    public void handleData(byte[] byArray) {
        int n5 = byArray.length;
        this.handleData(byArray, 0, n5);
    }

    public void handleData(byte[] byArray, int n5, int n6) {
        if (!this.done) {
            int n7;
            int n8;
            int n9;
            int n10;
            if (n6 > 0) {
                this.gotData = true;
            }
            if (this.start) {
                this.start = false;
                if (n6 > 3) {
                    n10 = byArray[n5] & 0xFF;
                    n9 = byArray[n5 + 1] & 0xFF;
                    n8 = byArray[n5 + 2] & 0xFF;
                    n7 = byArray[n5 + 3] & 0xFF;
                    if (n10 != 0) {
                        if (n10 != 239) {
                            if (n10 != 254) {
                                if (n10 == 255) {
                                    if (n9 == 254 && n8 == 0 && n7 == 0) {
                                        this.detectedCharset = Constants.CHARSET_UTF_32LE;
                                    } else if (n9 == 254) {
                                        this.detectedCharset = Constants.CHARSET_UTF_16LE;
                                    }
                                }
                            } else if (n9 == 255 && n8 == 0 && n7 == 0) {
                                this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_3412;
                            } else if (n9 == 255) {
                                this.detectedCharset = Constants.CHARSET_UTF_16BE;
                            }
                        } else if (n9 == 187 && n8 == 191) {
                            this.detectedCharset = Constants.CHARSET_UTF_8;
                        }
                    } else if (n9 == 0 && n8 == 254 && n7 == 255) {
                        this.detectedCharset = Constants.CHARSET_UTF_32BE;
                    } else if (n9 == 0 && n8 == 255 && n7 == 254) {
                        this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_2143;
                    }
                    if (this.detectedCharset != null) {
                        this.done = true;
                        return;
                    }
                }
            }
            n10 = n5 + n6;
            for (n9 = n5; n9 < n10; ++n9) {
                n8 = byArray[n9];
                n7 = n8 & 0xFF;
                if ((n8 & 0x80) != 0 && n7 != 160) {
                    MBCSGroupProber mBCSGroupProber;
                    Object object = InputState.HIGHBYTE;
                    if (this.inputState == InputState.HIGHBYTE) continue;
                    this.inputState = object;
                    if (this.escCharsetProber != null) {
                        this.escCharsetProber = null;
                    }
                    object = this.probers;
                    if (this.probers[0] != null) continue;
                    CharsetProber[] charsetProberArray = object;
                    object = mBCSGroupProber;
                    mBCSGroupProber = new MBCSGroupProber();
                    charsetProberArray[0] = object;
                    continue;
                }
                if (this.inputState == InputState.PURE_ASCII && (n7 == 27 || n7 == 123 && this.lastChar == 126)) {
                    this.inputState = InputState.ESC_ASCII;
                }
                this.lastChar = n8;
            }
            Object object = this.inputState;
            if (object == InputState.ESC_ASCII) {
                if (this.escCharsetProber == null) {
                    EscCharsetProber escCharsetProber;
                    object = escCharsetProber;
                    escCharsetProber = new EscCharsetProber();
                    this.escCharsetProber = object;
                }
                if (this.escCharsetProber.handleData(byArray, n5, n6) == CharsetProber.ProbingState.FOUND_IT) {
                    this.done = true;
                    this.detectedCharset = this.escCharsetProber.getCharSetName();
                    return;
                }
            } else if (object == InputState.HIGHBYTE) {
                int n11 = 0;
                while (true) {
                    CharsetProber[] charsetProberArray = this.probers;
                    if (n11 >= this.probers.length) break;
                    if (charsetProberArray[n11].handleData(byArray, n5, n6) == CharsetProber.ProbingState.FOUND_IT) {
                        this.done = true;
                        this.detectedCharset = this.probers[n11].getCharSetName();
                        return;
                    }
                    ++n11;
                }
            }
        }
    }

    public void dataEnd() {
        if (((UniversalDetector)object).gotData) {
            Object object;
            String string2 = ((UniversalDetector)object).detectedCharset;
            if (string2 != null) {
                ((UniversalDetector)object).done = true;
                object = ((UniversalDetector)object).listener;
                if (object != null) {
                    object.report(string2);
                    return;
                }
            } else if (((UniversalDetector)object).inputState == InputState.HIGHBYTE) {
                CharsetProber[] charsetProberArray;
                float f5 = 0.0f;
                int n5 = 0;
                int n6 = 0;
                while (true) {
                    float f6;
                    charsetProberArray = ((UniversalDetector)object).probers;
                    if (n6 >= ((UniversalDetector)object).probers.length) break;
                    float f7 = charsetProberArray[n6].getConfidence();
                    if (f6 > f5) {
                        n5 = n6;
                        f5 = f7;
                    }
                    ++n6;
                }
                if (f5 > 0.2f) {
                    Object object2 = object;
                    object = charsetProberArray[n5].getCharSetName();
                    ((UniversalDetector)object2).detectedCharset = object;
                    CharsetListener charsetListener = ((UniversalDetector)object2).listener;
                    if (charsetListener != null) {
                        charsetListener.report((String)object);
                        return;
                    }
                }
            }
        }
    }

    public void reset() {
        this.done = false;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = false;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = 0;
        CharsetProber charsetProber = this.escCharsetProber;
        if (charsetProber != null) {
            charsetProber.reset();
        }
        int n5 = 0;
        while (true) {
            Object object = this.probers;
            if (n5 >= this.probers.length) break;
            if ((object = object[n5]) != null) {
                ((CharsetProber)object).reset();
            }
            ++n5;
        }
    }

    public static enum InputState {
        PURE_ASCII,
        ESC_ASCII,
        HIGHBYTE;

    }
}

