/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils.batch;

import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import java.util.concurrent.CopyOnWriteArrayList;

public class BatchOperationHelper
implements Interceptor {
    private BactchExecutor mExecutor;
    private CopyOnWriteArrayList<Runnable> sRegisterTasks;
    private boolean isCollecting;

    public BatchOperationHelper(BactchExecutor bactchExecutor) {
        CopyOnWriteArrayList copyOnWriteArrayList;
        CopyOnWriteArrayList copyOnWriteArrayList2 = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        this.sRegisterTasks = copyOnWriteArrayList2;
        this.isCollecting = false;
        this.mExecutor = bactchExecutor;
        bactchExecutor.setInterceptor(this);
        this.isCollecting = true;
    }

    @Override
    public boolean take(Runnable runnable) {
        if (this.isCollecting) {
            this.sRegisterTasks.add(runnable);
            return true;
        }
        return false;
    }

    public void flush() {
        BatchOperationHelper batchOperationHelper = this;
        batchOperationHelper.isCollecting = false;
        batchOperationHelper.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                for (Runnable runnable : BatchOperationHelper.this.sRegisterTasks) {
                    runnable.run();
                    BatchOperationHelper.this.sRegisterTasks.remove(runnable);
                }
            }
        });
        batchOperationHelper.mExecutor.setInterceptor(null);
    }
}

