/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.view.animation.Interpolator;
import io.dcloud.nineoldandroids.animation.Keyframe;
import io.dcloud.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class IntKeyframeSet
extends KeyframeSet {
    private int firstValue;
    private int lastValue;
    private int deltaValue;
    private boolean firstTime = true;

    public IntKeyframeSet(Keyframe.IntKeyframe ... keyframes) {
        super(keyframes);
    }

    @Override
    public Object getValue(float fraction) {
        return this.getIntValue(fraction);
    }

    @Override
    public IntKeyframeSet clone() {
        ArrayList keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe.IntKeyframe[] newKeyframes = new Keyframe.IntKeyframe[numKeyframes];
        int i = 0;
        while (i < numKeyframes) {
            newKeyframes[i] = (Keyframe.IntKeyframe)((Keyframe)keyframes.get(i)).clone();
            ++i;
        }
        IntKeyframeSet newSet = new IntKeyframeSet(newKeyframes);
        return newSet;
    }

    public int getIntValue(float fraction) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(0)).getIntValue();
                this.lastValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(1)).getIntValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                fraction = this.mInterpolator.getInterpolation(fraction);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + (int)(fraction * (float)this.deltaValue);
            }
            return ((Number)this.mEvaluator.evaluate(fraction, this.firstValue, this.lastValue)).intValue();
        }
        if (fraction <= 0.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
        }
        if (fraction >= 1.0f) {
            Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            int prevValue = prevKeyframe.getIntValue();
            int nextValue = nextKeyframe.getIntValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
        }
        Keyframe.IntKeyframe prevKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        int i = 1;
        while (i < this.mNumKeyframes) {
            Keyframe.IntKeyframe nextKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator = nextKeyframe.getInterpolator();
                if (interpolator != null) {
                    fraction = interpolator.getInterpolation(fraction);
                }
                float intervalFraction = (fraction - prevKeyframe.getFraction()) / (nextKeyframe.getFraction() - prevKeyframe.getFraction());
                int prevValue = prevKeyframe.getIntValue();
                int nextValue = nextKeyframe.getIntValue();
                return this.mEvaluator == null ? prevValue + (int)(intervalFraction * (float)(nextValue - prevValue)) : ((Number)this.mEvaluator.evaluate(intervalFraction, prevValue, nextValue)).intValue();
            }
            prevKeyframe = nextKeyframe;
            ++i;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).intValue();
    }
}

