/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.Token;
import com.dcloud.zxing2.common.BitArray;

final class BinaryShiftToken
extends Token {
    private final short binaryShiftStart;
    private final short binaryShiftByteCount;

    BinaryShiftToken(Token token, int n5, int n6) {
        super(token);
        this.binaryShiftStart = (short)n5;
        this.binaryShiftByteCount = (short)n6;
    }

    @Override
    public void appendTo(BitArray bitArray, byte[] byArray) {
        int n5;
        for (int i5 = 0; i5 < (n5 = this.binaryShiftByteCount); ++i5) {
            if (i5 == 0 || i5 == 31 && n5 <= 62) {
                bitArray.appendBits(31, 5);
                n5 = this.binaryShiftByteCount;
                if (n5 > 62) {
                    bitArray.appendBits(n5 - 31, 16);
                } else if (i5 == 0) {
                    bitArray.appendBits(Math.min(n5, 31), 5);
                } else {
                    bitArray.appendBits(n5 - 31, 5);
                }
            }
            bitArray.appendBits(byArray[this.binaryShiftStart + i5], 8);
        }
    }

    public String toString() {
        return "<" + this.binaryShiftStart + "::" + (this.binaryShiftStart + this.binaryShiftByteCount - 1) + '>';
    }
}

