/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.multi;

import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import java.util.Map;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    public ByQuadrantReader(Reader reader) {
        this.delegate = reader;
    }

    private static void makeAbsolute(ResultPoint[] resultPointArray, int n5, int n6) {
        if (resultPointArray != null) {
            for (int i5 = 0; i5 < resultPointArray.length; ++i5) {
                ResultPoint resultPoint = resultPointArray[i5];
                resultPointArray[i5] = new ResultPoint(resultPoint.getX() + (float)n5, resultPoint.getY() + (float)n6);
            }
        }
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        BinaryBitmap binaryBitmap2 = binaryBitmap;
        int n5 = binaryBitmap2.getWidth();
        n5 /= 2;
        int n6 = binaryBitmap2.getHeight() / 2;
        try {
            return this.delegate.decode(binaryBitmap.crop(0, 0, n5, n6), map);
        }
        catch (NotFoundException notFoundException) {
            try {
                Result result = this.delegate.decode(binaryBitmap.crop(n5, 0, n5, n6), map);
                ByQuadrantReader.makeAbsolute(result.getResultPoints(), n5, 0);
                return result;
            }
            catch (NotFoundException notFoundException2) {
                try {
                    Result result = this.delegate.decode(binaryBitmap.crop(0, n6, n5, n6), map);
                    ByQuadrantReader.makeAbsolute(result.getResultPoints(), 0, n6);
                    return result;
                }
                catch (NotFoundException notFoundException3) {
                    try {
                        Result result = this.delegate.decode(binaryBitmap.crop(n5, n6, n5, n6), map);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), n5, n6);
                        return result;
                    }
                    catch (NotFoundException notFoundException4) {
                        int n7 = n5 / 2;
                        int n8 = n6 / 2;
                        BinaryBitmap binaryBitmap3 = binaryBitmap.crop(n7, n8, n5, n6);
                        Result result = this.delegate.decode(binaryBitmap3, map);
                        ByQuadrantReader.makeAbsolute(result.getResultPoints(), n7, n8);
                        return result;
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

