/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code93Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    static final int[] CHARACTER_ENCODINGS;
    private static final int ASTERISK_ENCODING;
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private final int[] counters = new int[6];

    private int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n5;
        Code93Reader code93Reader = this;
        int n6 = bitArray.getSize();
        Arrays.fill(code93Reader.counters, 0);
        int[] nArray = code93Reader.counters;
        int n7 = 0;
        int n8 = code93Reader.counters.length;
        int n9 = 0;
        int n10 = n7;
        n7 = n5;
        int n11 = n9;
        n9 = n10;
        for (n5 = (v91736).getNextSet(0); n5 < n6; ++n5) {
            if ((bitArray.get(n5) ^ n9) != 0) {
                nArray[n11] = nArray[n11] + 1;
                continue;
            }
            int n12 = n8 - 1;
            if (n11 == n12) {
                if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                    return new int[]{n7, n5};
                }
                int n13 = n12;
                n7 += nArray[0] + nArray[1];
                n12 = n8 - 2;
                System.arraycopy(nArray, 2, nArray, 0, n12);
                nArray[n12] = 0;
                nArray[n13] = 0;
                --n11;
            } else {
                ++n11;
            }
            nArray[n11] = 1;
            n9 ^= 1;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n5;
        int n6 = nArray.length;
        int n7 = 0;
        int n8 = nArray.length;
        for (n5 = 0; n5 < n8; ++n5) {
            n7 += nArray[n5];
        }
        n8 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            int n9 = Math.round((float)nArray[n5] * 9.0f / (float)n7);
            if (n9 >= 1 && n9 <= 4) {
                if ((n5 & 1) == 0) {
                    for (int i5 = 0; i5 < n9; ++i5) {
                        n8 = n8 << 1 | 1;
                    }
                    continue;
                }
                n8 <<= n9;
                continue;
            }
            return -1;
        }
        return n8;
    }

    private static char patternToChar(int n5) throws NotFoundException {
        int n6 = 0;
        while (true) {
            int[] nArray = CHARACTER_ENCODINGS;
            if (n6 >= CHARACTER_ENCODINGS.length) break;
            if (nArray[n6] == n5) {
                return ALPHABET[n6];
            }
            ++n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        StringBuilder stringBuilder;
        int n5 = charSequence.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n5);
        for (int i5 = 0; i5 < n5; ++i5) {
            char c6;
            block15: {
                block16: {
                    block17: {
                        c6 = charSequence.charAt(i5);
                        if (c6 < 'a' || c6 > 'd') break block15;
                        if (i5 >= n5 - 1) break block16;
                        char c7 = c6;
                        c6 = charSequence.charAt(++i5);
                        int n6 = 0;
                        switch (c7) {
                            default: {
                                break;
                            }
                            case 'd': {
                                if (c6 >= 'A' && c6 <= 'Z') {
                                    n6 = (char)(c6 + 32);
                                    break;
                                }
                                throw FormatException.getFormatInstance();
                            }
                            case 'c': {
                                if (c6 >= 'A' && c6 <= 'O') {
                                    n6 = (char)(c6 - 32);
                                    break;
                                }
                                if (c6 == 'Z') {
                                    n6 = 58;
                                    break;
                                }
                                throw FormatException.getFormatInstance();
                            }
                            case 'b': {
                                if (c6 >= 'A' && c6 <= 'E') {
                                    n6 = (char)(c6 - 38);
                                    break;
                                }
                                if (c6 >= 'F' && c6 <= 'J') {
                                    n6 = (char)(c6 - 11);
                                    break;
                                }
                                if (c6 >= 'K' && c6 <= 'O') {
                                    n6 = (char)(c6 + 16);
                                    break;
                                }
                                if (c6 >= 'P' && c6 <= 'S') {
                                    n6 = (char)(c6 + 43);
                                    break;
                                }
                                if (c6 >= 'T' && c6 <= 'Z') {
                                    n6 = 127;
                                    break;
                                }
                                throw FormatException.getFormatInstance();
                            }
                            case 'a': {
                                if (c6 < 'A' || c6 > 'Z') break block17;
                                n6 = (char)(c6 - 64);
                            }
                        }
                        stringBuilder2.append((char)n6);
                        continue;
                    }
                    throw FormatException.getFormatInstance();
                }
                throw FormatException.getFormatInstance();
            }
            stringBuilder2.append(c6);
        }
        return stringBuilder2.toString();
    }

    private static void checkChecksums(CharSequence charSequence) throws ChecksumException {
        CharSequence charSequence2 = charSequence;
        int n5 = charSequence2.length();
        Code93Reader.checkOneChecksum(charSequence, n5 - 2, 20);
        Code93Reader.checkOneChecksum(charSequence2, n5 - 1, 15);
    }

    private static void checkOneChecksum(CharSequence charSequence, int n5, int n6) throws ChecksumException {
        int n7 = 1;
        int n8 = 0;
        for (int i5 = n5 - 1; i5 >= 0; --i5) {
            n8 += n7 * ALPHABET_STRING.indexOf(charSequence.charAt(i5));
            if (++n7 <= n6) continue;
            n7 = 1;
        }
        if (charSequence.charAt(n5) == ALPHABET[n8 % 47]) {
            return;
        }
        throw ChecksumException.getChecksumInstance();
    }

    static {
        int[] nArray = new int[48];
        int[] nArray2 = nArray;
        nArray[0] = 276;
        nArray2[1] = 328;
        nArray2[2] = 324;
        nArray2[3] = 322;
        nArray2[4] = 296;
        nArray2[5] = 292;
        nArray2[6] = 290;
        nArray2[7] = 336;
        nArray2[8] = 274;
        nArray2[9] = 266;
        nArray2[10] = 424;
        nArray2[11] = 420;
        nArray2[12] = 418;
        nArray2[13] = 404;
        nArray2[14] = 402;
        nArray2[15] = 394;
        nArray2[16] = 360;
        nArray2[17] = 356;
        nArray2[18] = 354;
        nArray2[19] = 308;
        nArray2[20] = 282;
        nArray2[21] = 344;
        nArray2[22] = 332;
        nArray2[23] = 326;
        nArray2[24] = 300;
        nArray2[25] = 278;
        nArray2[26] = 436;
        nArray2[27] = 434;
        nArray2[28] = 428;
        nArray2[29] = 422;
        nArray2[30] = 406;
        nArray2[31] = 410;
        nArray2[32] = 364;
        nArray2[33] = 358;
        nArray2[34] = 310;
        nArray2[35] = 314;
        nArray2[36] = 302;
        nArray2[37] = 468;
        nArray2[38] = 466;
        nArray2[39] = 458;
        nArray2[40] = 366;
        nArray2[41] = 374;
        nArray2[42] = 430;
        nArray2[43] = 294;
        nArray2[44] = 474;
        nArray2[45] = 470;
        nArray2[46] = 306;
        nArray2[47] = 350;
        CHARACTER_ENCODINGS = nArray2;
        ASTERISK_ENCODING = nArray2[47];
    }

    @Override
    public Result decodeRow(int n5, BitArray object, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        Code93Reader code93Reader = object2;
        BitArray bitArray = object;
        int[] nArray = ((Code93Reader)object2).findAsteriskPattern((BitArray)object);
        Object object2 = nArray;
        int n6 = bitArray.getNextSet(nArray[1]);
        int n7 = bitArray.getSize();
        int[] nArray2 = code93Reader.counters;
        Arrays.fill(code93Reader.counters, 0);
        StringBuilder stringBuilder = code93Reader.decodeRowResult;
        stringBuilder.setLength(0);
        while (true) {
            int n8;
            OneDReader.recordPattern((BitArray)object, n6, nArray2);
            int n9 = Code93Reader.toPattern(nArray2);
            if (n9 < 0) break;
            char c6 = Code93Reader.patternToChar(n9);
            n9 = c6;
            stringBuilder.append(c6);
            int n10 = nArray2.length;
            int n11 = n6;
            for (n8 = 0; n8 < n10; ++n8) {
                n11 += nArray2[n8];
            }
            int n12 = n9;
            n9 = ((BitArray)object).getNextSet(n11);
            if (n12 == 42) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                n10 = 0;
                n8 = nArray2.length;
                for (n11 = 0; n11 < n8; ++n11) {
                    n10 += nArray2[n11];
                }
                if (n9 != n7 && ((BitArray)object).get(n9)) {
                    if (stringBuilder.length() >= 2) {
                        ResultPoint resultPoint;
                        ResultPoint resultPoint2;
                        StringBuilder stringBuilder3 = stringBuilder;
                        Code93Reader.checkChecksums(stringBuilder3);
                        stringBuilder3.setLength(stringBuilder3.length() - 2);
                        object = Code93Reader.decodeExtended(stringBuilder3);
                        float f5 = (float)(object2[1] + object2[0]) / 2.0f;
                        float f6 = (float)n6 + (float)n10 / 2.0f;
                        Object object3 = object;
                        object = resultPoint2;
                        float f7 = f5;
                        f5 = n5;
                        resultPoint2 = new ResultPoint(f7, f5);
                        Object object4 = resultPoint;
                        resultPoint = new ResultPoint(f6, f5);
                        ResultPoint[] resultPointArray = new ResultPoint[2];
                        ResultPoint[] resultPointArray2 = resultPointArray;
                        resultPointArray[0] = object;
                        resultPointArray[1] = object4;
                        object4 = BarcodeFormat.CODE_93;
                        return new Result((String)object3, null, resultPointArray2, (BarcodeFormat)((Object)object4));
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n6 = n9;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

