/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.internal.Util;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public final class Challenge {
    private final String scheme;
    private final Map<String, String> authParams;

    public Challenge(String object, Map<String, String> object2) {
        if (object != null) {
            if (object2 != null) {
                LinkedHashMap linkedHashMap;
                this.scheme = object;
                object = linkedHashMap;
                linkedHashMap = new LinkedHashMap();
                for (Map.Entry entry : object2.entrySet()) {
                    String string2 = entry.getKey() == null ? null : ((String)entry.getKey()).toLowerCase(Locale.US);
                    object.put(string2, (String)entry.getValue());
                }
                this.authParams = Collections.unmodifiableMap(object);
                return;
            }
            throw new NullPointerException("authParams == null");
        }
        throw new NullPointerException("scheme == null");
    }

    public Challenge(String string2, String string3) {
        if (string2 != null) {
            if (string3 != null) {
                Challenge challenge = this;
                challenge.scheme = string2;
                challenge.authParams = Collections.singletonMap("realm", string3);
                return;
            }
            throw new NullPointerException("realm == null");
        }
        throw new NullPointerException("scheme == null");
    }

    public Challenge withCharset(Charset charset) {
        if (charset != null) {
            LinkedHashMap<String, String> linkedHashMap;
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            linkedHashMap2(this.authParams);
            linkedHashMap.put("charset", charset.name());
            return new Challenge(this.scheme, linkedHashMap2);
        }
        throw new NullPointerException("charset == null");
    }

    public String scheme() {
        return this.scheme;
    }

    public Map<String, String> authParams() {
        return this.authParams;
    }

    public String realm() {
        return this.authParams.get("realm");
    }

    public Charset charset() {
        String string2 = ((Challenge)((Object)string2)).authParams.get("charset");
        if (string2 != null) {
            try {
                return Charset.forName(string2);
            }
            catch (Exception exception) {}
        }
        return Util.ISO_8859_1;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Challenge) {
            object = (Challenge)object;
            if (((Challenge)object).scheme.equals(this.scheme) && ((Challenge)object).authParams.equals(this.authParams)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (899 + this.scheme.hashCode()) * 31 + this.authParams.hashCode();
    }

    public String toString() {
        return this.scheme + " authParams=" + this.authParams;
    }
}

