/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.IOUtil;
import java.io.InputStream;

public class CanvasHelper {
    private static BitmapDrawable sDrawable;
    public static final int BASELINE = 0;
    public static final int BOTTOM = 80;
    public static final int HCENTER = 1;
    public static final int LEFT = 3;
    public static final int RIGHT = 5;
    public static final int TOP = 48;
    public static final int VCENTER = 16;
    private static final int DEVIANT = 5;

    public static Drawable getDrawable() {
        if (sDrawable == null) {
            Bitmap.Config config = Bitmap.Config.RGB_565;
            config = Bitmap.createBitmap((int)400, (int)400, (Bitmap.Config)config);
            new Canvas((Bitmap)config).drawColor(0);
            sDrawable = new BitmapDrawable((Bitmap)config);
        }
        return sDrawable;
    }

    public static void clearData() {
        BitmapDrawable bitmapDrawable = sDrawable;
        if (bitmapDrawable != null) {
            bitmapDrawable.getBitmap().recycle();
            sDrawable = null;
            return;
        }
    }

    public static Bitmap getBitmap(String string2) {
        InputStream inputStream;
        String string3 = string2;
        string2 = null;
        try {
            inputStream = PlatformUtil.getInputStream(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string2;
        }
        string2 = BitmapFactory.decodeStream((InputStream)inputStream);
        IOUtil.close(inputStream);
        return string2;
    }

    public static Drawable getDrawable(Context context, String string2) {
        if ((string2 = CanvasHelper.getBitmap(string2)) == null) {
            return null;
        }
        return new BitmapDrawable(context.getResources(), (Bitmap)string2);
    }

    public static Drawable getDrawable(String string2) {
        if ((string2 = CanvasHelper.getBitmap(string2)) == null) {
            return null;
        }
        return new BitmapDrawable((Bitmap)string2);
    }

    public static void drawNinePatchs(Canvas canvas, Bitmap bitmap, int[] nArray, int n5, int n6, int n7, int n8) {
        int n9;
        Paint paint;
        Bitmap bitmap2 = bitmap;
        Paint paint2 = paint;
        paint = new Paint();
        int n10 = bitmap2.getWidth();
        int n11 = bitmap2.getHeight();
        int n12 = 0;
        int n13 = n9 = 1;
        int n14 = n12;
        int n15 = n12;
        int n16 = n12;
        int n17 = n12;
        n9 = n12;
        for (int i5 = v326207; i5 <= 9; ++i5) {
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            if (i5 == 1) {
                n20 = nArray[0];
                n21 = nArray[1];
                n12 = n5 + n20;
                n9 = n6 + n21;
                n14 = n6;
                n15 = n5;
                n16 = n9;
                n17 = n12;
                n9 = n6;
                n12 = n5;
                n18 = n20;
                n19 = n21;
            } else if (i5 == 2) {
                n12 = nArray[0];
                n20 = n10 - n12 - nArray[2];
                n21 = nArray[1];
                n9 = n5 + n12;
                n17 = n9 + n20;
                n16 = n6 + n21;
                n18 = n7 - n12 - nArray[3];
                int n22 = n9;
                n14 = n6;
                n15 = n5;
                n9 = n6;
                n12 = n22;
                n19 = n21;
            } else if (i5 == 3) {
                n20 = nArray[2];
                n21 = nArray[1];
                n12 = n5 + n7;
                n9 = n12 - n20;
                n17 = n6 + n21;
                n16 = n12 - n10;
                int n23 = n9;
                n14 = n6;
                n15 = n16;
                n16 = n17;
                n17 = n12;
                n9 = n6;
                n12 = n23;
                n18 = n20;
                n19 = n21;
            } else if (i5 == 4) {
                n20 = nArray[0];
                n12 = nArray[1];
                n9 = nArray[3];
                n21 = n11 - n12 - n9;
                n17 = n6 + n12;
                int n24 = n12;
                n12 = n5 + n20;
                n16 = n17 + n21;
                n19 = n8 - n24 - n9;
                int n25 = n17;
                n14 = n6;
                n15 = n5;
                n17 = n12;
                n9 = n25;
                n12 = n5;
                n18 = n20;
            } else if (i5 == 5) {
                n12 = nArray[0];
                n9 = nArray[2];
                n20 = n10 - n12 - n9;
                n17 = nArray[1];
                n16 = nArray[3];
                n21 = n11 - n17 - n16;
                n15 = n5 + n12;
                n14 = n6 + n17;
                int n26 = n12;
                n12 = n15 + n20;
                n18 = n14 + n21;
                n9 = n7 - n26 - n9;
                n19 = n8 - n17 - n16;
                int n27 = n9;
                int n28 = n15;
                int n29 = n14;
                n14 = n6;
                n15 = n5;
                n16 = n18;
                n17 = n12;
                n9 = n29;
                n12 = n28;
                n18 = n27;
            } else if (i5 == 6) {
                n20 = nArray[2];
                n12 = nArray[1];
                n9 = nArray[3];
                n21 = n11 - n12 - n9;
                n17 = n5 + n7;
                int n30 = n12;
                n16 = n17 - n20;
                n12 = n6 + n12;
                n15 = n12 + n21;
                n14 = n16 - (n10 - n20);
                n19 = n8 - n30 - n9;
                int n31 = n16;
                int n32 = n15;
                int n33 = n14;
                n14 = n6;
                n15 = n33;
                n16 = n32;
                n9 = n12;
                n12 = n31;
                n18 = n20;
            } else if (i5 == 7) {
                n20 = nArray[0];
                n21 = nArray[3];
                n12 = n6 + n8 - n21;
                n9 = n5 + n20;
                n17 = n12 + n21;
                n14 = n16 = n12 - n11 + n21;
                n15 = n5;
                n16 = n17;
                n17 = n9;
                n9 = n12;
                n12 = n5;
                n18 = n20;
                n19 = n21;
            } else if (i5 == 8) {
                n12 = nArray[0];
                n9 = nArray[2];
                n20 = n10 - n12 - n9;
                n21 = nArray[3];
                n17 = n5 + n12;
                n16 = n6 + n8 - n21;
                int n34 = n12;
                n12 = n17 + n20;
                n15 = n16 + n21;
                n14 = n16 - n11 + n21;
                n18 = n7 - n34 - n9;
                int n35 = n17;
                int n36 = n16;
                int n37 = n15;
                n15 = n5;
                n16 = n37;
                n17 = n12;
                n9 = n36;
                n12 = n35;
                n19 = n21;
            } else if (i5 == 9) {
                n20 = nArray[2];
                n21 = nArray[3];
                n12 = n5 + n7;
                n9 = n12 - n20;
                n17 = n6 + n8 - n21;
                n16 = n17 + n21;
                n15 = n12 - n10;
                n14 = n17 - n11 + n21;
                int n38 = n9;
                int n39 = n17;
                n17 = n12;
                n9 = n39;
                n12 = n38;
                n18 = n20;
                n19 = n21;
            }
            int n40 = n19 / n21;
            int n41 = n19 % n21 > 0 ? 1 : 0;
            n40 += n41;
            n41 = n18 / n20;
            int n42 = n18 % n20 > 0 ? 1 : 0;
            n41 += n42;
            for (n42 = 0; n42 < n40; ++n42) {
                for (int i6 = 0; i6 < n41; ++i6) {
                    int n43;
                    int n44;
                    int n45 = i6 * n20;
                    int n46 = n17 + n45;
                    int n47 = n18 + n12;
                    if (n46 > n47) {
                        n46 = n47;
                    }
                    if ((n44 = n16 + (n47 = n42 * n21)) > (n43 = n19 + n9)) {
                        n44 = n43;
                    }
                    n43 = n12 + n45;
                    int n48 = n9 + n47;
                    n45 = n15 + n45;
                    n47 = n14 + n47;
                    CanvasHelper.drawClipBitmap(canvas, bitmap, paint2, n43, n48, n46, n44, n45, n47);
                }
            }
        }
    }

    private static void drawClipBitmap(Canvas canvas, Bitmap bitmap, Paint paint, int n5, int n6, int n7, int n8, int n9, int n10) {
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas3.save();
        canvas3.clipRect(n5, n6, n7, n8);
        float f5 = n9;
        float f6 = n10;
        canvas2.drawBitmap(bitmap, f5, f6, paint);
        canvas2.restore();
    }

    public static void drawString(Canvas canvas, String string2, int n5, int n6, int n7, Paint paint) {
        if (canvas != null && paint != null) {
            int n8 = (int)paint.getTextSize();
            if ((n7 & 3) == 3) {
                paint.setTextAlign(Paint.Align.LEFT);
            } else if ((n7 & 5) == 5) {
                paint.setTextAlign(Paint.Align.RIGHT);
            } else if ((n7 & 1) != 1) {
                paint.setTextAlign(Paint.Align.LEFT);
            }
            n6 = (n7 & 0x30) == 48 ? n6 + n8 - n8 / 5 : ((n7 & 0x50) == 80 ? (n6 -= (int)(paint.getFontMetrics().descent / 2.0f)) : ((n7 & 0x10) == 16 ? (n6 += n8) : n6 + n8 - n8 / 5));
            if (string2 != null) {
                float f5 = n5;
                float f6 = n6;
                canvas.drawText(string2, f5, f6, paint);
                return;
            }
        }
    }

    public static int getFontHeight(Paint paint) {
        paint = paint.getFontMetrics();
        return (int)Math.ceil(paint.descent - paint.top) + 2;
    }

    public static float getViablePx(int n5) {
        return (float)n5 * DeviceInfo.sDensity;
    }

    public static int dip2px(Context context, float f5) {
        return (int)(f5 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int px2dip(Context context, float f5) {
        return (int)(f5 / context.getResources().getDisplayMetrics().density + 0.5f);
    }
}

