/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.decoding;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.media.ThumbnailUtils;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.decoding.DecodeHandler;
import io.dcloud.feature.barcode2.decoding.DecodeThread;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.ViewfinderResultPointCallback;
import java.util.ArrayList;
import java.util.Vector;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = "CaptureActivityHandler";
    public static boolean isAutoZoom = true;
    public static final int CODE_AUTO_FOCUS = 1000;
    public static final int CODE_DECODE_FAILED = 1001;
    public static final int CODE_DECODE_SUCCEEDED = 1002;
    public static final int CODE_QUIT = 1003;
    public static final int CODE_DECODE = 1004;
    public static final int CODE_DECODE_NEED_ZOOM = 1010;
    public static final int CODE_DECODE_portrait = 1005;
    public static final int CODE_DECODE_landscape = 1006;
    private final IBarHandler activity;
    private final DecodeThread decodeThread;
    private State state;

    public CaptureActivityHandler(IBarHandler iBarHandler, Vector<BarcodeFormat> vector, String string2, boolean bl) {
        CaptureActivityHandler captureActivityHandler;
        ViewfinderResultPointCallback viewfinderResultPointCallback;
        object.activity = iBarHandler;
        Object object = viewfinderResultPointCallback;
        viewfinderResultPointCallback = new ViewfinderResultPointCallback(iBarHandler.getViewfinderView());
        object.decodeThread = new DecodeThread(iBarHandler, vector, string2, (ResultPointCallback)object, bl);
        object.decodeThread.start();
        captureActivityHandler.state = State.SUCCESS;
        captureActivityHandler.resume();
    }

    public static Result decode(Bitmap bitmap, boolean bl) {
        Result result = DecodeHandler.decode(bitmap, bl);
        if (result != null) {
            return result;
        }
        result = CaptureActivityHandler.trySmallerBitmap(bitmap, true, bl);
        if (result != null) {
            return result;
        }
        return CaptureActivityHandler.tryBiggerBitmap(bitmap, bl);
    }

    public static Result tryBiggerBitmap(Bitmap bitmap, boolean bl) {
        if (bitmap == null) {
            return null;
        }
        int n5 = bitmap.getWidth();
        int n6 = bitmap.getHeight();
        if (n5 < 1200 && n6 < 1200) {
            Paint paint;
            Bitmap bitmap2 = Bitmap.createBitmap((int)(n5 + 200), (int)(n6 + 200), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            canvas.drawColor(-1);
            bitmap = paint;
            paint = new Paint();
            canvas.drawBitmap(bitmap, 100.0f, 100.0f, (Paint)bitmap);
            bitmap = bitmap2;
        }
        Bitmap bitmap3 = bitmap;
        int n7 = bitmap3.getWidth();
        return DecodeHandler.decode(CaptureActivityHandler.convertToBMW(bitmap3, n7, bitmap3.getHeight(), 180), bl);
    }

    public static Bitmap convertToBMW(Bitmap bitmap, int n5, int n6, int n7) {
        Bitmap bitmap2 = bitmap;
        int n8 = bitmap2.getWidth();
        int n9 = bitmap.getHeight();
        int[] nArray = new int[n8 * n9];
        bitmap2.getPixels(nArray, 0, n8, 0, 0, n8, n9);
        for (int i5 = 0; i5 < n9; ++i5) {
            for (int i6 = 0; i6 < n8; ++i6) {
                int n10 = n8 * i5 + i6;
                int n11 = nArray[n10];
                int n12 = n11;
                int n13 = (n11 & 0xFF000000) >> 24;
                int n14 = n12;
                n12 = (n14 & 0xFF00) >> 8;
                int n15 = n14 & 0xFF;
                int n16 = (n11 & 0xFF0000) >> 16 > n7 ? 255 : 0;
                n15 = n15 > n7 ? 255 : 0;
                n12 = n12 > n7 ? 255 : 0;
                nArray[n10] = n12 = n13 << 24 | n16 << 16 | n12 << 8 | n15;
                nArray[n10] = n12 == -1 ? -1 : -16777216;
            }
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)n8, (int)n9, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap3.setPixels(nArray, 0, n8, 0, 0, n8, n9);
        return ThumbnailUtils.extractThumbnail((Bitmap)bitmap3, (int)n5, (int)n6);
    }

    public static Result trySmallerBitmap(Bitmap bitmap, boolean n5, boolean bl) {
        if (bitmap == null) {
            return null;
        }
        int n6 = bitmap.getWidth();
        int n7 = bitmap.getHeight();
        if (n6 >= 200 && n7 >= 200) {
            Object object;
            Bitmap bitmap2;
            Object object2;
            Object object3;
            ArrayList arrayList;
            Bitmap bitmap3;
            boolean bl2 = n6 <= n7;
            if (bl2) {
                int n8 = n7 / 2;
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n6, (int)n8);
            } else {
                int n9 = n6 / 2;
                bitmap3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n9, (int)n7);
            }
            int n10 = 0;
            final ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            if (n5 != 0) {
                ResultPointCallback resultPointCallback;
                object3 = resultPointCallback;
                resultPointCallback = new ResultPointCallback(){

                    @Override
                    public void foundPossibleResultPoint(ResultPoint resultPoint) {
                        arrayList2.add(resultPoint);
                    }
                };
                object3 = DecodeHandler.decode(bitmap3, (ResultPointCallback)object3, bl);
            } else {
                object3 = DecodeHandler.decode(bitmap3, bl);
            }
            if (object3 != null) {
                return object3;
            }
            if (n5 != 0) {
                ArrayList arrayList3 = arrayList2;
                n10 = arrayList3.size();
                arrayList3.clear();
            }
            if (bl2) {
                int n11 = n7 / 2;
                object3 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n11, (int)n6, (int)n11);
            } else {
                int n12 = n6 / 2;
                object3 = Bitmap.createBitmap((Bitmap)bitmap, (int)n12, (int)0, (int)n12, (int)n7);
            }
            int n13 = 0;
            if (n5 != 0) {
                ResultPointCallback resultPointCallback;
                object2 = resultPointCallback;
                resultPointCallback = new ResultPointCallback(){

                    @Override
                    public void foundPossibleResultPoint(ResultPoint resultPoint) {
                        arrayList2.add(resultPoint);
                    }
                };
                object2 = DecodeHandler.decode((Bitmap)object3, (ResultPointCallback)object2, bl);
            } else {
                object2 = DecodeHandler.decode((Bitmap)object3, bl);
            }
            if (object2 != null) {
                return object2;
            }
            if (n5 != 0) {
                ArrayList arrayList4 = arrayList2;
                n13 = arrayList4.size();
                arrayList4.clear();
            }
            if (bl2) {
                int n14 = n7;
                int n15 = n14 / 8;
                n7 = n14 / 4 * 3;
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n15, (int)n6, (int)n7);
            } else {
                int n16 = n6;
                int n17 = n16 / 8;
                n6 = n16 / 4 * 3;
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)n17, (int)0, (int)n6, (int)n7);
            }
            if (n5 != 0) {
                ResultPointCallback resultPointCallback;
                object = resultPointCallback;
                resultPointCallback = new ResultPointCallback(){

                    @Override
                    public void foundPossibleResultPoint(ResultPoint resultPoint) {
                        arrayList2.add(resultPoint);
                    }
                };
                object = DecodeHandler.decode(bitmap2, (ResultPointCallback)object, bl);
            } else {
                object = DecodeHandler.decode(bitmap2, bl);
            }
            if (object != null) {
                return object;
            }
            if (n5 != 0) {
                ArrayList arrayList5 = arrayList2;
                n5 = arrayList5.size();
                arrayList5.clear();
                if (n10 > n5 && n10 > n13) {
                    return CaptureActivityHandler.trySmallerBitmap(bitmap3, false, bl);
                }
                if (n5 > n13 && n5 > n10) {
                    return CaptureActivityHandler.trySmallerBitmap(bitmap2, false, bl);
                }
                if (n13 > n5 && n13 > n10) {
                    return CaptureActivityHandler.trySmallerBitmap((Bitmap)object3, false, bl);
                }
            }
            return null;
        }
        return null;
    }

    public void resume() {
        CaptureActivityHandler captureActivityHandler = this;
        CameraManager.get().startPreview();
        captureActivityHandler.activity.drawViewfinder();
        captureActivityHandler.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            default: {
                break;
            }
            case 1002: {
                Log.d((String)TAG, (String)"Got decode succeeded message");
                this.state = State.SUCCESS;
                Object object = message.getData();
                object = object == null ? null : (Bitmap)object.getParcelable("barcode_bitmap");
                this.activity.handleDecode((Result)message.obj, (Bitmap)object);
                if (object == null) break;
                object.recycle();
                System.out.println("barcode.recycle");
                return;
            }
            case 1001: {
                Log.d((String)TAG, (String)"CODE_DECODE_FAILED");
                this.state = State.PREVIEW;
                CameraManager.get().requestPreviewFrame(this.activity, this.decodeThread.getHandler(), 1004);
                return;
            }
            case 1000: {
                Log.d((String)TAG, (String)"Got auto-focus message");
                if (this.state != State.PREVIEW) break;
                CameraManager.get().requestAutoFocus(this, 1000);
                return;
            }
        }
    }

    public void quitSynchronously() {
        CaptureActivityHandler captureActivityHandler = this;
        captureActivityHandler.state = State.DONE;
        CameraManager.get().stopPreview();
        Message.obtain((Handler)captureActivityHandler.decodeThread.getHandler(), (int)1003).sendToTarget();
        try {
            captureActivityHandler.decodeThread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.stopDecode();
    }

    public void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.activity, this.decodeThread.getHandler(), 1004);
            this.autoFocus();
            return;
        }
    }

    public void autoFocus() {
        CameraManager.get().requestAutoFocus(this, 1000);
    }

    public void stopDecode() {
        CaptureActivityHandler captureActivityHandler = this;
        captureActivityHandler.removeMessages(1002);
        captureActivityHandler.removeMessages(1001);
        CameraManager.get().removeAutoFocus();
        captureActivityHandler.state = State.SUCCESS;
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

