/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;

public abstract class CharsetProber {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final int ASCII_A = 97;
    public static final int ASCII_Z = 122;
    public static final int ASCII_A_CAPITAL = 65;
    public static final int ASCII_Z_CAPITAL = 90;
    public static final int ASCII_LT = 60;
    public static final int ASCII_GT = 62;
    public static final int ASCII_SP = 32;
    private boolean active = true;

    private boolean isAscii(byte by) {
        return (by & 0x80) == 0;
    }

    private boolean isAsciiSymbol(byte by) {
        int n5 = by & 0xFF;
        return n5 < 65 || n5 > 90 && n5 < 97 || n5 > 122;
        {
        }
    }

    public abstract String getCharSetName();

    public abstract ProbingState handleData(byte[] var1, int var2, int var3);

    public abstract ProbingState getState();

    public abstract void reset();

    public abstract float getConfidence();

    public abstract void setOption();

    public ByteBuffer filterWithoutEnglishLetters(byte[] byArray, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n6);
        int n7 = 0;
        n6 = n5 + n6;
        int n8 = n7;
        n7 = n5;
        int n9 = n8;
        while (n5 < n6) {
            byte by = byArray[n5];
            if (!this.isAscii(by)) {
                n9 = 1;
            } else if (this.isAsciiSymbol(by)) {
                if (n9 != 0 && n5 > n7) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    n9 = n5 - n7;
                    byteBuffer2.put(byArray, n7, n9);
                    byteBuffer2.put((byte)32);
                    n7 = n5 + 1;
                    n9 = 0;
                } else {
                    n7 = n5 + 1;
                }
            }
            ++n5;
        }
        if (n9 != 0 && n5 > n7) {
            ByteBuffer byteBuffer3 = byteBuffer;
            int n10 = n5 - n7;
            byteBuffer3.put(byArray, n7, n10);
            return byteBuffer3;
        }
        return byteBuffer;
    }

    public ByteBuffer filterWithEnglishLetters(byte[] byArray, int n5, int n6) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n6);
        int n7 = 0;
        n6 = n5 + n6;
        int n8 = n7;
        n7 = n5;
        int n9 = n8;
        while (n5 < n6) {
            int n10 = byArray[n5];
            if (n10 == 62) {
                n9 = 0;
            } else if (n10 == 60) {
                n9 = 1;
            }
            if (this.isAscii((byte)n10) && this.isAsciiSymbol((byte)n10)) {
                if (n5 > n7 && n9 == 0) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    n10 = n5 - n7;
                    byteBuffer2.put(byArray, n7, n10);
                    byteBuffer2.put((byte)32);
                    n7 = n5 + 1;
                } else {
                    n7 = n5 + 1;
                }
            }
            ++n5;
        }
        if (n9 == 0 && n5 > n7) {
            ByteBuffer byteBuffer3 = byteBuffer;
            int n11 = n5 - n7;
            byteBuffer3.put(byArray, n7, n11);
            return byteBuffer3;
        }
        return byteBuffer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public static enum ProbingState {
        DETECTING,
        FOUND_IT,
        NOT_ME;

    }
}

