/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.ICheckBindingScroller;
import com.taobao.weex.common.OnWXScrollListener;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.AppearanceHelper;
import com.taobao.weex.ui.component.WXBaseRefresh;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXRefresh;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.helper.ScrollStartEndHelper;
import com.taobao.weex.ui.component.helper.WXStickyHelper;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.ui.view.WXHorizontalScrollView;
import com.taobao.weex.ui.view.WXScrollView;
import com.taobao.weex.ui.view.refresh.wrapper.BaseBounceView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceScrollerView;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Component(lazyload=false)
public class WXScroller
extends WXBaseScroller {
    public static final String DIRECTION = "direction";
    private static final int SWIPE_MIN_DISTANCE = 5;
    private static final int SWIPE_THRESHOLD_VELOCITY = 300;
    protected int mOrientation;
    private List<WXComponent> mRefreshs;
    private int mChildrenLayoutOffset;
    private boolean mForceLoadmoreNextTime;
    private int mOffsetAccuracy;
    private Point mLastReport;
    private boolean mHasAddScrollEvent;
    private Boolean mIslastDirectionRTL;
    private int mActiveFeature;
    private ScrollStartEndHelper mScrollStartEndHelper;
    private GestureDetector mGestureDetector;
    private int pageSize;
    private boolean pageEnable;
    private boolean mIsHostAttachedToWindow;
    private View.OnAttachStateChangeListener mOnAttachStateChangeListener;
    private boolean mlastDirectionRTL;
    private Map<String, AppearanceHelper> mAppearanceComponents;
    private Map<String, Map<String, WXComponent>> mStickyMap;
    private FrameLayout mRealView;
    private FrameLayout mScrollerView;
    private int mContentHeight;
    private int mContentWidth;
    private WXStickyHelper stickyHelper;
    private Handler handler;
    private boolean isScrollable;

    @Deprecated
    public WXScroller(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String string2, boolean bl, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public WXScroller(WXSDKInstance object, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        WXStickyHelper wXStickyHelper;
        Handler handler;
        HashMap hashMap;
        HashMap hashMap2;
        Point point;
        ArrayList arrayList;
        WXSDKInstance wXSDKInstance = object;
        super((WXSDKInstance)object, wXVContainer, basicComponentData);
        this.mOrientation = 1;
        object = arrayList;
        arrayList = new ArrayList();
        this.mRefreshs = object;
        this.mChildrenLayoutOffset = 0;
        this.mForceLoadmoreNextTime = false;
        this.mOffsetAccuracy = 10;
        object = point;
        point = new Point(-1, -1);
        this.mLastReport = object;
        this.mHasAddScrollEvent = false;
        this.mActiveFeature = 0;
        this.pageSize = 0;
        this.pageEnable = false;
        this.mIsHostAttachedToWindow = false;
        this.mlastDirectionRTL = false;
        object = hashMap2;
        hashMap2 = new HashMap();
        this.mAppearanceComponents = object;
        object = hashMap;
        hashMap = new HashMap();
        this.mStickyMap = object;
        this.mContentHeight = 0;
        this.mContentWidth = 0;
        object = handler;
        handler = new Handler(Looper.getMainLooper());
        this.handler = object;
        this.isScrollable = true;
        object = wXStickyHelper;
        wXStickyHelper = new WXStickyHelper(this);
        this.stickyHelper = object;
        wXSDKInstance.getApmForInstance().updateDiffStats("wxScrollerCount", 1.0);
    }

    private void fireScrollEvent(Rect rect, int n, int n2, int n3, int n4) {
        WXScroller wXScroller = this;
        wXScroller.fireEvent("scroll", wXScroller.getScrollEvent(n, n2));
    }

    private boolean shouldReport(int n, int n2) {
        Point point = this.mLastReport;
        int n3 = point.x;
        if (n3 == -1 && point.y == -1) {
            Point point2 = point;
            point2.x = n;
            point2.y = n2;
            return true;
        }
        if (this.mOrientation == 0 && Math.abs(n - n3) >= this.mOffsetAccuracy) {
            Point point3 = this.mLastReport;
            point3.x = n;
            point3.y = n2;
            return true;
        }
        if (this.mOrientation == 1 && Math.abs(n2 - this.mLastReport.y) >= this.mOffsetAccuracy) {
            Point point4 = this.mLastReport;
            point4.x = n;
            point4.y = n2;
            return true;
        }
        return false;
    }

    private boolean checkRefreshOrLoading(final WXComponent wXComponent) {
        boolean bl = false;
        if (wXComponent instanceof WXRefresh && ((WXComponent)((Object)runnable)).getHostView() != null) {
            WXScroller wXScroller = runnable;
            ((BaseBounceView)((Object)wXScroller.getHostView())).setOnRefreshListener((WXRefresh)wXComponent);
            Runnable runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)WXScroller.this.getHostView())).setHeaderView(wXComponent);
                }
            });
            wXScroller.handler.postDelayed(runnable, 100L);
            bl = true;
        }
        if (wXComponent instanceof WXLoading && ((WXComponent)((Object)runnable)).getHostView() != null) {
            WXScroller wXScroller = runnable;
            ((BaseBounceView)((Object)wXScroller.getHostView())).setOnLoadingListener((WXLoading)wXComponent);
            Runnable runnable = WXThread.secure(new Runnable(){

                @Override
                public void run() {
                    ((BaseBounceView)((Object)WXScroller.this.getHostView())).setFooterView(wXComponent);
                }
            });
            wXScroller.handler.postDelayed(runnable, 100L);
            return true;
        }
        return bl;
    }

    private void setWatch(int n, WXComponent wXComponent, boolean bl) {
        AppearanceHelper appearanceHelper = this.mAppearanceComponents.get(wXComponent.getRef());
        if (appearanceHelper == null) {
            AppearanceHelper appearanceHelper2;
            appearanceHelper = appearanceHelper2;
            appearanceHelper2 = new AppearanceHelper(wXComponent);
            this.mAppearanceComponents.put(wXComponent.getRef(), appearanceHelper);
        }
        appearanceHelper.setWatchEvent(n, bl);
        this.procAppear(0, 0, 0, 0);
    }

    private void procAppear(int n, int n2, int n3, int n4) {
        if (this.mIsHostAttachedToWindow) {
            String string2 = (n2 -= n4) > 0 ? "up" : (n2 < 0 ? "down" : null);
            if (this.mOrientation == 0 && (n -= n3) != 0) {
                String string3;
                String string4;
                string2 = n > 0 ? (string4 = "right") : (string3 = "left");
            }
            Iterator<Map.Entry<String, AppearanceHelper>> iterator = this.mAppearanceComponents.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next().getValue();
                if (!((AppearanceHelper)object).isWatch() || (n4 = ((AppearanceHelper)object).setAppearStatus(this.checkItemVisibleInScroller(((AppearanceHelper)object).getAwareChild()))) == 0) continue;
                object = ((AppearanceHelper)object).getAwareChild();
                String string5 = n4 == 1 ? "appear" : "disappear";
                ((WXComponent)object).notifyAppearStateChange(string5, string2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkItemVisibleInScroller(WXComponent var1_1) {
        var2_2 = false;
        while (var1_1 != null && !(var1_1 instanceof WXScroller)) {
            block6: {
                if (var1_1.getParent() instanceof WXScroller) {
                    if (this.mOrientation == 0) {
                        var2_3 = (int)var1_1.getLayoutPosition().getLeft() - this.getScrollX();
                        if (v0 > 0.0f - var1_1.getLayoutWidth() && var2_3 < this.getLayoutWidth()) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                var2_2 = true;
                                break block6;
                                break;
                            }
                        }
                        while (true) {
                            var2_2 = false;
                            break block6;
                            break;
                        }
                    }
                    var2_3 = (int)var1_1.getLayoutPosition().getTop() - this.getScrollY();
                    if (!(v1 > 0.0f - var1_1.getLayoutHeight()) || !(var2_3 < this.getLayoutHeight())) ** continue;
                    ** continue;
                }
            }
            var1_1 = var1_1.getParent();
        }
        return var2_2;
    }

    private void dispatchDisappearEvent() {
        Iterator<Map.Entry<String, AppearanceHelper>> iterator = ((WXScroller)((Object)iterator)).mAppearanceComponents.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Object object = (AppearanceHelper)((Map.Entry)iterator.next()).getValue();
            if (!((AppearanceHelper)object).isWatch() || (n = ((AppearanceHelper)object).setAppearStatus(false)) == 0) continue;
            object = ((AppearanceHelper)object).getAwareChild();
            String string2 = n == 1 ? "appear" : "disappear";
            ((WXComponent)object).notifyAppearStateChange(string2, "");
        }
    }

    static /* synthetic */ Boolean access$302(WXScroller wXScroller, Boolean bl) {
        wXScroller.mIslastDirectionRTL = bl;
        return bl;
    }

    static /* synthetic */ int access$402(WXScroller wXScroller, int n) {
        wXScroller.pageSize = n;
        return n;
    }

    static /* synthetic */ int access$602(WXScroller wXScroller, int n) {
        wXScroller.mActiveFeature = n;
        return n;
    }

    static /* synthetic */ boolean access$702(WXScroller wXScroller, boolean bl) {
        wXScroller.mIsHostAttachedToWindow = bl;
        return bl;
    }

    static /* synthetic */ ArrayList access$900(WXScroller wXScroller) {
        return wXScroller.mChildren;
    }

    @Override
    public ViewGroup getRealView() {
        return this.mScrollerView;
    }

    @Override
    public void createViewImpl() {
        super.createViewImpl();
        for (int i = 0; i < this.mRefreshs.size(); ++i) {
            WXScroller wXScroller = this;
            WXComponent wXComponent = wXScroller.mRefreshs.get(i);
            wXComponent.createViewImpl();
            wXScroller.checkRefreshOrLoading(wXComponent);
        }
    }

    @Override
    public ViewGroup getInnerView() {
        if (this.getHostView() == null) {
            return null;
        }
        if (this.getHostView() instanceof BounceScrollerView) {
            return (ViewGroup)((BounceScrollerView)((Object)this.getHostView())).getInnerView();
        }
        return (ViewGroup)this.getHostView();
    }

    @Override
    public void addEvent(String string2) {
        super.addEvent(string2);
        if (ScrollStartEndHelper.isScrollEvent(string2) && this.getInnerView() != null && !this.mHasAddScrollEvent) {
            this.mHasAddScrollEvent = true;
            if (this.getInnerView() instanceof WXScrollView) {
                ((WXScrollView)this.getInnerView()).addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                    @Override
                    public void onScrollChanged(WXScrollView wXScrollView, int n, int n2, int n3, int n4) {
                        1 v0 = this;
                        v0.WXScroller.this.getScrollStartEndHelper().onScrolled(n, n2);
                        if (((AbstractCollection)v0.WXScroller.this.getEvents()).contains("scroll") && WXScroller.this.shouldReport(n, n2)) {
                            WXScroller.this.fireScrollEvent(wXScrollView.getContentFrame(), n, n2, n3, n4);
                            return;
                        }
                    }

                    @Override
                    public void onScrollToBottom(WXScrollView wXScrollView, int n, int n2) {
                    }

                    @Override
                    public void onScrollStopped(WXScrollView wXScrollView, int n, int n2) {
                    }

                    @Override
                    public void onScroll(WXScrollView wXScrollView, int n, int n2) {
                    }
                });
                return;
            }
            if (this.getInnerView() instanceof WXHorizontalScrollView) {
                ((WXHorizontalScrollView)this.getInnerView()).addScrollViewListener(new WXHorizontalScrollView.ScrollViewListener(){

                    @Override
                    public void onScrollChanged(WXHorizontalScrollView wXHorizontalScrollView, int n, int n2, int n3, int n4) {
                        2 v0 = this;
                        v0.WXScroller.this.getScrollStartEndHelper().onScrolled(n, n2);
                        if (((AbstractCollection)v0.WXScroller.this.getEvents()).contains("scroll") && WXScroller.this.shouldReport(n, n2)) {
                            WXScroller.this.fireScrollEvent(wXHorizontalScrollView.getContentFrame(), n, n2, n3, n4);
                            return;
                        }
                    }
                });
                return;
            }
        }
    }

    @Override
    public Map<String, Object> getScrollEvent(int n, int n2) {
        HashMap<String, Float> hashMap;
        HashMap<String, Float> hashMap2;
        Rect rect;
        Rect rect2 = rect;
        rect = new Rect();
        if (this.getInnerView() instanceof WXScrollView) {
            rect2 = ((WXScrollView)this.getInnerView()).getContentFrame();
        } else if (this.getInnerView() instanceof WXHorizontalScrollView) {
            rect2 = ((WXHorizontalScrollView)this.getInnerView()).getContentFrame();
        }
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>(2);
        HashMap<String, Float> hashMap4 = hashMap2;
        hashMap2 = new HashMap<String, Float>(2);
        HashMap<String, Float> hashMap5 = hashMap;
        hashMap5(2);
        float f = this.getInstance().getInstanceViewPortWidthWithFloat();
        hashMap4.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth((float)rect2.width(), f)));
        hashMap4.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth((float)rect2.height(), f)));
        hashMap5.put("x", Float.valueOf(-WXViewUtils.getWebPxByWidth((float)n, f)));
        hashMap.put("y", Float.valueOf(-WXViewUtils.getWebPxByWidth((float)n2, f)));
        hashMap3.put("contentSize", hashMap4);
        hashMap3.put("contentOffset", hashMap5);
        return hashMap3;
    }

    @Override
    public void addSubView(View view, int n) {
        FrameLayout frameLayout;
        if (view != null && (frameLayout = this.mRealView) != null) {
            if (view instanceof WXBaseRefreshLayout) {
                return;
            }
            if (n >= frameLayout.getChildCount()) {
                n = -1;
            }
            if (n == -1) {
                this.mRealView.addView(view);
                return;
            }
            this.mRealView.addView(view, n);
            return;
        }
    }

    @Override
    protected int getChildrenLayoutTopOffset() {
        int n;
        if (this.mChildrenLayoutOffset == 0 && (n = this.mRefreshs.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                WXScroller wXScroller = this;
                WXComponent wXComponent = wXScroller.mRefreshs.get(i);
                wXScroller.mChildrenLayoutOffset += wXComponent.getLayoutTopOffsetForSibling();
            }
        }
        return this.mChildrenLayoutOffset;
    }

    @Override
    public void addChild(WXComponent wXComponent, int n) {
        if (wXComponent instanceof WXBaseRefresh && this.checkRefreshOrLoading(wXComponent)) {
            this.mRefreshs.add(wXComponent);
        }
        super.addChild(wXComponent, n);
    }

    @Override
    public void remove(WXComponent wXComponent, boolean bl) {
        super.remove(wXComponent, bl);
        if (wXComponent instanceof WXLoading) {
            ((BaseBounceView)((Object)this.getHostView())).removeFooterView(wXComponent);
            return;
        }
        if (wXComponent instanceof WXRefresh) {
            ((BaseBounceView)((Object)this.getHostView())).removeHeaderView(wXComponent);
            return;
        }
    }

    @Override
    public void destroy() {
        WXScroller wXScroller = this;
        super.destroy();
        Map<String, Object> map = wXScroller.mAppearanceComponents;
        if (map != null) {
            map.clear();
        }
        if ((map = this.mStickyMap) != null) {
            map.clear();
        }
        if (this.mOnAttachStateChangeListener != null && this.getInnerView() != null) {
            this.getInnerView().removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
        if (this.getInnerView() != null && this.getInnerView() instanceof IWXScroller) {
            ((IWXScroller)this.getInnerView()).destroy();
            return;
        }
    }

    @Override
    public void setMarginsSupportRTL(ViewGroup.MarginLayoutParams marginLayoutParams, int n, int n2, int n3, int n4) {
        if (Build.VERSION.SDK_INT >= 17) {
            ViewGroup.MarginLayoutParams marginLayoutParams2 = marginLayoutParams;
            marginLayoutParams2.setMargins(n, n2, n3, n4);
            marginLayoutParams2.setMarginStart(n);
            marginLayoutParams2.setMarginEnd(n3);
            return;
        }
        if (marginLayoutParams instanceof FrameLayout.LayoutParams) {
            WXScroller wXScroller = wXScroller2;
            WXScroller wXScroller2 = (FrameLayout.LayoutParams)marginLayoutParams;
            if (wXScroller.isLayoutRTL()) {
                ((FrameLayout.LayoutParams)wXScroller2).gravity = 53;
                marginLayoutParams.setMargins(n3, n2, n, n4);
                return;
            }
            ((FrameLayout.LayoutParams)wXScroller2).gravity = 51;
            marginLayoutParams.setMargins(n, n2, n3, n4);
            return;
        }
        marginLayoutParams.setMargins(n, n2, n3, n4);
    }

    @Override
    public void setLayout(WXComponent wXComponent) {
        if (!TextUtils.isEmpty((CharSequence)wXComponent.getComponentType()) && !TextUtils.isEmpty((CharSequence)wXComponent.getRef()) && wXComponent.getLayoutPosition() != null && wXComponent.getLayoutSize() != null) {
            if (wXComponent.getHostView() != null) {
                WXComponent wXComponent2 = wXComponent;
                int n = wXComponent2.isLayoutRTL();
                ViewCompat.setLayoutDirection(wXComponent2.getHostView(), (int)n);
            }
            super.setLayout(wXComponent);
            return;
        }
    }

    @Override
    protected WXComponent.MeasureOutput measure(int n, int n2) {
        WXComponent.MeasureOutput measureOutput;
        WXComponent.MeasureOutput measureOutput2 = measureOutput;
        measureOutput = new WXComponent.MeasureOutput();
        if (this.mOrientation == 0) {
            int n3 = WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            int n4 = WXViewUtils.getWeexWidth(this.getInstanceId());
            if (n4 < n3) {
                n3 = n4;
            }
            if (n > n3) {
                n = -1;
            }
            measureOutput2.width = n;
            measureOutput2.height = n2;
            return measureOutput2;
        }
        int n5 = WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
        int n6 = WXViewUtils.getWeexHeight(this.getInstanceId());
        if (n6 < n5) {
            n5 = n6;
        }
        if (n2 > n5) {
            n2 = -1;
        }
        measureOutput2.height = n2;
        measureOutput2.width = n;
        return measureOutput2;
    }

    @Override
    protected ViewGroup initComponentHostView(@NonNull Context object) {
        View.OnAttachStateChangeListener onAttachStateChangeListener;
        Object object2;
        if (this.getAttrs().isEmpty()) {
            object2 = "vertical";
        } else {
            float f;
            object2 = this.getAttrs().getScrollDirection();
            Object object3 = this.getAttrs().get("pagingEnabled");
            boolean bl = object3 != null && Boolean.parseBoolean(object3.toString());
            this.pageEnable = bl;
            Object object4 = this.getAttrs().get("pageSize");
            if (object4 != null && (f = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(object4), this.getInstance().getInstanceViewPortWidthWithFloat())) != 0.0f) {
                this.pageSize = (int)f;
            }
        }
        if ("horizontal".equals(object2)) {
            View.OnLayoutChangeListener onLayoutChangeListener;
            FrameLayout.LayoutParams layoutParams;
            FrameLayout frameLayout;
            WXHorizontalScrollView wXHorizontalScrollView;
            this.mOrientation = 0;
            object2 = wXHorizontalScrollView;
            Object object5 = frameLayout;
            frameLayout = new FrameLayout(object);
            this.mRealView = object5;
            new WXHorizontalScrollView((Context)object).setScrollViewListener(new WXHorizontalScrollView.ScrollViewListener(){

                @Override
                public void onScrollChanged(WXHorizontalScrollView wXHorizontalScrollView, int n, int n2, int n3, int n4) {
                    5 v0 = this;
                    v0.WXScroller.this.procAppear(n, n2, n3, n4);
                    v0.WXScroller.this.onLoadMore((FrameLayout)wXHorizontalScrollView, n, n2);
                }
            });
            object = layoutParams;
            layoutParams = new FrameLayout.LayoutParams(-1, -1);
            object2.addView((View)this.mRealView, (ViewGroup.LayoutParams)object);
            object2.setHorizontalScrollBarEnabled(false);
            this.mScrollerView = object2;
            object = onLayoutChangeListener;
            onLayoutChangeListener = new View.OnLayoutChangeListener(){
                final /* synthetic */ WXHorizontalScrollView val$scrollView;
                final /* synthetic */ WXScroller val$component;
                {
                    this.val$scrollView = wXHorizontalScrollView;
                    this.val$component = wXScroller2;
                }

                public void onLayoutChange(View view, final int n, int n2, final int n3, int n4, final int n5, int n6, final int n7, int n8) {
                    this.val$scrollView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (wXScroller.WXScroller.this.mIslastDirectionRTL != null && wXScroller.WXScroller.this.isLayoutRTL() != wXScroller.WXScroller.this.mIslastDirectionRTL.booleanValue()) {
                                WXScroller wXScroller = wXScroller;
                                int n4 = wXScroller.WXScroller.this.getScrollX();
                                int n2 = wXScroller.WXScroller.this.getInnerView().getChildAt(0).getWidth();
                                int n32 = wXScroller.WXScroller.this.getInnerView().getMeasuredWidth();
                                6 var4_6 = wXScroller.this;
                                var4_6.val$scrollView.scrollTo(n2 - n4 - n32, var4_6.val$component.getScrollY());
                            } else if (wXScroller.WXScroller.this.isLayoutRTL()) {
                                1 v1 = wXScroller;
                                int n6 = v1.n7 - wXScroller.n5;
                                if ((n6 = v1.n3 - wXScroller.n - n6) != 0) {
                                    6 var2_4 = wXScroller.this;
                                    var2_4.val$scrollView.scrollBy(n6, var2_4.val$component.getScrollY());
                                }
                            }
                            WXScroller wXScroller = wXScroller.WXScroller.this;
                            WXScroller.access$302(wXScroller, new Boolean(wXScroller.isLayoutRTL()));
                        }
                    });
                }
            };
            this.mRealView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){
                final /* synthetic */ View.OnLayoutChangeListener val$listener;
                {
                    this.val$listener = onLayoutChangeListener;
                }

                public void onViewAttachedToWindow(View view) {
                    view.addOnLayoutChangeListener(this.val$listener);
                }

                public void onViewDetachedFromWindow(View view) {
                    view.removeOnLayoutChangeListener(this.val$listener);
                }
            });
            if (this.pageEnable) {
                View.OnTouchListener onTouchListener;
                MyGestureDetector myGestureDetector;
                GestureDetector gestureDetector;
                object = gestureDetector;
                object5 = myGestureDetector;
                myGestureDetector = new MyGestureDetector((WXHorizontalScrollView)object2);
                gestureDetector = new GestureDetector((GestureDetector.OnGestureListener)object5);
                this.mGestureDetector = object;
                object = onTouchListener;
                onTouchListener = new View.OnTouchListener(){
                    final /* synthetic */ WXHorizontalScrollView val$scrollView;
                    {
                        this.val$scrollView = wXHorizontalScrollView;
                    }

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        if (WXScroller.this.pageSize == 0) {
                            WXScroller.access$402(WXScroller.this, view.getMeasuredWidth());
                        }
                        if (WXScroller.this.mGestureDetector.onTouchEvent(motionEvent)) {
                            return true;
                        }
                        if (motionEvent.getAction() != 1 && motionEvent.getAction() != 3) {
                            return false;
                        }
                        8 v0 = this;
                        int n = v0.WXScroller.this.getScrollX();
                        int n2 = v0.WXScroller.this.pageSize;
                        WXScroller.access$602(v0.WXScroller.this, (n + n2 / 2) / n2);
                        n = v0.WXScroller.this.mActiveFeature * n2;
                        v0.val$scrollView.smoothScrollTo(n, 0);
                        return true;
                    }
                };
                object2.setOnTouchListener((View.OnTouchListener)object);
            }
        } else {
            FrameLayout.LayoutParams layoutParams;
            FrameLayout frameLayout;
            BounceScrollerView bounceScrollerView;
            this.mOrientation = 1;
            object2 = bounceScrollerView;
            FrameLayout frameLayout2 = frameLayout;
            frameLayout = new FrameLayout(object);
            this.mRealView = frameLayout2;
            object = (WXScrollView)new BounceScrollerView((Context)object, this.mOrientation, this).getInnerView();
            object.addScrollViewListener(this);
            frameLayout2 = layoutParams;
            layoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.mScrollerView = object;
            object.addView((View)this.mRealView, (ViewGroup.LayoutParams)frameLayout2);
            object.setVerticalScrollBarEnabled(true);
            object.setNestedScrollingEnabled(WXUtils.getBoolean(this.getAttrs().get("nestedScrollingEnabled"), Boolean.TRUE));
            object.addScrollViewListener(new WXScrollView.WXScrollViewListener(){

                @Override
                public void onScrollChanged(WXScrollView wXScrollView, int n, int n2, int n3, int n4) {
                }

                @Override
                public void onScrollToBottom(WXScrollView wXScrollView, int n, int n2) {
                }

                @Override
                public void onScrollStopped(WXScrollView wXScrollView, int n, int n2) {
                    List<OnWXScrollListener> list = WXScroller.this.getInstance().getWXScrollListeners();
                    if (list != null && list.size() > 0) {
                        for (OnWXScrollListener onWXScrollListener : list) {
                            if (onWXScrollListener == null) continue;
                            onWXScrollListener.onScrollStateChanged((View)wXScrollView, n, n2, 0);
                        }
                    }
                    WXScroller.this.getScrollStartEndHelper().onScrollStateChanged(0);
                }

                @Override
                public void onScroll(WXScrollView wXScrollView, int n, int n2) {
                    List<OnWXScrollListener> list = WXScroller.this.getInstance().getWXScrollListeners();
                    if (list != null && list.size() > 0) {
                        for (OnWXScrollListener onWXScrollListener : list) {
                            if (onWXScrollListener == null) continue;
                            if (onWXScrollListener instanceof ICheckBindingScroller) {
                                if (!((ICheckBindingScroller)((Object)onWXScrollListener)).isNeedScroller(WXScroller.this.getRef(), null)) continue;
                                onWXScrollListener.onScrolled((View)wXScrollView, n, n2);
                                continue;
                            }
                            onWXScrollListener.onScrolled((View)wXScrollView, n, n2);
                        }
                    }
                }
            });
        }
        Object object6 = object2;
        object6.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                10 v0 = this;
                v0.WXScroller.this.procAppear(0, 0, 0, 0);
                Object t = v0.WXScroller.this.getHostView();
                if (t == null) {
                    return;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    t.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    return;
                }
                t.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        object = onAttachStateChangeListener;
        this.mOnAttachStateChangeListener = object;
        object6.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View view) {
                11 v0 = this;
                WXScroller.access$702(v0.WXScroller.this, true);
                WXScroller wXScroller = v0.WXScroller.this;
                11 v2 = this;
                int n = v2.WXScroller.this.getScrollY();
                int n2 = v2.WXScroller.this.getScrollX();
                int n3 = v2.WXScroller.this.getScrollY();
                wXScroller.procAppear(wXScroller.getScrollX(), n, n2, n3);
            }

            public void onViewDetachedFromWindow(View view) {
                11 v0 = this;
                WXScroller.access$702(v0.WXScroller.this, false);
                v0.WXScroller.this.dispatchDisappearEvent();
            }
        });
        return object6;
    }

    @Override
    public int getScrollY() {
        if (this.getInnerView() == null) {
            return 0;
        }
        return this.getInnerView().getScrollY();
    }

    @Override
    public int getScrollX() {
        if (this.getInnerView() == null) {
            return 0;
        }
        return this.getInnerView().getScrollX();
    }

    @Override
    public int getOrientation() {
        return this.mOrientation;
    }

    @Override
    public Map<String, Map<String, WXComponent>> getStickMap() {
        return this.mStickyMap;
    }

    @Override
    protected boolean setProperty(String object, Object object2) {
        String string2 = object;
        string2.getClass();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 66669991: {
                if (!((String)object).equals("scrollable")) break;
                n = 2;
                break;
            }
            case -5620052: {
                if (!((String)object).equals("offsetAccuracy")) break;
                n = 1;
                break;
            }
            case -223520855: {
                if (!((String)object).equals("showScrollbar")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return super.setProperty((String)object, object2);
            }
            case 2: {
                this.setScrollable(WXUtils.getBoolean(object2, Boolean.TRUE));
                return true;
            }
            case 1: {
                this.setOffsetAccuracy(WXUtils.getInteger(object2, 10));
                return true;
            }
            case 0: 
        }
        object = WXUtils.getBoolean(object2, null);
        if (object != null) {
            this.setShowScrollbar((Boolean)object);
        }
        return true;
    }

    @WXComponentProp(name="showScrollbar")
    public void setShowScrollbar(boolean bl) {
        if (this.getInnerView() == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.getInnerView().setVerticalScrollBarEnabled(bl);
            return;
        }
        this.getInnerView().setHorizontalScrollBarEnabled(bl);
    }

    @WXComponentProp(name="scrollable")
    public void setScrollable(boolean bl) {
        this.isScrollable = bl;
        if ((this = this.getInnerView()) instanceof WXHorizontalScrollView) {
            ((WXHorizontalScrollView)((Object)this)).setScrollable(bl);
            return;
        }
        if (this instanceof WXScrollView) {
            ((WXScrollView)((Object)this)).setScrollable(bl);
            return;
        }
    }

    @WXComponentProp(name="offsetAccuracy")
    public void setOffsetAccuracy(int n) {
        this.mOffsetAccuracy = (int)WXViewUtils.getRealPxByWidth((float)n, this.getInstance().getInstanceViewPortWidthWithFloat());
    }

    @Override
    public boolean isScrollable() {
        return this.isScrollable;
    }

    @Override
    public void bindStickStyle(WXComponent wXComponent) {
        this.stickyHelper.bindStickStyle(wXComponent, this.mStickyMap);
    }

    @Override
    public void unbindStickStyle(WXComponent wXComponent) {
        this.stickyHelper.unbindStickStyle(wXComponent, this.mStickyMap);
    }

    @Override
    public void bindAppearEvent(WXComponent wXComponent) {
        this.setWatch(0, wXComponent, true);
    }

    @Override
    public void bindDisappearEvent(WXComponent wXComponent) {
        this.setWatch(1, wXComponent, true);
    }

    @Override
    public void unbindAppearEvent(WXComponent wXComponent) {
        this.setWatch(0, wXComponent, false);
    }

    @Override
    public void unbindDisappearEvent(WXComponent wXComponent) {
        this.setWatch(1, wXComponent, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void scrollTo(WXComponent wXComponent, Map<String, Object> map) {
        int n;
        float f = 0.0f;
        boolean bl = true;
        if (map != null) {
            String string2 = map.get("offset") == null ? "0" : map.get("offset").toString();
            boolean bl2 = WXUtils.getBoolean(map.get("animated"), Boolean.TRUE);
            if (string2 != null) {
                try {
                    f = WXViewUtils.getRealPxByWidth(Float.parseFloat(string2), this.getInstance().getInstanceViewPortWidthWithFloat());
                }
                catch (Exception exception) {
                    WXLogUtils.e("Float parseFloat error :" + exception.getMessage());
                }
            }
            bl = bl2;
        }
        if (this.pageEnable) {
            this.mActiveFeature = this.mChildren.indexOf(wXComponent);
        }
        int n2 = wXComponent.getAbsoluteY() - this.getAbsoluteY();
        if (this.isLayoutRTL()) {
            if (wXComponent.getParent() != null && wXComponent.getParent() == this) {
                if (this.getInnerView().getChildCount() > 0) {
                    n = this.getInnerView().getMeasuredWidth();
                    n = this.getInnerView().getChildAt(0).getWidth() - (wXComponent.getAbsoluteX() - this.getAbsoluteX()) - n;
                } else {
                    n = wXComponent.getAbsoluteX() - this.getAbsoluteX();
                }
            } else {
                int n3 = this.getInnerView().getMeasuredWidth();
                n = wXComponent.getAbsoluteX() - this.getAbsoluteX() - n3 + (int)wXComponent.getLayoutWidth();
            }
            f = -f;
        } else {
            n = wXComponent.getAbsoluteX() - this.getAbsoluteX();
        }
        int n4 = (int)f;
        n = n - this.getScrollX() + n4;
        this.scrollBy(n, n2 - this.getScrollY() + n4, bl);
    }

    public void scrollBy(int n, int n2) {
        this.scrollBy(n, n2, false);
    }

    public void scrollBy(final int n, final int n2, final boolean bl) {
        if (this.getInnerView() == null) {
            return;
        }
        this.getInnerView().postDelayed(new Runnable(){

            @Override
            public void run() {
                WXScroller wXScroller = WXScroller.this;
                if (wXScroller.mOrientation == 1) {
                    if (bl) {
                        ((WXScrollView)wXScroller.getInnerView()).smoothScrollBy(0, n2);
                    } else {
                        ((WXScrollView)wXScroller.getInnerView()).scrollBy(0, n2);
                    }
                } else if (bl) {
                    ((WXHorizontalScrollView)wXScroller.getInnerView()).smoothScrollBy(n, 0);
                } else {
                    ((WXHorizontalScrollView)wXScroller.getInnerView()).scrollBy(n, 0);
                }
                WXScroller.this.getInnerView().invalidate();
            }
        }, 16L);
    }

    @Override
    public void onScrollChanged(WXScrollView wXScrollView, int n, int n2, int n3, int n4) {
        this.procAppear(n, n2, n3, n4);
    }

    @Override
    public void notifyAppearStateChange(String string2, String string3) {
        HashMap<String, String> hashMap;
        if (!((WXComponent)((Object)hashMap2)).containsEvent("appear") && !((WXComponent)((Object)hashMap2)).containsEvent("disappear")) {
            return;
        }
        WXScroller wXScroller = hashMap2;
        HashMap<String, String> hashMap2 = hashMap;
        new HashMap<String, String>().put(DIRECTION, string3);
        wXScroller.fireEvent(string2, (Map<String, Object>)hashMap2);
    }

    @Override
    public void onScrollToBottom(WXScrollView wXScrollView, int n, int n2) {
    }

    @Override
    public void onScrollStopped(WXScrollView wXScrollView, int n, int n2) {
    }

    @Override
    public void onScroll(WXScrollView wXScrollView, int n, int n2) {
        this.onLoadMore((FrameLayout)wXScrollView, n, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onLoadMore(FrameLayout var1_2, int var2_4, int var3_5) {
        block12: {
            try {
                var4_6 = this.getAttrs().getLoadMoreOffset();
            }
            catch (Exception var0_1) {
                break block12;
            }
            if (TextUtils.isEmpty((CharSequence)var4_6)) {
                var4_6 = String.valueOf(1);
            }
            var4_7 = (int)WXViewUtils.getRealPxByWidth(Float.parseFloat(var4_6), this.getInstance().getInstanceViewPortWidthWithFloat());
            {
                if (!(var1_2 instanceof WXHorizontalScrollView)) ** GOTO lbl17
            }
            {
                var3_5 = var1_2.getChildAt(0).getWidth();
                if (var3_5 - var2_4 - var1_2.getWidth() >= var4_7 || this.mContentWidth == var3_5 && !this.mForceLoadmoreNextTime) return;
                v0 = this;
                this.fireEvent("loadmore");
                v0.mContentWidth = var3_5;
                v0.mForceLoadmoreNextTime = false;
                return;
lbl17:
                // 1 sources

                var2_4 = var1_2.getChildAt(0).getHeight();
            }
            {
                var1_3 = var1_2.getHeight();
                if ((var1_3 = var2_4 - var3_5 - var1_3) >= var4_7) return;
            }
            {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("[WXScroller-onScroll] offScreenY :" + var1_3);
                }
                if (this.mContentHeight == var2_4 && !this.mForceLoadmoreNextTime) return;
                v1 = this;
                this.fireEvent("loadmore");
                v1.mContentHeight = var2_4;
                v1.mForceLoadmoreNextTime = false;
                return;
            }
        }
        WXLogUtils.d("[WXScroller-onScroll] ", var0_1);
    }

    @JSMethod
    public void resetLoadmore() {
        this.mForceLoadmoreNextTime = true;
    }

    public ScrollStartEndHelper getScrollStartEndHelper() {
        if (this.mScrollStartEndHelper == null) {
            ScrollStartEndHelper scrollStartEndHelper;
            ScrollStartEndHelper scrollStartEndHelper2 = scrollStartEndHelper;
            scrollStartEndHelper = new ScrollStartEndHelper(this);
            this.mScrollStartEndHelper = scrollStartEndHelper2;
        }
        return this.mScrollStartEndHelper;
    }

    class MyGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        private final WXHorizontalScrollView scrollView;

        MyGestureDetector(WXHorizontalScrollView wXHorizontalScrollView) {
            this.scrollView = wXHorizontalScrollView;
        }

        public WXHorizontalScrollView getScrollView() {
            return this.scrollView;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean onFling(MotionEvent var1_2, MotionEvent var2_5, float var3_6, float var4_9) {
            block14: {
                var4_10 = WXScroller.access$900(WXScroller.this).size();
                try {
                    v0 = var1_2.getX() - var2_5 /* !! */ .getX();
                }
                catch (Exception var0_1) {}
                if (!(v0 > 5.0f)) ** GOTO lbl27
                v1 = Math.abs(var3_6);
                if (!(v1 > 300.0f)) ** GOTO lbl27
                v2 = this;
                var1_3 = WXScroller.access$400(v2.WXScroller.this);
                var2_5 /* !! */  = v2.WXScroller.this;
                var3_7 = var4_10 - 1;
                if (WXScroller.access$600((WXScroller)var2_5 /* !! */ ) >= var3_7) ** GOTO lbl18
                var3_7 = WXScroller.access$600(WXScroller.this) + 1;
lbl18:
                // 2 sources

                v3 = this;
                WXScroller.access$602((WXScroller)var2_5 /* !! */ , var3_7);
                v4 = v3.scrollView;
                v5 = WXScroller.access$600(WXScroller.this);
                v4.smoothScrollTo(v5 * var1_3, 0);
                return true;
lbl27:
                // 2 sources

                v6 = var2_5 /* !! */ .getX() - var1_2.getX();
                if (!(v6 > 5.0f)) break block14;
                v7 = Math.abs(var3_6);
                if (!(v7 > 300.0f)) break block14;
                v8 = this;
                var1_4 = WXScroller.access$400(v8.WXScroller.this);
                var2_5 /* !! */  = v8.WXScroller.this;
                var3_8 = WXScroller.access$600((WXScroller)var2_5 /* !! */ ) > 0 ? WXScroller.access$600(WXScroller.this) - 1 : 0;
                v9 = this;
                WXScroller.access$602((WXScroller)var2_5 /* !! */ , var3_8);
                v10 = v9.scrollView;
                v11 = WXScroller.access$600(WXScroller.this);
                v10.smoothScrollTo(v11 * var1_4, 0);
                return true;
                WXLogUtils.e("There was an error processing the Fling event:" + var0_1.getMessage());
            }
            return false;
        }
    }

    public static class Creator
    implements ComponentCreator {
        @Override
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
            wXSDKInstance.setUseScroller(true);
            return new WXScroller(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }
}

