/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.DragHelper;
import com.taobao.weex.ui.component.list.DragSupportCallback;
import com.taobao.weex.ui.component.list.EventTrigger;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DefaultDragHelper
implements DragHelper {
    private static final String EVENT_START_DRAG = "dragstart";
    private static final String EVENT_END_DRAG = "dragend";
    private static final String TAG_EXCLUDED = "drag_excluded";
    private static final String TAG = "WXListExComponent";
    private boolean mLongPressEnabled;
    @NonNull
    private final EventTrigger mEventTrigger;
    @NonNull
    private final RecyclerView mRecyclerView;
    @NonNull
    private final List<WXComponent> mDataSource;
    @NonNull
    private ItemTouchHelper mItemTouchHelper;
    private boolean isDraggable = false;

    DefaultDragHelper(@NonNull List<WXComponent> itemTouchHelper, @NonNull RecyclerView recyclerView, @NonNull EventTrigger object) {
        DragSupportCallback dragSupportCallback;
        ItemTouchHelper itemTouchHelper2;
        this.mDataSource = itemTouchHelper;
        this.mEventTrigger = object;
        this.mRecyclerView = recyclerView;
        itemTouchHelper = itemTouchHelper2;
        object = dragSupportCallback;
        dragSupportCallback = new DragSupportCallback(this, true);
        itemTouchHelper((ItemTouchHelper.Callback)object);
        this.mItemTouchHelper = itemTouchHelper;
        try {
            itemTouchHelper2.attachToRecyclerView(recyclerView);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private Map<String, Object> buildEvent(@Nullable String string2, int n, int n2) {
        HashMap hashMap;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap(4);
        String string3 = "target";
        if (string2 == null) {
            string2 = "unknown";
        }
        HashMap hashMap3 = hashMap2;
        hashMap2.put(string3, string2);
        hashMap2.put("fromIndex", n);
        hashMap3.put("toIndex", n2);
        hashMap3.put("timestamp", System.currentTimeMillis());
        return hashMap3;
    }

    @Override
    public void onDragStart(@NonNull WXComponent wXComponent, int n) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "list on drag start : from index " + n);
        }
        this.mEventTrigger.triggerEvent(EVENT_START_DRAG, this.buildEvent(wXComponent.getRef(), n, -1));
    }

    @Override
    public void onDragEnd(@NonNull WXComponent wXComponent, int n, int n2) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "list on drag end : from index " + n + " to index " + n2);
        }
        this.mEventTrigger.triggerEvent(EVENT_END_DRAG, this.buildEvent(wXComponent.getRef(), n, n2));
    }

    @Override
    public void onDragging(int n, int n2) {
        RecyclerView.Adapter adapter;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "list on dragging : from index " + n + " to index " + n2);
        }
        if ((adapter = this.mRecyclerView.getAdapter()) == null) {
            WXLogUtils.e(TAG, "drag failed because of RecyclerView#Adapter is not bound");
            return;
        }
        if (n >= 0 && n <= this.mDataSource.size() - 1 && n2 >= 0 && n2 <= this.mDataSource.size() - 1) {
            Collections.swap(this.mDataSource, n, n2);
            adapter.notifyItemMoved(n, n2);
            return;
        }
    }

    @Override
    public boolean isLongPressDragEnabled() {
        return this.mLongPressEnabled;
    }

    @Override
    public void setLongPressDragEnabled(boolean bl) {
        this.mLongPressEnabled = bl;
    }

    @Override
    public void startDrag(@NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isDraggable) {
            this.mItemTouchHelper.startDrag(viewHolder);
            return;
        }
    }

    @Override
    public boolean isDraggable() {
        return this.isDraggable;
    }

    @Override
    public void setDraggable(boolean bl) {
        this.isDraggable = bl;
    }

    @Override
    public void setDragExcluded(@NonNull RecyclerView.ViewHolder viewHolder, boolean bl) {
        DefaultDragHelper defaultDragHelper = viewHolder.itemView;
        if (defaultDragHelper == null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e(TAG, "[error] viewHolder.itemView is null");
                return;
            }
            return;
        }
        if (bl) {
            defaultDragHelper.setTag(TAG_EXCLUDED);
            return;
        }
        defaultDragHelper.setTag(null);
    }

    @Override
    public boolean isDragExcluded(@NonNull RecyclerView.ViewHolder viewHolder) {
        DefaultDragHelper defaultDragHelper = viewHolder.itemView;
        if (defaultDragHelper == null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e(TAG, "[error] viewHolder.itemView is null");
            }
            return false;
        }
        return defaultDragHelper.getTag() != null && TAG_EXCLUDED.equals(viewHolder.itemView.getTag());
    }
}

