/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.DragHelper;
import com.taobao.weex.ui.view.listview.adapter.ListBaseViewHolder;
import com.taobao.weex.utils.WXLogUtils;

class DragSupportCallback
extends ItemTouchHelper.Callback {
    private static final String TAG = "WXListExComponent";
    private final DragHelper mDragHelper;
    private boolean mEnableDifferentViewTypeDrag;
    private int dragFrom = -1;
    private int dragTo = -1;

    DragSupportCallback(@NonNull DragHelper dragHelper) {
        this.mDragHelper = dragHelper;
        this.mEnableDifferentViewTypeDrag = false;
    }

    DragSupportCallback(@NonNull DragHelper dragHelper, boolean bl) {
        this.mDragHelper = dragHelper;
        this.mEnableDifferentViewTypeDrag = bl;
    }

    public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (!(recyclerView.getLayoutManager() instanceof GridLayoutManager) && !(recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager)) {
            return ItemTouchHelper.Callback.makeMovementFlags((int)3, (int)48);
        }
        return ItemTouchHelper.Callback.makeMovementFlags((int)15, (int)0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder viewHolder2) {
        Exception exception2;
        block6: {
            int n;
            int n2;
            block5: {
                if (viewHolder == null) return false;
                if (viewHolder2 == null) {
                    return false;
                }
                if (!this.mEnableDifferentViewTypeDrag && viewHolder.getItemViewType() != viewHolder2.getItemViewType()) {
                    return false;
                }
                if (this.mDragHelper.isDragExcluded(viewHolder)) {
                    return false;
                }
                try {
                    n2 = viewHolder.getAdapterPosition();
                    n = viewHolder2.getAdapterPosition();
                    if (this.dragFrom != -1) break block5;
                    this.dragFrom = n2;
                }
                catch (Exception exception2) {
                    break block6;
                }
            }
            this.dragTo = n;
            this.mDragHelper.onDragging(n2, n);
            return true;
        }
        WXLogUtils.e(TAG, exception2.getMessage());
        return false;
    }

    public boolean isLongPressDragEnabled() {
        return this.mDragHelper.isDraggable() && this.mDragHelper.isLongPressDragEnabled();
    }

    public void onSwiped(RecyclerView.ViewHolder viewHolder, int n) {
    }

    public boolean isItemViewSwipeEnabled() {
        return false;
    }

    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int n) {
        Object object;
        if (n != 0 && viewHolder instanceof ListBaseViewHolder && (object = (ListBaseViewHolder)viewHolder).getComponent() != null) {
            ListBaseViewHolder listBaseViewHolder = object;
            object = listBaseViewHolder.getComponent();
            this.mDragHelper.onDragStart((WXComponent)object, listBaseViewHolder.getAdapterPosition());
        }
        super.onSelectedChanged(viewHolder, n);
    }

    public void clearView(RecyclerView object, RecyclerView.ViewHolder viewHolder) {
        super.clearView((RecyclerView)object, viewHolder);
        if (viewHolder instanceof ListBaseViewHolder && ((ListBaseViewHolder)((Object)(object = (ListBaseViewHolder)viewHolder))).getComponent() != null && this.dragFrom != -1 && this.dragTo != -1) {
            DragSupportCallback dragSupportCallback = this;
            object = ((ListBaseViewHolder)((Object)object)).getComponent();
            int n = dragSupportCallback.dragFrom;
            int n2 = dragSupportCallback.dragTo;
            this.mDragHelper.onDragEnd((WXComponent)object, n, n2);
        }
        DragSupportCallback dragSupportCallback = this;
        dragSupportCallback.dragTo = -1;
        dragSupportCallback.dragFrom = -1;
    }
}

