/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.widget.refresh;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import androidx.annotation.VisibleForTesting;
import com.dcloud.android.annotation.ColorInt;
import com.dcloud.android.annotation.ColorRes;
import com.dcloud.android.annotation.Nullable;
import com.dcloud.android.v4.view.MotionEventCompat;
import com.dcloud.android.v4.view.NestedScrollingChild;
import com.dcloud.android.v4.view.NestedScrollingChildHelper;
import com.dcloud.android.v4.view.NestedScrollingParent;
import com.dcloud.android.v4.view.NestedScrollingParentHelper;
import com.dcloud.android.v4.view.ViewCompat;
import com.dcloud.android.v4.widget.MaterialProgressDrawable;
import io.dcloud.feature.weex.adapter.widget.refresh.CircleLayout;
import io.dcloud.feature.weex.adapter.widget.refresh.DCWeexCircleImageView;

public class DCWeexBaseRefreshLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    @VisibleForTesting
    static final int CIRCLE_DIAMETER = 40;
    @VisibleForTesting
    static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final String LOG_TAG = "DCWeexBaseRefreshLayout";
    private static final int MAX_ALPHA = 255;
    private static final int STARTING_PROGRESS_ALPHA = 76;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 0.5f;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private static final int SCALE_DOWN_DURATION = 150;
    private static final int ALPHA_ANIMATION_DURATION = 300;
    private static final int ANIMATE_TO_TRIGGER_DURATION = 200;
    private static final int ANIMATE_TO_START_DURATION = 200;
    private static final int CIRCLE_BG_LIGHT = -328966;
    private static final int DEFAULT_CIRCLE_TARGET = 64;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    private View mTarget;
    private OnRefreshListener mListener;
    private boolean mRefreshing;
    private int mTouchSlop;
    protected float mTotalDragDistance;
    private float mTotalUnconsumed;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed;
    private final int[] mParentOffsetInWindow;
    private boolean mNestedScrollInProgress;
    private int mMediumAnimationDuration;
    private int mCurrentTargetOffsetTop;
    private float mInitialMotionY;
    private float mInitialDownY;
    private boolean mIsBeingDragged;
    private int mActivePointerId;
    private boolean mScale;
    private boolean mReturningToStart;
    private final DecelerateInterpolator mDecelerateInterpolator;
    private DCWeexCircleImageView mCircleView;
    private CircleLayout mCircleLayout;
    private int mCircleLatyouOffsetTop;
    private int mCircleViewIndex;
    protected int mFrom;
    private float mStartingScale;
    protected int mOriginalOffsetTop;
    private MaterialProgressDrawable mProgress;
    private Animation mScaleAnimation;
    private Animation mScaleDownAnimation;
    private Animation mAlphaStartAnimation;
    private Animation mAlphaMaxAnimation;
    private Animation mScaleDownToStartAnimation;
    protected float mSpinnerFinalOffset;
    private boolean mNotify;
    private int mCircleDiameter;
    private boolean mUsingCustomStart;
    private OnChildScrollUpCallback mChildScrollUpCallback;
    private Animation.AnimationListener mRefreshListener;
    boolean mBeginRefresh;
    private final Animation mAnimateToCorrectPosition;
    private final Animation mAnimateToStartPosition;

    private void reset() {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout.mProgress.stop();
        dCWeexBaseRefreshLayout.mCircleView.setVisibility(8);
        dCWeexBaseRefreshLayout.setColorViewAlpha(255);
        if (dCWeexBaseRefreshLayout.mScale) {
            this.setAnimationProgress(0.0f);
        } else {
            DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
            dCWeexBaseRefreshLayout2.setTargetOffsetTopAndBottom(dCWeexBaseRefreshLayout2.mOriginalOffsetTop - this.mCurrentTargetOffsetTop, true);
        }
        this.mCurrentTargetOffsetTop = this.mCircleView.getTop();
    }

    private void setColorViewAlpha(int n) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView.getBackground().setAlpha(n);
        dCWeexBaseRefreshLayout.mProgress.setAlpha(n);
    }

    public DCWeexBaseRefreshLayout(Context context) {
        this(context, null);
    }

    public DCWeexBaseRefreshLayout(Context object, AttributeSet attributeSet) {
        int n;
        NestedScrollingChildHelper nestedScrollingChildHelper;
        NestedScrollingParentHelper nestedScrollingParentHelper;
        float f;
        DecelerateInterpolator decelerateInterpolator;
        Animation animation;
        Animation animation2;
        Animation.AnimationListener animationListener;
        Context context = object;
        Context context2 = object;
        super(object, attributeSet);
        this.mRefreshing = false;
        this.mTotalDragDistance = -1.0f;
        this.mParentScrollConsumed = new int[2];
        this.mParentOffsetInWindow = new int[2];
        this.mActivePointerId = -1;
        this.mCircleLatyouOffsetTop = 0;
        this.mCircleViewIndex = -1;
        object = animationListener;
        animationListener = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (DCWeexBaseRefreshLayout.this.mRefreshing) {
                    1 v0 = this;
                    v0.DCWeexBaseRefreshLayout.this.mProgress.setAlpha(255);
                    v0.DCWeexBaseRefreshLayout.this.mProgress.start();
                    if (v0.DCWeexBaseRefreshLayout.this.mNotify && DCWeexBaseRefreshLayout.this.mListener != null) {
                        DCWeexBaseRefreshLayout.this.mListener.onRefresh();
                    }
                    DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = DCWeexBaseRefreshLayout.this;
                    DCWeexBaseRefreshLayout.access$402(dCWeexBaseRefreshLayout, dCWeexBaseRefreshLayout.mCircleView.getTop());
                    return;
                }
                DCWeexBaseRefreshLayout.this.reset();
            }
        };
        this.mRefreshListener = object;
        this.mBeginRefresh = false;
        object = animation2;
        animation2 = new Animation(){

            public void applyTransformation(float f, Transformation object) {
                int n;
                if (!object2.DCWeexBaseRefreshLayout.this.mUsingCustomStart) {
                    object = object2.DCWeexBaseRefreshLayout.this;
                    n = (int)(object.mSpinnerFinalOffset - (float)Math.abs(object.mOriginalOffsetTop));
                } else {
                    n = (int)object2.DCWeexBaseRefreshLayout.this.mSpinnerFinalOffset;
                }
                7 v0 = object2;
                Object object2 = v0.DCWeexBaseRefreshLayout.this;
                int n2 = ((DCWeexBaseRefreshLayout)((Object)object2)).mFrom;
                int n3 = n2 + (int)((float)(n - n2) * f) - ((DCWeexBaseRefreshLayout)((Object)object2)).mCircleView.getTop();
                v0.DCWeexBaseRefreshLayout.this.setTargetOffsetTopAndBottom(n3, false);
                v0.DCWeexBaseRefreshLayout.this.mProgress.setArrowScale(1.0f - f);
            }
        };
        this.mAnimateToCorrectPosition = object;
        object = animation;
        animation = new Animation(){

            public void applyTransformation(float f, Transformation transformation) {
                DCWeexBaseRefreshLayout.this.moveToStart(f);
            }
        };
        this.mAnimateToStartPosition = object;
        this.mTouchSlop = ViewConfiguration.get((Context)context2).getScaledTouchSlop();
        this.mMediumAnimationDuration = this.getResources().getInteger(0x10E0001);
        this.setWillNotDraw(false);
        object = decelerateInterpolator;
        decelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.mDecelerateInterpolator = object;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
        this.setEnabled(typedArray.getBoolean(0, true));
        typedArray.recycle();
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mCircleDiameter = (int)(displayMetrics.density * 40.0f);
        this.createProgressView();
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
        this.mSpinnerFinalOffset = f = displayMetrics.density * 64.0f;
        this.mTotalDragDistance = f;
        NestedScrollingParentHelper nestedScrollingParentHelper2 = nestedScrollingParentHelper;
        nestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingParentHelper = nestedScrollingParentHelper2;
        nestedScrollingParentHelper2 = nestedScrollingChildHelper;
        nestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.mNestedScrollingChildHelper = nestedScrollingParentHelper2;
        this.setNestedScrollingEnabled(true);
        this.mCurrentTargetOffsetTop = n = -this.mCircleDiameter;
        this.mOriginalOffsetTop = n;
        this.moveToStart(1.0f);
    }

    private void createProgressView() {
        CircleLayout circleLayout;
        CircleLayout circleLayout2;
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView = new DCWeexCircleImageView(this.getContext(), -328966, 20.0f);
        this.mProgress = new MaterialProgressDrawable(this.getContext(), (View)this);
        this.mProgress.setBackgroundColor(-328966);
        dCWeexBaseRefreshLayout.mCircleView.setImageDrawable((Drawable)this.mProgress);
        dCWeexBaseRefreshLayout.mCircleView.setVisibility(8);
        CircleLayout circleLayout3 = circleLayout2 = circleLayout;
        circleLayout3(this.getContext());
        this.mCircleLayout = circleLayout3;
        circleLayout.addView((View)this.mCircleView);
        dCWeexBaseRefreshLayout.mCircleLayout.setVisibility(0);
        dCWeexBaseRefreshLayout.addView((View)dCWeexBaseRefreshLayout.mCircleLayout, new ViewGroup.LayoutParams(-1, -1));
    }

    private boolean isAlphaUsedForScale() {
        return Build.VERSION.SDK_INT < 11;
    }

    private void startScaleUpAnimation(Animation.AnimationListener animationListener) {
        3 v1;
        3 var2_2;
        this.mCircleView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mProgress.setAlpha(255);
        }
        3 v0 = var2_2 = v1;
        v0();
        this.mScaleAnimation = v0;
        v1.setDuration(this.mMediumAnimationDuration);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout.mCircleView.startAnimation(this.mScaleAnimation);
    }

    private void setAnimationProgress(float f) {
        if (this.isAlphaUsedForScale()) {
            this.setColorViewAlpha((int)(f * 255.0f));
            return;
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        ViewCompat.setScaleX((View)dCWeexBaseRefreshLayout.mCircleView, (float)f);
        ViewCompat.setScaleY((View)dCWeexBaseRefreshLayout.mCircleView, (float)f);
    }

    private void setRefreshing(boolean bl, boolean bl2) {
        if (this.mRefreshing != bl) {
            this.mNotify = bl2;
            this.ensureTarget();
            this.mRefreshing = bl;
            if (bl) {
                DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
                int n = dCWeexBaseRefreshLayout.mCurrentTargetOffsetTop;
                dCWeexBaseRefreshLayout.animateOffsetToCorrectPosition(n, dCWeexBaseRefreshLayout.mRefreshListener);
                return;
            }
            DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
            dCWeexBaseRefreshLayout.startScaleDownAnimation(dCWeexBaseRefreshLayout.mRefreshListener);
            return;
        }
    }

    private void startScaleDownAnimation(Animation.AnimationListener animationListener) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        this.mScaleDownAnimation = new Animation(){

            public void applyTransformation(float f, Transformation transformation) {
                DCWeexBaseRefreshLayout.this.setAnimationProgress(1.0f - f);
            }
        };
        this.mScaleDownAnimation.setDuration(150L);
        dCWeexBaseRefreshLayout.mCircleView.setAnimationListener(animationListener);
        dCWeexBaseRefreshLayout.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout.mCircleView.startAnimation(this.mScaleDownAnimation);
    }

    private void startProgressAlphaStartAnimation() {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mAlphaStartAnimation = dCWeexBaseRefreshLayout.startAlphaAnimation(dCWeexBaseRefreshLayout.mProgress.getAlpha(), 76);
    }

    private void startProgressAlphaMaxAnimation() {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mAlphaMaxAnimation = dCWeexBaseRefreshLayout.startAlphaAnimation(dCWeexBaseRefreshLayout.mProgress.getAlpha(), 255);
    }

    private Animation startAlphaAnimation(int n, int n2) {
        5 v0;
        if (this.mScale && this.isAlphaUsedForScale()) {
            return null;
        }
        5 var3_3 = v0;
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        5 v2 = var3_3;
        v2(n, n2);
        v2.setDuration(300L);
        dCWeexBaseRefreshLayout.mCircleView.setAnimationListener(null);
        dCWeexBaseRefreshLayout.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout.mCircleView.startAnimation(var3_3);
        return v0;
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                if (view.equals((Object)this.mCircleLayout)) continue;
                this.mTarget = view;
                return;
            }
        }
    }

    private boolean isAnimationRunning(Animation animation) {
        return animation != null && animation.hasStarted() && !animation.hasEnded();
    }

    private void moveSpinner(float f) {
        float f2 = f;
        this.mProgress.showArrow(true);
        float f3 = Math.min(1.0f, Math.abs(f2 / this.mTotalDragDistance));
        float f4 = (float)Math.max((double)f3 - 0.4, 0.0) * 5.0f / 3.0f;
        float f5 = Math.abs(f2) - this.mTotalDragDistance;
        float f6 = this.mUsingCustomStart ? this.mSpinnerFinalOffset - (float)this.mOriginalOffsetTop : this.mSpinnerFinalOffset;
        double d = Math.max(0.0f, Math.min(f5, f6 * 2.0f) / f6) / 4.0f;
        f5 = (float)(d - Math.pow(d, 2.0)) * 2.0f;
        float f7 = f6 * f5 * 2.0f;
        int n = this.mOriginalOffsetTop + (int)(f6 * f3 + f7);
        if (this.mCircleView.getVisibility() != 0) {
            this.mCircleView.setVisibility(0);
        }
        if (!this.mScale) {
            ViewCompat.setScaleX((View)this.mCircleView, (float)1.0f);
            ViewCompat.setScaleY((View)this.mCircleView, (float)1.0f);
        }
        if (this.mScale) {
            this.setAnimationProgress(Math.min(1.0f, f / this.mTotalDragDistance));
        }
        if (f < this.mTotalDragDistance) {
            if (this.mProgress.getAlpha() > 76 && !this.isAnimationRunning(this.mAlphaStartAnimation)) {
                this.startProgressAlphaStartAnimation();
            }
        } else if (this.mProgress.getAlpha() < 255 && !this.isAnimationRunning(this.mAlphaMaxAnimation)) {
            this.startProgressAlphaMaxAnimation();
        }
        float f8 = f4;
        f = f8 * 0.8f;
        this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, f));
        this.mProgress.setArrowScale(Math.min(1.0f, f4));
        this.mProgress.setProgressRotation((f8 * 0.4f + -0.25f + f5 * 2.0f) * 0.5f);
        this.setTargetOffsetTopAndBottom(n - this.mCurrentTargetOffsetTop, true);
    }

    private void finishSpinner(float f) {
        if (f > this.mTotalDragDistance) {
            this.setRefreshing(true, true);
            return;
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mRefreshing = false;
        dCWeexBaseRefreshLayout.mProgress.setStartEndTrim(0.0f, 0.0f);
        Animation.AnimationListener animationListener = null;
        if (!dCWeexBaseRefreshLayout.mScale) {
            Animation.AnimationListener animationListener2;
            animationListener = animationListener2;
            animationListener2 = new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (!DCWeexBaseRefreshLayout.this.mScale) {
                        DCWeexBaseRefreshLayout.this.startScaleDownAnimation(null);
                        return;
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            };
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
        dCWeexBaseRefreshLayout2.animateOffsetToStartPosition(dCWeexBaseRefreshLayout2.mCurrentTargetOffsetTop, animationListener);
        dCWeexBaseRefreshLayout2.mProgress.showArrow(false);
    }

    private void startDragging(float f) {
        int n;
        float f2;
        float f3 = f;
        f = this.mInitialDownY;
        int n2 = this.mTouchSlop;
        if (f3 - f2 > (float)n && !this.mIsBeingDragged) {
            this.mInitialMotionY = f + (float)n2;
            this.mIsBeingDragged = true;
            this.mProgress.setAlpha(76);
            return;
        }
    }

    private void animateOffsetToCorrectPosition(int n, Animation.AnimationListener animationListener) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mFrom = n;
        dCWeexBaseRefreshLayout.mAnimateToCorrectPosition.reset();
        dCWeexBaseRefreshLayout.mAnimateToCorrectPosition.setDuration(200L);
        dCWeexBaseRefreshLayout.mAnimateToCorrectPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
        dCWeexBaseRefreshLayout2.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout2.mCircleView.startAnimation(this.mAnimateToCorrectPosition);
    }

    private void animateOffsetToStartPosition(int n, Animation.AnimationListener animationListener) {
        if (this.mScale) {
            this.startScaleDownReturnToStartAnimation(n, animationListener);
            return;
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mFrom = n;
        dCWeexBaseRefreshLayout.mAnimateToStartPosition.reset();
        dCWeexBaseRefreshLayout.mAnimateToStartPosition.setDuration(200L);
        dCWeexBaseRefreshLayout.mAnimateToStartPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
        dCWeexBaseRefreshLayout2.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout2.mCircleView.startAnimation(this.mAnimateToStartPosition);
    }

    private void moveToStart(float f) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        int n = dCWeexBaseRefreshLayout.mFrom;
        dCWeexBaseRefreshLayout.setTargetOffsetTopAndBottom(n + (int)((float)(this.mOriginalOffsetTop - n) * f) - this.mCircleView.getTop(), false);
    }

    private void startScaleDownReturnToStartAnimation(int n, Animation.AnimationListener animationListener) {
        9 v0;
        this.mFrom = n;
        this.mStartingScale = this.isAlphaUsedForScale() ? (float)this.mProgress.getAlpha() : ViewCompat.getScaleX((View)this.mCircleView);
        9 var1_2 = v0;
        var1_2();
        this.mScaleDownToStartAnimation = var1_2;
        v0.setDuration(150L);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView.clearAnimation();
        dCWeexBaseRefreshLayout.mCircleView.startAnimation(this.mScaleDownToStartAnimation);
    }

    private void setTargetOffsetTopAndBottom(int n, boolean bl) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleLayout.bringToFront();
        ViewCompat.offsetTopAndBottom((View)dCWeexBaseRefreshLayout.mCircleView, (int)n);
        dCWeexBaseRefreshLayout.mCurrentTargetOffsetTop = dCWeexBaseRefreshLayout.mCircleView.getTop();
        if (bl && Build.VERSION.SDK_INT < 11) {
            this.invalidate();
            return;
        }
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        int n = MotionEventCompat.getActionIndex((MotionEvent)motionEvent2);
        if (motionEvent2.getPointerId(n) == this.mActivePointerId) {
            n = n == 0 ? 1 : 0;
            this.mActivePointerId = motionEvent.getPointerId(n);
            return;
        }
    }

    static /* synthetic */ int access$402(DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout, int n) {
        dCWeexBaseRefreshLayout.mCurrentTargetOffsetTop = n;
        return n;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.reset();
            return;
        }
    }

    protected void onDetachedFromWindow() {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        super.onDetachedFromWindow();
        dCWeexBaseRefreshLayout.reset();
    }

    public void setProgressViewOffset(boolean bl, int n, int n2, int n3, int n4) {
        this.mScale = bl;
        this.mOriginalOffsetTop = n;
        this.mCircleLatyouOffsetTop = n4;
        this.mSpinnerFinalOffset = n2;
        this.mTotalDragDistance = n3;
        this.mUsingCustomStart = true;
        this.reset();
        this.mRefreshing = false;
    }

    public void setProgressViewEndTarget(boolean bl, int n) {
        this.mSpinnerFinalOffset = n;
        this.mScale = bl;
        this.mCircleView.invalidate();
    }

    public void setSize(int n) {
        if (n != 0 && n != 1) {
            return;
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mCircleDiameter = n == 0 ? (int)(displayMetrics.density * 56.0f) : (int)(displayMetrics.density * 40.0f);
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView.setImageDrawable(null);
        dCWeexBaseRefreshLayout.mProgress.updateSizes(n);
        dCWeexBaseRefreshLayout.mCircleView.setImageDrawable((Drawable)this.mProgress);
    }

    protected int getChildDrawingOrder(int n, int n2) {
        int n3 = this.mCircleViewIndex;
        if (n3 >= 0) {
            if (n2 == n - 1) {
                return n3;
            }
            if (n2 >= n3) {
                return n2 + 1;
            }
        }
        return n2;
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mListener = onRefreshListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshing(boolean bl) {
        if (bl && this.mRefreshing != bl) {
            void var1_4;
            this.mRefreshing = bl;
            if (!this.mUsingCustomStart) {
                int n = (int)(this.mSpinnerFinalOffset + (float)this.mOriginalOffsetTop);
            } else {
                int n = (int)this.mSpinnerFinalOffset;
            }
            DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
            dCWeexBaseRefreshLayout.setTargetOffsetTopAndBottom((int)(var1_4 - this.mCurrentTargetOffsetTop), true);
            dCWeexBaseRefreshLayout.mNotify = false;
            dCWeexBaseRefreshLayout.startScaleUpAnimation(dCWeexBaseRefreshLayout.mRefreshListener);
            return;
        }
        this.setRefreshing(bl, false);
    }

    public void beginRefresh() {
        if (!this.mBeginRefresh && this.mCircleView.getVisibility() != 0) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                int offset = 0;

                @Override
                public void run() {
                    DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout;
                    int n;
                    int n2 = this.offset;
                    DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = DCWeexBaseRefreshLayout.this;
                    if ((float)n < dCWeexBaseRefreshLayout.mTotalDragDistance) {
                        2 v2 = this;
                        dCWeexBaseRefreshLayout2.moveSpinner(n2);
                        v2.DCWeexBaseRefreshLayout.this.postDelayed(this, 1L);
                        v2.offset += 15;
                        return;
                    }
                    dCWeexBaseRefreshLayout2.setRefreshing(true, true);
                    DCWeexBaseRefreshLayout.this.mBeginRefresh = false;
                }
            };
            this.post(runnable2);
            this.mBeginRefresh = true;
            return;
        }
    }

    @Deprecated
    public void setProgressBackgroundColor(int n) {
        this.setProgressBackgroundColorSchemeResource(n);
    }

    public void setProgressBackgroundColorSchemeResource(@ColorRes int n) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.setProgressBackgroundColorSchemeColor(dCWeexBaseRefreshLayout.getResources().getColor(n));
    }

    public void setProgressBackgroundColorSchemeColor(@ColorInt int n) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mCircleView.setBackgroundColor(n);
        dCWeexBaseRefreshLayout.mProgress.setBackgroundColor(n);
    }

    @Deprecated
    public void setColorScheme(int ... nArray) {
        this.setColorSchemeResources(nArray);
    }

    public void setColorSchemeResources(int ... nArray) {
        Resources resources = this.getResources();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = resources.getColor(nArray[i]);
        }
        this.setColorSchemeColors(nArray2);
    }

    public void setColorSchemeColors(int ... nArray) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.ensureTarget();
        dCWeexBaseRefreshLayout.mProgress.setColorSchemeColors(nArray);
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    public void clearTarget() {
        this.mTarget = null;
    }

    public void setDistanceToTriggerSync(int n) {
        this.mTotalDragDistance = n;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view;
        int n5;
        int n6;
        block5: {
            block4: {
                DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
                n6 = dCWeexBaseRefreshLayout.getMeasuredWidth();
                n5 = dCWeexBaseRefreshLayout.getMeasuredHeight();
                if (dCWeexBaseRefreshLayout.getChildCount() == 0) break block4;
                if (this.mTarget == null) {
                    this.ensureTarget();
                }
                if ((view = this.mTarget) != null) break block5;
            }
            return;
        }
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        int n7 = n5;
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
        n5 = dCWeexBaseRefreshLayout2.getPaddingLeft();
        int n8 = dCWeexBaseRefreshLayout2.getPaddingTop();
        int n9 = n6 - dCWeexBaseRefreshLayout2.getPaddingLeft() - this.getPaddingRight();
        int n10 = n7 - this.getPaddingTop() - this.getPaddingBottom();
        int n11 = n5;
        int n12 = n5;
        int n13 = n5;
        n5 = n8 + this.mCircleLatyouOffsetTop;
        n9 = n13 + n9;
        n10 = n8 + n10;
        this.mCircleLayout.layout(n12, n5, n9, n10);
        view.layout(n11, n8, n9, n10);
        n5 = dCWeexBaseRefreshLayout.mCircleView.getMeasuredWidth();
        n8 = dCWeexBaseRefreshLayout.mCircleView.getMeasuredHeight();
        int n102 = n6 / 2;
        int n14 = n5 / 2;
        n5 = n102 - n14;
        n9 = this.mCurrentTargetOffsetTop;
        int n15 = n9 + n8;
        dCWeexBaseRefreshLayout.mCircleView.layout(n5, n9, n102 += n14, n15);
    }

    public void onMeasure(int n, int n2) {
        View view;
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        super.onMeasure(n, n2);
        if (dCWeexBaseRefreshLayout.mTarget == null) {
            this.ensureTarget();
        }
        if ((view = this.mTarget) != null) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
            this.mCircleView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mCircleDiameter, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mCircleDiameter, (int)0x40000000));
            this.mCircleViewIndex = -1;
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.getChildAt(i) != this.mCircleLayout) continue;
                this.mCircleViewIndex = i;
                return;
            }
        }
    }

    public int getProgressCircleDiameter() {
        return this.mCircleDiameter;
    }

    public boolean canChildScrollUp() {
        View view;
        if (dCWeexBaseRefreshLayout.mTarget == null) {
            dCWeexBaseRefreshLayout.ensureTarget();
        }
        if ((view = dCWeexBaseRefreshLayout.mTarget) == null) {
            return false;
        }
        OnChildScrollUpCallback onChildScrollUpCallback = dCWeexBaseRefreshLayout.mChildScrollUpCallback;
        if (onChildScrollUpCallback != null) {
            return onChildScrollUpCallback.canChildScrollUp(dCWeexBaseRefreshLayout, view);
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = (AbsListView)view;
                return dCWeexBaseRefreshLayout.getChildCount() > 0 && (dCWeexBaseRefreshLayout.getFirstVisiblePosition() > 0 || dCWeexBaseRefreshLayout.getChildAt(0).getTop() < dCWeexBaseRefreshLayout.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)view, (int)-1) || dCWeexBaseRefreshLayout.mTarget.getScrollY() > 0;
            {
            }
        }
        return ViewCompat.canScrollVertically((View)view, (int)-1);
    }

    public void setOnChildScrollUpCallback(@Nullable OnChildScrollUpCallback onChildScrollUpCallback) {
        this.mChildScrollUpCallback = onChildScrollUpCallback;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        this.ensureTarget();
        int n = MotionEventCompat.getActionMasked((MotionEvent)motionEvent);
        if (this.mReturningToStart && n == 0) {
            this.mReturningToStart = false;
        }
        if (!(!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp() || this.mRefreshing || this.mNestedScrollInProgress)) {
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    this.onSecondaryPointerUp(motionEvent);
                    break;
                }
                case 2: {
                    n = this.mActivePointerId;
                    if (n == -1) {
                        Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but don't have an active pointer id.");
                        return false;
                    }
                    if ((n = motionEvent.findPointerIndex(n)) < 0) {
                        return false;
                    }
                    this.startDragging(motionEvent.getY(n));
                    break;
                }
                case 1: 
                case 3: {
                    DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
                    dCWeexBaseRefreshLayout.mIsBeingDragged = false;
                    dCWeexBaseRefreshLayout.mActivePointerId = -1;
                    break;
                }
                case 0: {
                    DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
                    DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
                    dCWeexBaseRefreshLayout2.setTargetOffsetTopAndBottom(dCWeexBaseRefreshLayout2.mOriginalOffsetTop - this.mCircleView.getTop(), true);
                    dCWeexBaseRefreshLayout.mActivePointerId = n = motionEvent.getPointerId(0);
                    dCWeexBaseRefreshLayout.mIsBeingDragged = false;
                    n = motionEvent.findPointerIndex(n);
                    if (n < 0) {
                        return false;
                    }
                    this.mInitialDownY = motionEvent.getY(n);
                }
            }
            return this.mIsBeingDragged;
        }
        return false;
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        View view;
        if (Build.VERSION.SDK_INT < 21 && this.mTarget instanceof AbsListView || (view = this.mTarget) != null && !ViewCompat.isNestedScrollingEnabled((View)view)) {
            return;
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    public boolean onStartNestedScroll(View view, View view2, int n) {
        return this.isEnabled() && !this.mReturningToStart && !this.mRefreshing && (n & 2) != 0;
    }

    public void onNestedScrollAccepted(View view, View view2, int n) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(view, view2, n);
        this.startNestedScroll(n & 2);
        this.mTotalUnconsumed = 0.0f;
        this.mNestedScrollInProgress = true;
    }

    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
        int n3;
        if (n2 > 0) {
            float f;
            float f2 = ((DCWeexBaseRefreshLayout)((Object)this)).mTotalUnconsumed;
            if (f > 0.0f) {
                float f3;
                float f4 = n2;
                if (f3 > f2) {
                    nArray[1] = n2 - (int)f2;
                    ((DCWeexBaseRefreshLayout)((Object)this)).mTotalUnconsumed = 0.0f;
                } else {
                    ((DCWeexBaseRefreshLayout)((Object)this)).mTotalUnconsumed = f2 - f4;
                    nArray[1] = n2;
                }
                Object object = this;
                ((DCWeexBaseRefreshLayout)((Object)object)).moveSpinner(((DCWeexBaseRefreshLayout)((Object)object)).mTotalUnconsumed);
            }
        }
        if (((DCWeexBaseRefreshLayout)((Object)this)).mUsingCustomStart && n2 > 0 && ((DCWeexBaseRefreshLayout)((Object)this)).mTotalUnconsumed == 0.0f && Math.abs(n2 - nArray[1]) > 0) {
            ((DCWeexBaseRefreshLayout)((Object)this)).mCircleView.setVisibility(8);
        }
        if (((DCWeexBaseRefreshLayout)((Object)this)).dispatchNestedPreScroll(n3 = n - nArray[0], n2 - nArray[1], (int[])(this = (Object)((DCWeexBaseRefreshLayout)((Object)this)).mParentScrollConsumed), null)) {
            int[] nArray2 = nArray;
            nArray2[0] = nArray[0] + this[0];
            nArray2[1] = nArray[1] + this[1];
            return;
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View view) {
        float f;
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        dCWeexBaseRefreshLayout.mNestedScrollingParentHelper.onStopNestedScroll(view);
        dCWeexBaseRefreshLayout.mNestedScrollInProgress = false;
        float f2 = dCWeexBaseRefreshLayout.mTotalUnconsumed;
        if (f > 0.0f) {
            this.finishSpinner(f2);
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    public void onNestedScroll(View object, int n, int n2, int n3, int n4) {
        DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout = this;
        object = this.mParentOffsetInWindow;
        dCWeexBaseRefreshLayout.dispatchNestedScroll(n, n2, n3, n4, (int[])object);
        int n5 = n4 + dCWeexBaseRefreshLayout.mParentOffsetInWindow[1];
        if (n5 < 0 && !this.canChildScrollUp()) {
            float f;
            DCWeexBaseRefreshLayout dCWeexBaseRefreshLayout2 = this;
            dCWeexBaseRefreshLayout2.mTotalUnconsumed = f = dCWeexBaseRefreshLayout2.mTotalUnconsumed + (float)Math.abs(n5);
            dCWeexBaseRefreshLayout2.moveSpinner(f);
            return;
        }
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(bl);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int n) {
        return this.mNestedScrollingChildHelper.startNestedScroll(n);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(n, n2, n3, n4, nArray);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(n, n2, nArray, nArray2);
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return this.dispatchNestedPreFling(f, f2);
    }

    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return this.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean bl) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(f, f2);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = MotionEventCompat.getActionMasked((MotionEvent)motionEvent);
        if (this.mReturningToStart && n == 0) {
            this.mReturningToStart = false;
        }
        if (!(!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp() || this.mRefreshing || this.mNestedScrollInProgress)) {
            Boolean bl = Boolean.TRUE;
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    this.onSecondaryPointerUp(motionEvent);
                    break;
                }
                case 5: {
                    int n2 = MotionEventCompat.getActionIndex((MotionEvent)motionEvent);
                    if (n2 < 0) {
                        Log.e((String)LOG_TAG, (String)"Got ACTION_POINTER_DOWN event but have an invalid action index.");
                        return false;
                    }
                    this.mActivePointerId = motionEvent.getPointerId(n2);
                    break;
                }
                case 3: {
                    bl = Boolean.FALSE;
                    break;
                }
                case 2: {
                    float f;
                    int n3 = motionEvent.findPointerIndex(this.mActivePointerId);
                    if (n3 < 0) {
                        Log.e((String)LOG_TAG, (String)"Got ACTION_MOVE event but have an invalid active pointer id.");
                        bl = Boolean.FALSE;
                        break;
                    }
                    float f2 = motionEvent.getY(n3);
                    this.startDragging(f2);
                    if (!this.mIsBeingDragged) break;
                    f2 = (f2 - this.mInitialMotionY) * 0.5f;
                    if (f > 0.0f) {
                        this.moveSpinner(f2);
                        break;
                    }
                    bl = Boolean.FALSE;
                    break;
                }
                case 1: {
                    int n4 = motionEvent.findPointerIndex(this.mActivePointerId);
                    if (n4 < 0) {
                        Log.e((String)LOG_TAG, (String)"Got ACTION_UP event but don't have an active pointer id.");
                        bl = Boolean.FALSE;
                        break;
                    }
                    if (this.mIsBeingDragged) {
                        this.mIsBeingDragged = false;
                        this.finishSpinner((motionEvent.getY(n4) - this.mInitialMotionY) * 0.5f);
                    }
                    this.mActivePointerId = -1;
                    bl = Boolean.FALSE;
                    break;
                }
                case 0: {
                    this.mActivePointerId = motionEvent.getPointerId(0);
                    this.mIsBeingDragged = false;
                }
            }
            return bl;
        }
        return false;
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }

    public static interface OnChildScrollUpCallback {
        public boolean canChildScrollUp(DCWeexBaseRefreshLayout var1, @Nullable View var2);
    }
}

