/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.widget.refresh;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import io.dcloud.feature.weex.adapter.widget.refresh.DCWeexBaseRefreshLayout;

public class WeexDcRefreshLayout
extends DCWeexBaseRefreshLayout {
    private boolean mDragger;
    private float mStartY;
    private float mStartX;
    private int mTouchSlop;

    public WeexDcRefreshLayout(Context context) {
        super(context);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    private boolean isViewRefresh() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            WeexDcRefreshLayout weexDcRefreshLayout = this;
            if (!weexDcRefreshLayout.canScrollVertically(weexDcRefreshLayout.getChildAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean canScrollVertically(View view) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup;
            if (view.canScrollVertically(-1)) {
                return true;
            }
            for (int i = 0; i < (viewGroup = (ViewGroup)view).getChildCount(); ++i) {
                if (!this.canScrollVertically(viewGroup.getChildAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.isEnabled()) {
            int n = motionEvent.getAction();
            if (!this.isViewRefresh()) {
                return false;
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    float f;
                    if (this.mDragger) {
                        return false;
                    }
                    MotionEvent motionEvent2 = motionEvent;
                    float f2 = motionEvent2.getY();
                    float f3 = Math.abs(motionEvent2.getX() - this.mStartX);
                    f2 = Math.abs(f2 - this.mStartY);
                    if (!(f > (float)this.mTouchSlop) || !(f3 > f2)) break;
                    this.mDragger = true;
                    return false;
                }
                case 1: 
                case 3: {
                    this.mDragger = false;
                    break;
                }
                case 0: {
                    WeexDcRefreshLayout weexDcRefreshLayout = this;
                    this.mStartY = motionEvent.getY();
                    weexDcRefreshLayout.mStartX = motionEvent.getX();
                    weexDcRefreshLayout.mDragger = false;
                }
            }
        }
        return super.onInterceptTouchEvent(motionEvent);
    }
}

