/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.UPCEANReader;

public final class UPCEReader
extends UPCEANReader {
    static final int[] CHECK_DIGIT_ENCODINGS = new int[]{56, 52, 50, 49, 44, 38, 35, 42, 41, 37};
    private static final int[] MIDDLE_END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
    private static final int[][] NUMSYS_AND_CHECK_DIGIT_PATTERNS;
    private final int[] decodeMiddleCounters = new int[4];

    private static void determineNumSysAndCheckDigit(StringBuilder stringBuilder, int n5) throws NotFoundException {
        for (int i5 = 0; i5 <= 1; ++i5) {
            for (int i6 = 0; i6 < 10; ++i6) {
                if (n5 != NUMSYS_AND_CHECK_DIGIT_PATTERNS[i5][i6]) continue;
                stringBuilder.insert(0, (char)(i5 + 48));
                stringBuilder.append((char)(i6 + 48));
                return;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public static String convertUPCEtoUPCA(String string2) {
        StringBuilder stringBuilder;
        char[] cArray = new char[6];
        string2.getChars(1, 7, cArray, 0);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(12);
        stringBuilder.append(string2.charAt(0));
        char c6 = cArray[5];
        switch (c6) {
            default: {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(cArray, 0, 5);
                stringBuilder3.append("0000");
                stringBuilder3.append(c6);
                break;
            }
            case '4': {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.append(cArray, 0, 4);
                stringBuilder4.append("00000");
                stringBuilder2.append(cArray[4]);
                break;
            }
            case '3': {
                StringBuilder stringBuilder5 = stringBuilder2;
                stringBuilder5.append(cArray, 0, 3);
                stringBuilder5.append("00000");
                stringBuilder5.append(cArray, 3, 2);
                break;
            }
            case '0': 
            case '1': 
            case '2': {
                StringBuilder stringBuilder6 = stringBuilder2;
                stringBuilder6.append(cArray, 0, 2);
                stringBuilder6.append(c6);
                stringBuilder6.append("0000");
                stringBuilder6.append(cArray, 2, 3);
            }
        }
        StringBuilder stringBuilder7 = stringBuilder2;
        stringBuilder7.append(string2.charAt(7));
        return stringBuilder7.toString();
    }

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[10];
        int[] nArray2 = nArray;
        nArray[0] = 56;
        nArray[1] = 52;
        nArray[2] = 50;
        nArray[3] = 49;
        nArray[4] = 44;
        nArray[5] = 38;
        nArray[6] = 35;
        nArray[7] = 42;
        nArray[8] = 41;
        nArray[9] = 37;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[10];
        nArray2 = nArray3;
        nArray3[0] = 7;
        nArray3[1] = 11;
        nArray3[2] = 13;
        nArray3[3] = 14;
        nArray3[4] = 19;
        nArray3[5] = 25;
        nArray3[6] = 28;
        nArray3[7] = 21;
        nArray3[8] = 22;
        nArray3[9] = 26;
        nArrayArray[1] = nArray2;
        NUMSYS_AND_CHECK_DIGIT_PATTERNS = nArrayArray;
    }

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray2 = ((UPCEReader)object).decodeMiddleCounters;
        Object object = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        ((UPCEReader)object).decodeMiddleCounters[3] = 0;
        int n5 = bitArray.getSize();
        int n6 = nArray[1];
        int n7 = 0;
        for (int i5 = 0; i5 < 6 && n6 < n5; ++i5) {
            int n8 = UPCEANReader.decodeDigit(bitArray, (int[])object, n6, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(n8 % 10 + 48));
            int n9 = ((Object)object).length;
            for (int i6 = 0; i6 < n9; ++i6) {
                n6 += object[i6];
            }
            if (n8 < 10) continue;
            n7 |= 1 << 5 - i5;
        }
        UPCEReader.determineNumSysAndCheckDigit(stringBuilder, n7);
        return n6;
    }

    @Override
    protected int[] decodeEnd(BitArray bitArray, int n5) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n5, true, MIDDLE_END_PATTERN);
    }

    @Override
    protected boolean checkChecksum(String string2) throws FormatException {
        return super.checkChecksum(UPCEReader.convertUPCEtoUPCA(string2));
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_E;
    }
}

