/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.cache;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.cache.FaultHidingSink;
import dc.squareup.okhttp3.internal.io.FileSystem;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable,
Flushable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    static final /* synthetic */ boolean $assertionsDisabled;
    final FileSystem fileSystem;
    final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    final int valueCount;
    private long size = 0L;
    BufferedSink journalWriter;
    final LinkedHashMap<String, Entry> lruEntries;
    int redundantOpCount;
    boolean hasJournalErrors;
    boolean initialized;
    boolean closed;
    boolean mostRecentTrimFailed;
    boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    private final Executor executor;
    private final Runnable cleanupRunnable;

    DiskLruCache(FileSystem fileSystem, File file, int n5, int n6, long l5, Executor executor) {
        File file2;
        File file3;
        File file4;
        Runnable runnable;
        LinkedHashMap linkedHashMap;
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap(0, 0.75f, true);
        ((DiskLruCache)object2).lruEntries = object;
        ((DiskLruCache)object2).nextSequenceNumber = 0L;
        object = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                v0 = this;
                var1_1 = v0.DiskLruCache.this;
                synchronized (var1_1) {
                    block12: {
                        var2_2 = v0.DiskLruCache.this;
                        {
                            catch (Throwable v1) {
                                break block12;
                            }
                            {
                                v2 = var2_2.initialized;
                            }
                            if (v2 ^ true | var2_2.closed) {
                                return;
                            }
                            try {
                                var2_2.trimToSize();
                            }
                            catch (IOException v3) {
                                DiskLruCache.this.mostRecentTrimFailed = true;
                            }
                            try {
                                if (DiskLruCache.this.journalRebuildRequired()) {
                                    DiskLruCache.this.rebuildJournal();
                                    DiskLruCache.this.redundantOpCount = 0;
                                }
                                ** GOTO lbl26
                            }
                            catch (IOException v4) {}
                            {
                                v5 = DiskLruCache.this;
                                v5.mostRecentRebuildFailed = true;
                                v5.journalWriter = Okio.buffer(Okio.blackhole());
lbl26:
                                // 2 sources

                                return;
                            }
                        }
                    }
                    throw v1;
                }
            }
        };
        ((DiskLruCache)object2).cleanupRunnable = object;
        ((DiskLruCache)object2).fileSystem = fileSystem;
        ((DiskLruCache)object2).directory = file;
        ((DiskLruCache)object2).appVersion = n5;
        Object object2 = file4;
        file4 = new File(file, JOURNAL_FILE);
        v3.journalFile = object2;
        object2 = file3;
        file3 = new File(file, JOURNAL_FILE_TEMP);
        v3.journalFileTmp = object2;
        object2 = file2;
        file2 = new File(file, JOURNAL_FILE_BACKUP);
        v3.journalFileBackup = object2;
        v3.valueCount = n6;
        v3.maxSize = l5;
        v3.executor = executor;
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n5, int n6, long l5) {
        if (l5 > 0L) {
            if (n6 > 0) {
                LinkedBlockingQueue<Runnable> linkedBlockingQueue;
                ThreadPoolExecutor threadPoolExecutor;
                ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
                TimeUnit timeUnit = TimeUnit.SECONDS;
                LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
                linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
                ThreadFactory threadFactory = Util.threadFactory("OkHttp DiskLruCache", true);
                threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, timeUnit, linkedBlockingQueue2, threadFactory);
                return new DiskLruCache(fileSystem, file, n5, n6, l5, threadPoolExecutor2);
            }
            throw new IllegalArgumentException("valueCount <= 0");
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    /*
     * Exception decompiling
     */
    private void readJournal() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 11[TRYBLOCK] [12 : 133->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink sink = this.fileSystem.appendingSink(this.journalFile);
        return Okio.buffer(new FaultHidingSink(sink){
            static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = DiskLruCache.class.desiredAssertionStatus() ^ true;
            }

            @Override
            protected void onException(IOException iOException) {
                if (!$assertionsDisabled && !Thread.holdsLock(DiskLruCache.this)) {
                    throw new AssertionError();
                }
                DiskLruCache.this.hasJournalErrors = true;
            }
        });
    }

    private void readJournalLine(String object) throws IOException {
        int n5 = ((String)object).indexOf(32);
        if (n5 != -1) {
            Entry entry;
            String string2;
            int n6 = n5 + 1;
            int n7 = ((String)object).indexOf(32, n6);
            if (n7 == -1) {
                string2 = ((String)object).substring(n6);
                if (n5 == 6 && ((String)object).startsWith(REMOVE)) {
                    ((AbstractMap)stringArray.lruEntries).remove(string2);
                    return;
                }
            } else {
                string2 = ((String)object).substring(n6, n7);
            }
            if ((entry = stringArray.lruEntries.get(string2)) == null) {
                Entry entry2;
                entry = entry2;
                entry2 = new Entry((DiskLruCache)stringArray, string2);
                ((AbstractMap)stringArray.lruEntries).put(string2, entry);
            }
            if (n7 != -1 && n5 == 5 && ((String)object).startsWith(CLEAN)) {
                String[] stringArray = ((String)object).substring(n7 + 1).split(" ");
                entry.readable = true;
                entry.currentEditor = null;
                entry.setLengths(stringArray);
                return;
            }
            if (n7 == -1 && n5 == 5 && ((String)object).startsWith(DIRTY)) {
                Editor editor;
                object = editor;
                editor = (DiskLruCache)stringArray.new Editor(entry);
                entry.currentEditor = object;
                return;
            }
            if (n7 == -1 && n5 == 4 && ((String)object).startsWith(READ)) {
                return;
            }
            throw new IOException("unexpected journal line: " + (String)object);
        }
        throw new IOException("unexpected journal line: " + (String)object);
    }

    private void processJournal() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> iterator = diskLruCache.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n5;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n5 = 0; n5 < this.valueCount; ++n5) {
                    this.size += entry.lengths[n5];
                }
                continue;
            }
            entry.currentEditor = null;
            for (n5 = 0; n5 < this.valueCount; ++n5) {
                DiskLruCache diskLruCache2 = this;
                diskLruCache2.fileSystem.delete(entry.cleanFiles[n5]);
                diskLruCache2.fileSystem.delete(entry.dirtyFiles[n5]);
            }
            iterator.remove();
        }
    }

    private synchronized void checkNotClosed() {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException("cache is closed");
    }

    private void validateKey(String string2) {
        if (LEGAL_KEY_PATTERN.matcher(string2).matches()) {
            return;
        }
        throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,120}: \"" + string2 + "\"");
    }

    static {
        $assertionsDisabled = DiskLruCache.class.desiredAssertionStatus() ^ true;
        LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
    }

    public synchronized void initialize() throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.rename(this.journalFileBackup, this.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "DiskLruCache " + this.directory + " is corrupt: " + iOException.getMessage() + ", removing", iOException);
                try {
                    this.delete();
                    this.closed = false;
                }
                catch (Throwable throwable) {
                    this.closed = false;
                    throw throwable;
                }
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void rebuildJournal() throws IOException {
        var1_1 = this.journalWriter;
        if (var1_1 != null) {
            var1_1.close();
        }
        v0 = this;
        var1_1 = Okio.buffer(v0.fileSystem.sink(this.journalFileTmp));
        v1 = this;
        v2 = var1_1;
        v3 = this;
        v4 = var1_1;
        v5 = v4;
        v4.writeUtf8("libcore.io.DiskLruCache").writeByte(10);
        v5.writeUtf8("1").writeByte(10);
        v2.writeDecimalLong(v3.appVersion).writeByte(10);
        var1_1.writeDecimalLong(v1.valueCount).writeByte(10);
        var1_1.writeByte(10);
        ** for (var3_3 : v0.lruEntries.values())
        {
            block16: {
                catch (Throwable v6) {
                }
lbl31:
                // 2 sources

                if (var3_3.currentEditor == null) break block16;
                v7 = var1_1;
                v8 = v7;
                v9 = v7;
                v10 = var3_3;
                var1_1.writeUtf8("DIRTY").writeByte(32);
                v8.writeUtf8(v10.key);
                v11 = v9.writeByte(10);
                continue;
            }
            v12 = var1_1;
            v13 = var3_3;
            v14 = var1_1;
            v15 = v14;
            v16 = v14;
            v17 = var3_3;
            var1_1.writeUtf8("CLEAN").writeByte(32);
            v15.writeUtf8(v17.key);
            v13.writeLengths(v16);
            v11 = v12.writeByte(10);
            continue;
        }
lbl61:
        // 1 sources

        var1_1.close();
        if (this.fileSystem.exists(this.journalFile)) {
            v18 = this;
            var1_1 = v18.journalFile;
            this.fileSystem.rename((File)var1_1, v18.journalFileBackup);
        }
        v19 = this;
        v20 = this;
        var1_1 = v20.journalFileTmp;
        v19.fileSystem.rename((File)var1_1, v20.journalFile);
        v19.fileSystem.delete(this.journalFileBackup);
        v19.journalWriter = v19.newJournalWriter();
        v19.hasJournalErrors = false;
        v19.mostRecentRebuildFailed = false;
        return;
        var1_1.close();
        throw v6;
    }

    public synchronized Snapshot get(String string2) throws IOException {
        DiskLruCache diskLruCache = this;
        DiskLruCache diskLruCache2 = this;
        diskLruCache2.initialize();
        diskLruCache2.checkNotClosed();
        diskLruCache.validateKey(string2);
        Object object = diskLruCache.lruEntries.get(string2);
        if (object != null && ((Entry)object).readable) {
            if ((object = ((Entry)object).snapshot()) == null) {
                return null;
            }
            DiskLruCache diskLruCache3 = this;
            ++diskLruCache3.redundantOpCount;
            diskLruCache3.journalWriter.writeUtf8(READ).writeByte(32).writeUtf8(string2).writeByte(10);
            if (diskLruCache3.journalRebuildRequired()) {
                this.executor.execute(this.cleanupRunnable);
                return object;
            }
            return object;
        }
        return null;
    }

    @Nullable
    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    synchronized Editor edit(String object, long l5) throws IOException {
        DiskLruCache diskLruCache = this;
        DiskLruCache diskLruCache2 = this;
        diskLruCache2.initialize();
        diskLruCache2.checkNotClosed();
        diskLruCache.validateKey((String)object);
        Entry entry = diskLruCache.lruEntries.get(object);
        if (l5 != -1L && (entry == null || entry.sequenceNumber != l5)) {
            return null;
        }
        if (entry != null && entry.currentEditor != null) {
            return null;
        }
        if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) {
            Editor editor;
            DiskLruCache diskLruCache3 = this;
            diskLruCache3.journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8((String)object).writeByte(10);
            diskLruCache3.journalWriter.flush();
            if (diskLruCache3.hasJournalErrors) {
                return null;
            }
            if (entry == null) {
                Entry entry2;
                entry = entry2;
                entry2 = new Entry(this, (String)object);
                ((AbstractMap)this.lruEntries).put((String)object, entry);
            }
            object = editor;
            ((Editor)object)(entry);
            entry.currentEditor = object;
            return editor;
        }
        this.executor.execute(this.cleanupRunnable);
        return null;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long l5) {
        this.maxSize = l5;
        if (this.initialized) {
            this.executor.execute(this.cleanupRunnable);
            return;
        }
    }

    public synchronized long size() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.initialize();
        return diskLruCache.size;
    }

    synchronized void completeEdit(Editor editor, boolean bl) throws IOException {
        Entry entry = editor.entry;
        if (entry.currentEditor == editor) {
            if (bl && !entry.readable) {
                for (int i5 = 0; i5 < this.valueCount; ++i5) {
                    if (editor.written[i5]) {
                        if (this.fileSystem.exists(entry.dirtyFiles[i5])) continue;
                        editor.abort();
                        return;
                    }
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i5);
                }
            }
            for (int i6 = 0; i6 < this.valueCount; ++i6) {
                File file = entry.dirtyFiles[i6];
                if (bl) {
                    long l5;
                    if (!this.fileSystem.exists(file)) continue;
                    Entry entry2 = entry;
                    File file2 = entry2.cleanFiles[i6];
                    this.fileSystem.rename(file, file2);
                    long l6 = entry2.lengths[i6];
                    entry2.lengths[i6] = l5 = this.fileSystem.size(file2);
                    this.size = l5 = this.size - l6 + l5;
                    continue;
                }
                this.fileSystem.delete(file);
            }
            ++this.redundantOpCount;
            entry.currentEditor = null;
            if (entry.readable | bl) {
                entry.readable = true;
                this.journalWriter.writeUtf8(CLEAN).writeByte(32);
                this.journalWriter.writeUtf8(entry.key);
                entry.writeLengths(this.journalWriter);
                this.journalWriter.writeByte(10);
                if (bl) {
                    long l7;
                    long l8 = this.nextSequenceNumber;
                    this.nextSequenceNumber = l7 = l8 + 1L;
                    entry.sequenceNumber = l8;
                }
            } else {
                ((AbstractMap)this.lruEntries).remove(entry.key);
                this.journalWriter.writeUtf8(REMOVE).writeByte(32);
                this.journalWriter.writeUtf8(entry.key);
                this.journalWriter.writeByte(10);
            }
            this.journalWriter.flush();
            if (this.size <= this.maxSize && !this.journalRebuildRequired()) {
                return;
            }
            this.executor.execute(this.cleanupRunnable);
            return;
        }
        throw new IllegalStateException();
    }

    boolean journalRebuildRequired() {
        int n5 = this.redundantOpCount;
        return n5 >= 2000 && n5 >= ((AbstractMap)this.lruEntries).size();
    }

    public synchronized boolean remove(String object) throws IOException {
        DiskLruCache diskLruCache = this;
        DiskLruCache diskLruCache2 = this;
        diskLruCache2.initialize();
        diskLruCache2.checkNotClosed();
        diskLruCache.validateKey((String)object);
        object = diskLruCache.lruEntries.get(object);
        if (object == null) {
            return false;
        }
        boolean bl = this.removeEntry((Entry)object);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
            return bl;
        }
        return bl;
    }

    boolean removeEntry(Entry entry) throws IOException {
        Editor editor = entry.currentEditor;
        if (editor != null) {
            editor.detach();
        }
        for (int i5 = 0; i5 < this.valueCount; ++i5) {
            DiskLruCache diskLruCache = this;
            diskLruCache.fileSystem.delete(entry.cleanFiles[i5]);
            long l5 = diskLruCache.size;
            long[] lArray = entry.lengths;
            this.size = l5 - lArray[i5];
            entry.lengths[i5] = 0L;
        }
        DiskLruCache diskLruCache = this;
        ++diskLruCache.redundantOpCount;
        diskLruCache.journalWriter.writeUtf8(REMOVE).writeByte(32).writeUtf8(entry.key).writeByte(10);
        ((AbstractMap)diskLruCache.lruEntries).remove(entry.key);
        if (diskLruCache.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        DiskLruCache diskLruCache = this;
        diskLruCache.checkNotClosed();
        diskLruCache.trimToSize();
        diskLruCache.journalWriter.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.initialized && !this.closed) {
            Entry[] entryArray = this.lruEntries.values().toArray(new Entry[((AbstractMap)this.lruEntries).size()]);
            int n5 = entryArray.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                Editor editor = entryArray[i5].currentEditor;
                if (editor == null) continue;
                editor.abort();
            }
            DiskLruCache diskLruCache = this;
            diskLruCache.trimToSize();
            diskLruCache.journalWriter.close();
            diskLruCache.journalWriter = null;
            diskLruCache.closed = true;
            return;
        }
        this.closed = true;
    }

    void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            DiskLruCache diskLruCache = this;
            diskLruCache.removeEntry(diskLruCache.lruEntries.values().iterator().next());
        }
        this.mostRecentTrimFailed = false;
    }

    public void delete() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.close();
        diskLruCache.fileSystem.deleteContents(this.directory);
    }

    public synchronized void evictAll() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.initialize();
        Entry[] entryArray = diskLruCache.lruEntries.values().toArray(new Entry[((AbstractMap)this.lruEntries).size()]);
        int n5 = entryArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            this.removeEntry(entryArray[i5]);
        }
        this.mostRecentTrimFailed = false;
    }

    public synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(){
            final Iterator<Entry> delegate;
            Snapshot nextSnapshot;
            Snapshot removeSnapshot;
            {
                this.delegate = new ArrayList<Entry>(DiskLruCache.this.lruEntries.values()).iterator();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasNext() {
                if (this.nextSnapshot != null) {
                    return true;
                }
                3 v02 = this;
                DiskLruCache diskLruCache = v02.DiskLruCache.this;
                synchronized (diskLruCache) {
                    try {
                        if (v02.DiskLruCache.this.closed) {
                            return false;
                        }
                    }
                    catch (Throwable throwable) {}
                    throw throwable;
                    while (this.delegate.hasNext()) {
                        Object object = this.delegate.next();
                        if (!((Entry)object).readable || (object = ((Entry)object).snapshot()) == null) continue;
                        this.nextSnapshot = object;
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public Snapshot next() {
                if (this.hasNext()) {
                    Snapshot snapshot = this.nextSnapshot;
                    3 v02 = this;
                    v02.removeSnapshot = snapshot;
                    v02.nextSnapshot = null;
                    return snapshot;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                Snapshot snapshot = this.removeSnapshot;
                if (snapshot != null) {
                    block4: {
                        try {
                            3 v02 = this;
                            3 v12 = v02;
                            v02.DiskLruCache.this.remove(snapshot.key);
                        }
                        catch (Throwable throwable) {
                        }
                        catch (IOException iOException) {
                            break block4;
                        }
                        v12.removeSnapshot = null;
                        return;
                        this.removeSnapshot = null;
                        throw throwable;
                    }
                    this.removeSnapshot = null;
                    return;
                }
                throw new IllegalStateException("remove() before next()");
            }
        };
    }

    private final class Entry {
        final String key;
        final long[] lengths;
        final File[] cleanFiles;
        final File[] dirtyFiles;
        boolean readable;
        Editor currentEditor;
        long sequenceNumber;
        final /* synthetic */ DiskLruCache this$0;

        Entry(DiskLruCache diskLruCache, String charSequence) {
            Entry entry = this;
            this.this$0 = diskLruCache;
            this.key = charSequence;
            int n5 = diskLruCache.valueCount;
            entry.lengths = new long[n5];
            entry.cleanFiles = new File[n5];
            entry.dirtyFiles = new File[n5];
            charSequence = new StringBuilder((String)charSequence).append('.');
            n5 = ((StringBuilder)charSequence).length();
            for (int i5 = 0; i5 < diskLruCache.valueCount; ++i5) {
                File file;
                File file2;
                ((StringBuilder)charSequence).append(i5);
                File file3 = file2;
                File file4 = diskLruCache.directory;
                file2 = new File(file4, ((StringBuilder)charSequence).toString());
                this.cleanFiles[i5] = file3;
                ((StringBuilder)charSequence).append(".tmp");
                file3 = file;
                file4 = diskLruCache.directory;
                file = new File(file4, ((StringBuilder)charSequence).toString());
                this.dirtyFiles[i5] = file3;
                ((StringBuilder)charSequence).setLength(n5);
            }
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != this.this$0.valueCount) throw this.invalidLengths(stringArray);
            int n5 = 0;
            try {
                while (n5 < stringArray.length) {
                    this.lengths[n5] = Long.parseLong(stringArray[n5]);
                    ++n5;
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        void writeLengths(BufferedSink bufferedSink) throws IOException {
            Object object = ((Entry)object).lengths;
            int n5 = ((Entry)object).lengths.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                Object object2 = object[i5];
                bufferedSink.writeByte(32).writeDecimalLong((long)object2);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Snapshot snapshot() {
            DiskLruCache diskLruCache;
            Closeable closeable;
            Source[] sourceArray;
            block8: {
                if (!Thread.holdsLock(this.this$0)) throw new AssertionError();
                Entry entry = this;
                sourceArray = new Source[entry.this$0.valueCount];
                long[] lArray = (long[])entry.lengths.clone();
                int n5 = 0;
                while (true) {
                    int n6;
                    try {
                        n6 = n5;
                        closeable = this.this$0;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        break block8;
                    }
                    {
                        if (n6 >= closeable.valueCount) break;
                        sourceArray[n5] = closeable.fileSystem.source(this.cleanFiles[n5]);
                        ++n5;
                        continue;
                    }
                    break;
                }
                {
                    Entry entry2 = this;
                    String string2 = entry2.key;
                    long l5 = entry2.sequenceNumber;
                    return (DiskLruCache)closeable.new Snapshot(string2, l5, sourceArray, lArray);
                }
            }
            int n7 = 0;
            while (true) {
                diskLruCache = this.this$0;
                if (n7 >= diskLruCache.valueCount || (closeable = sourceArray[n7]) == null) break;
                Util.closeQuietly(closeable);
                ++n7;
            }
            try {
                diskLruCache.removeEntry(this);
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public final class Editor {
        final Entry entry;
        final boolean[] written;
        private boolean done;

        Editor(Entry entry) {
            this.entry = entry;
            DiskLruCache.this = entry.readable ? null : (Object)new boolean[((DiskLruCache)DiskLruCache.this).valueCount];
            this.written = (boolean[])DiskLruCache.this;
        }

        void detach() {
            if (this.entry.currentEditor == this) {
                int n5 = 0;
                while (true) {
                    DiskLruCache diskLruCache = DiskLruCache.this;
                    if (n5 >= diskLruCache.valueCount) break;
                    try {
                        diskLruCache.fileSystem.delete(this.entry.dirtyFiles[n5]);
                    }
                    catch (IOException iOException) {}
                    ++n5;
                }
                this.entry.currentEditor = null;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Source newSource(int n5) {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                Throwable throwable2;
                block10: {
                    block8: {
                        block9: {
                            Entry entry;
                            try {
                                if (editor.done) break block8;
                                entry = this.entry;
                                if (!entry.readable || entry.currentEditor != this) break block9;
                            }
                            catch (Throwable throwable2) {}
                            try {
                                return DiskLruCache.this.fileSystem.source(entry.cleanFiles[n5]);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                return null;
                            }
                            break block10;
                        }
                        return null;
                    }
                    throw new IllegalStateException();
                }
                throw throwable2;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Sink newSink(int n5) {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                Throwable throwable2;
                block12: {
                    block11: {
                        if (editor.done) break block11;
                        Entry entry = this.entry;
                        if (entry.currentEditor != this) {
                            return Okio.blackhole();
                        }
                        if (!entry.readable) {
                            this.written[n5] = true;
                        }
                        Object object = entry.dirtyFiles[n5];
                        object = DiskLruCache.this.fileSystem.sink((File)object);
                        return new FaultHidingSink((Sink)object){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void onException(IOException object) {
                                object = DiskLruCache.this;
                                synchronized (object) {
                                    Editor.this.detach();
                                    return;
                                }
                            }
                        };
                        {
                            catch (Throwable throwable2) {
                                break block12;
                            }
                        }
                        {
                            catch (FileNotFoundException fileNotFoundException) {
                                return Okio.blackhole();
                            }
                        }
                    }
                    throw new IllegalStateException();
                }
                throw throwable2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit() throws IOException {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                Throwable throwable2;
                block6: {
                    block4: {
                        block5: {
                            try {
                                if (editor.done) break block4;
                                if (this.entry.currentEditor != this) break block5;
                            }
                            catch (Throwable throwable2) {
                                break block6;
                            }
                            DiskLruCache.this.completeEdit(this, true);
                        }
                        this.done = true;
                        return;
                    }
                    throw new IllegalStateException();
                }
                throw throwable2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abort() throws IOException {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                Throwable throwable2;
                block6: {
                    block4: {
                        block5: {
                            try {
                                if (editor.done) break block4;
                                if (this.entry.currentEditor != this) break block5;
                            }
                            catch (Throwable throwable2) {
                                break block6;
                            }
                            DiskLruCache.this.completeEdit(this, false);
                        }
                        this.done = true;
                        return;
                    }
                    throw new IllegalStateException();
                }
                throw throwable2;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abortUnlessCommitted() {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                Throwable throwable2;
                block7: {
                    try {
                        if (editor.done || this.entry.currentEditor != this) break block7;
                    }
                    catch (Throwable throwable2) {}
                    try {
                        DiskLruCache.this.completeEdit(this, false);
                    }
                    catch (IOException iOException) {}
                }
                return;
                throw throwable2;
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final Source[] sources;
        private final long[] lengths;

        Snapshot(String string2, long l5, Source[] sourceArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l5;
            this.sources = sourceArray;
            this.lengths = lArray;
        }

        public String key() {
            return this.key;
        }

        @Nullable
        public Editor edit() throws IOException {
            Snapshot snapshot = string2;
            String string2 = snapshot.key;
            long l5 = snapshot.sequenceNumber;
            return ((Snapshot)((Object)string2)).DiskLruCache.this.edit(string2, l5);
        }

        public Source getSource(int n5) {
            return this.sources[n5];
        }

        public long getLength(int n5) {
            return this.lengths[n5];
        }

        @Override
        public void close() {
            Source[] sourceArray = sourceArray.sources;
            int n5 = sourceArray.sources.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                Util.closeQuietly(sourceArray[i5]);
            }
        }
    }
}

