/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview.decoder;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.dcloud.feature.nativeObj.photoview.subscaleview.SubsamplingScaleImageView;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageRegionDecoder;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public class SkiaPooledImageRegionDecoder
implements ImageRegionDecoder {
    private static final String TAG = "SkiaPooledImageRegionDecoder";
    private static boolean debug = false;
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private DecoderPool decoderPool;
    private final ReadWriteLock decoderLock;
    private final Bitmap.Config bitmapConfig;
    private Context context;
    private Uri uri;
    private long fileLength;
    private final Point imageDimensions;
    private final AtomicBoolean lazyInited;

    @Keep
    public SkiaPooledImageRegionDecoder() {
        this(null);
    }

    public SkiaPooledImageRegionDecoder(@Nullable Bitmap.Config config) {
        AtomicBoolean atomicBoolean;
        Point point;
        ReentrantReadWriteLock reentrantReadWriteLock;
        DecoderPool decoderPool;
        Object object = decoderPool;
        decoderPool = new DecoderPool();
        this.decoderPool = object;
        object = reentrantReadWriteLock;
        reentrantReadWriteLock = new ReentrantReadWriteLock(true);
        this.decoderLock = object;
        this.fileLength = Long.MAX_VALUE;
        object = point;
        point = new Point(0, 0);
        this.imageDimensions = object;
        object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.lazyInited = object;
        object = SubsamplingScaleImageView.getPreferredBitmapConfig();
        if (config != null) {
            this.bitmapConfig = config;
            return;
        }
        if (object != null) {
            this.bitmapConfig = object;
            return;
        }
        this.bitmapConfig = Bitmap.Config.RGB_565;
    }

    @Keep
    public static void setDebug(boolean bl) {
        debug = bl;
    }

    private void lazyInit() {
        if (this.lazyInited.compareAndSet(false, true) && this.fileLength < Long.MAX_VALUE) {
            this.debug("Starting lazy init of additional decoders");
            new Thread(){

                @Override
                public void run() {
                    while (SkiaPooledImageRegionDecoder.this.decoderPool != null) {
                        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = SkiaPooledImageRegionDecoder.this;
                        if (!skiaPooledImageRegionDecoder.allowAdditionalDecoder(skiaPooledImageRegionDecoder.decoderPool.size(), SkiaPooledImageRegionDecoder.this.fileLength)) break;
                        if (SkiaPooledImageRegionDecoder.this.decoderPool == null) continue;
                        1 v12 = this;
                        1 v22 = v12;
                        1 v32 = v12;
                        1 v42 = v12;
                        long l5 = System.currentTimeMillis();
                        v32.SkiaPooledImageRegionDecoder.this.debug("Starting decoder");
                        v42.SkiaPooledImageRegionDecoder.this.initialiseDecoder();
                        long l6 = System.currentTimeMillis();
                        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = v22.SkiaPooledImageRegionDecoder.this;
                        StringBuilder stringBuilder = new StringBuilder().append("Started decoder, took ");
                        try {
                            skiaPooledImageRegionDecoder2.debug(stringBuilder.append(l6 - l5).append("ms").toString());
                        }
                        catch (Exception exception) {
                            SkiaPooledImageRegionDecoder.this.debug("Failed to start decoder: " + exception.getMessage());
                        }
                    }
                }
            }.start();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialiseDecoder() throws Exception {
        block30: {
            block32: {
                block31: {
                    block29: {
                        block34: {
                            block33: {
                                var1_2 = this.uri.toString();
                                var2_3 = 0x7FFFFFFFFFFFFFFFL;
                                if (!var1_2.startsWith("android.resource://")) break block33;
                                v0 = this;
                                var1_2 = v0.uri.getAuthority();
                                var4_6 = v0.context.getPackageName().equals(var1_2) != false ? this.context.getResources() : this.context.getPackageManager().getResourcesForApplication((String)var1_2);
                                var5_8 = 0;
                                var6_11 = this.uri.getPathSegments();
                                var7_12 = var6_11.size();
                                if (var7_12 == 2 && ((String)var6_11.get(0)).equals("drawable")) {
                                    var5_8 = var4_6.getIdentifier((String)var6_11.get(1), "drawable", (String)var1_2);
                                } else if (var7_12 == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)var6_11.get(0)))) {
                                    try {
                                        var5_8 = Integer.parseInt((String)var6_11.get(0));
                                    }
                                    catch (NumberFormatException v1) {}
                                }
                                try {
                                    var2_3 = this.context.getResources().openRawResourceFd(var5_8).getLength();
                                }
                                catch (Exception v2) {}
                                var1_2 = BitmapRegionDecoder.newInstance((InputStream)this.context.getResources().openRawResource(var5_8), (boolean)false);
                                break block29;
                            }
                            if (!var1_2.startsWith("file:///android_asset/")) break block34;
                            var1_2 = var1_2.substring(22);
                            try {
                                var2_3 = this.context.getAssets().openFd((String)var1_2).getLength();
                            }
                            catch (Exception v3) {}
                            var1_2 = BitmapRegionDecoder.newInstance((InputStream)this.context.getAssets().open((String)var1_2, 1), (boolean)false);
                            break block29;
                        }
                        if (var1_2.startsWith("file://")) {
                            var4_7 = BitmapRegionDecoder.newInstance((String)var1_2.substring(7), (boolean)false);
                            var5_9 = v4;
                            try {
                                if (new File((String)var1_2).exists()) {
                                    var2_3 = var5_9.length();
                                }
                            }
                            catch (Exception v5) {}
lbl42:
                            // 4 sources

                            while (true) {
                                var1_2 = var4_7;
                                break block29;
                                break;
                            }
                        }
                        var1_2 = null;
                        try {
                            v6 = this.context.getContentResolver();
                        }
                        catch (Throwable var0_1) {
                            break block30;
                        }
                        {
                            v7 = this;
                            var1_2 = v6.openInputStream(this.uri);
                        }
                        {
                            var4_7 = BitmapRegionDecoder.newInstance((InputStream)var1_2, (boolean)false);
                            try {
                                var5_10 = v6.openAssetFileDescriptor(v7.uri, "r");
                                if (var5_10 != null) {
                                    var2_3 = var5_10.getLength();
                                }
                            }
                            catch (Exception v8) {}
                        }
                        if (var1_2 == null) ** GOTO lbl42
                        {
                            var1_2.close();
                            ** continue;
                        }
                    }
                    v9 = this;
                    v9.fileLength = var2_3;
                    v10 = var1_2;
                    var2_4 = v10.getWidth();
                    v9.imageDimensions.set(var2_4, v10.getHeight());
                    v9.decoderLock.writeLock().lock();
                    try {
                        var2_5 = v9.decoderPool;
                        if (var2_5 == null) break block31;
                    }
                    catch (Throwable v11) {
                        break block32;
                    }
                    {
                        DecoderPool.access$600(var2_5, (BitmapRegionDecoder)var1_2);
                    }
                }
                this.decoderLock.writeLock().unlock();
                return;
            }
            this.decoderLock.writeLock().unlock();
            throw v11;
        }
        if (var1_2 == null) throw var0_1;
        try {
            var1_2.close();
            throw var0_1;
        }
        catch (Exception v12) {}
        throw var0_1;
    }

    private int getNumberOfCores() {
        if (Build.VERSION.SDK_INT >= 17) {
            return Runtime.getRuntime().availableProcessors();
        }
        return this.getNumCoresOldPhones();
    }

    private int getNumCoresOldPhones() {
        try {
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]+", file.getName());
                }
            }
            return new File("/sys/devices/system/cpu/").listFiles(new CpuFilter()).length;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private boolean isLowMemory() {
        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = (ActivityManager)skiaPooledImageRegionDecoder.context.getSystemService("activity");
        if (skiaPooledImageRegionDecoder != null) {
            ActivityManager.MemoryInfo memoryInfo;
            SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = skiaPooledImageRegionDecoder;
            skiaPooledImageRegionDecoder = memoryInfo;
            skiaPooledImageRegionDecoder2.getMemoryInfo(new ActivityManager.MemoryInfo());
            return ((ActivityManager.MemoryInfo)skiaPooledImageRegionDecoder).lowMemory;
        }
        return true;
    }

    private void debug(String string2) {
        if (debug) {
            Log.d((String)TAG, (String)string2);
            return;
        }
    }

    @Override
    @NonNull
    public Point init(Context context, @NonNull Uri uri) throws Exception {
        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
        this.context = context;
        skiaPooledImageRegionDecoder.uri = uri;
        skiaPooledImageRegionDecoder.initialiseDecoder();
        return skiaPooledImageRegionDecoder.imageDimensions;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public Bitmap decodeRegion(@NonNull Rect rect, int n5) {
        Throwable throwable2;
        block14: {
            block11: {
                DecoderPool decoderPool;
                block12: {
                    block13: {
                        BitmapFactory.Options options;
                        this.debug("Decode region " + rect + " on thread " + Thread.currentThread().getName());
                        if (rect.width() < this.imageDimensions.x || rect.height() < this.imageDimensions.y) {
                            this.lazyInit();
                        }
                        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
                        skiaPooledImageRegionDecoder.decoderLock.readLock().lock();
                        decoderPool = skiaPooledImageRegionDecoder.decoderPool;
                        if (decoderPool == null) break block11;
                        if ((decoderPool = decoderPool.acquire()) == null) break block12;
                        {
                            catch (Throwable throwable2) {}
                        }
                        if (decoderPool.isRecycled()) break block12;
                        DecoderPool decoderPool2 = decoderPool;
                        Rect rect2 = rect;
                        rect = options;
                        rect();
                        rect.inSampleSize = n5;
                        options.inPreferredConfig = this.bitmapConfig;
                        rect = decoderPool2.decodeRegion(rect2, (BitmapFactory.Options)rect);
                        if (rect == null) break block13;
                        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = this;
                        skiaPooledImageRegionDecoder2.decoderPool.release((BitmapRegionDecoder)decoderPool);
                        skiaPooledImageRegionDecoder2.decoderLock.readLock().unlock();
                        return rect;
                    }
                    try {
                        throw new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
                    }
                    catch (Throwable throwable3) {
                        this.decoderPool.release((BitmapRegionDecoder)decoderPool);
                        throw throwable3;
                    }
                    break block14;
                }
                if (decoderPool != null) {
                    this.decoderPool.release((BitmapRegionDecoder)decoderPool);
                }
            }
            throw new IllegalStateException("Cannot decode region after decoder has been recycled");
        }
        this.decoderLock.readLock().unlock();
        throw throwable2;
    }

    @Override
    public synchronized boolean isReady() {
        DecoderPool decoderPool = ((SkiaPooledImageRegionDecoder)((Object)decoderPool)).decoderPool;
        return decoderPool != null && !decoderPool.isEmpty();
    }

    @Override
    public synchronized void recycle() {
        Throwable throwable2;
        block4: {
            block3: {
                DecoderPool decoderPool;
                SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
                skiaPooledImageRegionDecoder.decoderLock.writeLock().lock();
                try {
                    decoderPool = skiaPooledImageRegionDecoder.decoderPool;
                    if (decoderPool == null) break block3;
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = this;
                decoderPool.recycle();
                skiaPooledImageRegionDecoder2.decoderPool = null;
                skiaPooledImageRegionDecoder2.context = null;
                skiaPooledImageRegionDecoder2.uri = null;
            }
            this.decoderLock.writeLock().unlock();
            return;
        }
        this.decoderLock.writeLock().unlock();
        throw throwable2;
    }

    protected boolean allowAdditionalDecoder(int n5, long l5) {
        if (n5 >= 4) {
            this.debug("No additional decoders allowed, reached hard limit (4)");
            return false;
        }
        if ((l5 = (long)n5 * l5) > 0x1400000L) {
            this.debug("No additional encoders allowed, reached hard memory limit (20Mb)");
            return false;
        }
        if (n5 >= this.getNumberOfCores()) {
            this.debug("No additional encoders allowed, limited by CPU cores (" + this.getNumberOfCores() + ")");
            return false;
        }
        if (this.isLowMemory()) {
            this.debug("No additional encoders allowed, memory is low");
            return false;
        }
        this.debug("Additional decoder allowed, current count is " + n5 + ", estimated native memory " + l5 / 0x100000L + "Mb");
        return true;
    }

    private static class DecoderPool {
        private final Semaphore available;
        private final Map<BitmapRegionDecoder, Boolean> decoders;

        private DecoderPool() {
            ConcurrentHashMap concurrentHashMap;
            Semaphore semaphore;
            Object object = semaphore;
            semaphore = new Semaphore(0, true);
            v1.available = object;
            object = concurrentHashMap;
            concurrentHashMap = new ConcurrentHashMap();
            v1.decoders = object;
        }

        private synchronized boolean isEmpty() {
            return this.decoders.isEmpty();
        }

        private synchronized int size() {
            return this.decoders.size();
        }

        private BitmapRegionDecoder acquire() {
            DecoderPool decoderPool = this;
            decoderPool.available.acquireUninterruptibly();
            return decoderPool.getNextAvailable();
        }

        private void release(BitmapRegionDecoder bitmapRegionDecoder) {
            if (this.markAsUnused(bitmapRegionDecoder)) {
                this.available.release();
                return;
            }
        }

        private synchronized void add(BitmapRegionDecoder bitmapRegionDecoder) {
            DecoderPool decoderPool = this;
            decoderPool.decoders.put(bitmapRegionDecoder, Boolean.FALSE);
            decoderPool.available.release();
        }

        private synchronized void recycle() {
            while (!this.decoders.isEmpty()) {
                DecoderPool decoderPool = this;
                BitmapRegionDecoder bitmapRegionDecoder = decoderPool.acquire();
                bitmapRegionDecoder.recycle();
                decoderPool.decoders.remove(bitmapRegionDecoder);
            }
        }

        private synchronized BitmapRegionDecoder getNextAvailable() {
            for (Map.Entry entry : ((DecoderPool)this).decoders.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                Map.Entry entry2 = entry;
                entry2.setValue(Boolean.TRUE);
                return (BitmapRegionDecoder)entry2.getKey();
            }
            return null;
        }

        private synchronized boolean markAsUnused(BitmapRegionDecoder bitmapRegionDecoder) {
            for (Map.Entry entry : ((DecoderPool)this).decoders.entrySet()) {
                if (bitmapRegionDecoder != entry.getKey()) continue;
                if (((Boolean)entry.getValue()).booleanValue()) {
                    entry.setValue(Boolean.FALSE);
                    return true;
                }
                return false;
            }
            return false;
        }

        static /* synthetic */ void access$600(DecoderPool decoderPool, BitmapRegionDecoder bitmapRegionDecoder) {
            decoderPool.add(bitmapRegionDecoder);
        }
    }
}

