/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.node;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.ui.component.richtext.node.ANode;
import com.taobao.weex.ui.component.richtext.node.ImgNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeCreator;
import com.taobao.weex.ui.component.richtext.node.SpanNode;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;

public class RichTextNodeManager {
    private static final Map<String, RichTextNodeCreator> registeredTextNodes;

    public static void registerTextNode(String string2, RichTextNodeCreator richTextNodeCreator) {
        registeredTextNodes.put(string2, richTextNodeCreator);
    }

    @Nullable
    static RichTextNode createRichTextNode(@NonNull Context context, @NonNull String string2, @NonNull String string3, @Nullable JSONObject jSONObject) {
        RichTextNode richTextNode = null;
        if (jSONObject != null) {
            try {
                Object t = registeredTextNodes.get(jSONObject.getString("type")).createRichTextNode(context, string2, string3);
                ((RichTextNode)t).parse(context, string2, string3, jSONObject);
                return t;
            }
            catch (Exception exception) {
                WXLogUtils.e("Richtext", WXLogUtils.getStackTrace(exception));
                return null;
            }
        }
        return richTextNode;
    }

    public static RichTextNode createRichTextNode(Context context, String string2, String string3, String string4, String string5, Map<String, String> map, Map<String, String> map2) {
        try {
            return registeredTextNodes.get(string5).createRichTextNode(context, string2, string3, string4, map, map2);
        }
        catch (Exception exception) {
            WXLogUtils.e("Richtext", WXLogUtils.getStackTrace(exception));
            return null;
        }
    }

    static {
        ANode.ANodeCreator aNodeCreator;
        ImgNode.ImgNodeCreator imgNodeCreator;
        SpanNode.SpanNodeCreator spanNodeCreator;
        registeredTextNodes = new ArrayMap();
        RichTextNodeCreator<SpanNode> richTextNodeCreator = spanNodeCreator;
        spanNodeCreator = new SpanNode.SpanNodeCreator();
        registeredTextNodes.put("span", richTextNodeCreator);
        richTextNodeCreator = imgNodeCreator;
        imgNodeCreator = new ImgNode.ImgNodeCreator();
        registeredTextNodes.put("image", richTextNodeCreator);
        richTextNodeCreator = aNodeCreator;
        aNodeCreator = new ANode.ANodeCreator();
        registeredTextNodes.put("a", richTextNodeCreator);
    }
}

