/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.taobao.weex.bridge.WXJSObject;
import com.taobao.weex.utils.WXJsonUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.wson.Wson;
import com.taobao.weex.wson.WsonUtils;

public class WXWsonJSONSwitch {
    private static final String TAG = "WXSwitch";
    public static boolean USE_WSON = true;
    public static final String WSON_OFF = "wson_off";

    public static final byte[] convertJSONToWsonIfUseWson(byte[] byArray) {
        String string2;
        if (!USE_WSON) {
            return byArray;
        }
        if (byArray == null) {
            return null;
        }
        String string3 = string2;
        if (new String(byArray).startsWith("[")) {
            return WsonUtils.toWson(JSON.parseArray((String)string3));
        }
        return WsonUtils.toWson(JSON.parse((String)string3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object parseWsonOrJSON(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            if (!USE_WSON) return JSON.parse((String)new String(byArray, "UTF-8"));
            return Wson.parse(byArray);
        }
        catch (Exception exception) {}
        WXLogUtils.e(TAG, exception);
        if (!USE_WSON) return Wson.parse(byArray);
        return JSON.parse((String)new String(byArray));
    }

    public static final WXJSObject toWsonOrJsonWXJSObject(Object object) {
        if (object == null) {
            return new WXJSObject(null);
        }
        if (object.getClass() == WXJSObject.class) {
            return (WXJSObject)object;
        }
        if (USE_WSON) {
            return new WXJSObject(4, Wson.toWson(object));
        }
        return new WXJSObject(3, WXJsonUtils.fromObjectToJSONString(object));
    }

    public static final Object convertWXJSObjectDataToJSON(WXJSObject wXJSObject) {
        if (wXJSObject.type == 4) {
            return JSON.parse((String)Wson.parse((byte[])wXJSObject.data).toString());
        }
        return JSON.parse((String)wXJSObject.data.toString());
    }

    @NonNull
    public static String fromObjectToJSONString(WXJSObject wXJSObject) {
        Object object;
        if (wXJSObject != null && wXJSObject.type == 4 && (object = Wson.parse((byte[])wXJSObject.data)) != null) {
            return object.toString();
        }
        return WXJsonUtils.fromObjectToJSONString(wXJSObject, false);
    }
}

