/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_scroller.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DCWXHorizontalScrollView
extends HorizontalScrollView
implements IWXScroller,
WXGestureObservable {
    private WXGesture wxGesture;
    private ScrollViewListener mScrollViewListener;
    private List<ScrollViewListener> mScrollViewListeners;
    private boolean scrollable;
    private Field scroller;
    private boolean isTouch;
    int mScrollX;
    int mScrollY;
    private boolean shouldBeTriggerUpper;
    private boolean shouldBeTriggerLower;
    private float upper;
    private float lowwer;

    public DCWXHorizontalScrollView(Context context) {
        DCWXHorizontalScrollView dCWXHorizontalScrollView = this;
        super(context);
        dCWXHorizontalScrollView.scrollable = true;
        dCWXHorizontalScrollView.scroller = null;
        dCWXHorizontalScrollView.isTouch = false;
        dCWXHorizontalScrollView.shouldBeTriggerUpper = true;
        dCWXHorizontalScrollView.shouldBeTriggerLower = true;
        dCWXHorizontalScrollView.upper = 50.0f;
        dCWXHorizontalScrollView.lowwer = 50.0f;
        dCWXHorizontalScrollView.init();
    }

    private void init() {
        Field field;
        DCWXHorizontalScrollView dCWXHorizontalScrollView = this;
        dCWXHorizontalScrollView.setWillNotDraw(false);
        dCWXHorizontalScrollView.setOverScrollMode(2);
        try {
            field = HorizontalScrollView.class.getDeclaredField("mScroller");
        }
        catch (Exception exception) {
            return;
        }
        this.scroller = field;
        ((AccessibleObject)field).setAccessible(true);
    }

    public DCWXHorizontalScrollView(Context context, AttributeSet attributeSet) {
        DCWXHorizontalScrollView dCWXHorizontalScrollView = this;
        super(context, attributeSet);
        dCWXHorizontalScrollView.scrollable = true;
        dCWXHorizontalScrollView.scroller = null;
        dCWXHorizontalScrollView.isTouch = false;
        dCWXHorizontalScrollView.shouldBeTriggerUpper = true;
        dCWXHorizontalScrollView.shouldBeTriggerLower = true;
        dCWXHorizontalScrollView.upper = 50.0f;
        dCWXHorizontalScrollView.lowwer = 50.0f;
        dCWXHorizontalScrollView.init();
    }

    private void scrollToTop() {
        ScrollViewListener scrollViewListener = ((DCWXHorizontalScrollView)((Object)iterator)).mScrollViewListener;
        if (scrollViewListener != null) {
            scrollViewListener.onScrolltoTop();
        }
        if ((iterator = ((DCWXHorizontalScrollView)((Object)iterator)).mScrollViewListeners) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((ScrollViewListener)iterator.next()).onScrolltoTop();
            }
        }
    }

    private void scrollToBottom() {
        ScrollViewListener scrollViewListener = ((DCWXHorizontalScrollView)((Object)iterator)).mScrollViewListener;
        if (scrollViewListener != null) {
            scrollViewListener.onScrollToBottom();
        }
        if ((iterator = ((DCWXHorizontalScrollView)((Object)iterator)).mScrollViewListeners) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((ScrollViewListener)iterator.next()).onScrollToBottom();
            }
        }
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        super.onScrollChanged(n, n2, n3, n4);
        AppEventForBlurManager.onScrollChanged((int)n, (int)n2);
        this.mScrollX = this.getScrollX();
        this.mScrollY = this.getScrollY();
        if ((float)this.getScrollX() <= this.upper && !this.shouldBeTriggerUpper) {
            this.scrollToTop();
            this.shouldBeTriggerUpper = true;
        } else if ((float)this.getScrollX() > this.upper) {
            this.shouldBeTriggerUpper = false;
        }
        View view = this.getChildAt(this.getChildCount() - 1);
        if (view != null) {
            Object object;
            float f;
            float f2;
            float f3 = view.getRight() - (this.getWidth() + this.mScrollX);
            float f4 = this.lowwer;
            if (f2 <= f && !this.shouldBeTriggerLower) {
                this.scrollToBottom();
                this.shouldBeTriggerLower = true;
            } else if (f3 > f4) {
                this.shouldBeTriggerLower = false;
            }
            ScrollViewListener scrollViewListener = this.mScrollViewListener;
            if (scrollViewListener != null) {
                int n5 = n3 - n;
                int n6 = n4 - n2;
                scrollViewListener.onScrollChanged(this, n, n2, n5, n6);
            }
            if ((object = this.mScrollViewListeners) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    int n7 = n3 - n;
                    int n8 = n4 - n2;
                    ((ScrollViewListener)object.next()).onScrollChanged(this, n, n2, n7, n8);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopScroll() {
        AccessibleObject accessibleObject = this.scroller;
        if (accessibleObject == null || this.isTouch) return;
        try {
            accessibleObject = ((Field)accessibleObject).getType().getMethod("abortAnimation", null);
            if (accessibleObject == null) return;
        }
        catch (Exception exception) {}
        ((Method)accessibleObject).setAccessible(true);
        ((Method)accessibleObject).invoke(this.scroller.get(this), null);
        return;
    }

    public void setUpperLength(float f) {
        this.upper = f;
    }

    public void setLowwerLength(float f) {
        this.lowwer = f;
    }

    public void setScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListener = scrollViewListener;
    }

    @Override
    public void destroy() {
        List<ScrollViewListener> list = ((DCWXHorizontalScrollView)((Object)list)).mScrollViewListeners;
        if (list != null) {
            list.clear();
            return;
        }
    }

    public void addScrollViewListener(ScrollViewListener scrollViewListener) {
        if (this.mScrollViewListeners == null) {
            ArrayList<ScrollViewListener> arrayList;
            ArrayList<ScrollViewListener> arrayList2 = arrayList;
            arrayList = new ArrayList<ScrollViewListener>();
            this.mScrollViewListeners = arrayList2;
        }
        if (!this.mScrollViewListeners.contains(scrollViewListener)) {
            this.mScrollViewListeners.add(scrollViewListener);
            return;
        }
    }

    public void removeScrollViewListener(ScrollViewListener scrollViewListener) {
        this.mScrollViewListeners.remove(scrollViewListener);
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        DCWXHorizontalScrollView dCWXHorizontalScrollView = this;
        boolean bl = super.dispatchTouchEvent(motionEvent);
        WXGesture wXGesture = dCWXHorizontalScrollView.wxGesture;
        if (wXGesture != null) {
            return bl | wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n != 0) {
            if (n != 1) {
                if (n == 3) {
                    this.isTouch = false;
                }
            } else {
                this.isTouch = false;
            }
        } else {
            this.isTouch = true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public Rect getContentFrame() {
        DCWXHorizontalScrollView dCWXHorizontalScrollView = this;
        int n = dCWXHorizontalScrollView.computeHorizontalScrollRange();
        int n2 = dCWXHorizontalScrollView.computeVerticalScrollRange();
        return new Rect(0, 0, n, n2);
    }

    public void setWAScroller(DCWXScroller dCWXScroller) {
        this.upper = WXViewUtils.getRealPxByWidth(50.0f, dCWXScroller.getViewPortWidth());
        this.lowwer = WXViewUtils.getRealPxByWidth(50.0f, dCWXScroller.getViewPortWidth());
    }

    public static interface ScrollViewListener {
        public void onScrollChanged(DCWXHorizontalScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrolltoTop();

        public void onScrollToBottom();
    }
}

