/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.uts;

import io.dcloud.uts.Math;
import io.dcloud.uts.NumberKt;
import io.dcloud.uts.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0001J\u0010\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00182\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00182\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006#"}, d2={"Lio/dcloud/uts/UTSNumber;", "", "()V", "EPSILON", "", "getEPSILON", "()Ljava/lang/Number;", "MAX_SAFE_INTEGER", "getMAX_SAFE_INTEGER", "MAX_VALUE", "getMAX_VALUE", "MIN_SAFE_INTEGER", "getMIN_SAFE_INTEGER", "MIN_VALUE", "getMIN_VALUE", "NEGATIVE_INFINITY", "getNEGATIVE_INFINITY", "NaN", "getNaN", "POSITIVE_INFINITY", "getPOSITIVE_INFINITY", "from", "inputNum", "str", "", "isFinite", "", "number", "isInteger", "isNaN", "isSafeInteger", "parseFloat", "string", "radix", "parseInt", "utsplugin_release"})
public final class UTSNumber {
    @NotNull
    public static final UTSNumber INSTANCE = new UTSNumber();
    @NotNull
    private static final Number MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFFL;
    @NotNull
    private static final Number MIN_SAFE_INTEGER = -9007199254740991L;
    @NotNull
    private static final Number EPSILON = 2.220446049250313E-16;
    @NotNull
    private static final Number MAX_VALUE = Double.MAX_VALUE;
    @NotNull
    private static final Number MIN_VALUE = Double.MIN_VALUE;
    @NotNull
    private static final Number NaN = Double.NaN;
    @NotNull
    private static final Number NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
    @NotNull
    private static final Number POSITIVE_INFINITY = Double.POSITIVE_INFINITY;

    private UTSNumber() {
    }

    @NotNull
    public final Number getMAX_SAFE_INTEGER() {
        return MAX_SAFE_INTEGER;
    }

    @NotNull
    public final Number getMIN_SAFE_INTEGER() {
        return MIN_SAFE_INTEGER;
    }

    @NotNull
    public final Number getEPSILON() {
        return EPSILON;
    }

    @NotNull
    public final Number getMAX_VALUE() {
        return MAX_VALUE;
    }

    @NotNull
    public final Number getMIN_VALUE() {
        return MIN_VALUE;
    }

    @NotNull
    public final Number getNaN() {
        return NaN;
    }

    @NotNull
    public final Number getNEGATIVE_INFINITY() {
        return NEGATIVE_INFINITY;
    }

    @NotNull
    public final Number getPOSITIVE_INFINITY() {
        return POSITIVE_INFINITY;
    }

    @NotNull
    public final Number from(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Number strNumber = 0;
        if (StringKt.includes$default(str, ".", null, 2, null) || StringKt.includes$default(str, "e", null, 2, null) || StringKt.includes$default(str, "E", null, 2, null)) {
            strNumber = Double.parseDouble(str);
        } else {
            try {
                strNumber = Integer.parseInt(str);
            }
            catch (Exception intE) {
                try {
                    strNumber = Long.parseLong(str);
                }
                catch (NumberFormatException longE) {
                    try {
                        strNumber = Double.parseDouble(str);
                    }
                    catch (Exception e) {
                        strNumber = Double.NaN;
                    }
                }
            }
        }
        return strNumber;
    }

    @NotNull
    public final Number from(@NotNull Number inputNum) {
        Intrinsics.checkNotNullParameter((Object)inputNum, (String)"inputNum");
        return inputNum;
    }

    public final boolean isNaN(@Nullable Object number) {
        if (!(number instanceof Number)) {
            return false;
        }
        Number number2 = (Number)number;
        return number2 instanceof Double ? Double.isNaN(((Number)number).doubleValue()) : (number2 instanceof Float ? Float.isNaN(((Number)number).floatValue()) : false);
    }

    public final boolean isFinite(@Nullable Object number) {
        float f;
        double d;
        if (!(number instanceof Number)) {
            return false;
        }
        Number number2 = (Number)number;
        boolean bl = number2 instanceof Double ? !Double.isInfinite(d = ((Number)number).doubleValue()) && !Double.isNaN(d) : (number2 instanceof Float ? !Float.isInfinite(f = ((Number)number).floatValue()) && !Float.isNaN(f) : true);
        return bl;
    }

    public final boolean isInteger(@NotNull Object inputNum) {
        Intrinsics.checkNotNullParameter((Object)inputNum, (String)"inputNum");
        if (!(inputNum instanceof Number)) {
            return false;
        }
        if (!this.isFinite(inputNum)) {
            return false;
        }
        if (inputNum instanceof Integer || inputNum instanceof Long || inputNum instanceof Short || inputNum instanceof Byte) {
            return true;
        }
        return Intrinsics.areEqual((Object)NumberKt.times(Math.floor((Number)inputNum), 1.0), (Object)inputNum);
    }

    public final boolean isSafeInteger(@Nullable Object number) {
        if (!(number instanceof Number)) {
            return false;
        }
        return NumberKt.compareTo((Number)number, MAX_SAFE_INTEGER) <= 0 && NumberKt.compareTo((Number)number, MIN_SAFE_INTEGER) >= 0;
    }

    @NotNull
    public final Number parseInt(@NotNull String string2, @Nullable Number radix) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        return NumberKt.parseInt(string2, radix);
    }

    public static /* synthetic */ Number parseInt$default(UTSNumber uTSNumber, String string2, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            number = 0;
        }
        return uTSNumber.parseInt(string2, number);
    }

    @NotNull
    public final Number parseFloat(@NotNull String string2, @Nullable Number radix) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        return NumberKt.parseFloat(string2);
    }

    public static /* synthetic */ Number parseFloat$default(UTSNumber uTSNumber, String string2, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            number = 0;
        }
        return uTSNumber.parseFloat(string2, number);
    }
}

