/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.weex.weex_video.ijkplayer.media;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.dcloud.android.annotation.NonNull;
import com.dcloud.android.annotation.Nullable;
import io.dcloud.media.weex.weex_video.ijkplayer.media.IRenderView;
import io.dcloud.media.weex.weex_video.ijkplayer.media.MeasureHelper;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.ISurfaceTextureHolder;
import tv.danmaku.ijk.media.player.ISurfaceTextureHost;

@TargetApi(value=14)
public class TextureRenderView
extends TextureView
implements IRenderView {
    private static final String TAG = "TextureRenderView";
    private MeasureHelper mMeasureHelper;
    private SurfaceCallback mSurfaceCallback;

    public TextureRenderView(Context context) {
        super(context);
        this.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TextureRenderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @TargetApi(value=21)
    public TextureRenderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mMeasureHelper = new MeasureHelper((View)this);
        this.mSurfaceCallback = new SurfaceCallback(this);
        this.setSurfaceTextureListener(this.mSurfaceCallback);
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public boolean shouldWaitForResize() {
        return false;
    }

    protected void onDetachedFromWindow() {
        this.mSurfaceCallback.willDetachFromWindow();
        super.onDetachedFromWindow();
        this.mSurfaceCallback.didDetachFromWindow();
    }

    @Override
    public void setVideoSize(int videoWidth, int videoHeight) {
        if (videoWidth > 0 && videoHeight > 0) {
            this.mMeasureHelper.setVideoSize(videoWidth, videoHeight);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoSampleAspectRatio(int videoSarNum, int videoSarDen) {
        if (videoSarNum > 0 && videoSarDen > 0) {
            this.mMeasureHelper.setVideoSampleAspectRatio(videoSarNum, videoSarDen);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int degree) {
        this.mMeasureHelper.setVideoRotation(degree);
        this.setRotation(degree);
    }

    @Override
    public void setAspectRatio(int aspectRatio) {
        this.mMeasureHelper.setAspectRatio(aspectRatio);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mMeasureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mMeasureHelper.getMeasuredWidth(), this.mMeasureHelper.getMeasuredHeight());
    }

    public IRenderView.ISurfaceHolder getSurfaceHolder() {
        return new InternalSurfaceHolder(this, this.mSurfaceCallback.mSurfaceTexture, this.mSurfaceCallback);
    }

    @Override
    public void addRenderCallback(IRenderView.IRenderCallback callback) {
        this.mSurfaceCallback.addRenderCallback(callback);
    }

    @Override
    public void removeRenderCallback(IRenderView.IRenderCallback callback) {
        this.mSurfaceCallback.removeRenderCallback(callback);
    }

    @Override
    public Matrix getTransform() {
        return this.getTransform(null);
    }

    @Override
    public Bitmap getVideoScreenshot() {
        return this.getBitmap();
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)TextureRenderView.class.getName());
    }

    private static final class SurfaceCallback
    implements TextureView.SurfaceTextureListener,
    ISurfaceTextureHost {
        private SurfaceTexture mSurfaceTexture;
        private boolean mIsFormatChanged;
        private int mWidth;
        private int mHeight;
        private boolean mOwnSurfaceTexture = true;
        private boolean mWillDetachFromWindow = false;
        private boolean mDidDetachFromWindow = false;
        private WeakReference<TextureRenderView> mWeakRenderView;
        private Map<IRenderView.IRenderCallback, Object> mRenderCallbackMap = new ConcurrentHashMap<IRenderView.IRenderCallback, Object>();

        public SurfaceCallback(@NonNull TextureRenderView renderView) {
            this.mWeakRenderView = new WeakReference<TextureRenderView>(renderView);
        }

        public void setOwnSurfaceTexture(boolean ownSurfaceTexture) {
            this.mOwnSurfaceTexture = ownSurfaceTexture;
        }

        public void addRenderCallback(@NonNull IRenderView.IRenderCallback callback) {
            this.mRenderCallbackMap.put(callback, callback);
            InternalSurfaceHolder surfaceHolder = null;
            if (this.mSurfaceTexture != null && !this.mSurfaceTexture.isReleased()) {
                surfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), this.mSurfaceTexture, this);
                callback.onSurfaceCreated(surfaceHolder, this.mWidth, this.mHeight);
            }
            if (this.mIsFormatChanged) {
                if (surfaceHolder == null) {
                    surfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), this.mSurfaceTexture, this);
                }
                callback.onSurfaceChanged(surfaceHolder, 0, this.mWidth, this.mHeight);
            }
        }

        public void removeRenderCallback(@NonNull IRenderView.IRenderCallback callback) {
            this.mRenderCallbackMap.remove(callback);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            this.mSurfaceTexture = surface;
            this.mIsFormatChanged = false;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder surfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), surface, this);
            for (IRenderView.IRenderCallback renderCallback : this.mRenderCallbackMap.keySet()) {
                renderCallback.onSurfaceCreated(surfaceHolder, 0, 0);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            this.mSurfaceTexture = surface;
            this.mIsFormatChanged = true;
            this.mWidth = width;
            this.mHeight = height;
            InternalSurfaceHolder surfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), surface, this);
            for (IRenderView.IRenderCallback renderCallback : this.mRenderCallbackMap.keySet()) {
                renderCallback.onSurfaceChanged(surfaceHolder, 0, width, height);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            this.mSurfaceTexture = surface;
            this.mIsFormatChanged = false;
            this.mWidth = 0;
            this.mHeight = 0;
            InternalSurfaceHolder surfaceHolder = new InternalSurfaceHolder((TextureRenderView)this.mWeakRenderView.get(), surface, this);
            for (IRenderView.IRenderCallback renderCallback : this.mRenderCallbackMap.keySet()) {
                renderCallback.onSurfaceDestroyed(surfaceHolder);
            }
            Log.d((String)TextureRenderView.TAG, (String)("onSurfaceTextureDestroyed: onDestroy: " + this.mOwnSurfaceTexture));
            return this.mOwnSurfaceTexture;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }

        public void releaseSurfaceTexture(SurfaceTexture surfaceTexture) {
            if (surfaceTexture == null) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: null");
            } else if (this.mDidDetachFromWindow) {
                if (surfaceTexture != this.mSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.mOwnSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): release detached SurfaceTexture");
                    surfaceTexture.release();
                } else {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: didDetachFromWindow(): already released by TextureView");
                }
            } else if (this.mWillDetachFromWindow) {
                if (surfaceTexture != this.mSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): release different SurfaceTexture");
                    surfaceTexture.release();
                } else if (!this.mOwnSurfaceTexture) {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): re-attach SurfaceTexture to TextureView");
                    this.setOwnSurfaceTexture(true);
                } else {
                    Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: willDetachFromWindow(): will released by TextureView");
                }
            } else if (surfaceTexture != this.mSurfaceTexture) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: release different SurfaceTexture");
                surfaceTexture.release();
            } else if (!this.mOwnSurfaceTexture) {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: re-attach SurfaceTexture to TextureView");
                this.setOwnSurfaceTexture(true);
            } else {
                Log.d((String)TextureRenderView.TAG, (String)"releaseSurfaceTexture: alive: will released by TextureView");
            }
        }

        public void willDetachFromWindow() {
            Log.d((String)TextureRenderView.TAG, (String)"willDetachFromWindow()");
            this.mWillDetachFromWindow = true;
        }

        public void didDetachFromWindow() {
            Log.d((String)TextureRenderView.TAG, (String)"didDetachFromWindow()");
            this.mDidDetachFromWindow = true;
        }
    }

    private static final class InternalSurfaceHolder
    implements IRenderView.ISurfaceHolder {
        private TextureRenderView mTextureView;
        private SurfaceTexture mSurfaceTexture;
        private ISurfaceTextureHost mSurfaceTextureHost;

        public InternalSurfaceHolder(@NonNull TextureRenderView textureView, @Nullable SurfaceTexture surfaceTexture, @NonNull ISurfaceTextureHost surfaceTextureHost) {
            this.mTextureView = textureView;
            this.mSurfaceTexture = surfaceTexture;
            this.mSurfaceTextureHost = surfaceTextureHost;
        }

        @Override
        @TargetApi(value=16)
        public void bindToMediaPlayer(IMediaPlayer mp) {
            if (mp == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 16 && mp instanceof ISurfaceTextureHolder) {
                boolean isSurfaceTextureAllRight;
                ISurfaceTextureHolder textureHolder = (ISurfaceTextureHolder)mp;
                this.mTextureView.mSurfaceCallback.setOwnSurfaceTexture(false);
                SurfaceTexture surfaceTexture = textureHolder.getSurfaceTexture();
                if (Build.VERSION.SDK_INT >= 26) {
                    isSurfaceTextureAllRight = surfaceTexture != null && !surfaceTexture.isReleased();
                } else {
                    boolean bl = isSurfaceTextureAllRight = surfaceTexture != null;
                }
                if (isSurfaceTextureAllRight) {
                    this.mTextureView.setSurfaceTexture(surfaceTexture);
                } else {
                    textureHolder.setSurfaceTexture(this.mSurfaceTexture);
                    textureHolder.setSurfaceTextureHost((ISurfaceTextureHost)this.mTextureView.mSurfaceCallback);
                }
            } else {
                mp.setSurface(this.openSurface());
            }
        }

        @Override
        @NonNull
        public IRenderView getRenderView() {
            return this.mTextureView;
        }

        @Override
        @Nullable
        public SurfaceHolder getSurfaceHolder() {
            return null;
        }

        @Override
        @Nullable
        public SurfaceTexture getSurfaceTexture() {
            return this.mSurfaceTexture;
        }

        @Override
        @Nullable
        public Surface openSurface() {
            if (this.mSurfaceTexture == null) {
                return null;
            }
            return new Surface(this.mSurfaceTexture);
        }
    }
}

