/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.cache.memory;

import android.graphics.Bitmap;
import com.nostra13.dcloudimageloader.cache.memory.MemoryCacheAware;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class BaseMemoryCache
implements MemoryCacheAware {
    private final Map<String, Reference<Bitmap>> softMap = Collections.synchronizedMap(new HashMap());

    @Override
    public Bitmap get(String key) {
        Bitmap result = null;
        Reference<Bitmap> reference = this.softMap.get(key);
        if (reference != null) {
            result = reference.get();
        }
        return result;
    }

    @Override
    public boolean put(String key, Bitmap value) {
        this.softMap.put(key, this.createReference(value));
        return true;
    }

    @Override
    public Bitmap remove(String key) {
        Reference<Bitmap> bmpRef = this.softMap.remove(key);
        return bmpRef == null ? null : bmpRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        Map<String, Reference<Bitmap>> map = this.softMap;
        synchronized (map) {
            return new HashSet<String>(this.softMap.keySet());
        }
    }

    @Override
    public void clear() {
        this.softMap.clear();
    }

    protected abstract Reference<Bitmap> createReference(Bitmap var1);
}

