/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.nostra13.dcloudimageloader.core.assist.ViewScaleType;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import com.nostra13.dcloudimageloader.utils.L;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class ImageViewAware
implements ImageAware {
    protected Reference<ImageView> imageViewRef;
    protected boolean checkActualViewSize;

    public ImageViewAware(ImageView imageView) {
        this(imageView, true);
    }

    public ImageViewAware(ImageView imageView, boolean checkActualViewSize) {
        this.imageViewRef = new WeakReference<ImageView>(imageView);
        this.checkActualViewSize = checkActualViewSize;
    }

    @Override
    public int getWidth() {
        ImageView imageView = this.imageViewRef.get();
        if (imageView != null) {
            ViewGroup.LayoutParams params = imageView.getLayoutParams();
            int width = 0;
            if (this.checkActualViewSize && params != null && params.width != -2) {
                width = imageView.getWidth();
            }
            if (width <= 0 && params != null) {
                width = params.width;
            }
            if (width <= 0) {
                width = imageView.getMaxWidth();
            }
            L.w("width = " + width, new Object[0]);
            return width;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        ImageView imageView = this.imageViewRef.get();
        if (imageView != null) {
            ViewGroup.LayoutParams params = imageView.getLayoutParams();
            int height = 0;
            if (this.checkActualViewSize && params != null && params.height != -2) {
                height = imageView.getHeight();
            }
            if (height <= 0 && params != null) {
                height = params.height;
            }
            if (height <= 0) {
                height = imageView.getMaxHeight();
            }
            L.w("height = " + height, new Object[0]);
            return height;
        }
        return 0;
    }

    @Override
    public ViewScaleType getScaleType() {
        ImageView imageView = this.imageViewRef.get();
        return imageView != null ? ViewScaleType.fromImageView(imageView) : null;
    }

    public ImageView getWrappedView() {
        return this.imageViewRef.get();
    }

    @Override
    public boolean isCollected() {
        return this.imageViewRef.get() == null;
    }

    @Override
    public int getId() {
        ImageView imageView = this.imageViewRef.get();
        return imageView == null ? super.hashCode() : imageView.hashCode();
    }

    @Override
    public boolean setImageDrawable(Drawable drawable) {
        ImageView imageView = this.imageViewRef.get();
        if (imageView != null) {
            imageView.setImageDrawable(drawable);
            return true;
        }
        return false;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        ImageView imageView = this.imageViewRef.get();
        if (imageView != null) {
            imageView.setImageBitmap(bitmap);
            return true;
        }
        return false;
    }
}

