/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.core;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import androidx.annotation.Nullable;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewParentCompat;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.core.WXRefreshView;
import java.util.LinkedList;
import java.util.List;

public class WXSwipeLayout
extends FrameLayout
implements NestedScrollingParent,
NestedScrollingChild {
    private static final int INVALID = -1;
    private static final int PULL_REFRESH = 0;
    private static final int LOAD_MORE = 1;
    private static final float overFlow = 1.0f;
    private static final float DAMPING = 0.4f;
    private NestedScrollingParentHelper mNestedScrollingParentHelper;
    private NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed = new int[2];
    private final int[] mParentOffsetInWindow = new int[2];
    private boolean mNestedScrollInProgress;
    private WXOnRefreshListener onRefreshListener;
    private WXOnLoadingListener onLoadingListener;
    private ViewParent mNestedScrollAcceptedParent;
    private final List<OnRefreshOffsetChangedListener> mRefreshOffsetChangedListeners = new LinkedList<OnRefreshOffsetChangedListener>();
    private WXRefreshView headerView;
    private WXRefreshView footerView;
    private View mTargetView;
    private boolean mPullRefreshEnable = false;
    private boolean mPullLoadEnable = false;
    private volatile boolean mRefreshing = false;
    private volatile float refreshViewHeight = 0.0f;
    private volatile float loadingViewHeight = 0.0f;
    private volatile float refreshViewFlowHeight = 0.0f;
    private volatile float loadingViewFlowHeight = 0.0f;
    private int mCurrentAction = -1;
    private boolean isConfirm = false;
    private int mRefreshViewBgColor;
    private int mProgressBgColor;
    private int mProgressColor;

    public WXSwipeLayout(Context context) {
        super(context);
        this.initAttrs(context, null);
    }

    public WXSwipeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initAttrs(context, attributeSet);
    }

    public WXSwipeLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initAttrs(context, attributeSet);
    }

    @TargetApi(value=21)
    public WXSwipeLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initAttrs(context, attributeSet);
    }

    private void initAttrs(Context context, AttributeSet attributeSet) {
        if (this.getChildCount() <= 1) {
            WXSwipeLayout wXSwipeLayout = this;
            wXSwipeLayout.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
            wXSwipeLayout.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
            wXSwipeLayout.setNestedScrollingEnabled(false);
            if (wXSwipeLayout.isInEditMode() && attributeSet == null) {
                return;
            }
            WXSwipeLayout wXSwipeLayout2 = this;
            wXSwipeLayout2.mRefreshViewBgColor = 0;
            wXSwipeLayout2.mProgressBgColor = 0;
            wXSwipeLayout2.mProgressColor = -65536;
            return;
        }
        throw new RuntimeException("WXSwipeLayout should not have more than one child");
    }

    private void setRefreshView() {
        WXRefreshView wXRefreshView;
        FrameLayout.LayoutParams layoutParams;
        WXRefreshView wXRefreshView2;
        WXRefreshView wXRefreshView3;
        FrameLayout.LayoutParams layoutParams2;
        FrameLayout.LayoutParams layoutParams3 = layoutParams2;
        layoutParams2 = new FrameLayout.LayoutParams(-1, 0);
        this.headerView = wXRefreshView3 = wXRefreshView2;
        new WXRefreshView(this.getContext()).setStartEndTrim(0.0f, 0.75f);
        this.headerView.setBackgroundColor(this.mRefreshViewBgColor);
        this.headerView.setProgressBgColor(this.mProgressBgColor);
        this.headerView.setProgressColor(this.mProgressColor);
        this.headerView.setContentGravity(80);
        this.addView((View)this.headerView, (ViewGroup.LayoutParams)layoutParams3);
        layoutParams3 = layoutParams;
        new FrameLayout.LayoutParams((int)-1, (int)0).gravity = 80;
        this.footerView = wXRefreshView3 = wXRefreshView;
        new WXRefreshView(this.getContext()).setStartEndTrim(0.5f, 1.25f);
        this.footerView.setBackgroundColor(this.mRefreshViewBgColor);
        this.footerView.setProgressBgColor(this.mProgressBgColor);
        this.footerView.setProgressColor(this.mProgressColor);
        this.footerView.setContentGravity(48);
        this.addView((View)this.footerView, (ViewGroup.LayoutParams)layoutParams3);
    }

    private double calculateDistanceY(View view, int n) {
        double d;
        int n2 = view.getMeasuredHeight();
        double d2 = (double)((float)n2 - Math.abs(view.getY())) / 1.0 / (double)n2 * (double)0.4f;
        if (d <= 0.01) {
            d2 = 0.01;
        }
        return d2 * (double)n;
    }

    private boolean moveSpinner(float f) {
        if (this.mRefreshing) {
            return false;
        }
        if (!this.canChildScrollUp() && this.mPullRefreshEnable && this.mCurrentAction == 0) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height + f);
            if (layoutParams.height < 0) {
                layoutParams.height = 0;
            }
            if (layoutParams.height == 0) {
                this.isConfirm = false;
                this.mCurrentAction = -1;
            }
            FrameLayout.LayoutParams layoutParams2 = layoutParams;
            this.headerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.onRefreshListener.onPullingDown(f, layoutParams.height, this.refreshViewFlowHeight);
            this.notifyOnRefreshOffsetChangedListener(layoutParams2.height);
            this.headerView.setProgressRotation((float)layoutParams.height / this.refreshViewFlowHeight);
            this.moveTargetView(layoutParams2.height);
            return true;
        }
        if (!this.canChildScrollDown() && this.mPullLoadEnable && this.mCurrentAction == 1) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
            layoutParams.height = (int)((float)layoutParams.height - f);
            if (layoutParams.height < 0) {
                layoutParams.height = 0;
            }
            if (layoutParams.height == 0) {
                this.isConfirm = false;
                this.mCurrentAction = -1;
            }
            this.footerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.onLoadingListener.onPullingUp(f, layoutParams.height, this.loadingViewFlowHeight);
            this.footerView.setProgressRotation((float)layoutParams.height / this.loadingViewFlowHeight);
            this.moveTargetView(-layoutParams.height);
            return true;
        }
        return false;
    }

    private void moveTargetView(float f) {
        this.mTargetView.setTranslationY(f);
    }

    private void handlerAction() {
        if (!this.isRefreshing()) {
            FrameLayout.LayoutParams layoutParams;
            this.isConfirm = false;
            if (this.mPullRefreshEnable && this.mCurrentAction == 0) {
                FrameLayout.LayoutParams layoutParams2;
                layoutParams = (FrameLayout.LayoutParams)this.headerView.getLayoutParams();
                if ((float)layoutParams2.height >= this.refreshViewHeight) {
                    this.startRefresh(layoutParams.height);
                } else {
                    int n = layoutParams.height;
                    if (n > 0) {
                        this.resetHeaderView(n);
                    } else {
                        this.resetRefreshState();
                    }
                }
            }
            if (this.mPullLoadEnable && this.mCurrentAction == 1) {
                FrameLayout.LayoutParams layoutParams3;
                layoutParams = (FrameLayout.LayoutParams)this.footerView.getLayoutParams();
                if ((float)layoutParams3.height >= this.loadingViewHeight) {
                    this.startLoadmore(layoutParams.height);
                    return;
                }
                int n = layoutParams.height;
                if (n > 0) {
                    this.resetFootView(n);
                    return;
                }
                this.resetLoadmoreState();
                return;
            }
        }
    }

    private void startRefresh(int n) {
        WXRefreshAnimatorListener wXRefreshAnimatorListener;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        this.mRefreshing = true;
        float f = n;
        float f2 = this.refreshViewHeight;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f, f2});
        Object object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n;
                1 v0 = this_;
                1 this_ = (FrameLayout.LayoutParams)v0.WXSwipeLayout.this.headerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v0.WXSwipeLayout.this.headerView.getLayoutParams()).height = n = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v0.WXSwipeLayout.this.notifyOnRefreshOffsetChangedListener(n);
                v0.WXSwipeLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v0.WXSwipeLayout.this.moveTargetView(((FrameLayout.LayoutParams)this_).height);
            }
        };
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
        object = wXRefreshAnimatorListener;
        wXRefreshAnimatorListener = new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                2 v0 = this;
                v0.WXSwipeLayout.this.headerView.startAnimation();
                if (v0.WXSwipeLayout.this.onRefreshListener != null) {
                    WXSwipeLayout.this.onRefreshListener.onRefresh();
                    return;
                }
            }
        };
        valueAnimator.addListener((Animator.AnimatorListener)object);
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetHeaderView(int n) {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.headerView.stopAnimation();
        wXSwipeLayout.headerView.setStartEndTrim(0.0f, 0.75f);
        float f = n;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f, 0.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n;
                3 v0 = this_;
                3 this_ = (FrameLayout.LayoutParams)v0.WXSwipeLayout.this.headerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v0.WXSwipeLayout.this.headerView.getLayoutParams()).height = n = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v0.WXSwipeLayout.this.notifyOnRefreshOffsetChangedListener(n);
                v0.WXSwipeLayout.this.headerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v0.WXSwipeLayout.this.moveTargetView(((FrameLayout.LayoutParams)this_).height);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                WXSwipeLayout.this.resetRefreshState();
            }
        });
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetRefreshState() {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.mRefreshing = false;
        wXSwipeLayout.isConfirm = false;
        wXSwipeLayout.mCurrentAction = -1;
    }

    private void startLoadmore(int n) {
        WXRefreshAnimatorListener wXRefreshAnimatorListener;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        this.mRefreshing = true;
        float f = n;
        float f2 = this.loadingViewHeight;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f, f2});
        Object object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                5 v0 = this_;
                5 this_ = (FrameLayout.LayoutParams)v0.WXSwipeLayout.this.footerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v0.WXSwipeLayout.this.footerView.getLayoutParams()).height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v0.WXSwipeLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v0.WXSwipeLayout.this.moveTargetView(-((FrameLayout.LayoutParams)this_).height);
            }
        };
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
        object = wXRefreshAnimatorListener;
        wXRefreshAnimatorListener = new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                6 v0 = this;
                v0.WXSwipeLayout.this.footerView.startAnimation();
                if (v0.WXSwipeLayout.this.onLoadingListener != null) {
                    WXSwipeLayout.this.onLoadingListener.onLoading();
                    return;
                }
            }
        };
        valueAnimator.addListener((Animator.AnimatorListener)object);
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetFootView(int n) {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.footerView.stopAnimation();
        wXSwipeLayout.footerView.setStartEndTrim(0.5f, 1.25f);
        float f = n;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f, 0.0f});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                7 v0 = this_;
                7 this_ = (FrameLayout.LayoutParams)v0.WXSwipeLayout.this.footerView.getLayoutParams();
                ((FrameLayout.LayoutParams)v0.WXSwipeLayout.this.footerView.getLayoutParams()).height = (int)((Float)valueAnimator.getAnimatedValue()).floatValue();
                v0.WXSwipeLayout.this.footerView.setLayoutParams((ViewGroup.LayoutParams)this_);
                v0.WXSwipeLayout.this.moveTargetView(-((FrameLayout.LayoutParams)this_).height);
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new WXRefreshAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animator) {
                WXSwipeLayout.this.resetLoadmoreState();
            }
        });
        valueAnimator.setDuration(300L);
        valueAnimator.start();
    }

    private void resetLoadmoreState() {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.mRefreshing = false;
        wXSwipeLayout.isConfirm = false;
        wXSwipeLayout.mCurrentAction = -1;
    }

    private void notifyOnRefreshOffsetChangedListener(int n) {
        int n2 = this.mRefreshOffsetChangedListeners.size();
        for (int i = 0; i < n2 && i < this.mRefreshOffsetChangedListeners.size(); ++i) {
            OnRefreshOffsetChangedListener onRefreshOffsetChangedListener = this.mRefreshOffsetChangedListeners.get(i);
            if (onRefreshOffsetChangedListener == null) continue;
            onRefreshOffsetChangedListener.onOffsetChanged(n);
        }
    }

    protected void onAttachedToWindow() {
        WXSwipeLayout wXSwipeLayout = this;
        super.onAttachedToWindow();
        if (wXSwipeLayout.mTargetView == null && this.getChildCount() > 0) {
            this.mTargetView = this.getChildAt(0);
        }
        if (this.mTargetView != null && (this.headerView == null || this.footerView == null)) {
            this.setRefreshView();
            return;
        }
    }

    public void addTargetView(View view) {
        FrameLayout.LayoutParams layoutParams;
        WXSwipeLayout wXSwipeLayout = wXSwipeLayout2;
        WXSwipeLayout wXSwipeLayout2 = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        wXSwipeLayout.addView(view, (ViewGroup.LayoutParams)wXSwipeLayout2);
        wXSwipeLayout.setRefreshView();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.mPullRefreshEnable && !this.mPullLoadEnable) {
            return false;
        }
        if (this.isEnabled() && !this.canChildScrollUp() && !this.mRefreshing && !this.mNestedScrollInProgress) {
            return super.onInterceptTouchEvent(motionEvent);
        }
        return false;
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(bl);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int n) {
        boolean bl = this.mNestedScrollingChildHelper.startNestedScroll(n);
        if (bl && this.mNestedScrollAcceptedParent == null) {
            WXSwipeLayout wXSwipeLayout = this;
            for (ViewParent viewParent = this.getParent(); viewParent != null; viewParent = viewParent.getParent()) {
                if (ViewParentCompat.onStartNestedScroll((ViewParent)viewParent, (View)wXSwipeLayout, (View)this, (int)n)) {
                    this.mNestedScrollAcceptedParent = viewParent;
                    return bl;
                }
                if (!(viewParent instanceof View)) continue;
                wXSwipeLayout = (View)viewParent;
            }
        }
        return bl;
    }

    public void stopNestedScroll() {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.mNestedScrollingChildHelper.stopNestedScroll();
        if (wXSwipeLayout.mNestedScrollAcceptedParent != null) {
            this.mNestedScrollAcceptedParent = null;
            return;
        }
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(n, n2, n3, n4, nArray);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(n, n2, nArray, nArray2);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean bl) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(f, f2);
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        if (this.isNestedScrollingEnabled()) {
            return this.dispatchNestedPreFling(f, f2);
        }
        return false;
    }

    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        if (this.isNestedScrollingEnabled()) {
            return this.dispatchNestedFling(f, f2, bl);
        }
        return false;
    }

    public boolean onStartNestedScroll(View object, View view, int n) {
        boolean bl = this.isEnabled() && !this.mRefreshing && (n & 2) != 0;
        if (view instanceof WXRecyclerView && ((WXRecyclerView)(object = (WXRecyclerView)view)).isNestScroll()) {
            return bl && ((WXRecyclerView)object).isScrollTop();
        }
        return bl;
    }

    public void onNestedScrollAccepted(View view, View view2, int n) {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.mNestedScrollingParentHelper.onNestedScrollAccepted(view, view2, n);
        if (wXSwipeLayout.isNestedScrollingEnabled()) {
            this.startNestedScroll(n & 2);
            this.mNestedScrollInProgress = true;
            return;
        }
    }

    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
        int n3;
        int[] nArray2 = this.mParentScrollConsumed;
        if (this.isNestedScrollingEnabled() && this.dispatchNestedPreScroll(n -= nArray[0], n3 = n2 - nArray[1], nArray2, null)) {
            int[] nArray3 = nArray;
            nArray3[0] = nArray[0] + nArray2[0];
            nArray3[1] = nArray[1] + nArray2[1];
            return;
        }
        if (this.mPullRefreshEnable || this.mPullLoadEnable) {
            ViewParent viewParent;
            if (!this.canChildScrollUp() && this.isNestedScrollingEnabled() && (viewParent = this.mNestedScrollAcceptedParent) != null && viewParent != this.mTargetView && (viewParent = (ViewGroup)viewParent).getChildCount() > 0) {
                int n4 = viewParent.getChildCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    View view2 = viewParent.getChildAt(n3);
                    if (view2.getVisibility() == 8 || view2.getMeasuredHeight() <= 0) continue;
                    if (view2.getTop() >= 0) break;
                    break;
                }
            } else {
                int n5 = (int)this.calculateDistanceY(view, n2);
                this.mRefreshing = false;
                if (!this.isConfirm) {
                    if (n5 < 0 && !this.canChildScrollUp()) {
                        this.mCurrentAction = 0;
                        this.isConfirm = true;
                    } else if (n5 > 0 && !this.canChildScrollDown() && !this.mRefreshing) {
                        this.mCurrentAction = 1;
                        this.isConfirm = true;
                    }
                }
                if (this.moveSpinner(-n5)) {
                    if (!this.canChildScrollUp() && this.mPullRefreshEnable && this.mTargetView.getTranslationY() > 0.0f && n2 > 0) {
                        nArray[1] = nArray[1] + n2;
                        return;
                    }
                    if (!this.canChildScrollDown() && this.mPullLoadEnable && this.mTargetView.getTranslationY() < 0.0f && n2 < 0) {
                        nArray[1] = nArray[1] + n2;
                        return;
                    }
                    nArray[1] = nArray[1] + n5;
                    return;
                }
            }
        }
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View view) {
        WXSwipeLayout wXSwipeLayout = this;
        wXSwipeLayout.mNestedScrollingParentHelper.onStopNestedScroll(view);
        wXSwipeLayout.handlerAction();
        if (wXSwipeLayout.isNestedScrollingEnabled()) {
            this.mNestedScrollInProgress = true;
            this.stopNestedScroll();
            return;
        }
    }

    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        if (object.isNestedScrollingEnabled()) {
            WXSwipeLayout wXSwipeLayout = object;
            Object object = wXSwipeLayout.mParentOffsetInWindow;
            wXSwipeLayout.dispatchNestedScroll(n, n2, n3, n4, (int[])object);
            return;
        }
    }

    public boolean canChildScrollUp() {
        View view = wXSwipeLayout.mTargetView;
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                WXSwipeLayout wXSwipeLayout = (AbsListView)view;
                return wXSwipeLayout.getChildCount() > 0 && (wXSwipeLayout.getFirstVisiblePosition() > 0 || wXSwipeLayout.getChildAt(0).getTop() < wXSwipeLayout.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)view, (int)-1) || wXSwipeLayout.mTargetView.getScrollY() > 0;
            {
            }
        }
        return ViewCompat.canScrollVertically((View)view, (int)-1);
    }

    public boolean canChildScrollDown() {
        View view = wXSwipeLayout.mTargetView;
        if (view == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                WXSwipeLayout wXSwipeLayout = (AbsListView)view;
                if (wXSwipeLayout.getChildCount() > 0) {
                    WXSwipeLayout wXSwipeLayout2 = wXSwipeLayout;
                    int n = wXSwipeLayout2.getChildAt(wXSwipeLayout2.getChildCount() - 1).getBottom();
                    return wXSwipeLayout2.getLastVisiblePosition() == ((ListAdapter)wXSwipeLayout.getAdapter()).getCount() - 1 && n <= wXSwipeLayout.getMeasuredHeight();
                }
                return false;
            }
            return ViewCompat.canScrollVertically((View)view, (int)1) || wXSwipeLayout.mTargetView.getScrollY() > 0;
            {
            }
        }
        return ViewCompat.canScrollVertically((View)view, (int)1);
    }

    public float dipToPx(Context context, float f) {
        WXSwipeLayout wXSwipeLayout = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)wXSwipeLayout);
    }

    public void setOnLoadingListener(WXOnLoadingListener wXOnLoadingListener) {
        this.onLoadingListener = wXOnLoadingListener;
    }

    public void setOnRefreshListener(WXOnRefreshListener wXOnRefreshListener) {
        this.onRefreshListener = wXOnRefreshListener;
    }

    public void addOnRefreshOffsetChangedListener(@Nullable OnRefreshOffsetChangedListener onRefreshOffsetChangedListener) {
        if (onRefreshOffsetChangedListener != null && !this.mRefreshOffsetChangedListeners.contains(onRefreshOffsetChangedListener)) {
            this.mRefreshOffsetChangedListeners.add(onRefreshOffsetChangedListener);
            return;
        }
    }

    public boolean removeOnRefreshOffsetChangedListener(@Nullable OnRefreshOffsetChangedListener onRefreshOffsetChangedListener) {
        if (onRefreshOffsetChangedListener != null) {
            return this.mRefreshOffsetChangedListeners.remove(onRefreshOffsetChangedListener);
        }
        return false;
    }

    public void finishPullRefresh() {
        if (this.mCurrentAction == 0) {
            WXRefreshView wXRefreshView = this.headerView;
            int n = wXRefreshView == null ? 0 : wXRefreshView.getMeasuredHeight();
            this.resetHeaderView(n);
            return;
        }
    }

    public void finishPullLoad() {
        if (this.mCurrentAction == 1) {
            WXRefreshView wXRefreshView = this.footerView;
            int n = wXRefreshView == null ? 0 : wXRefreshView.getMeasuredHeight();
            this.resetFootView(n);
            return;
        }
    }

    public WXRefreshView getHeaderView() {
        return this.headerView;
    }

    public WXRefreshView getFooterView() {
        return this.footerView;
    }

    public boolean isPullLoadEnable() {
        return this.mPullLoadEnable;
    }

    public void setPullLoadEnable(boolean bl) {
        this.mPullLoadEnable = bl;
    }

    public boolean isPullRefreshEnable() {
        return this.mPullRefreshEnable;
    }

    public void setPullRefreshEnable(boolean bl) {
        this.mPullRefreshEnable = bl;
    }

    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    public void setRefreshHeight(int n) {
        this.refreshViewHeight = n;
        this.refreshViewFlowHeight = this.refreshViewHeight * 1.0f;
    }

    public void setLoadingHeight(int n) {
        this.loadingViewHeight = n;
        this.loadingViewFlowHeight = this.loadingViewHeight * 1.0f;
    }

    public void setRefreshBgColor(int n) {
        this.headerView.setBackgroundColor(n);
    }

    public void setLoadingBgColor(int n) {
        this.footerView.setBackgroundColor(n);
    }

    public static interface WXOnLoadingListener {
        public void onLoading();

        public void onPullingUp(float var1, int var2, float var3);
    }

    public static interface WXOnRefreshListener {
        public void onRefresh();

        public void onPullingDown(float var1, int var2, float var3);
    }

    public static interface OnRefreshOffsetChangedListener {
        public void onOffsetChanged(int var1);
    }

    static class WXRefreshAnimatorListener
    implements Animator.AnimatorListener {
        WXRefreshAnimatorListener() {
        }

        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    }
}

