/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.weex.weex_video.ijkplayer.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

public class NetWorkUtils {
    public static final String NETWORK_TYPE_WIFI = "wifi";
    public static final String NETWORK_TYPE_3G = "eg";
    public static final String NETWORK_TYPE_2G = "2g";
    public static final String NETWORK_TYPE_WAP = "wap";
    public static final String NETWORK_TYPE_UNKNOWN = "unknown";
    public static final String NETWORK_TYPE_DISCONNECT = "disconnect";

    public static int getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager == null ? null : connectivityManager.getActiveNetworkInfo();
        return networkInfo == null ? -1 : networkInfo.getType();
    }

    public static String getNetworkTypeName(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        String type = NETWORK_TYPE_DISCONNECT;
        if (manager == null || (networkInfo = manager.getActiveNetworkInfo()) == null) {
            return type;
        }
        if (networkInfo.isConnected()) {
            String proxyHost;
            String typeName = networkInfo.getTypeName();
            type = "WIFI".equalsIgnoreCase(typeName) ? NETWORK_TYPE_WIFI : ("MOBILE".equalsIgnoreCase(typeName) ? (TextUtils.isEmpty((CharSequence)(proxyHost = Proxy.getDefaultHost())) ? (NetWorkUtils.isFastMobileNetwork(context) ? NETWORK_TYPE_3G : NETWORK_TYPE_2G) : NETWORK_TYPE_WAP) : NETWORK_TYPE_UNKNOWN);
        }
        return type;
    }

    private static boolean isFastMobileNetwork(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return false;
        }
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return false;
            }
            case 4: {
                return false;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 1: {
                return false;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 3: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 11: {
                return false;
            }
            case 13: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = cm.getActiveNetworkInfo();
            return null != info && info.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mMobileNetworkInfo;
        if (context != null && (mMobileNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(0)) != null && mMobileNetworkInfo.isAvailable()) {
            return mMobileNetworkInfo.isConnected();
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        if (context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null && mWiFiNetworkInfo.isAvailable()) {
            return mWiFiNetworkInfo.isConnected();
        }
        return false;
    }
}

