/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder;

import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidtranscoder.engine.MediaTranscoderEngine;
import androidtranscoder.format.MediaFormatPresets;
import androidtranscoder.format.MediaFormatStrategy;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class MediaTranscoder {
    private static final String TAG = "MediaTranscoder";
    private static final int MAXIMUM_THREAD = 1;
    private static volatile MediaTranscoder sMediaTranscoder;
    private ThreadPoolExecutor mExecutor;

    private MediaTranscoder() {
        ThreadFactory threadFactory;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory2 = threadFactory;
        threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "MediaTranscoder-Worker");
            }
        };
        threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, timeUnit, linkedBlockingQueue2, threadFactory2);
        this.mExecutor = threadPoolExecutor2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaTranscoder getInstance() {
        if (sMediaTranscoder != null) return sMediaTranscoder;
        Class<MediaTranscoder> clazz = MediaTranscoder.class;
        synchronized (MediaTranscoder.class) {
            try {
                if (sMediaTranscoder != null) return sMediaTranscoder;
                sMediaTranscoder = new MediaTranscoder();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sMediaTranscoder;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    @Deprecated
    public Future<Void> transcodeVideo(FileDescriptor object, String string, Listener listener) {
        MediaFormatStrategy mediaFormatStrategy;
        FileDescriptor fileDescriptor = object;
        object = mediaFormatStrategy;
        mediaFormatStrategy = new MediaFormatStrategy(){

            @Override
            public MediaFormat createVideoOutputFormat(MediaFormat mediaFormat) {
                return MediaFormatPresets.getExportPreset960x540();
            }

            @Override
            public MediaFormat createAudioOutputFormat(MediaFormat mediaFormat) {
                return null;
            }
        };
        return this.transcodeVideo(fileDescriptor, string, (MediaFormatStrategy)object, listener);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<Void> transcodeVideo(String object, String string, MediaFormatStrategy mediaFormatStrategy, final Listener listener) throws IOException {
        void var0_3;
        FileInputStream fileInputStream;
        block7: {
            Listener listener2;
            FileDescriptor fileDescriptor;
            FileInputStream fileInputStream2;
            fileInputStream = null;
            final FileInputStream fileInputStream3 = fileInputStream2;
            try {
                fileInputStream2 = new FileInputStream((String)object);
            }
            catch (IOException iOException) {
                // empty catch block
                break block7;
            }
            try {
                fileDescriptor = fileInputStream2.getFD();
            }
            catch (IOException iOException) {
                fileInputStream = fileInputStream3;
                break block7;
            }
            object = listener2;
            listener2 = new Listener(){

                private void closeStream() {
                    try {
                        fileInputStream3.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)MediaTranscoder.TAG, (String)"Can't close input stream: ", (Throwable)iOException);
                    }
                }

                @Override
                public void onTranscodeProgress(double d6) {
                    listener.onTranscodeProgress(d6);
                }

                @Override
                public void onTranscodeCompleted() {
                    3 v02 = this;
                    v02.closeStream();
                    v02.listener.onTranscodeCompleted();
                }

                @Override
                public void onTranscodeCanceled() {
                    3 v02 = this;
                    v02.closeStream();
                    v02.listener.onTranscodeCanceled();
                }

                @Override
                public void onTranscodeFailed(Exception exception) {
                    3 v02 = this;
                    v02.closeStream();
                    v02.listener.onTranscodeFailed(exception);
                }
            };
            return this.transcodeVideo(fileDescriptor, string, mediaFormatStrategy, (Listener)object);
        }
        if (fileInputStream == null) throw var0_3;
        try {
            fileInputStream.close();
            throw var0_3;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)"Can't close input stream: ", (Throwable)iOException);
        }
        throw var0_3;
    }

    public Future<Void> transcodeVideo(final FileDescriptor fileDescriptor, final String string, final MediaFormatStrategy mediaFormatStrategy, final Listener listener) {
        AtomicReference atomicReference;
        Handler handler;
        Object object = Looper.myLooper();
        if (object == null) {
            object = Looper.getMainLooper();
        }
        final Handler handler2 = handler;
        handler = new Handler((Looper)object);
        object = atomicReference;
        atomicReference = new AtomicReference();
        Future<Void> future = this.mExecutor.submit(new Callable<Void>(){
            final /* synthetic */ AtomicReference val$futureReference;
            {
                this.val$futureReference = atomicReference;
            }

            @Override
            public Void call() throws Exception {
                Exception exception;
                block7: {
                    IOException iOException2;
                    block10: {
                        InterruptedException interruptedException2;
                        block9: {
                            MediaTranscoderEngine mediaTranscoderEngine;
                            exception = null;
                            Object object = mediaTranscoderEngine;
                            4 v12 = this;
                            4 v22 = v12;
                            MediaTranscoderEngine mediaTranscoderEngine2 = object;
                            mediaTranscoderEngine2();
                            mediaTranscoderEngine2.setProgressCallback(new MediaTranscoderEngine.ProgressCallback(){

                                @Override
                                public void onProgress(final double d6) {
                                    handler2.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            listener.onTranscodeProgress(d6);
                                        }
                                    });
                                }
                            });
                            ((MediaTranscoderEngine)object).setDataSource(fileDescriptor);
                            object = v12.string;
                            try {
                                mediaTranscoderEngine.transcodeVideo((String)object, v22.mediaFormatStrategy);
                                break block7;
                            }
                            catch (RuntimeException runtimeException) {
                            }
                            catch (InterruptedException interruptedException2) {
                                break block9;
                            }
                            catch (IOException iOException2) {
                                break block10;
                            }
                            Log.e((String)MediaTranscoder.TAG, (String)"Fatal error while transcoding, this might be invalid format or bug in engine or Android.", (Throwable)runtimeException);
                            break block7;
                        }
                        Log.i((String)MediaTranscoder.TAG, (String)"Cancel transcode video file.", (Throwable)interruptedException2);
                        break block7;
                    }
                    Log.w((String)MediaTranscoder.TAG, (String)("Transcode failed: input file (fd: " + fileDescriptor.toString() + ") not found or could not open output file ('" + string + "') ."), (Throwable)iOException2);
                }
                handler2.post(new Runnable(){

                    @Override
                    public void run() {
                        if (exception == null) {
                            listener.onTranscodeCompleted();
                        } else {
                            Future future = (Future)val$futureReference.get();
                            if (future != null && future.isCancelled()) {
                                listener.onTranscodeCanceled();
                            } else {
                                listener.onTranscodeFailed(exception);
                            }
                        }
                    }
                });
                if (exception == null) {
                    return null;
                }
                throw exception;
            }
        });
        ((AtomicReference)object).set(future);
        return future;
    }

    public static interface Listener {
        public void onTranscodeProgress(double var1);

        public void onTranscodeCompleted();

        public void onTranscodeCanceled();

        public void onTranscodeFailed(Exception var1);
    }
}

