/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.view.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatApi21;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatApi22;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatIcs;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatJellyBean;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatJellybeanMr1;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatJellybeanMr2;
import com.dcloud.android.v4.view.accessibility.AccessibilityNodeInfoCompatKitKat;
import com.dcloud.android.v4.view.accessibility.AccessibilityWindowInfoCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessibilityNodeInfoCompat {
    private static final AccessibilityNodeInfoImpl IMPL;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_DISMISS = 0x100000;
    public static final int ACTION_SET_TEXT = 0x200000;
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final int FOCUS_INPUT = 1;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;
    private final Object mInfo;

    static AccessibilityNodeInfoCompat wrapNonNullInstance(Object object) {
        if (object != null) {
            return new AccessibilityNodeInfoCompat(object);
        }
        return null;
    }

    public AccessibilityNodeInfoCompat(Object object) {
        this.mInfo = object;
    }

    public static AccessibilityNodeInfoCompat obtain(View view) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(view));
    }

    public static AccessibilityNodeInfoCompat obtain(View view, int n5) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(view, n5));
    }

    public static AccessibilityNodeInfoCompat obtain() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain());
    }

    public static AccessibilityNodeInfoCompat obtain(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(accessibilityNodeInfoCompat.mInfo));
    }

    private static String getActionSymbolicName(int n5) {
        switch (n5) {
            default: {
                return "ACTION_UNKNOWN";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 1: 
        }
        return "ACTION_FOCUS";
    }

    static {
        int n5 = Build.VERSION.SDK_INT;
        IMPL = n5 >= 22 ? new AccessibilityNodeInfoApi22Impl() : (n5 >= 21 ? new AccessibilityNodeInfoApi21Impl() : (n5 >= 19 ? new AccessibilityNodeInfoKitKatImpl() : (n5 >= 18 ? new AccessibilityNodeInfoJellybeanMr2Impl() : (n5 >= 17 ? new AccessibilityNodeInfoJellybeanMr1Impl() : (n5 >= 16 ? new AccessibilityNodeInfoJellybeanImpl() : (n5 >= 14 ? new AccessibilityNodeInfoIcsImpl() : new AccessibilityNodeInfoStubImpl()))))));
    }

    public Object getInfo() {
        return this.mInfo;
    }

    public void setSource(View view) {
        IMPL.setSource(this.mInfo, view);
    }

    public void setSource(View view, int n5) {
        IMPL.setSource(this.mInfo, view, n5);
    }

    public AccessibilityNodeInfoCompat findFocus(int n5) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.findFocus(this.mInfo, n5));
    }

    public AccessibilityNodeInfoCompat focusSearch(int n5) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.focusSearch(this.mInfo, n5));
    }

    public int getWindowId() {
        return IMPL.getWindowId(this.mInfo);
    }

    public int getChildCount() {
        return IMPL.getChildCount(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getChild(int n5) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getChild(this.mInfo, n5));
    }

    public void addChild(View view) {
        IMPL.addChild(this.mInfo, view);
    }

    public void addChild(View view, int n5) {
        IMPL.addChild(this.mInfo, view, n5);
    }

    public boolean removeChild(View view) {
        return IMPL.removeChild(this.mInfo, view);
    }

    public boolean removeChild(View view, int n5) {
        return IMPL.removeChild(this.mInfo, view, n5);
    }

    public int getActions() {
        return IMPL.getActions(this.mInfo);
    }

    public void addAction(int n5) {
        IMPL.addAction(this.mInfo, n5);
    }

    public void addAction(AccessibilityActionCompat accessibilityActionCompat) {
        Object object = ((AccessibilityNodeInfoCompat)object).mInfo;
        IMPL.addAction(object, accessibilityActionCompat.mAction);
    }

    public boolean removeAction(AccessibilityActionCompat accessibilityActionCompat) {
        Object object = ((AccessibilityNodeInfoCompat)object).mInfo;
        return IMPL.removeAction(object, accessibilityActionCompat.mAction);
    }

    public boolean performAction(int n5) {
        return IMPL.performAction(this.mInfo, n5);
    }

    public boolean performAction(int n5, Bundle bundle) {
        return IMPL.performAction(this.mInfo, n5, bundle);
    }

    public void setMovementGranularities(int n5) {
        IMPL.setMovementGranularities(this.mInfo, n5);
    }

    public int getMovementGranularities() {
        return IMPL.getMovementGranularities(this.mInfo);
    }

    public List<AccessibilityNodeInfoCompat> findAccessibilityNodeInfosByText(String string2) {
        ArrayList<AccessibilityNodeInfoCompat> arrayList;
        ArrayList<AccessibilityNodeInfoCompat> arrayList2 = arrayList;
        arrayList = new ArrayList<AccessibilityNodeInfoCompat>();
        List<Object> list = IMPL.findAccessibilityNodeInfosByText(((AccessibilityNodeInfoCompat)((Object)list)).mInfo, string2);
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat;
            Object e5 = list.get(i5);
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
            accessibilityNodeInfoCompat = new AccessibilityNodeInfoCompat(e5);
            arrayList2.add(accessibilityNodeInfoCompat2);
        }
        return arrayList2;
    }

    public AccessibilityNodeInfoCompat getParent() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getParent(this.mInfo));
    }

    public void setParent(View view) {
        IMPL.setParent(this.mInfo, view);
    }

    public void setParent(View view, int n5) {
        IMPL.setParent(this.mInfo, view, n5);
    }

    public void getBoundsInParent(Rect rect) {
        IMPL.getBoundsInParent(this.mInfo, rect);
    }

    public void setBoundsInParent(Rect rect) {
        IMPL.setBoundsInParent(this.mInfo, rect);
    }

    public void getBoundsInScreen(Rect rect) {
        IMPL.getBoundsInScreen(this.mInfo, rect);
    }

    public void setBoundsInScreen(Rect rect) {
        IMPL.setBoundsInScreen(this.mInfo, rect);
    }

    public boolean isCheckable() {
        return IMPL.isCheckable(this.mInfo);
    }

    public void setCheckable(boolean bl) {
        IMPL.setCheckable(this.mInfo, bl);
    }

    public boolean isChecked() {
        return IMPL.isChecked(this.mInfo);
    }

    public void setChecked(boolean bl) {
        IMPL.setChecked(this.mInfo, bl);
    }

    public boolean isFocusable() {
        return IMPL.isFocusable(this.mInfo);
    }

    public void setFocusable(boolean bl) {
        IMPL.setFocusable(this.mInfo, bl);
    }

    public boolean isFocused() {
        return IMPL.isFocused(this.mInfo);
    }

    public void setFocused(boolean bl) {
        IMPL.setFocused(this.mInfo, bl);
    }

    public boolean isVisibleToUser() {
        return IMPL.isVisibleToUser(this.mInfo);
    }

    public void setVisibleToUser(boolean bl) {
        IMPL.setVisibleToUser(this.mInfo, bl);
    }

    public boolean isAccessibilityFocused() {
        return IMPL.isAccessibilityFocused(this.mInfo);
    }

    public void setAccessibilityFocused(boolean bl) {
        IMPL.setAccessibilityFocused(this.mInfo, bl);
    }

    public boolean isSelected() {
        return IMPL.isSelected(this.mInfo);
    }

    public void setSelected(boolean bl) {
        IMPL.setSelected(this.mInfo, bl);
    }

    public boolean isClickable() {
        return IMPL.isClickable(this.mInfo);
    }

    public void setClickable(boolean bl) {
        IMPL.setClickable(this.mInfo, bl);
    }

    public boolean isLongClickable() {
        return IMPL.isLongClickable(this.mInfo);
    }

    public void setLongClickable(boolean bl) {
        IMPL.setLongClickable(this.mInfo, bl);
    }

    public boolean isEnabled() {
        return IMPL.isEnabled(this.mInfo);
    }

    public void setEnabled(boolean bl) {
        IMPL.setEnabled(this.mInfo, bl);
    }

    public boolean isPassword() {
        return IMPL.isPassword(this.mInfo);
    }

    public void setPassword(boolean bl) {
        IMPL.setPassword(this.mInfo, bl);
    }

    public boolean isScrollable() {
        return IMPL.isScrollable(this.mInfo);
    }

    public void setScrollable(boolean bl) {
        IMPL.setScrollable(this.mInfo, bl);
    }

    public CharSequence getPackageName() {
        return IMPL.getPackageName(this.mInfo);
    }

    public void setPackageName(CharSequence charSequence) {
        IMPL.setPackageName(this.mInfo, charSequence);
    }

    public CharSequence getClassName() {
        return IMPL.getClassName(this.mInfo);
    }

    public void setClassName(CharSequence charSequence) {
        IMPL.setClassName(this.mInfo, charSequence);
    }

    public CharSequence getText() {
        return IMPL.getText(this.mInfo);
    }

    public void setText(CharSequence charSequence) {
        IMPL.setText(this.mInfo, charSequence);
    }

    public CharSequence getContentDescription() {
        return IMPL.getContentDescription(this.mInfo);
    }

    public void setContentDescription(CharSequence charSequence) {
        IMPL.setContentDescription(this.mInfo, charSequence);
    }

    public void recycle() {
        IMPL.recycle(this.mInfo);
    }

    public void setViewIdResourceName(String string2) {
        IMPL.setViewIdResourceName(this.mInfo, string2);
    }

    public String getViewIdResourceName() {
        return IMPL.getViewIdResourceName(this.mInfo);
    }

    public int getLiveRegion() {
        return IMPL.getLiveRegion(this.mInfo);
    }

    public void setLiveRegion(int n5) {
        IMPL.setLiveRegion(this.mInfo, n5);
    }

    public CollectionInfoCompat getCollectionInfo() {
        Object object = IMPL.getCollectionInfo(((AccessibilityNodeInfoCompat)object).mInfo);
        if (object == null) {
            return null;
        }
        return new CollectionInfoCompat(object);
    }

    public void setCollectionInfo(Object object) {
        IMPL.setCollectionInfo(this.mInfo, ((CollectionInfoCompat)object).mInfo);
    }

    public void setCollectionItemInfo(Object object) {
        IMPL.setCollectionItemInfo(this.mInfo, ((CollectionItemInfoCompat)object).mInfo);
    }

    public CollectionItemInfoCompat getCollectionItemInfo() {
        Object object = IMPL.getCollectionItemInfo(((AccessibilityNodeInfoCompat)object).mInfo);
        if (object == null) {
            return null;
        }
        return new CollectionItemInfoCompat(object);
    }

    public RangeInfoCompat getRangeInfo() {
        Object object = IMPL.getRangeInfo(((AccessibilityNodeInfoCompat)object).mInfo);
        if (object == null) {
            return null;
        }
        return new RangeInfoCompat(object);
    }

    public void setRangeInfo(RangeInfoCompat rangeInfoCompat) {
        Object object = ((AccessibilityNodeInfoCompat)object).mInfo;
        IMPL.setRangeInfo(object, rangeInfoCompat.mInfo);
    }

    public List<AccessibilityActionCompat> getActionList() {
        List<Object> list = IMPL.getActionList(((AccessibilityNodeInfoCompat)((Object)list)).mInfo);
        if (list != null) {
            ArrayList<AccessibilityActionCompat> arrayList;
            ArrayList<AccessibilityActionCompat> arrayList2 = arrayList;
            arrayList = new ArrayList<AccessibilityActionCompat>();
            int n5 = list.size();
            for (int i5 = 0; i5 < n5; ++i5) {
                AccessibilityActionCompat accessibilityActionCompat;
                Object e5 = list.get(i5);
                AccessibilityActionCompat accessibilityActionCompat2 = accessibilityActionCompat;
                accessibilityActionCompat = new AccessibilityActionCompat(e5);
                arrayList2.add(accessibilityActionCompat2);
            }
            return arrayList2;
        }
        return Collections.emptyList();
    }

    public void setContentInvalid(boolean bl) {
        IMPL.setContentInvalid(this.mInfo, bl);
    }

    public boolean isContentInvalid() {
        return IMPL.isContentInvalid(this.mInfo);
    }

    public void setError(CharSequence charSequence) {
        IMPL.setError(this.mInfo, charSequence);
    }

    public CharSequence getError() {
        return IMPL.getError(this.mInfo);
    }

    public void setLabelFor(View view) {
        IMPL.setLabelFor(this.mInfo, view);
    }

    public void setLabelFor(View view, int n5) {
        IMPL.setLabelFor(this.mInfo, view, n5);
    }

    public AccessibilityNodeInfoCompat getLabelFor() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getLabelFor(this.mInfo));
    }

    public void setLabeledBy(View view) {
        IMPL.setLabeledBy(this.mInfo, view);
    }

    public void setLabeledBy(View view, int n5) {
        IMPL.setLabeledBy(this.mInfo, view, n5);
    }

    public AccessibilityNodeInfoCompat getLabeledBy() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getLabeledBy(this.mInfo));
    }

    public boolean canOpenPopup() {
        return IMPL.canOpenPopup(this.mInfo);
    }

    public void setCanOpenPopup(boolean bl) {
        IMPL.setCanOpenPopup(this.mInfo, bl);
    }

    public List<AccessibilityNodeInfoCompat> findAccessibilityNodeInfosByViewId(String object) {
        List<Object> list;
        list = IMPL.findAccessibilityNodeInfosByViewId(((AccessibilityNodeInfoCompat)((Object)list)).mInfo, (String)((Object)object));
        if (list != null) {
            ArrayList arrayList;
            List<Object> list2 = list;
            list = arrayList;
            arrayList = new ArrayList();
            for (Object e5 : list2) {
                AccessibilityNodeInfoCompat accessibilityNodeInfoCompat;
                AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                accessibilityNodeInfoCompat = new AccessibilityNodeInfoCompat(e5);
                list.add(accessibilityNodeInfoCompat2);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public Bundle getExtras() {
        return IMPL.getExtras(this.mInfo);
    }

    public int getInputType() {
        return IMPL.getInputType(this.mInfo);
    }

    public void setInputType(int n5) {
        IMPL.setInputType(this.mInfo, n5);
    }

    public void setMaxTextLength(int n5) {
        IMPL.setMaxTextLength(this.mInfo, n5);
    }

    public int getMaxTextLength() {
        return IMPL.getMaxTextLength(this.mInfo);
    }

    public void setTextSelection(int n5, int n6) {
        IMPL.setTextSelection(this.mInfo, n5, n6);
    }

    public int getTextSelectionStart() {
        return IMPL.getTextSelectionStart(this.mInfo);
    }

    public int getTextSelectionEnd() {
        return IMPL.getTextSelectionEnd(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getTraversalBefore() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getTraversalBefore(this.mInfo));
    }

    public void setTraversalBefore(View view) {
        IMPL.setTraversalBefore(this.mInfo, view);
    }

    public void setTraversalBefore(View view, int n5) {
        IMPL.setTraversalBefore(this.mInfo, view, n5);
    }

    public AccessibilityNodeInfoCompat getTraversalAfter() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getTraversalAfter(this.mInfo));
    }

    public void setTraversalAfter(View view) {
        IMPL.setTraversalAfter(this.mInfo, view);
    }

    public void setTraversalAfter(View view, int n5) {
        IMPL.setTraversalAfter(this.mInfo, view, n5);
    }

    public AccessibilityWindowInfoCompat getWindow() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getWindow(this.mInfo));
    }

    public boolean isDismissable() {
        return IMPL.isDismissable(this.mInfo);
    }

    public void setDismissable(boolean bl) {
        IMPL.setDismissable(this.mInfo, bl);
    }

    public boolean isEditable() {
        return IMPL.isEditable(this.mInfo);
    }

    public void setEditable(boolean bl) {
        IMPL.setEditable(this.mInfo, bl);
    }

    public boolean isMultiLine() {
        return IMPL.isMultiLine(this.mInfo);
    }

    public void setMultiLine(boolean bl) {
        IMPL.setMultiLine(this.mInfo, bl);
    }

    public boolean refresh() {
        return IMPL.refresh(this.mInfo);
    }

    public int hashCode() {
        Object object = ((AccessibilityNodeInfoCompat)object).mInfo;
        return object == null ? 0 : object.hashCode();
    }

    public boolean equals(Object object) {
        if (accessibilityNodeInfoCompat2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (accessibilityNodeInfoCompat2.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = accessibilityNodeInfoCompat2;
        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = (AccessibilityNodeInfoCompat)object;
        object = accessibilityNodeInfoCompat.mInfo;
        return !(object == null ? accessibilityNodeInfoCompat2.mInfo != null : !object.equals(accessibilityNodeInfoCompat2.mInfo));
    }

    public String toString() {
        Rect rect;
        StringBuilder stringBuilder;
        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = this;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        stringBuilder2.append(super.toString());
        Rect rect2 = rect;
        accessibilityNodeInfoCompat.getBoundsInParent(new Rect());
        stringBuilder2.append("; boundsInParent: " + rect2);
        accessibilityNodeInfoCompat.getBoundsInScreen(rect2);
        stringBuilder2.append("; boundsInScreen: " + rect2);
        stringBuilder2.append("; packageName: ").append(this.getPackageName());
        stringBuilder2.append("; className: ").append(this.getClassName());
        stringBuilder2.append("; text: ").append(this.getText());
        stringBuilder2.append("; contentDescription: ").append(this.getContentDescription());
        stringBuilder2.append("; viewId: ").append(this.getViewIdResourceName());
        stringBuilder2.append("; checkable: ").append(this.isCheckable());
        stringBuilder2.append("; checked: ").append(this.isChecked());
        stringBuilder2.append("; focusable: ").append(this.isFocusable());
        stringBuilder2.append("; focused: ").append(this.isFocused());
        stringBuilder2.append("; selected: ").append(this.isSelected());
        stringBuilder2.append("; clickable: ").append(this.isClickable());
        stringBuilder2.append("; longClickable: ").append(this.isLongClickable());
        stringBuilder2.append("; enabled: ").append(this.isEnabled());
        stringBuilder2.append("; password: ").append(this.isPassword());
        stringBuilder2.append("; scrollable: " + this.isScrollable());
        stringBuilder2.append("; [");
        int n5 = accessibilityNodeInfoCompat.getActions();
        while (n5 != 0) {
            int n6 = n5;
            n5 = 1 << Integer.numberOfTrailingZeros(n6);
            int n7 = n6 & ~n5;
            stringBuilder2.append(AccessibilityNodeInfoCompat.getActionSymbolicName(n5));
            if (n7 != 0) {
                stringBuilder2.append(", ");
            }
            n5 = n7;
        }
        stringBuilder2.append("]");
        return stringBuilder2.toString();
    }

    static interface AccessibilityNodeInfoImpl {
        public Object newAccessibilityAction(int var1, CharSequence var2);

        public Object obtain();

        public Object obtain(View var1);

        public Object obtain(Object var1);

        public Object obtain(View var1, int var2);

        public void setSource(Object var1, View var2);

        public void setSource(Object var1, View var2, int var3);

        public Object findFocus(Object var1, int var2);

        public Object focusSearch(Object var1, int var2);

        public int getWindowId(Object var1);

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public void addChild(Object var1, View var2);

        public void addChild(Object var1, View var2, int var3);

        public boolean removeChild(Object var1, View var2);

        public boolean removeChild(Object var1, View var2, int var3);

        public int getActions(Object var1);

        public void addAction(Object var1, int var2);

        public void addAction(Object var1, Object var2);

        public boolean removeAction(Object var1, Object var2);

        public int getAccessibilityActionId(Object var1);

        public CharSequence getAccessibilityActionLabel(Object var1);

        public boolean performAction(Object var1, int var2);

        public boolean performAction(Object var1, int var2, Bundle var3);

        public void setMovementGranularities(Object var1, int var2);

        public int getMovementGranularities(Object var1);

        public List<Object> findAccessibilityNodeInfosByText(Object var1, String var2);

        public Object getParent(Object var1);

        public void setParent(Object var1, View var2, int var3);

        public void setParent(Object var1, View var2);

        public void getBoundsInParent(Object var1, Rect var2);

        public void setBoundsInParent(Object var1, Rect var2);

        public void getBoundsInScreen(Object var1, Rect var2);

        public void setBoundsInScreen(Object var1, Rect var2);

        public boolean isCheckable(Object var1);

        public void setCheckable(Object var1, boolean var2);

        public boolean isChecked(Object var1);

        public void setChecked(Object var1, boolean var2);

        public boolean isFocusable(Object var1);

        public void setFocusable(Object var1, boolean var2);

        public boolean isFocused(Object var1);

        public void setFocused(Object var1, boolean var2);

        public boolean isVisibleToUser(Object var1);

        public void setVisibleToUser(Object var1, boolean var2);

        public boolean isAccessibilityFocused(Object var1);

        public void setAccessibilityFocused(Object var1, boolean var2);

        public boolean isSelected(Object var1);

        public void setSelected(Object var1, boolean var2);

        public boolean isClickable(Object var1);

        public void setClickable(Object var1, boolean var2);

        public boolean isLongClickable(Object var1);

        public void setLongClickable(Object var1, boolean var2);

        public boolean isEnabled(Object var1);

        public void setEnabled(Object var1, boolean var2);

        public boolean isPassword(Object var1);

        public void setPassword(Object var1, boolean var2);

        public boolean isScrollable(Object var1);

        public void setScrollable(Object var1, boolean var2);

        public CharSequence getPackageName(Object var1);

        public void setPackageName(Object var1, CharSequence var2);

        public CharSequence getClassName(Object var1);

        public void setClassName(Object var1, CharSequence var2);

        public CharSequence getText(Object var1);

        public void setText(Object var1, CharSequence var2);

        public CharSequence getContentDescription(Object var1);

        public void setContentDescription(Object var1, CharSequence var2);

        public void recycle(Object var1);

        public String getViewIdResourceName(Object var1);

        public void setViewIdResourceName(Object var1, String var2);

        public int getLiveRegion(Object var1);

        public void setLiveRegion(Object var1, int var2);

        public Object getCollectionInfo(Object var1);

        public void setCollectionInfo(Object var1, Object var2);

        public Object getCollectionItemInfo(Object var1);

        public void setCollectionItemInfo(Object var1, Object var2);

        public Object getRangeInfo(Object var1);

        public void setRangeInfo(Object var1, Object var2);

        public List<Object> getActionList(Object var1);

        public Object obtainCollectionInfo(int var1, int var2, boolean var3, int var4);

        public int getCollectionInfoColumnCount(Object var1);

        public int getCollectionInfoRowCount(Object var1);

        public boolean isCollectionInfoHierarchical(Object var1);

        public Object obtainCollectionItemInfo(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

        public int getCollectionItemColumnIndex(Object var1);

        public int getCollectionItemColumnSpan(Object var1);

        public int getCollectionItemRowIndex(Object var1);

        public int getCollectionItemRowSpan(Object var1);

        public boolean isCollectionItemHeading(Object var1);

        public boolean isCollectionItemSelected(Object var1);

        public Object getTraversalBefore(Object var1);

        public void setTraversalBefore(Object var1, View var2);

        public void setTraversalBefore(Object var1, View var2, int var3);

        public Object getTraversalAfter(Object var1);

        public void setTraversalAfter(Object var1, View var2);

        public void setTraversalAfter(Object var1, View var2, int var3);

        public void setContentInvalid(Object var1, boolean var2);

        public boolean isContentInvalid(Object var1);

        public void setError(Object var1, CharSequence var2);

        public CharSequence getError(Object var1);

        public void setLabelFor(Object var1, View var2);

        public void setLabelFor(Object var1, View var2, int var3);

        public Object getLabelFor(Object var1);

        public void setLabeledBy(Object var1, View var2);

        public void setLabeledBy(Object var1, View var2, int var3);

        public Object getLabeledBy(Object var1);

        public boolean canOpenPopup(Object var1);

        public void setCanOpenPopup(Object var1, boolean var2);

        public List<Object> findAccessibilityNodeInfosByViewId(Object var1, String var2);

        public Bundle getExtras(Object var1);

        public int getInputType(Object var1);

        public void setInputType(Object var1, int var2);

        public void setMaxTextLength(Object var1, int var2);

        public int getMaxTextLength(Object var1);

        public void setTextSelection(Object var1, int var2, int var3);

        public int getTextSelectionStart(Object var1);

        public int getTextSelectionEnd(Object var1);

        public Object getWindow(Object var1);

        public boolean isDismissable(Object var1);

        public void setDismissable(Object var1, boolean var2);

        public boolean isEditable(Object var1);

        public void setEditable(Object var1, boolean var2);

        public boolean isMultiLine(Object var1);

        public void setMultiLine(Object var1, boolean var2);

        public boolean refresh(Object var1);
    }

    public static class AccessibilityActionCompat {
        public static final AccessibilityActionCompat ACTION_FOCUS = new AccessibilityActionCompat(1, null);
        public static final AccessibilityActionCompat ACTION_CLEAR_FOCUS = new AccessibilityActionCompat(2, null);
        public static final AccessibilityActionCompat ACTION_SELECT = new AccessibilityActionCompat(4, null);
        public static final AccessibilityActionCompat ACTION_CLEAR_SELECTION = new AccessibilityActionCompat(8, null);
        public static final AccessibilityActionCompat ACTION_CLICK = new AccessibilityActionCompat(16, null);
        public static final AccessibilityActionCompat ACTION_LONG_CLICK = new AccessibilityActionCompat(32, null);
        public static final AccessibilityActionCompat ACTION_ACCESSIBILITY_FOCUS = new AccessibilityActionCompat(64, null);
        public static final AccessibilityActionCompat ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityActionCompat(128, null);
        public static final AccessibilityActionCompat ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityActionCompat(256, null);
        public static final AccessibilityActionCompat ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityActionCompat(512, null);
        public static final AccessibilityActionCompat ACTION_NEXT_HTML_ELEMENT = new AccessibilityActionCompat(1024, null);
        public static final AccessibilityActionCompat ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityActionCompat(2048, null);
        public static final AccessibilityActionCompat ACTION_SCROLL_FORWARD = new AccessibilityActionCompat(4096, null);
        public static final AccessibilityActionCompat ACTION_SCROLL_BACKWARD = new AccessibilityActionCompat(8192, null);
        public static final AccessibilityActionCompat ACTION_COPY = new AccessibilityActionCompat(16384, null);
        public static final AccessibilityActionCompat ACTION_PASTE = new AccessibilityActionCompat(32768, null);
        public static final AccessibilityActionCompat ACTION_CUT = new AccessibilityActionCompat(65536, null);
        public static final AccessibilityActionCompat ACTION_SET_SELECTION = new AccessibilityActionCompat(131072, null);
        public static final AccessibilityActionCompat ACTION_EXPAND = new AccessibilityActionCompat(262144, null);
        public static final AccessibilityActionCompat ACTION_COLLAPSE = new AccessibilityActionCompat(524288, null);
        public static final AccessibilityActionCompat ACTION_DISMISS = new AccessibilityActionCompat(0x100000, null);
        public static final AccessibilityActionCompat ACTION_SET_TEXT = new AccessibilityActionCompat(0x200000, null);
        private final Object mAction;

        public AccessibilityActionCompat(int n5, CharSequence charSequence) {
            this(IMPL.newAccessibilityAction(n5, charSequence));
        }

        private AccessibilityActionCompat(Object object) {
            this.mAction = object;
        }

        public int getId() {
            return IMPL.getAccessibilityActionId(this.mAction);
        }

        public CharSequence getLabel() {
            return IMPL.getAccessibilityActionLabel(this.mAction);
        }
    }

    public static class CollectionInfoCompat {
        public static final int SELECTION_MODE_NONE = 0;
        public static final int SELECTION_MODE_SINGLE = 1;
        public static final int SELECTION_MODE_MULTIPLE = 2;
        final Object mInfo;

        public static CollectionInfoCompat obtain(int n5, int n6, boolean bl, int n7) {
            return new CollectionInfoCompat(IMPL.obtainCollectionInfo(n5, n6, bl, n7));
        }

        private CollectionInfoCompat(Object object) {
            this.mInfo = object;
        }

        public int getColumnCount() {
            return IMPL.getCollectionInfoColumnCount(this.mInfo);
        }

        public int getRowCount() {
            return IMPL.getCollectionInfoRowCount(this.mInfo);
        }

        public boolean isHierarchical() {
            return IMPL.isCollectionInfoHierarchical(this.mInfo);
        }
    }

    public static class CollectionItemInfoCompat {
        private final Object mInfo;

        public static CollectionItemInfoCompat obtain(int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
            return new CollectionItemInfoCompat(IMPL.obtainCollectionItemInfo(n5, n6, n7, n8, bl, bl2));
        }

        private CollectionItemInfoCompat(Object object) {
            this.mInfo = object;
        }

        public int getColumnIndex() {
            return IMPL.getCollectionItemColumnIndex(this.mInfo);
        }

        public int getColumnSpan() {
            return IMPL.getCollectionItemColumnSpan(this.mInfo);
        }

        public int getRowIndex() {
            return IMPL.getCollectionItemRowIndex(this.mInfo);
        }

        public int getRowSpan() {
            return IMPL.getCollectionItemRowSpan(this.mInfo);
        }

        public boolean isHeading() {
            return IMPL.isCollectionItemHeading(this.mInfo);
        }

        public boolean isSelected() {
            return IMPL.isCollectionItemSelected(this.mInfo);
        }
    }

    public static class RangeInfoCompat {
        public static final int RANGE_TYPE_INT = 0;
        public static final int RANGE_TYPE_FLOAT = 1;
        public static final int RANGE_TYPE_PERCENT = 2;
        private final Object mInfo;

        private RangeInfoCompat(Object object) {
            this.mInfo = object;
        }

        public float getCurrent() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getCurrent(this.mInfo);
        }

        public float getMax() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getMax(this.mInfo);
        }

        public float getMin() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getMin(this.mInfo);
        }

        public int getType() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getType(this.mInfo);
        }
    }

    static class AccessibilityNodeInfoApi22Impl
    extends AccessibilityNodeInfoApi21Impl {
        AccessibilityNodeInfoApi22Impl() {
        }

        @Override
        public Object getTraversalBefore(Object object) {
            return AccessibilityNodeInfoCompatApi22.getTraversalBefore(object);
        }

        @Override
        public void setTraversalBefore(Object object, View view) {
            AccessibilityNodeInfoCompatApi22.setTraversalBefore(object, view);
        }

        @Override
        public void setTraversalBefore(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatApi22.setTraversalBefore(object, view, n5);
        }

        @Override
        public Object getTraversalAfter(Object object) {
            return AccessibilityNodeInfoCompatApi22.getTraversalAfter(object);
        }

        @Override
        public void setTraversalAfter(Object object, View view) {
            AccessibilityNodeInfoCompatApi22.setTraversalAfter(object, view);
        }

        @Override
        public void setTraversalAfter(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatApi22.setTraversalAfter(object, view, n5);
        }
    }

    static class AccessibilityNodeInfoApi21Impl
    extends AccessibilityNodeInfoKitKatImpl {
        AccessibilityNodeInfoApi21Impl() {
        }

        @Override
        public Object newAccessibilityAction(int n5, CharSequence charSequence) {
            return AccessibilityNodeInfoCompatApi21.newAccessibilityAction(n5, charSequence);
        }

        @Override
        public List<Object> getActionList(Object object) {
            return AccessibilityNodeInfoCompatApi21.getActionList(object);
        }

        @Override
        public Object obtainCollectionInfo(int n5, int n6, boolean bl, int n7) {
            return AccessibilityNodeInfoCompatApi21.obtainCollectionInfo(n5, n6, bl, n7);
        }

        @Override
        public void addAction(Object object, Object object2) {
            AccessibilityNodeInfoCompatApi21.addAction(object, object2);
        }

        @Override
        public boolean removeAction(Object object, Object object2) {
            return AccessibilityNodeInfoCompatApi21.removeAction(object, object2);
        }

        @Override
        public int getAccessibilityActionId(Object object) {
            return AccessibilityNodeInfoCompatApi21.getAccessibilityActionId(object);
        }

        @Override
        public CharSequence getAccessibilityActionLabel(Object object) {
            return AccessibilityNodeInfoCompatApi21.getAccessibilityActionLabel(object);
        }

        @Override
        public Object obtainCollectionItemInfo(int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
            return AccessibilityNodeInfoCompatApi21.obtainCollectionItemInfo(n5, n6, n7, n8, bl, bl2);
        }

        @Override
        public boolean isCollectionItemSelected(Object object) {
            return AccessibilityNodeInfoCompatApi21.CollectionItemInfo.isSelected(object);
        }

        @Override
        public CharSequence getError(Object object) {
            return AccessibilityNodeInfoCompatApi21.getError(object);
        }

        @Override
        public void setError(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatApi21.setError(object, charSequence);
        }

        @Override
        public void setMaxTextLength(Object object, int n5) {
            AccessibilityNodeInfoCompatApi21.setMaxTextLength(object, n5);
        }

        @Override
        public int getMaxTextLength(Object object) {
            return AccessibilityNodeInfoCompatApi21.getMaxTextLength(object);
        }

        @Override
        public Object getWindow(Object object) {
            return AccessibilityNodeInfoCompatApi21.getWindow(object);
        }

        @Override
        public boolean removeChild(Object object, View view) {
            return AccessibilityNodeInfoCompatApi21.removeChild(object, view);
        }

        @Override
        public boolean removeChild(Object object, View view, int n5) {
            return AccessibilityNodeInfoCompatApi21.removeChild(object, view, n5);
        }
    }

    static class AccessibilityNodeInfoKitKatImpl
    extends AccessibilityNodeInfoJellybeanMr2Impl {
        AccessibilityNodeInfoKitKatImpl() {
        }

        @Override
        public int getLiveRegion(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getLiveRegion(object);
        }

        @Override
        public void setLiveRegion(Object object, int n5) {
            AccessibilityNodeInfoCompatKitKat.setLiveRegion(object, n5);
        }

        @Override
        public Object getCollectionInfo(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getCollectionInfo(object);
        }

        @Override
        public void setCollectionInfo(Object object, Object object2) {
            AccessibilityNodeInfoCompatKitKat.setCollectionInfo(object, object2);
        }

        @Override
        public Object obtainCollectionInfo(int n5, int n6, boolean bl, int n7) {
            return AccessibilityNodeInfoCompatKitKat.obtainCollectionInfo(n5, n6, bl, n7);
        }

        @Override
        public Object obtainCollectionItemInfo(int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
            return AccessibilityNodeInfoCompatKitKat.obtainCollectionItemInfo(n5, n6, n7, n8, bl);
        }

        @Override
        public int getCollectionInfoColumnCount(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionInfo.getColumnCount(object);
        }

        @Override
        public int getCollectionInfoRowCount(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionInfo.getRowCount(object);
        }

        @Override
        public boolean isCollectionInfoHierarchical(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionInfo.isHierarchical(object);
        }

        @Override
        public Object getCollectionItemInfo(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getCollectionItemInfo(object);
        }

        @Override
        public Object getRangeInfo(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getRangeInfo(object);
        }

        @Override
        public void setRangeInfo(Object object, Object object2) {
            AccessibilityNodeInfoCompatKitKat.setRangeInfo(object, object2);
        }

        @Override
        public int getCollectionItemColumnIndex(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getColumnIndex(object);
        }

        @Override
        public int getCollectionItemColumnSpan(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getColumnSpan(object);
        }

        @Override
        public int getCollectionItemRowIndex(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getRowIndex(object);
        }

        @Override
        public int getCollectionItemRowSpan(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getRowSpan(object);
        }

        @Override
        public boolean isCollectionItemHeading(Object object) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.isHeading(object);
        }

        @Override
        public void setCollectionItemInfo(Object object, Object object2) {
            AccessibilityNodeInfoCompatKitKat.setCollectionItemInfo(object, object2);
        }

        @Override
        public void setContentInvalid(Object object, boolean bl) {
            AccessibilityNodeInfoCompatKitKat.setContentInvalid(object, bl);
        }

        @Override
        public boolean isContentInvalid(Object object) {
            return AccessibilityNodeInfoCompatKitKat.isContentInvalid(object);
        }

        @Override
        public boolean canOpenPopup(Object object) {
            return AccessibilityNodeInfoCompatKitKat.canOpenPopup(object);
        }

        @Override
        public void setCanOpenPopup(Object object, boolean bl) {
            AccessibilityNodeInfoCompatKitKat.setCanOpenPopup(object, bl);
        }

        @Override
        public Bundle getExtras(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getExtras(object);
        }

        @Override
        public int getInputType(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getInputType(object);
        }

        @Override
        public void setInputType(Object object, int n5) {
            AccessibilityNodeInfoCompatKitKat.setInputType(object, n5);
        }

        @Override
        public boolean isDismissable(Object object) {
            return AccessibilityNodeInfoCompatKitKat.isDismissable(object);
        }

        @Override
        public void setDismissable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatKitKat.setDismissable(object, bl);
        }

        @Override
        public boolean isMultiLine(Object object) {
            return AccessibilityNodeInfoCompatKitKat.isMultiLine(object);
        }

        @Override
        public void setMultiLine(Object object, boolean bl) {
            AccessibilityNodeInfoCompatKitKat.setMultiLine(object, bl);
        }
    }

    static class AccessibilityNodeInfoJellybeanMr2Impl
    extends AccessibilityNodeInfoJellybeanMr1Impl {
        AccessibilityNodeInfoJellybeanMr2Impl() {
        }

        @Override
        public String getViewIdResourceName(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getViewIdResourceName(object);
        }

        @Override
        public void setViewIdResourceName(Object object, String string2) {
            AccessibilityNodeInfoCompatJellybeanMr2.setViewIdResourceName(object, string2);
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByViewId(Object object, String string2) {
            return AccessibilityNodeInfoCompatJellybeanMr2.findAccessibilityNodeInfosByViewId(object, string2);
        }

        @Override
        public void setTextSelection(Object object, int n5, int n6) {
            AccessibilityNodeInfoCompatJellybeanMr2.setTextSelection(object, n5, n6);
        }

        @Override
        public int getTextSelectionStart(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getTextSelectionStart(object);
        }

        @Override
        public int getTextSelectionEnd(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getTextSelectionEnd(object);
        }

        @Override
        public boolean isEditable(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr2.isEditable(object);
        }

        @Override
        public void setEditable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatJellybeanMr2.setEditable(object, bl);
        }

        @Override
        public boolean refresh(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr2.refresh(object);
        }
    }

    static class AccessibilityNodeInfoJellybeanMr1Impl
    extends AccessibilityNodeInfoJellybeanImpl {
        AccessibilityNodeInfoJellybeanMr1Impl() {
        }

        @Override
        public void setLabelFor(Object object, View view) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabelFor(object, view);
        }

        @Override
        public void setLabelFor(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabelFor(object, view, n5);
        }

        @Override
        public Object getLabelFor(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr1.getLabelFor(object);
        }

        @Override
        public void setLabeledBy(Object object, View view) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabeledBy(object, view);
        }

        @Override
        public void setLabeledBy(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabeledBy(object, view, n5);
        }

        @Override
        public Object getLabeledBy(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr1.getLabeledBy(object);
        }
    }

    static class AccessibilityNodeInfoJellybeanImpl
    extends AccessibilityNodeInfoIcsImpl {
        AccessibilityNodeInfoJellybeanImpl() {
        }

        @Override
        public Object obtain(View view, int n5) {
            return AccessibilityNodeInfoCompatJellyBean.obtain(view, n5);
        }

        @Override
        public Object findFocus(Object object, int n5) {
            return AccessibilityNodeInfoCompatJellyBean.findFocus(object, n5);
        }

        @Override
        public Object focusSearch(Object object, int n5) {
            return AccessibilityNodeInfoCompatJellyBean.focusSearch(object, n5);
        }

        @Override
        public void addChild(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatJellyBean.addChild(object, view, n5);
        }

        @Override
        public void setSource(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatJellyBean.setSource(object, view, n5);
        }

        @Override
        public boolean isVisibleToUser(Object object) {
            return AccessibilityNodeInfoCompatJellyBean.isVisibleToUser(object);
        }

        @Override
        public void setVisibleToUser(Object object, boolean bl) {
            AccessibilityNodeInfoCompatJellyBean.setVisibleToUser(object, bl);
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return AccessibilityNodeInfoCompatJellyBean.isAccessibilityFocused(object);
        }

        @Override
        public void setAccessibilityFocused(Object object, boolean bl) {
            AccessibilityNodeInfoCompatJellyBean.setAccesibilityFocused(object, bl);
        }

        @Override
        public boolean performAction(Object object, int n5, Bundle bundle) {
            return AccessibilityNodeInfoCompatJellyBean.performAction(object, n5, bundle);
        }

        @Override
        public void setMovementGranularities(Object object, int n5) {
            AccessibilityNodeInfoCompatJellyBean.setMovementGranularities(object, n5);
        }

        @Override
        public int getMovementGranularities(Object object) {
            return AccessibilityNodeInfoCompatJellyBean.getMovementGranularities(object);
        }

        @Override
        public void setParent(Object object, View view, int n5) {
            AccessibilityNodeInfoCompatJellyBean.setParent(object, view, n5);
        }
    }

    static class AccessibilityNodeInfoIcsImpl
    extends AccessibilityNodeInfoStubImpl {
        AccessibilityNodeInfoIcsImpl() {
        }

        @Override
        public Object obtain() {
            return AccessibilityNodeInfoCompatIcs.obtain();
        }

        @Override
        public Object obtain(View view) {
            return AccessibilityNodeInfoCompatIcs.obtain(view);
        }

        @Override
        public Object obtain(Object object) {
            return AccessibilityNodeInfoCompatIcs.obtain(object);
        }

        @Override
        public void addAction(Object object, int n5) {
            AccessibilityNodeInfoCompatIcs.addAction(object, n5);
        }

        @Override
        public void addChild(Object object, View view) {
            AccessibilityNodeInfoCompatIcs.addChild(object, view);
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByText(Object object, String string2) {
            return AccessibilityNodeInfoCompatIcs.findAccessibilityNodeInfosByText(object, string2);
        }

        @Override
        public int getActions(Object object) {
            return AccessibilityNodeInfoCompatIcs.getActions(object);
        }

        @Override
        public void getBoundsInParent(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.getBoundsInParent(object, rect);
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.getBoundsInScreen(object, rect);
        }

        @Override
        public Object getChild(Object object, int n5) {
            return AccessibilityNodeInfoCompatIcs.getChild(object, n5);
        }

        @Override
        public int getChildCount(Object object) {
            return AccessibilityNodeInfoCompatIcs.getChildCount(object);
        }

        @Override
        public CharSequence getClassName(Object object) {
            return AccessibilityNodeInfoCompatIcs.getClassName(object);
        }

        @Override
        public CharSequence getContentDescription(Object object) {
            return AccessibilityNodeInfoCompatIcs.getContentDescription(object);
        }

        @Override
        public CharSequence getPackageName(Object object) {
            return AccessibilityNodeInfoCompatIcs.getPackageName(object);
        }

        @Override
        public Object getParent(Object object) {
            return AccessibilityNodeInfoCompatIcs.getParent(object);
        }

        @Override
        public CharSequence getText(Object object) {
            return AccessibilityNodeInfoCompatIcs.getText(object);
        }

        @Override
        public int getWindowId(Object object) {
            return AccessibilityNodeInfoCompatIcs.getWindowId(object);
        }

        @Override
        public boolean isCheckable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isCheckable(object);
        }

        @Override
        public boolean isChecked(Object object) {
            return AccessibilityNodeInfoCompatIcs.isChecked(object);
        }

        @Override
        public boolean isClickable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isClickable(object);
        }

        @Override
        public boolean isEnabled(Object object) {
            return AccessibilityNodeInfoCompatIcs.isEnabled(object);
        }

        @Override
        public boolean isFocusable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isFocusable(object);
        }

        @Override
        public boolean isFocused(Object object) {
            return AccessibilityNodeInfoCompatIcs.isFocused(object);
        }

        @Override
        public boolean isLongClickable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isLongClickable(object);
        }

        @Override
        public boolean isPassword(Object object) {
            return AccessibilityNodeInfoCompatIcs.isPassword(object);
        }

        @Override
        public boolean isScrollable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isScrollable(object);
        }

        @Override
        public boolean isSelected(Object object) {
            return AccessibilityNodeInfoCompatIcs.isSelected(object);
        }

        @Override
        public boolean performAction(Object object, int n5) {
            return AccessibilityNodeInfoCompatIcs.performAction(object, n5);
        }

        @Override
        public void setBoundsInParent(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.setBoundsInParent(object, rect);
        }

        @Override
        public void setBoundsInScreen(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.setBoundsInScreen(object, rect);
        }

        @Override
        public void setCheckable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setCheckable(object, bl);
        }

        @Override
        public void setChecked(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setChecked(object, bl);
        }

        @Override
        public void setClassName(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setClassName(object, charSequence);
        }

        @Override
        public void setClickable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setClickable(object, bl);
        }

        @Override
        public void setContentDescription(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setContentDescription(object, charSequence);
        }

        @Override
        public void setEnabled(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setEnabled(object, bl);
        }

        @Override
        public void setFocusable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setFocusable(object, bl);
        }

        @Override
        public void setFocused(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setFocused(object, bl);
        }

        @Override
        public void setLongClickable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setLongClickable(object, bl);
        }

        @Override
        public void setPackageName(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setPackageName(object, charSequence);
        }

        @Override
        public void setParent(Object object, View view) {
            AccessibilityNodeInfoCompatIcs.setParent(object, view);
        }

        @Override
        public void setPassword(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setPassword(object, bl);
        }

        @Override
        public void setScrollable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setScrollable(object, bl);
        }

        @Override
        public void setSelected(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setSelected(object, bl);
        }

        @Override
        public void setSource(Object object, View view) {
            AccessibilityNodeInfoCompatIcs.setSource(object, view);
        }

        @Override
        public void setText(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setText(object, charSequence);
        }

        @Override
        public void recycle(Object object) {
            AccessibilityNodeInfoCompatIcs.recycle(object);
        }
    }

    static class AccessibilityNodeInfoStubImpl
    implements AccessibilityNodeInfoImpl {
        AccessibilityNodeInfoStubImpl() {
        }

        @Override
        public Object newAccessibilityAction(int n5, CharSequence charSequence) {
            return null;
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(View view) {
            return null;
        }

        @Override
        public Object obtain(View view, int n5) {
            return null;
        }

        @Override
        public Object obtain(Object object) {
            return null;
        }

        @Override
        public void addAction(Object object, int n5) {
        }

        @Override
        public void addAction(Object object, Object object2) {
        }

        @Override
        public boolean removeAction(Object object, Object object2) {
            return false;
        }

        @Override
        public int getAccessibilityActionId(Object object) {
            return 0;
        }

        @Override
        public CharSequence getAccessibilityActionLabel(Object object) {
            return null;
        }

        @Override
        public void addChild(Object object, View view) {
        }

        @Override
        public void addChild(Object object, View view, int n5) {
        }

        @Override
        public boolean removeChild(Object object, View view) {
            return false;
        }

        @Override
        public boolean removeChild(Object object, View view, int n5) {
            return false;
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByText(Object object, String string2) {
            return Collections.emptyList();
        }

        @Override
        public int getActions(Object object) {
            return 0;
        }

        @Override
        public void getBoundsInParent(Object object, Rect rect) {
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
        }

        @Override
        public Object getChild(Object object, int n5) {
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            return 0;
        }

        @Override
        public CharSequence getClassName(Object object) {
            return null;
        }

        @Override
        public CharSequence getContentDescription(Object object) {
            return null;
        }

        @Override
        public CharSequence getPackageName(Object object) {
            return null;
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public CharSequence getText(Object object) {
            return null;
        }

        @Override
        public int getWindowId(Object object) {
            return 0;
        }

        @Override
        public boolean isCheckable(Object object) {
            return false;
        }

        @Override
        public boolean isChecked(Object object) {
            return false;
        }

        @Override
        public boolean isClickable(Object object) {
            return false;
        }

        @Override
        public boolean isEnabled(Object object) {
            return false;
        }

        @Override
        public boolean isFocusable(Object object) {
            return false;
        }

        @Override
        public boolean isFocused(Object object) {
            return false;
        }

        @Override
        public boolean isVisibleToUser(Object object) {
            return false;
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return false;
        }

        @Override
        public boolean isLongClickable(Object object) {
            return false;
        }

        @Override
        public boolean isPassword(Object object) {
            return false;
        }

        @Override
        public boolean isScrollable(Object object) {
            return false;
        }

        @Override
        public boolean isSelected(Object object) {
            return false;
        }

        @Override
        public boolean performAction(Object object, int n5) {
            return false;
        }

        @Override
        public boolean performAction(Object object, int n5, Bundle bundle) {
            return false;
        }

        @Override
        public void setMovementGranularities(Object object, int n5) {
        }

        @Override
        public int getMovementGranularities(Object object) {
            return 0;
        }

        @Override
        public void setBoundsInParent(Object object, Rect rect) {
        }

        @Override
        public void setBoundsInScreen(Object object, Rect rect) {
        }

        @Override
        public void setCheckable(Object object, boolean bl) {
        }

        @Override
        public void setChecked(Object object, boolean bl) {
        }

        @Override
        public void setClassName(Object object, CharSequence charSequence) {
        }

        @Override
        public void setClickable(Object object, boolean bl) {
        }

        @Override
        public void setContentDescription(Object object, CharSequence charSequence) {
        }

        @Override
        public void setEnabled(Object object, boolean bl) {
        }

        @Override
        public void setFocusable(Object object, boolean bl) {
        }

        @Override
        public void setFocused(Object object, boolean bl) {
        }

        @Override
        public void setVisibleToUser(Object object, boolean bl) {
        }

        @Override
        public void setAccessibilityFocused(Object object, boolean bl) {
        }

        @Override
        public void setLongClickable(Object object, boolean bl) {
        }

        @Override
        public void setPackageName(Object object, CharSequence charSequence) {
        }

        @Override
        public void setParent(Object object, View view) {
        }

        @Override
        public void setPassword(Object object, boolean bl) {
        }

        @Override
        public void setScrollable(Object object, boolean bl) {
        }

        @Override
        public void setSelected(Object object, boolean bl) {
        }

        @Override
        public void setSource(Object object, View view) {
        }

        @Override
        public void setSource(Object object, View view, int n5) {
        }

        @Override
        public Object findFocus(Object object, int n5) {
            return null;
        }

        @Override
        public Object focusSearch(Object object, int n5) {
            return null;
        }

        @Override
        public void setText(Object object, CharSequence charSequence) {
        }

        @Override
        public void recycle(Object object) {
        }

        @Override
        public void setParent(Object object, View view, int n5) {
        }

        @Override
        public String getViewIdResourceName(Object object) {
            return null;
        }

        @Override
        public void setViewIdResourceName(Object object, String string2) {
        }

        @Override
        public int getLiveRegion(Object object) {
            return 0;
        }

        @Override
        public void setLiveRegion(Object object, int n5) {
        }

        @Override
        public Object getCollectionInfo(Object object) {
            return null;
        }

        @Override
        public void setCollectionInfo(Object object, Object object2) {
        }

        @Override
        public Object getCollectionItemInfo(Object object) {
            return null;
        }

        @Override
        public void setCollectionItemInfo(Object object, Object object2) {
        }

        @Override
        public Object getRangeInfo(Object object) {
            return null;
        }

        @Override
        public void setRangeInfo(Object object, Object object2) {
        }

        @Override
        public List<Object> getActionList(Object object) {
            return null;
        }

        @Override
        public Object obtainCollectionInfo(int n5, int n6, boolean bl, int n7) {
            return null;
        }

        @Override
        public int getCollectionInfoColumnCount(Object object) {
            return 0;
        }

        @Override
        public int getCollectionInfoRowCount(Object object) {
            return 0;
        }

        @Override
        public boolean isCollectionInfoHierarchical(Object object) {
            return false;
        }

        @Override
        public Object obtainCollectionItemInfo(int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
            return null;
        }

        @Override
        public int getCollectionItemColumnIndex(Object object) {
            return 0;
        }

        @Override
        public int getCollectionItemColumnSpan(Object object) {
            return 0;
        }

        @Override
        public int getCollectionItemRowIndex(Object object) {
            return 0;
        }

        @Override
        public int getCollectionItemRowSpan(Object object) {
            return 0;
        }

        @Override
        public boolean isCollectionItemHeading(Object object) {
            return false;
        }

        @Override
        public boolean isCollectionItemSelected(Object object) {
            return false;
        }

        @Override
        public Object getTraversalBefore(Object object) {
            return null;
        }

        @Override
        public void setTraversalBefore(Object object, View view) {
        }

        @Override
        public void setTraversalBefore(Object object, View view, int n5) {
        }

        @Override
        public Object getTraversalAfter(Object object) {
            return null;
        }

        @Override
        public void setTraversalAfter(Object object, View view) {
        }

        @Override
        public void setTraversalAfter(Object object, View view, int n5) {
        }

        @Override
        public void setContentInvalid(Object object, boolean bl) {
        }

        @Override
        public boolean isContentInvalid(Object object) {
            return false;
        }

        @Override
        public void setError(Object object, CharSequence charSequence) {
        }

        @Override
        public CharSequence getError(Object object) {
            return null;
        }

        @Override
        public void setLabelFor(Object object, View view) {
        }

        @Override
        public void setLabelFor(Object object, View view, int n5) {
        }

        @Override
        public Object getLabelFor(Object object) {
            return null;
        }

        @Override
        public void setLabeledBy(Object object, View view) {
        }

        @Override
        public void setLabeledBy(Object object, View view, int n5) {
        }

        @Override
        public Object getLabeledBy(Object object) {
            return null;
        }

        @Override
        public boolean canOpenPopup(Object object) {
            return false;
        }

        @Override
        public void setCanOpenPopup(Object object, boolean bl) {
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByViewId(Object object, String string2) {
            return Collections.emptyList();
        }

        @Override
        public Bundle getExtras(Object object) {
            return new Bundle();
        }

        @Override
        public int getInputType(Object object) {
            return 0;
        }

        @Override
        public void setInputType(Object object, int n5) {
        }

        @Override
        public void setMaxTextLength(Object object, int n5) {
        }

        @Override
        public int getMaxTextLength(Object object) {
            return -1;
        }

        @Override
        public void setTextSelection(Object object, int n5, int n6) {
        }

        @Override
        public int getTextSelectionStart(Object object) {
            return -1;
        }

        @Override
        public int getTextSelectionEnd(Object object) {
            return -1;
        }

        @Override
        public Object getWindow(Object object) {
            return null;
        }

        @Override
        public boolean isDismissable(Object object) {
            return false;
        }

        @Override
        public void setDismissable(Object object, boolean bl) {
        }

        @Override
        public boolean isEditable(Object object) {
            return false;
        }

        @Override
        public void setEditable(Object object, boolean bl) {
        }

        @Override
        public boolean isMultiLine(Object object) {
            return false;
        }

        @Override
        public void setMultiLine(Object object, boolean bl) {
        }

        @Override
        public boolean refresh(Object object) {
            return false;
        }
    }
}

