/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import com.dcloud.android.annotation.ColorInt;
import com.dcloud.android.annotation.ColorRes;
import com.dcloud.android.v4.view.MotionEventCompat;
import com.dcloud.android.v4.view.NestedScrollingChild;
import com.dcloud.android.v4.view.NestedScrollingChildHelper;
import com.dcloud.android.v4.view.NestedScrollingParent;
import com.dcloud.android.v4.view.NestedScrollingParentHelper;
import com.dcloud.android.v4.view.ViewCompat;
import com.dcloud.android.v4.widget.CircleImageView;
import com.dcloud.android.v4.widget.IRefreshAble;
import com.dcloud.android.v4.widget.MaterialProgressDrawable;
import io.dcloud.common.util.PdrUtil;
import org.json.JSONObject;

public class SwipeRefreshLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild,
IRefreshAble {
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    private static final String LOG_TAG = "SwipeRefreshLayout";
    private static final int MAX_ALPHA = 255;
    private static final int STARTING_PROGRESS_ALPHA = 76;
    private static final int CIRCLE_DIAMETER = 40;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 0.5f;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private static final int SCALE_DOWN_DURATION = 150;
    private static final int ALPHA_ANIMATION_DURATION = 300;
    private static final int ANIMATE_TO_TRIGGER_DURATION = 200;
    private static final int ANIMATE_TO_START_DURATION = 200;
    private static final int CIRCLE_BG_LIGHT = -328966;
    private static final int DEFAULT_CIRCLE_TARGET = 64;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    static final int PULL_BOTTOM = -1;
    static final int PULL_DEGREE_GAP = 40;
    private View mTarget;
    private IRefreshAble.OnRefreshListener mListener;
    private boolean mRefreshing = false;
    private int mTouchSlop;
    private float mTotalDragDistance = -1.0f;
    private float mTotalUnconsumed;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed = new int[2];
    private int mMediumAnimationDuration;
    private int mCurrentTargetOffsetTop;
    private boolean mOriginalOffsetCalculated = false;
    private float mInitialMotionY;
    private float mInitialDownY;
    private float mInitialDownX;
    private boolean mIsBeingDragged = false;
    private boolean mScale;
    private boolean mReturningToStart;
    private final DecelerateInterpolator mDecelerateInterpolator;
    private CircleImageView mCircleView;
    private int mCircleViewIndex = -1;
    protected int mFrom;
    private float mStartingScale;
    protected int mOriginalOffsetTop;
    private MaterialProgressDrawable mProgress;
    private Animation mScaleAnimation;
    private Animation mScaleDownAnimation;
    private Animation mAlphaStartAnimation;
    private Animation mAlphaMaxAnimation;
    private Animation mScaleDownToStartAnimation;
    private float mSpinnerFinalOffset;
    private boolean mNotify;
    private int mCircleWidth;
    private int mCircleHeight;
    private boolean mUsingCustomStart;
    private boolean mPlusRefreshing = false;
    private int F_OriginalOffsetTop;
    private float F_SpinnerFinalOffset;
    private float F_TotalDragDistance;
    private Animation.AnimationListener mRefreshListener;
    boolean mUseSys;
    boolean mBeginRefresh;
    private boolean isSetOffset;
    JSONObject mJsonData;
    View mDrawParentView;
    View mParentView;
    int mPullDirect;
    private boolean mRefreshEnable;
    boolean mHandledDown;
    private final Animation mAnimateToCorrectPosition;
    private final Animation mPeek;
    private final Animation mAnimateToStartPosition;

    private void setColorViewAlpha(int n5) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.getBackground().setAlpha(n5);
        swipeRefreshLayout.mProgress.setAlpha(n5);
    }

    public SwipeRefreshLayout(Context context, AttributeSet attributeSet, boolean bl) {
        super(context);
        NestedScrollingChildHelper nestedScrollingChildHelper;
        NestedScrollingParentHelper nestedScrollingParentHelper;
        float f5;
        DecelerateInterpolator decelerateInterpolator;
        Animation animation;
        Animation animation2;
        Animation animation3;
        Animation.AnimationListener animationListener;
        Object object = animationListener;
        animationListener = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
                SwipeRefreshLayout.this.parentInvalidate();
            }

            public void onAnimationEnd(Animation object) {
                if (SwipeRefreshLayout.this.mRefreshing) {
                    1 v02 = this;
                    v02.SwipeRefreshLayout.this.mProgress.setAlpha(255);
                    v02.SwipeRefreshLayout.this.mProgress.start();
                    SwipeRefreshLayout.access$302(v02.SwipeRefreshLayout.this, true);
                    if (v02.SwipeRefreshLayout.this.mNotify && SwipeRefreshLayout.this.mListener != null) {
                        SwipeRefreshLayout.this.mListener.onRefresh(3);
                    }
                } else {
                    1 v12 = this;
                    v12.SwipeRefreshLayout.this.mProgress.stop();
                    SwipeRefreshLayout.access$302(v12.SwipeRefreshLayout.this, false);
                    v12.SwipeRefreshLayout.this.mCircleView.setVisibility(8);
                    v12.SwipeRefreshLayout.this.setColorViewAlpha(255);
                    if (v12.SwipeRefreshLayout.this.mScale) {
                        SwipeRefreshLayout.this.setAnimationProgress(0.0f);
                    } else {
                        object = SwipeRefreshLayout.this;
                        ((SwipeRefreshLayout)object).setTargetOffsetTopAndBottom(object.mOriginalOffsetTop - ((SwipeRefreshLayout)object).mCurrentTargetOffsetTop, true);
                    }
                }
                SwipeRefreshLayout swipeRefreshLayout = SwipeRefreshLayout.this;
                SwipeRefreshLayout.access$1002(swipeRefreshLayout, swipeRefreshLayout.mCircleView.getTop());
            }
        };
        this.mRefreshListener = object;
        this.mUseSys = false;
        this.mBeginRefresh = false;
        this.isSetOffset = false;
        this.mJsonData = null;
        this.mDrawParentView = null;
        this.mParentView = null;
        this.mPullDirect = -1;
        this.mRefreshEnable = true;
        this.mHandledDown = false;
        object = animation3;
        animation3 = new Animation(){

            public void applyTransformation(float f5, Transformation transformation) {
                int n5 = !object.SwipeRefreshLayout.this.mUsingCustomStart ? (int)(object.SwipeRefreshLayout.this.mSpinnerFinalOffset - (float)Math.abs(object.SwipeRefreshLayout.this.mOriginalOffsetTop)) : (int)object.SwipeRefreshLayout.this.mSpinnerFinalOffset;
                7 v02 = object;
                Object object = v02.SwipeRefreshLayout.this;
                int n6 = ((SwipeRefreshLayout)object).mFrom;
                int n7 = n6 + (int)((float)(n5 - n6) * f5) - ((SwipeRefreshLayout)object).mCircleView.getTop();
                v02.SwipeRefreshLayout.this.setTargetOffsetTopAndBottom(n7, false);
                v02.SwipeRefreshLayout.this.mProgress.setArrowScale(1.0f - f5);
            }
        };
        this.mAnimateToCorrectPosition = object;
        object = animation2;
        animation2 = new Animation(){

            public void applyTransformation(float f5, Transformation transformation) {
                int n5 = !object.SwipeRefreshLayout.this.mUsingCustomStart ? (int)(object.SwipeRefreshLayout.this.mSpinnerFinalOffset - (float)Math.abs(object.SwipeRefreshLayout.this.mOriginalOffsetTop)) : (int)object.SwipeRefreshLayout.this.mSpinnerFinalOffset;
                8 v02 = object;
                Object object = v02.SwipeRefreshLayout.this;
                int n6 = ((SwipeRefreshLayout)object).mFrom;
                int n7 = n6 + (int)((float)(n5 - n6) * f5) - ((SwipeRefreshLayout)object).mCircleView.getTop();
                v02.SwipeRefreshLayout.this.setTargetOffsetTopAndBottom(n7, false);
                v02.SwipeRefreshLayout.this.mProgress.setArrowScale(1.0f - f5);
            }
        };
        this.mPeek = object;
        object = animation;
        animation = new Animation(){

            public void applyTransformation(float f5, Transformation transformation) {
                SwipeRefreshLayout.this.moveToStart(f5);
            }
        };
        this.mAnimateToStartPosition = object;
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mUseSys = bl;
        this.mMediumAnimationDuration = this.getResources().getInteger(0x10E0001);
        this.setWillNotDraw(false);
        DecelerateInterpolator decelerateInterpolator2 = decelerateInterpolator;
        decelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.mDecelerateInterpolator = decelerateInterpolator2;
        if (attributeSet != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.setEnabled(typedArray.getBoolean(0, true));
            typedArray.recycle();
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        float f6 = displayMetrics.density;
        this.mCircleWidth = (int)(f6 * 40.0f);
        this.mCircleHeight = (int)(f6 * 40.0f);
        this.createProgressView();
        ViewCompat.setChildrenDrawingOrderEnabled(this, true);
        this.mSpinnerFinalOffset = f5 = displayMetrics.density * 64.0f;
        this.mTotalDragDistance = f5;
        this.F_SpinnerFinalOffset = f5;
        this.F_TotalDragDistance = f5;
        Object object2 = nestedScrollingParentHelper;
        nestedScrollingParentHelper = new NestedScrollingParentHelper(this);
        this.mNestedScrollingParentHelper = object2;
        object2 = nestedScrollingChildHelper;
        nestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        this.mNestedScrollingChildHelper = object2;
        this.setNestedScrollingEnabled(true);
    }

    public SwipeRefreshLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, true);
    }

    private void createProgressView() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView = new CircleImageView(this.getContext(), -328966, 20.0f, false);
        this.mProgress = new MaterialProgressDrawable(this.getContext(), (View)this);
        this.mProgress.setBackgroundColor(-328966);
        swipeRefreshLayout.mCircleView.setImageDrawable(this.mProgress);
        swipeRefreshLayout.mCircleView.setVisibility(8);
        swipeRefreshLayout.addView((View)swipeRefreshLayout.mCircleView);
    }

    private boolean isAlphaUsedForScale() {
        return Build.VERSION.SDK_INT < 11;
    }

    private void startScaleUpAnimation(Animation.AnimationListener animationListener) {
        2 v12;
        2 var2_2;
        this.mCircleView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mProgress.setAlpha(255);
        }
        2 v02 = var2_2 = v12;
        v02();
        this.mScaleAnimation = v02;
        v12.setDuration(this.mMediumAnimationDuration);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(this.mScaleAnimation);
    }

    private void setAnimationProgress(float f5) {
        if (this.isAlphaUsedForScale()) {
            this.setColorViewAlpha((int)(f5 * 255.0f));
        } else {
            SwipeRefreshLayout swipeRefreshLayout = this;
            ViewCompat.setScaleX((View)swipeRefreshLayout.mCircleView, f5);
            ViewCompat.setScaleY((View)swipeRefreshLayout.mCircleView, f5);
        }
    }

    private void setRefreshing(boolean bl, boolean bl2) {
        if (this.mRefreshing != bl) {
            this.mNotify = bl2;
            this.ensureTarget();
            this.mRefreshing = bl;
            if (bl) {
                SwipeRefreshLayout swipeRefreshLayout = this;
                int n5 = swipeRefreshLayout.mCurrentTargetOffsetTop;
                swipeRefreshLayout.animateOffsetToCorrectPosition(n5, swipeRefreshLayout.mRefreshListener);
            } else {
                SwipeRefreshLayout swipeRefreshLayout = this;
                swipeRefreshLayout.startScaleDownAnimation(swipeRefreshLayout.mRefreshListener);
            }
        }
    }

    private void startScaleDownAnimation(Animation.AnimationListener animationListener) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        this.mScaleDownAnimation = new Animation(){

            public void applyTransformation(float f5, Transformation transformation) {
                SwipeRefreshLayout.this.setAnimationProgress(1.0f - f5);
            }
        };
        this.mScaleDownAnimation.setDuration(150L);
        swipeRefreshLayout.mCircleView.setAnimationListener(animationListener);
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(this.mScaleDownAnimation);
    }

    private void startProgressAlphaStartAnimation() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mAlphaStartAnimation = swipeRefreshLayout.startAlphaAnimation(swipeRefreshLayout.mProgress.getAlpha(), 76);
    }

    private void startProgressAlphaMaxAnimation() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mAlphaMaxAnimation = swipeRefreshLayout.startAlphaAnimation(swipeRefreshLayout.mProgress.getAlpha(), 255);
    }

    private Animation startAlphaAnimation(int n5, int n6) {
        4 v02;
        if (this.mScale && this.isAlphaUsedForScale()) {
            return null;
        }
        4 var3_3 = v02;
        SwipeRefreshLayout swipeRefreshLayout = this;
        4 v22 = var3_3;
        v22(n5, n6);
        v22.setDuration(300L);
        swipeRefreshLayout.mCircleView.setAnimationListener(null);
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(var3_3);
        return v02;
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i5 = 0; i5 < this.getChildCount(); ++i5) {
                View view = this.getChildAt(i5);
                if (view.equals((Object)this.mCircleView)) continue;
                this.mTarget = view;
                break;
            }
        }
    }

    private boolean isAnimationRunning(Animation animation) {
        return animation != null && animation.hasStarted() && !animation.hasEnded();
    }

    private void moveSpinner(float f5) {
        float f6;
        float f7 = f5;
        this.mProgress.showArrow(true);
        float f8 = Math.min(1.0f, Math.abs(f7 / this.mTotalDragDistance));
        float f9 = (float)Math.max((double)f8 - 0.4, 0.0) * 5.0f / 3.0f;
        float f10 = Math.abs(f7) - this.mTotalDragDistance;
        float f11 = this.mUsingCustomStart ? this.mSpinnerFinalOffset - (float)this.mOriginalOffsetTop : this.mSpinnerFinalOffset;
        double d6 = Math.max(0.0f, Math.min(f10, f11 * 2.0f) / f11) / 4.0f;
        f10 = (float)(d6 - Math.pow(d6, 2.0)) * 2.0f;
        float f12 = f11 * f10 * 2.0f;
        int n5 = this.mOriginalOffsetTop + (int)(f11 * f8 + f12);
        if (this.mCircleView.getVisibility() != 0) {
            this.mCircleView.setVisibility(0);
        }
        if (!this.mScale) {
            ViewCompat.setScaleX((View)this.mCircleView, 1.0f);
            ViewCompat.setScaleY((View)this.mCircleView, 1.0f);
        }
        f11 = this.mTotalDragDistance;
        if (f5 < f6) {
            if (this.mScale) {
                this.setAnimationProgress(f5 / f11);
            }
            if (this.mProgress.getAlpha() > 76 && !this.isAnimationRunning(this.mAlphaStartAnimation)) {
                this.startProgressAlphaStartAnimation();
            }
            f5 = f9 * 0.8f;
            this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, f5));
            this.mProgress.setArrowScale(Math.min(1.0f, f9));
        } else if (this.mProgress.getAlpha() < 255 && !this.isAnimationRunning(this.mAlphaMaxAnimation)) {
            this.startProgressAlphaMaxAnimation();
            this.mProgress.setStartEndTrim(0.0f, 0.8f);
            this.mProgress.setArrowScale(1.0f);
        }
        this.mProgress.setProgressRotation((f9 * 0.4f + -0.25f + f10 * 2.0f) * 0.5f);
        this.setTargetOffsetTopAndBottom((int)((float)(n5 - this.mCurrentTargetOffsetTop)), true);
    }

    private void cancelRefresh() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mRefreshing = false;
        swipeRefreshLayout.mProgress.setStartEndTrim(0.0f, 0.0f);
        Animation.AnimationListener animationListener = null;
        if (!swipeRefreshLayout.mScale) {
            Animation.AnimationListener animationListener2;
            animationListener = animationListener2;
            animationListener2 = new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (SwipeRefreshLayout.this.mCircleView != null) {
                        SwipeRefreshLayout.this.mCircleView.setVisibility(8);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            };
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.animateOffsetToStartPosition(swipeRefreshLayout2.mCurrentTargetOffsetTop, animationListener);
        swipeRefreshLayout2.mProgress.showArrow(false);
    }

    private void finishSpinner(float f5) {
        if (f5 > this.mTotalDragDistance) {
            this.setRefreshing(true, true);
        } else {
            this.cancelRefresh();
        }
    }

    private boolean isDrawAble() {
        return this.mCircleView.getVisibility() == 0 && this.mCircleView.getTop() > this.mOriginalOffsetTop - this.mCircleView.getMeasuredHeight() && (this.mParentView.getScrollY() <= 0 || this.mPlusRefreshing);
    }

    private void parentInvalidate() {
        if (this.isDrawAble() && this.mParentView != null) {
            SwipeRefreshLayout swipeRefreshLayout = this;
            Log.d((String)"parentInvalidate", (String)"parentInvalidate");
            int n5 = (swipeRefreshLayout.mParentView.getWidth() - this.mCircleWidth) / 2 + this.mParentView.getScrollX();
            int n6 = swipeRefreshLayout.mOriginalOffsetTop + this.mCircleHeight + this.mParentView.getScrollY();
            int n7 = this.mCircleView.getTop() + n6 + this.mCircleHeight;
            swipeRefreshLayout.mDrawParentView.invalidate(n5, n6, n5 += this.mCircleWidth, n7);
        }
    }

    private boolean handleTouchEvent(MotionEvent motionEvent) {
        if (this.isRefreshing()) {
            return false;
        }
        return motionEvent.getAction() == 0 || this.mHandledDown;
    }

    private void animateOffsetToCorrectPosition(int n5, Animation.AnimationListener animationListener) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mFrom = n5;
        swipeRefreshLayout.mAnimateToCorrectPosition.reset();
        swipeRefreshLayout.mAnimateToCorrectPosition.setDuration(200L);
        swipeRefreshLayout.mAnimateToCorrectPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.mCircleView.clearAnimation();
        swipeRefreshLayout2.mCircleView.startAnimation(this.mAnimateToCorrectPosition);
    }

    private void peek(int n5, Animation.AnimationListener animationListener) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mFrom = n5;
        swipeRefreshLayout.mPeek.reset();
        swipeRefreshLayout.mPeek.setDuration(500L);
        swipeRefreshLayout.mPeek.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.mCircleView.clearAnimation();
        swipeRefreshLayout2.mCircleView.startAnimation(this.mPeek);
    }

    private void animateOffsetToStartPosition(int n5, Animation.AnimationListener animationListener) {
        if (this.mScale) {
            this.startScaleDownReturnToStartAnimation(n5, animationListener);
        } else {
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.mFrom = n5;
            swipeRefreshLayout.mAnimateToStartPosition.reset();
            swipeRefreshLayout.mAnimateToStartPosition.setDuration(200L);
            swipeRefreshLayout.mAnimateToStartPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
            if (animationListener != null) {
                this.mCircleView.setAnimationListener(animationListener);
            }
            SwipeRefreshLayout swipeRefreshLayout2 = this;
            swipeRefreshLayout2.mCircleView.clearAnimation();
            swipeRefreshLayout2.mCircleView.startAnimation(this.mAnimateToStartPosition);
        }
    }

    private void moveToStart(float f5) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        int n5 = swipeRefreshLayout.mFrom;
        swipeRefreshLayout.setTargetOffsetTopAndBottom(n5 + (int)((float)(this.mOriginalOffsetTop - n5) * f5) - this.mCircleView.getTop(), false);
    }

    private void startScaleDownReturnToStartAnimation(int n5, Animation.AnimationListener animationListener) {
        10 v02;
        this.mFrom = n5;
        this.mStartingScale = this.isAlphaUsedForScale() ? (float)this.mProgress.getAlpha() : ViewCompat.getScaleX((View)this.mCircleView);
        10 var1_2 = v02;
        var1_2();
        this.mScaleDownToStartAnimation = var1_2;
        v02.setDuration(150L);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(this.mScaleDownToStartAnimation);
    }

    private void setTargetOffsetTopAndBottom(int n5, boolean bl) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.bringToFront();
        swipeRefreshLayout.mCircleView.offsetTopAndBottom(n5);
        swipeRefreshLayout.mCurrentTargetOffsetTop = swipeRefreshLayout.mCircleView.getTop();
        if (bl && Build.VERSION.SDK_INT < 11) {
            this.invalidate();
        }
    }

    static /* synthetic */ boolean access$302(SwipeRefreshLayout swipeRefreshLayout, boolean bl) {
        swipeRefreshLayout.mPlusRefreshing = bl;
        return bl;
    }

    static /* synthetic */ int access$1002(SwipeRefreshLayout swipeRefreshLayout, int n5) {
        swipeRefreshLayout.mCurrentTargetOffsetTop = n5;
        return n5;
    }

    public void setProgressViewOffset(boolean bl, int n5, int n6, int n7) {
        this.mScale = bl;
        this.mCircleView.setVisibility(8);
        this.mCurrentTargetOffsetTop = n5;
        this.mOriginalOffsetTop = n5;
        this.mSpinnerFinalOffset = n6;
        this.mTotalDragDistance = n7;
        this.mUsingCustomStart = true;
        this.mCircleView.invalidate();
    }

    public void setProgressViewEndTarget(boolean bl, int n5) {
        this.mSpinnerFinalOffset = n5;
        this.mScale = bl;
        this.mCircleView.invalidate();
    }

    public void setSize(int n5) {
        if (n5 != 0 && n5 != 1) {
            return;
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        if (n5 == 0) {
            int n6;
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.mCircleWidth = n6 = (int)(displayMetrics.density * 56.0f);
            swipeRefreshLayout.mCircleHeight = n6;
        } else {
            int n7;
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.mCircleWidth = n7 = (int)(displayMetrics.density * 40.0f);
            swipeRefreshLayout.mCircleHeight = n7;
        }
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.setImageDrawable(null);
        swipeRefreshLayout.mProgress.updateSizes(n5);
        swipeRefreshLayout.mCircleView.setImageDrawable(this.mProgress);
    }

    protected int getChildDrawingOrder(int n5, int n6) {
        int n7 = this.mCircleViewIndex;
        if (n7 < 0) {
            return n6;
        }
        if (n6 == n5 - 1) {
            return n7;
        }
        if (n6 >= n7) {
            return n6 + 1;
        }
        return n6;
    }

    public void setOnRefreshListener(IRefreshAble.OnRefreshListener onRefreshListener) {
        this.mListener = onRefreshListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshing(boolean bl) {
        if (bl && this.mRefreshing != bl) {
            void var1_4;
            this.mRefreshing = bl;
            if (!this.mUsingCustomStart) {
                int n5 = (int)(this.mSpinnerFinalOffset + (float)this.mOriginalOffsetTop);
            } else {
                int n6 = (int)this.mSpinnerFinalOffset;
            }
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.setTargetOffsetTopAndBottom((int)(var1_4 - this.mCurrentTargetOffsetTop), true);
            swipeRefreshLayout.mNotify = false;
            swipeRefreshLayout.startScaleUpAnimation(swipeRefreshLayout.mRefreshListener);
        } else {
            this.setRefreshing(bl, true);
        }
    }

    @Deprecated
    public void setProgressBackgroundColor(int n5) {
        this.setProgressBackgroundColorSchemeResource(n5);
    }

    public void setProgressBackgroundColorSchemeResource(@ColorRes int n5) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.setProgressBackgroundColorSchemeColor(swipeRefreshLayout.getResources().getColor(n5));
    }

    public void setProgressBackgroundColorSchemeColor(@ColorInt int n5) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.setBackgroundColor(n5);
        swipeRefreshLayout.mProgress.setBackgroundColor(n5);
    }

    @Deprecated
    public void setColorScheme(int ... nArray) {
        this.setColorSchemeResources(nArray);
    }

    public void setColorSchemeResources(int ... nArray) {
        Resources resources = this.getResources();
        int[] nArray2 = new int[nArray.length];
        for (int i5 = 0; i5 < nArray.length; ++i5) {
            nArray2[i5] = resources.getColor(nArray[i5]);
        }
        this.setColorSchemeColors(nArray2);
    }

    @ColorInt
    public void setColorSchemeColors(int ... nArray) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.ensureTarget();
        swipeRefreshLayout.mProgress.setColorSchemeColors(nArray);
    }

    @Override
    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    @Override
    public boolean hasRefreshOperator() {
        return this.mIsBeingDragged || this.isRefreshing();
    }

    public void setDistanceToTriggerSync(int n5) {
        this.mTotalDragDistance = n5;
    }

    protected void onLayout(boolean bl, int n5, int n6, int n7, int n8) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        int n9 = swipeRefreshLayout.getMeasuredWidth();
        swipeRefreshLayout.getMeasuredHeight();
        if (swipeRefreshLayout.getChildCount() == 0) {
            return;
        }
        if (this.mTarget == null) {
            this.ensureTarget();
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        int n10 = swipeRefreshLayout2.mCircleView.getMeasuredWidth();
        int n11 = swipeRefreshLayout2.mCircleView.getMeasuredHeight();
        int n92 = n9 / 2;
        int n12 = n10 / 2;
        n10 = n92 - n12;
        int n13 = this.mCurrentTargetOffsetTop;
        int n14 = n13 + n11;
        swipeRefreshLayout2.mCircleView.layout(n10, n13, n92 += n12, n14);
    }

    public void onMeasure(int n5, int n6) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        super.onMeasure(n5, n6);
        if (swipeRefreshLayout.mTarget == null) {
            this.ensureTarget();
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.mCircleView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mCircleWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mCircleHeight, (int)0x40000000));
        if (!swipeRefreshLayout2.mUsingCustomStart && !this.mOriginalOffsetCalculated) {
            this.mOriginalOffsetCalculated = true;
            this.mOriginalOffsetTop = n5 = -this.mCircleView.getMeasuredHeight();
            this.mCurrentTargetOffsetTop = n5;
            this.F_OriginalOffsetTop = n5;
        }
        this.mCircleViewIndex = -1;
        for (n5 = 0; n5 < this.getChildCount(); ++n5) {
            if (this.getChildAt(n5) != this.mCircleView) continue;
            this.mCircleViewIndex = n5;
            break;
        }
    }

    public int getProgressCircleDiameter() {
        Object object = object.mCircleView;
        return object != null ? object.getMeasuredHeight() : 0;
    }

    public boolean canChildScrollUp() {
        View view = swipeRefreshLayout.mTarget;
        if (view != null) {
            if (Build.VERSION.SDK_INT < 14) {
                if (view instanceof AbsListView) {
                    SwipeRefreshLayout swipeRefreshLayout = (AbsListView)view;
                    return swipeRefreshLayout.getChildCount() > 0 && (swipeRefreshLayout.getFirstVisiblePosition() > 0 || swipeRefreshLayout.getChildAt(0).getTop() < swipeRefreshLayout.getPaddingTop());
                }
                return ViewCompat.canScrollVertically(view, -1) || swipeRefreshLayout.mTarget.getScrollY() > 0;
            }
            return ViewCompat.canScrollVertically(view, -1);
        }
        return false;
    }

    @Override
    public void endRefresh() {
        this.setRefreshing(false);
    }

    @Override
    public void beginRefresh() {
        if (!this.mBeginRefresh && this.mCircleView.getVisibility() != 0) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                int offset = 0;

                @Override
                public void run() {
                    if ((float)this.offset < SwipeRefreshLayout.this.mTotalDragDistance) {
                        5 v02 = this;
                        v02.SwipeRefreshLayout.this.moveSpinner(this.offset);
                        v02.SwipeRefreshLayout.this.postDelayed(this, 1L);
                        v02.offset += 15;
                    } else {
                        SwipeRefreshLayout.this.setRefreshing(true, true);
                        SwipeRefreshLayout.this.mBeginRefresh = false;
                    }
                }
            };
            this.post(runnable2);
            this.mBeginRefresh = true;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parseData(JSONObject var1_2, int var2_4, int var3_6, float var4_7) {
        block14: {
            if (var4_7 != 0.0f && var4_7 != 1.0f) ** GOTO lbl4
            var4_7 = this.mParentView.getContext().getResources().getDisplayMetrics().density;
lbl4:
            // 2 sources

            v0 = this;
            v0.mOriginalOffsetTop = v0.F_OriginalOffsetTop;
            v0.mSpinnerFinalOffset = v0.F_SpinnerFinalOffset;
            v0.mTotalDragDistance = v0.F_TotalDragDistance;
            this.mJsonData = var1_2;
            var2_5 = var1_2.optString("offset");
            var5_8 = this.mOriginalOffsetTop;
            if (!TextUtils.isEmpty((CharSequence)var2_5)) {
                var5_8 = PdrUtil.convertToScreenInt(var2_5, var3_6, var5_8, var4_7);
            }
            ** GOTO lbl17
            {
                catch (Exception var0_1) {
                    break block14;
                }
lbl17:
                // 2 sources

                var2_5 = var1_2.optString("height");
                var6_9 = (int)this.mTotalDragDistance;
                {
                    if (!TextUtils.isEmpty((CharSequence)var2_5)) {
                        var6_9 = PdrUtil.convertToScreenInt(var2_5, var3_6, var6_9, var4_7);
                    }
                    var2_5 = var1_2.optString("range");
                }
                {
                    var7_10 = (int)this.mSpinnerFinalOffset;
                }
                {
                    if (!TextUtils.isEmpty((CharSequence)var2_5)) {
                        var7_10 = PdrUtil.convertToScreenInt(var2_5, var3_6, var7_10, var4_7);
                    }
                    var1_3 = var7_10 + var5_8;
                    var2_5 = var1_2.optString("color");
                }
                {
                    var3_6 = Color.parseColor((String)"#2BD009");
                    if (TextUtils.isEmpty((CharSequence)var2_5) || !var2_5.startsWith("#")) ** GOTO lbl34
                }
                try {
                    var3_6 = Color.parseColor((String)var2_5);
                    ** GOTO lbl34
                }
                catch (Exception v1) {}
                {
                    v1.printStackTrace();
lbl34:
                    // 3 sources

                    v2 = this;
                    v2.setColorSchemeColors(new int[]{var3_6});
                    if (v2.mOriginalOffsetTop != var5_8) {
                        this.isSetOffset = false;
                    }
                    if (this.isSetOffset != false) return;
                    this.isSetOffset = true;
                    this.setProgressViewOffset(false, var5_8, var1_3, var6_9);
                    return;
                }
            }
        }
        var0_1.printStackTrace();
    }

    @Override
    public void onResize(int n5, int n6, float f5) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.parseData(swipeRefreshLayout.mJsonData, n5, n6, f5);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        View view;
        if (!(Build.VERSION.SDK_INT < 21 && this.mTarget instanceof AbsListView || (view = this.mTarget) != null && !ViewCompat.isNestedScrollingEnabled(view))) {
            super.requestDisallowInterceptTouchEvent(bl);
        }
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n5) {
        int n6;
        if (this.isEnabled() && (n6 = n5 & 2) != 0) {
            this.startNestedScroll(n6);
            return true;
        }
        return false;
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n5) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(view, view2, n5);
        this.mTotalUnconsumed = 0.0f;
    }

    @Override
    public void onNestedPreScroll(View view, int n5, int n6, int[] nArray) {
        int n7;
        if (n6 > 0) {
            float f5;
            float f6 = ((SwipeRefreshLayout)this).mTotalUnconsumed;
            if (f5 > 0.0f) {
                float f7;
                float f8 = n6;
                if (f7 > f6) {
                    nArray[1] = n6 - (int)f6;
                    ((SwipeRefreshLayout)this).mTotalUnconsumed = 0.0f;
                } else {
                    ((SwipeRefreshLayout)this).mTotalUnconsumed = f6 - f8;
                    nArray[1] = n6;
                }
                Object object = this;
                super.moveSpinner(((SwipeRefreshLayout)object).mTotalUnconsumed);
            }
        }
        if (((SwipeRefreshLayout)this).dispatchNestedPreScroll(n7 = n5 - nArray[0], n6 - nArray[1], (int[])(this = (Object)((SwipeRefreshLayout)this).mParentScrollConsumed), null)) {
            int[] nArray2 = nArray;
            nArray2[0] = nArray[0] + this[0];
            nArray2[1] = nArray[1] + this[1];
        }
    }

    @Override
    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    @Override
    public void onStopNestedScroll(View view) {
        float f5;
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mNestedScrollingParentHelper.onStopNestedScroll(view);
        float f6 = swipeRefreshLayout.mTotalUnconsumed;
        if (f5 > 0.0f) {
            this.finishSpinner(f6);
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    @Override
    public void onNestedScroll(View view, int n5, int n6, int n7, int n8) {
        if (n8 < 0) {
            float f5;
            SwipeRefreshLayout swipeRefreshLayout = this;
            int n9 = Math.abs(n8);
            swipeRefreshLayout.mTotalUnconsumed = f5 = swipeRefreshLayout.mTotalUnconsumed + (float)n9;
            swipeRefreshLayout.moveSpinner(f5);
        }
        this.dispatchNestedScroll(n5, n6, n7, n5, null);
    }

    @Override
    public boolean onNestedPreFling(View view, float f5, float f6) {
        return false;
    }

    @Override
    public boolean onNestedFling(View view, float f5, float f6, boolean bl) {
        return false;
    }

    @Override
    public void setNestedScrollingEnabled(boolean bl) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(bl);
    }

    @Override
    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    @Override
    public boolean startNestedScroll(int n5) {
        return this.mNestedScrollingChildHelper.startNestedScroll(n5);
    }

    @Override
    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    @Override
    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    @Override
    public boolean dispatchNestedScroll(int n5, int n6, int n7, int n8, int[] nArray) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(n5, n6, n7, n8, nArray);
    }

    @Override
    public boolean dispatchNestedPreScroll(int n5, int n6, int[] nArray, int[] nArray2) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(n5, n6, nArray, nArray2);
    }

    @Override
    public boolean dispatchNestedFling(float f5, float f6, boolean bl) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(f5, f6, bl);
    }

    @Override
    public boolean dispatchNestedPreFling(float f5, float f6) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(f5, f6);
    }

    @Override
    public void onInit(ViewGroup viewGroup, View view, IRefreshAble.OnRefreshListener onRefreshListener) {
        this.mParentView = view;
        this.mDrawParentView = view;
        this.setOnRefreshListener(onRefreshListener);
        viewGroup.addView((View)this, -1, -1);
    }

    @Override
    public void setRefreshEnable(boolean bl) {
        this.mRefreshEnable = bl;
    }

    @Override
    public boolean isRefreshEnable() {
        return this.mRefreshEnable;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mUseSys) {
            super.dispatchDraw(canvas);
        } else {
            this.parentInvalidate();
        }
    }

    @Override
    public void onSelfDraw(Canvas canvas) {
        if (this.isDrawAble()) {
            Canvas canvas2 = canvas;
            SwipeRefreshLayout swipeRefreshLayout = this;
            canvas.save();
            int n5 = swipeRefreshLayout.mCircleView.getMeasuredWidth();
            int n6 = swipeRefreshLayout.mCircleView.getMeasuredHeight();
            int n7 = (swipeRefreshLayout.mParentView.getWidth() - n5) / 2 + this.mParentView.getScrollX();
            int n8 = Math.max(this.mParentView.getScrollY() - n6 + this.mCircleView.getTop(), this.mOriginalOffsetTop);
            n5 = n7 + n5;
            canvas.clipRect(n7, n8, n5, n8 + n6);
            canvas2.translate((float)this.mParentView.getScrollX(), (float)(this.mParentView.getScrollY() - n6));
            super.dispatchDraw(canvas2);
            canvas.restore();
        }
    }

    @Override
    public boolean onSelfTouchEvent(MotionEvent motionEvent) {
        boolean bl;
        block13: {
            block14: {
                block12: {
                    if (!this.handleTouchEvent(motionEvent)) {
                        return false;
                    }
                    int n5 = MotionEventCompat.getActionMasked(motionEvent);
                    bl = false;
                    if (this.mReturningToStart && n5 == 0) {
                        this.mReturningToStart = false;
                    }
                    if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp()) break block12;
                    switch (n5) {
                        default: {
                            break block13;
                        }
                        case 2: {
                            float f5;
                            float f6 = motionEvent.getY();
                            float f7 = motionEvent.getX();
                            if (f5 - this.mInitialDownY > (float)this.mTouchSlop && !this.mIsBeingDragged && Math.atan(Math.abs(f7 - this.mInitialDownX) / Math.abs(f6 - this.mInitialDownY)) * 180.0 / Math.PI < 40.0) {
                                this.mInitialMotionY = this.mInitialDownY + (float)this.mTouchSlop;
                                this.mIsBeingDragged = true;
                                this.mProgress.setAlpha(76);
                            }
                            if (this.mIsBeingDragged) {
                                float f8;
                                bl = true;
                                f7 = (f6 - this.mInitialMotionY) * 0.5f;
                                if (f8 > 0.0f) {
                                    this.moveSpinner(f7);
                                }
                            }
                            break block13;
                        }
                        case 1: 
                        case 3: {
                            float f9 = motionEvent.getY();
                            if (this.mIsBeingDragged) {
                                bl = true;
                                this.finishSpinner((f9 - this.mInitialMotionY) * 0.5f);
                            }
                            this.mInitialDownY = 0.0f;
                            this.mIsBeingDragged = false;
                            this.mHandledDown = false;
                            break block13;
                        }
                        case 0: {
                            if (this.mIsBeingDragged) break block14;
                            this.mHandledDown = true;
                            this.setTargetOffsetTopAndBottom(this.mOriginalOffsetTop - this.mCircleView.getTop(), true);
                            float f10 = motionEvent.getY();
                            if (f10 == -1.0f) break;
                            this.mInitialDownY = f10;
                            this.mInitialDownX = motionEvent.getX();
                        }
                    }
                }
                bl = false;
                break block13;
            }
            this.moveSpinner(this.mOriginalOffsetTop);
            this.mIsBeingDragged = false;
        }
        if (bl) {
            this.parentInvalidate();
        }
        return bl || this.mUseSys;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mUseSys) {
            return this.onSelfTouchEvent(motionEvent);
        }
        return false;
    }
}

