/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget.photoview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import androidx.core.view.MotionEventCompat;
import com.dcloud.android.widget.photoview.Compat;
import com.dcloud.android.widget.photoview.CustomGestureDetector;
import com.dcloud.android.widget.photoview.OnGestureListener;
import com.dcloud.android.widget.photoview.OnMatrixChangedListener;
import com.dcloud.android.widget.photoview.OnOutsidePhotoTapListener;
import com.dcloud.android.widget.photoview.OnPhotoTapListener;
import com.dcloud.android.widget.photoview.OnScaleChangedListener;
import com.dcloud.android.widget.photoview.OnSingleFlingListener;
import com.dcloud.android.widget.photoview.Util;

public class PhotoViewAttacher
implements View.OnTouchListener,
OnGestureListener,
View.OnLayoutChangeListener {
    private static float DEFAULT_MAX_SCALE = 3.0f;
    private static float DEFAULT_MID_SCALE = 1.75f;
    private static float DEFAULT_MIN_SCALE = 1.0f;
    private static int DEFAULT_ZOOM_DURATION = 200;
    private static final int EDGE_NONE = -1;
    private static final int EDGE_LEFT = 0;
    private static final int EDGE_RIGHT = 1;
    private static final int EDGE_BOTH = 2;
    private static int SINGLE_TOUCH = 1;
    private Interpolator mInterpolator;
    private int mZoomDuration;
    private float mMinScale;
    private float mMidScale;
    private float mMaxScale;
    private boolean mAllowParentInterceptOnEdge;
    private boolean mBlockParentIntercept;
    private ImageView mImageView;
    private GestureDetector mGestureDetector;
    private CustomGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix;
    private final Matrix mDrawMatrix;
    private final Matrix mSuppMatrix;
    private final RectF mDisplayRect;
    private final float[] mMatrixValues;
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private OnOutsidePhotoTapListener mOutsidePhotoTapListener;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mLongClickListener;
    private OnScaleChangedListener mScaleChangeListener;
    private OnSingleFlingListener mSingleFlingListener;
    private FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge;
    private float mBaseRotation;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType;

    public PhotoViewAttacher(ImageView imageView) {
        GestureDetector gestureDetector;
        CustomGestureDetector customGestureDetector;
        RectF rectF;
        Matrix matrix;
        Matrix matrix2;
        Matrix matrix3;
        AccelerateDecelerateInterpolator accelerateDecelerateInterpolator;
        ImageView imageView2 = imageView;
        Object object = accelerateDecelerateInterpolator;
        accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
        this.mInterpolator = object;
        this.mZoomDuration = DEFAULT_ZOOM_DURATION;
        this.mMinScale = DEFAULT_MIN_SCALE;
        this.mMidScale = DEFAULT_MID_SCALE;
        this.mMaxScale = DEFAULT_MAX_SCALE;
        this.mAllowParentInterceptOnEdge = true;
        this.mBlockParentIntercept = false;
        object = matrix3;
        matrix3 = new Matrix();
        this.mBaseMatrix = object;
        object = matrix2;
        matrix2 = new Matrix();
        this.mDrawMatrix = object;
        object = matrix;
        matrix = new Matrix();
        this.mSuppMatrix = object;
        object = rectF;
        rectF = new RectF();
        this.mDisplayRect = object;
        this.mMatrixValues = new float[9];
        this.mScrollEdge = 2;
        this.mZoomEnabled = true;
        this.mScaleType = ImageView.ScaleType.FIT_CENTER;
        this.mImageView = imageView;
        imageView2.setOnTouchListener((View.OnTouchListener)this);
        imageView2.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (imageView2.isInEditMode()) {
            return;
        }
        this.mBaseRotation = 0.0f;
        object = customGestureDetector;
        customGestureDetector = new CustomGestureDetector(imageView.getContext(), this);
        this.mScaleDragDetector = object;
        object = gestureDetector;
        this.mGestureDetector = object;
        new GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                if (PhotoViewAttacher.this.mLongClickListener != null) {
                    PhotoViewAttacher.this.mLongClickListener.onLongClick((View)PhotoViewAttacher.this.mImageView);
                }
            }

            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f5, float f6) {
                if (PhotoViewAttacher.this.mSingleFlingListener != null) {
                    if (PhotoViewAttacher.this.getScale() > DEFAULT_MIN_SCALE) {
                        return false;
                    }
                    if (MotionEventCompat.getPointerCount((MotionEvent)motionEvent) <= SINGLE_TOUCH && MotionEventCompat.getPointerCount((MotionEvent)motionEvent2) <= SINGLE_TOUCH) {
                        return PhotoViewAttacher.this.mSingleFlingListener.onFling(motionEvent, motionEvent2, f5, f6);
                    }
                    return false;
                }
                return false;
            }
        }).setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                RectF rectF;
                if (PhotoViewAttacher.this.mOnClickListener != null) {
                    PhotoViewAttacher.this.mOnClickListener.onClick((View)PhotoViewAttacher.this.mImageView);
                }
                if ((rectF = PhotoViewAttacher.this.getDisplayRect()) != null) {
                    float f5;
                    MotionEvent motionEvent2 = motionEvent;
                    float f6 = motionEvent2.getX();
                    if (rectF.contains(f6, f5 = motionEvent2.getY())) {
                        f6 = (f6 - rectF.left) / rectF.width();
                        float f7 = (f5 - rectF.top) / rectF.height();
                        if (PhotoViewAttacher.this.mPhotoTapListener != null) {
                            PhotoViewAttacher.this.mPhotoTapListener.onPhotoTap(PhotoViewAttacher.this.mImageView, f6, f7);
                        }
                        return true;
                    }
                    if (PhotoViewAttacher.this.mOutsidePhotoTapListener != null) {
                        PhotoViewAttacher.this.mOutsidePhotoTapListener.onOutsidePhotoTap(PhotoViewAttacher.this.mImageView);
                    }
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean onDoubleTap(MotionEvent motionEvent) {
                float f5;
                float f6;
                block8: {
                    float f7;
                    block7: {
                        try {
                            float f8;
                            f7 = PhotoViewAttacher.this.getScale();
                            MotionEvent motionEvent2 = motionEvent;
                            f6 = motionEvent2.getX();
                            f5 = motionEvent2.getY();
                            if (!(f8 < PhotoViewAttacher.this.getMediumScale())) break block7;
                            PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                            photoViewAttacher.setScale(photoViewAttacher.getMediumScale(), f6, f5, true);
                            return true;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            return true;
                        }
                    }
                    if (!(f7 >= PhotoViewAttacher.this.getMediumScale())) break block8;
                    if (!(f7 < PhotoViewAttacher.this.getMaximumScale())) break block8;
                    PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                    photoViewAttacher.setScale(photoViewAttacher.getMaximumScale(), f6, f5, true);
                    return true;
                }
                PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                photoViewAttacher.setScale(photoViewAttacher.getMinimumScale(), f6, f5, true);
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent motionEvent) {
                return false;
            }
        });
    }

    private Matrix getDrawMatrix() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mDrawMatrix.set(this.mBaseMatrix);
        photoViewAttacher.mDrawMatrix.postConcat(this.mSuppMatrix);
        return photoViewAttacher.mDrawMatrix;
    }

    private float getValue(Matrix matrix, int n5) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n5];
    }

    private void resetMatrix() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.reset();
        photoViewAttacher.setRotationBy(photoViewAttacher.mBaseRotation);
        photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
        photoViewAttacher.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mImageView.setImageMatrix(matrix);
        if (photoViewAttacher.mMatrixChangeListener != null && (matrix = this.getDisplayRect(matrix)) != null) {
            this.mMatrixChangeListener.onMatrixChanged((RectF)matrix);
        }
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
        }
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable drawable = this.mImageView.getDrawable();
        if (drawable != null) {
            PhotoViewAttacher photoViewAttacher = this;
            Drawable drawable2 = drawable;
            float f5 = drawable2.getIntrinsicWidth();
            float f6 = drawable2.getIntrinsicHeight();
            photoViewAttacher.mDisplayRect.set(0.0f, 0.0f, f5, f6);
            matrix.mapRect(photoViewAttacher.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private void updateBaseMatrix(Drawable drawable) {
        if (drawable == null) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        float f5 = photoViewAttacher.getImageViewWidth(photoViewAttacher.mImageView);
        float f6 = photoViewAttacher.getImageViewHeight(photoViewAttacher.mImageView);
        Drawable drawable2 = drawable;
        int n5 = drawable2.getIntrinsicWidth();
        int n6 = drawable2.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float f7 = n5;
        float f8 = f5 / f7;
        float f9 = n6;
        float f10 = f6 / f9;
        ImageView.ScaleType scaleType = photoViewAttacher.mScaleType;
        if (scaleType == ImageView.ScaleType.CENTER) {
            f7 = (f5 - f7) / 2.0f;
            this.mBaseMatrix.postTranslate(f7, (f6 - f9) / 2.0f);
        } else if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            PhotoViewAttacher photoViewAttacher2 = this;
            float f11 = f8 = Math.max(f8, f10);
            photoViewAttacher2.mBaseMatrix.postScale(f11, f11);
            f7 = (f5 - f7 * f8) / 2.0f;
            photoViewAttacher2.mBaseMatrix.postTranslate(f7, (f6 - f9 * f8) / 2.0f);
        } else if (scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            PhotoViewAttacher photoViewAttacher3 = this;
            float f12 = f8 = Math.min(1.0f, Math.min(f8, f10));
            photoViewAttacher3.mBaseMatrix.postScale(f12, f12);
            f7 = (f5 - f7 * f8) / 2.0f;
            photoViewAttacher3.mBaseMatrix.postTranslate(f7, (f6 - f9 * f8) / 2.0f);
        } else {
            RectF rectF;
            RectF rectF2;
            RectF rectF3 = rectF2;
            rectF2 = new RectF(0.0f, 0.0f, f7, f9);
            RectF rectF4 = rectF;
            rectF = new RectF(0.0f, 0.0f, f5, f6);
            if ((int)this.mBaseRotation % 180 != 0) {
                RectF rectF5;
                rectF3 = rectF5;
                rectF5 = new RectF(0.0f, 0.0f, f9, f7);
            }
            switch (3.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.FILL);
                    break;
                }
                case 3: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.END);
                    break;
                }
                case 2: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.START);
                    break;
                }
                case 1: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.CENTER);
                }
            }
        }
        this.resetMatrix();
    }

    private boolean checkMatrixBounds() {
        float f5;
        float f6;
        float f7;
        PhotoViewAttacher photoViewAttacher = this;
        RectF rectF = photoViewAttacher.getDisplayRect(photoViewAttacher.getDrawMatrix());
        if (rectF == null) {
            return false;
        }
        float f8 = rectF.height();
        PhotoViewAttacher photoViewAttacher2 = this;
        float f9 = rectF.width();
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = photoViewAttacher2.getImageViewHeight(photoViewAttacher2.mImageView);
        if (f7 <= f6) {
            int n5 = 3.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
            f11 = n5 != 2 ? (n5 != 3 ? (f12 - f8) / 2.0f - rectF.top : f12 - f8 - rectF.top) : -rectF.top;
        } else {
            float f13;
            f8 = rectF.top;
            if (f13 > 0.0f) {
                f11 = -f8;
            } else {
                float f14;
                f8 = rectF.bottom;
                if (f14 < f12) {
                    f11 = f12 - f8;
                }
            }
        }
        PhotoViewAttacher photoViewAttacher3 = this;
        f8 = photoViewAttacher3.getImageViewWidth(photoViewAttacher3.mImageView);
        if (f9 <= f5) {
            float f15;
            float f16;
            float f17;
            int n6 = 3.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
            f10 = n6 != 2 ? (n6 != 3 ? (f17 = (f8 - f9) / 2.0f - rectF.left) : (f16 = f8 - f9 - rectF.left)) : (f15 = -rectF.left);
            this.mScrollEdge = 2;
        } else {
            float f18;
            f9 = rectF.left;
            if (f18 > 0.0f) {
                this.mScrollEdge = 0;
                f10 = -f9;
            } else {
                float f19;
                float f20 = rectF.right;
                if (f19 < f8) {
                    f10 = f8 - f20;
                    this.mScrollEdge = 1;
                } else {
                    this.mScrollEdge = -1;
                }
            }
        }
        this.mSuppMatrix.postTranslate(f10, f11);
        return true;
    }

    private int getImageViewWidth(ImageView imageView) {
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private void cancelFling() {
        FlingRunnable flingRunnable = this.mCurrentFlingRunnable;
        if (flingRunnable != null) {
            flingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.mGestureDetector.setOnDoubleTapListener(onDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangedListener) {
        this.mScaleChangeListener = onScaleChangedListener;
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
        this.mSingleFlingListener = onSingleFlingListener;
    }

    public boolean isZoomEnabled() {
        return this.mZoomEnabled;
    }

    public RectF getDisplayRect() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.checkMatrixBounds();
        return photoViewAttacher.getDisplayRect(photoViewAttacher.getDrawMatrix());
    }

    public boolean setDisplayMatrix(Matrix matrix) {
        if (matrix != null) {
            if (this.mImageView.getDrawable() == null) {
                return false;
            }
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.mSuppMatrix.set(matrix);
            photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
            photoViewAttacher.checkMatrixBounds();
            return true;
        }
        throw new IllegalArgumentException("Matrix cannot be null");
    }

    public void setBaseRotation(float f5) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mBaseRotation = f5 % 360.0f;
        photoViewAttacher.update();
        photoViewAttacher.setRotationBy(photoViewAttacher.mBaseRotation);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public void setRotationTo(float f5) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.setRotate(f5 % 360.0f);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public void setRotationBy(float f5) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.postRotate(f5 % 360.0f);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public float getMinimumScale() {
        return this.mMinScale;
    }

    public float getMediumScale() {
        return this.mMidScale;
    }

    public float getMaximumScale() {
        return this.mMaxScale;
    }

    public float getScale() {
        PhotoViewAttacher photoViewAttacher = this;
        PhotoViewAttacher photoViewAttacher2 = this;
        return (float)Math.sqrt((float)Math.pow(photoViewAttacher.getValue(photoViewAttacher.mSuppMatrix, 0), 2.0) + (float)Math.pow(photoViewAttacher2.getValue(photoViewAttacher2.mSuppMatrix, 3), 2.0));
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    @Override
    public void onDrag(float f5, float f6) {
        if (this.mScaleDragDetector.isScaling()) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.postTranslate(f5, f6);
        photoViewAttacher.checkAndDisplayMatrix();
        ViewParent viewParent = photoViewAttacher.mImageView.getParent();
        if (photoViewAttacher.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling() && !this.mBlockParentIntercept) {
            int n5 = this.mScrollEdge;
            if ((n5 == 2 || n5 == 0 && f5 >= 1.0f || n5 == 1 && f5 <= -1.0f) && viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(false);
            }
        } else if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    @Override
    public void onFling(float f5, float f6, float f7, float f8) {
        FlingRunnable flingRunnable;
        FlingRunnable flingRunnable2 = flingRunnable;
        PhotoViewAttacher photoViewAttacher = this;
        FlingRunnable flingRunnable3 = flingRunnable2;
        PhotoViewAttacher photoViewAttacher2 = this;
        flingRunnable3(photoViewAttacher2.mImageView.getContext());
        photoViewAttacher.mCurrentFlingRunnable = flingRunnable3;
        int n5 = photoViewAttacher.getImageViewWidth(photoViewAttacher.mImageView);
        int n6 = photoViewAttacher.getImageViewHeight(photoViewAttacher.mImageView);
        int n7 = (int)f7;
        int n8 = (int)f8;
        flingRunnable.fling(n5, n6, n7, n8);
        this.mImageView.post((Runnable)this.mCurrentFlingRunnable);
    }

    public void onLayoutChange(View view, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.updateBaseMatrix(photoViewAttacher.mImageView.getDrawable());
    }

    @Override
    public void onScale(float f5, float f6, float f7) {
        if ((this.getScale() < this.mMaxScale || f5 < 1.0f) && (this.getScale() > this.mMinScale || f5 > 1.0f)) {
            OnScaleChangedListener onScaleChangedListener = this.mScaleChangeListener;
            if (onScaleChangedListener != null) {
                onScaleChangedListener.onScaleChange(f5, f6, f7);
            }
            PhotoViewAttacher photoViewAttacher = this;
            float f8 = f5;
            photoViewAttacher.mSuppMatrix.postScale(f8, f8, f6, f7);
            photoViewAttacher.checkAndDisplayMatrix();
        }
    }

    public boolean onTouch(View object, MotionEvent motionEvent) {
        boolean bl = false;
        if (this.mZoomEnabled && Util.hasDrawable((ImageView)object)) {
            int n5 = motionEvent.getAction();
            if (n5 != 0) {
                RectF rectF;
                if ((n5 == 1 || n5 == 3) && this.getScale() < this.mMinScale && (rectF = this.getDisplayRect()) != null) {
                    AnimatedZoomRunnable animatedZoomRunnable;
                    Object object2 = object;
                    object = animatedZoomRunnable;
                    RectF rectF2 = rectF;
                    PhotoViewAttacher photoViewAttacher = this;
                    float f5 = photoViewAttacher.getScale();
                    float f6 = photoViewAttacher.mMinScale;
                    float f7 = rectF2.centerX();
                    float f8 = rectF2.centerY();
                    animatedZoomRunnable = new AnimatedZoomRunnable(this, f5, f6, f7, f8);
                    object2.post((Runnable)object);
                    bl = true;
                }
            } else {
                if ((object = object.getParent()) != null) {
                    object.requestDisallowInterceptTouchEvent(true);
                }
                this.cancelFling();
            }
            if ((object = this.mScaleDragDetector) != null) {
                PhotoViewAttacher photoViewAttacher = this;
                boolean bl2 = photoViewAttacher.mScaleDragDetector.isDragging();
                bl = photoViewAttacher.mScaleDragDetector.onTouchEvent(motionEvent);
                n5 = !((CustomGestureDetector)object).isScaling() && !this.mScaleDragDetector.isScaling() ? 1 : 0;
                bl2 = !bl2 && !this.mScaleDragDetector.isDragging();
                bl2 = n5 != 0 && bl2;
                this.mBlockParentIntercept = bl2;
            }
            if ((this = this.mGestureDetector) != null && this.onTouchEvent(motionEvent)) {
                bl = true;
            }
        }
        return bl;
    }

    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.mAllowParentInterceptOnEdge = bl;
    }

    public void setMinimumScale(float f5) {
        PhotoViewAttacher photoViewAttacher = this;
        float f6 = photoViewAttacher.mMidScale;
        Util.checkZoomLevels(f5, f6, photoViewAttacher.mMaxScale);
        this.mMinScale = f5;
    }

    public void setMediumScale(float f5) {
        Util.checkZoomLevels(this.mMinScale, f5, this.mMaxScale);
        this.mMidScale = f5;
    }

    public void setMaximumScale(float f5) {
        Util.checkZoomLevels(this.mMinScale, this.mMidScale, f5);
        this.mMaxScale = f5;
    }

    public void setScaleLevels(float f5, float f6, float f7) {
        PhotoViewAttacher photoViewAttacher = this;
        Util.checkZoomLevels(f5, f6, f7);
        photoViewAttacher.mMinScale = f5;
        photoViewAttacher.mMidScale = f6;
        photoViewAttacher.mMaxScale = f7;
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mLongClickListener = onLongClickListener;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener onMatrixChangedListener) {
        this.mMatrixChangeListener = onMatrixChangedListener;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.mPhotoTapListener = onPhotoTapListener;
    }

    public void setOnOutsidePhotoTapListener(OnOutsidePhotoTapListener onOutsidePhotoTapListener) {
        this.mOutsidePhotoTapListener = onOutsidePhotoTapListener;
    }

    public void setScale(float f5) {
        this.setScale(f5, false);
    }

    public void setScale(float f5, boolean bl) {
        PhotoViewAttacher photoViewAttacher = this;
        float f6 = photoViewAttacher.mImageView.getRight() / 2;
        this.setScale(f5, f6, photoViewAttacher.mImageView.getBottom() / 2, bl);
    }

    public void setScale(float f5, float f6, float f7, boolean bl) {
        if (!(f5 < this.mMinScale) && !(f5 > this.mMaxScale)) {
            if (bl) {
                PhotoViewAttacher photoViewAttacher = this;
                this.mImageView.post((Runnable)new AnimatedZoomRunnable(photoViewAttacher, photoViewAttacher.getScale(), f5, f6, f7));
            } else {
                PhotoViewAttacher photoViewAttacher = this;
                float f8 = f5;
                photoViewAttacher.mSuppMatrix.setScale(f8, f8, f6, f7);
                photoViewAttacher.checkAndDisplayMatrix();
            }
            return;
        }
        throw new IllegalArgumentException("Scale must be within the range of minScale and maxScale");
    }

    public void setZoomInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (Util.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public void setZoomable(boolean bl) {
        this.mZoomEnabled = bl;
        this.update();
    }

    public void update() {
        if (this.mZoomEnabled) {
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.updateBaseMatrix(photoViewAttacher.mImageView.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    public void getDisplayMatrix(Matrix matrix) {
        matrix.set(this.getDrawMatrix());
    }

    public void getSuppMatrix(Matrix matrix) {
        matrix.set(this.mSuppMatrix);
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    public void setZoomTransitionDuration(int n5) {
        this.mZoomDuration = n5;
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            OverScroller overScroller;
            FlingRunnable flingRunnable = overScroller;
            overScroller = new OverScroller(context);
            v1.mScroller = flingRunnable;
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public void fling(int n5, int n6, int n7, int n8) {
            int n9;
            int n10;
            float f5;
            int n11;
            int n12;
            float f6;
            RectF rectF = PhotoViewAttacher.this.getDisplayRect();
            if (rectF == null) {
                return;
            }
            int n13 = n5;
            n5 = Math.round(-rectF.left);
            float f7 = n13;
            if (f6 < rectF.width()) {
                n12 = 0;
                n11 = Math.round(rectF.width() - f7);
            } else {
                n12 = n5;
                n11 = n5;
            }
            int n14 = n6;
            n6 = Math.round(-rectF.top);
            float f8 = n14;
            if (f5 < rectF.height()) {
                n10 = 0;
                n9 = Math.round(rectF.height() - f8);
            } else {
                n10 = n6;
                n9 = n6;
            }
            FlingRunnable flingRunnable = this;
            flingRunnable.mCurrentX = n5;
            flingRunnable.mCurrentY = n6;
            if (n5 != n11 || n6 != n9) {
                this.mScroller.fling(n5, n6, n7, n8, n12, n11, n10, n9, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            if (this.mScroller.computeScrollOffset()) {
                FlingRunnable flingRunnable = this;
                int n5 = flingRunnable.mScroller.getCurrX();
                int n6 = flingRunnable.mScroller.getCurrY();
                flingRunnable.PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - n5), (float)(this.mCurrentY - n6));
                PhotoViewAttacher photoViewAttacher = flingRunnable.PhotoViewAttacher.this;
                photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
                flingRunnable.mCurrentX = n5;
                flingRunnable.mCurrentY = n6;
                Compat.postOnAnimation((View)flingRunnable.PhotoViewAttacher.this.mImageView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;
        final /* synthetic */ PhotoViewAttacher this$0;

        public AnimatedZoomRunnable(PhotoViewAttacher photoViewAttacher, float f5, float f6, float f7, float f8) {
            AnimatedZoomRunnable animatedZoomRunnable = this;
            this.this$0 = photoViewAttacher;
            this.mFocalX = f7;
            animatedZoomRunnable.mFocalY = f8;
            animatedZoomRunnable.mStartTime = System.currentTimeMillis();
            this.mZoomStart = f5;
            this.mZoomEnd = f6;
        }

        private float interpolate() {
            float f5 = Math.min(1.0f, (float)(System.currentTimeMillis() - this.mStartTime) * 1.0f / (float)this.this$0.mZoomDuration);
            return this.this$0.mInterpolator.getInterpolation(f5);
        }

        @Override
        public void run() {
            float f5;
            float f6 = this.interpolate();
            AnimatedZoomRunnable animatedZoomRunnable = this;
            float f7 = animatedZoomRunnable.mZoomStart;
            float f8 = f6 = (f7 + f6 * (this.mZoomEnd - f7)) / this.this$0.getScale();
            AnimatedZoomRunnable animatedZoomRunnable2 = this;
            f6 = animatedZoomRunnable2.mFocalX;
            animatedZoomRunnable.this$0.onScale(f8, f6, animatedZoomRunnable2.mFocalY);
            if (f5 < 1.0f) {
                Compat.postOnAnimation((View)this.this$0.mImageView, this);
            }
        }
    }
}

