/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.client.result.ParsedResult;
import com.dcloud.zxing2.client.result.ParsedResultType;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CalendarParsedResult
extends ParsedResult {
    private static final Pattern RFC2445_DURATION = Pattern.compile("P(?:(\\d+)W)?(?:(\\d+)D)?(?:T(?:(\\d+)H)?(?:(\\d+)M)?(?:(\\d+)S)?)?");
    private static final long[] RFC2445_DURATION_FIELD_UNITS = new long[]{604800000L, 86400000L, 3600000L, 60000L, 1000L};
    private static final Pattern DATE_TIME = Pattern.compile("[0-9]{8}(T[0-9]{6}Z?)?");
    private final String summary;
    private final Date start;
    private final boolean startAllDay;
    private final Date end;
    private final boolean endAllDay;
    private final String location;
    private final String organizer;
    private final String[] attendees;
    private final String description;
    private final double latitude;
    private final double longitude;

    public CalendarParsedResult(String object, String string2, String string3, String object2, String string4, String string5, String[] stringArray, String string6, double d6, double d7) {
        block8: {
            block7: {
                super(ParsedResultType.CALENDAR);
                this.summary = object;
                try {
                    object = CalendarParsedResult.parseDate(string2);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException(((Object)parseException).toString());
                }
                this.start = object;
                if (string3 != null) break block7;
                long l5 = CalendarParsedResult.parseDurationMS((CharSequence)object2);
                if (l5 < 0L) {
                    object = null;
                } else {
                    Date date;
                    object2 = date;
                    date = new Date(((Date)object).getTime() + l5);
                    object = object2;
                }
                this.end = object;
                break block8;
            }
            try {
                this.end = CalendarParsedResult.parseDate(string3);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(((Object)parseException).toString());
            }
        }
        boolean bl = string2.length() == 8;
        this.startAllDay = bl;
        bl = string3 != null && string3.length() == 8;
        CalendarParsedResult calendarParsedResult = this;
        calendarParsedResult.endAllDay = bl;
        calendarParsedResult.location = string4;
        calendarParsedResult.organizer = string5;
        calendarParsedResult.attendees = stringArray;
        calendarParsedResult.description = string6;
        calendarParsedResult.latitude = d6;
        calendarParsedResult.longitude = d7;
    }

    private static Date parseDate(String object) throws ParseException {
        if (DATE_TIME.matcher((CharSequence)object).matches()) {
            if (((String)object).length() == 8) {
                return CalendarParsedResult.buildDateFormat().parse((String)object);
            }
            if (((String)object).length() == 16 && ((String)object).charAt(15) == 'Z') {
                Date date;
                GregorianCalendar gregorianCalendar;
                Date date2 = CalendarParsedResult.buildDateTimeFormat().parse(((String)object).substring(0, 15));
                object = gregorianCalendar;
                gregorianCalendar = new GregorianCalendar();
                long l5 = date2.getTime() + (long)((Calendar)object).get(15);
                Object object2 = object;
                ((Calendar)object2).setTime(new Date(l5));
                object = date;
                date = new Date(l5 += (long)((Calendar)object2).get(16));
            } else {
                object = CalendarParsedResult.buildDateTimeFormat().parse((String)object);
            }
            return object;
        }
        throw new ParseException((String)object, 0);
    }

    private static String format(boolean bl, Date date) {
        if (date == null) {
            return null;
        }
        return (bl ? DateFormat.getDateInstance(2) : DateFormat.getDateTimeInstance(2, 2)).format(date);
    }

    private static long parseDurationMS(CharSequence object) {
        if (object == null) {
            return -1L;
        }
        if (!((Matcher)(object = RFC2445_DURATION.matcher((CharSequence)object))).matches()) {
            return -1L;
        }
        long l5 = 0L;
        int n5 = 0;
        while (true) {
            long[] lArray = RFC2445_DURATION_FIELD_UNITS;
            if (n5 >= RFC2445_DURATION_FIELD_UNITS.length) break;
            int n6 = n5 + 1;
            String string2 = ((Matcher)object).group(n6);
            if (string2 != null) {
                l5 += lArray[n5] * (long)Integer.parseInt(string2);
            }
            n5 = n6;
        }
        return l5;
    }

    private static DateFormat buildDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    private static DateFormat buildDateTimeFormat() {
        return new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
    }

    public String getSummary() {
        return this.summary;
    }

    public Date getStart() {
        return this.start;
    }

    public boolean isStartAllDay() {
        return this.startAllDay;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean isEndAllDay() {
        return this.endAllDay;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrganizer() {
        return this.organizer;
    }

    public String[] getAttendees() {
        return this.attendees;
    }

    public String getDescription() {
        return this.description;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        CalendarParsedResult calendarParsedResult = this;
        stringBuilder2(100);
        ParsedResult.maybeAppend(calendarParsedResult.summary, stringBuilder2);
        ParsedResult.maybeAppend(CalendarParsedResult.format(calendarParsedResult.startAllDay, this.start), stringBuilder2);
        ParsedResult.maybeAppend(CalendarParsedResult.format(calendarParsedResult.endAllDay, this.end), stringBuilder2);
        ParsedResult.maybeAppend(calendarParsedResult.location, stringBuilder2);
        ParsedResult.maybeAppend(calendarParsedResult.organizer, stringBuilder2);
        ParsedResult.maybeAppend(calendarParsedResult.attendees, stringBuilder2);
        ParsedResult.maybeAppend(calendarParsedResult.description, stringBuilder2);
        return stringBuilder.toString();
    }
}

