/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n5) {
        this.size = n5;
        this.bits = BitArray.makeArray(n5);
    }

    BitArray(int[] nArray, int n5) {
        this.bits = nArray;
        this.size = n5;
    }

    private void ensureCapacity(int n5) {
        if (n5 > ((BitArray)object).bits.length * 32) {
            BitArray bitArray = object;
            Object object = BitArray.makeArray(n5);
            n5 = bitArray.bits.length;
            System.arraycopy(bitArray.bits, 0, object, 0, n5);
            bitArray.bits = (int[])object;
        }
    }

    private static int[] makeArray(int n5) {
        return new int[(n5 + 31) / 32];
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    public boolean get(int n5) {
        return (this.bits[n5 / 32] & 1 << (n5 & 0x1F)) != 0;
    }

    public void set(int n5) {
        int n6 = n5 / 32;
        this.bits[n6] = this.bits[n6] | 1 << (n5 & 0x1F);
    }

    public void flip(int n5) {
        int n6 = n5 / 32;
        this.bits[n6] = this.bits[n6] ^ 1 << (n5 & 0x1F);
    }

    public int getNextSet(int n5) {
        int n6;
        int n7 = this.size;
        if (n5 >= n7) {
            return n7;
        }
        n7 = n5 / 32;
        n5 = this.bits[n7] & ~((1 << (n5 & 0x1F)) - 1);
        while (n5 == 0) {
            int[] nArray = this.bits;
            if (++n7 == this.bits.length) {
                return this.size;
            }
            n5 = nArray[n7];
        }
        if ((n5 = n7 * 32 + Integer.numberOfTrailingZeros(n5)) > (n6 = this.size)) {
            n5 = n6;
        }
        return n5;
    }

    public int getNextUnset(int n5) {
        int n6;
        int n7 = this.size;
        if (n5 >= n7) {
            return n7;
        }
        n7 = n5 / 32;
        n5 = ~this.bits[n7] & ~((1 << (n5 & 0x1F)) - 1);
        while (n5 == 0) {
            int[] nArray = this.bits;
            if (++n7 == this.bits.length) {
                return this.size;
            }
            n5 = ~nArray[n7];
        }
        if ((n5 = n7 * 32 + Integer.numberOfTrailingZeros(n5)) > (n6 = this.size)) {
            n5 = n6;
        }
        return n5;
    }

    public void setBulk(int n5, int n6) {
        this.bits[n5 / 32] = n6;
    }

    public void setRange(int n5, int n6) {
        if (n6 >= n5) {
            if (n6 == n5) {
                return;
            }
            int n7 = n5 / 32;
            int n8 = (n6 += -1) / 32;
            for (int i5 = n7; i5 <= n8; ++i5) {
                int n9;
                int n10 = i5 < n8 ? 31 : n6 & 0x1F;
                if (n9 == 0 && n10 == 31) {
                    n9 = -1;
                } else {
                    int n11 = 0;
                    for (n9 = i5 > n7 ? 0 : n5 & 0x1F; n9 <= n10; ++n9) {
                        n11 |= 1 << n9;
                    }
                    n9 = n11;
                }
                this.bits[i5] = this.bits[i5] | n9;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void clear() {
        int n5 = this.bits.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            this.bits[i5] = 0;
        }
    }

    public boolean isRange(int n5, int n6, boolean bl) {
        if (n6 >= n5) {
            if (n6 == n5) {
                return true;
            }
            int n7 = n5 / 32;
            int n8 = (n6 += -1) / 32;
            for (int i5 = n7; i5 <= n8; ++i5) {
                int n9;
                int n10 = i5 < n8 ? 31 : n6 & 0x1F;
                if (n9 == 0 && n10 == 31) {
                    n9 = -1;
                } else {
                    int n11 = 0;
                    for (n9 = i5 > n7 ? 0 : n5 & 0x1F; n9 <= n10; ++n9) {
                        n11 |= 1 << n9;
                    }
                    n9 = n11;
                }
                n10 = this.bits[i5] & n9;
                if (!bl) {
                    n9 = 0;
                }
                if (n10 == n9) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public void appendBit(boolean bl) {
        BitArray bitArray = this;
        bitArray.ensureCapacity(bitArray.size + 1);
        if (bl) {
            int n5 = this.size;
            int n6 = n5 / 32;
            this.bits[n6] = this.bits[n6] | 1 << (n5 & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int n5, int n6) {
        if (n6 >= 0 && n6 <= 32) {
            BitArray bitArray = this;
            bitArray.ensureCapacity(bitArray.size + n6);
            while (n6 > 0) {
                boolean bl = (n5 >> n6 - 1 & 1) == 1;
                this.appendBit(bl);
                --n6;
            }
            return;
        }
        throw new IllegalArgumentException("Num bits must be between 0 and 32");
    }

    public void appendBitArray(BitArray bitArray) {
        BitArray bitArray2 = this;
        int n5 = bitArray.size;
        bitArray2.ensureCapacity(bitArray2.size + n5);
        for (int i5 = 0; i5 < n5; ++i5) {
            this.appendBit(bitArray.get(i5));
        }
    }

    public void xor(BitArray bitArray) {
        if (this.bits.length == bitArray.bits.length) {
            int n5 = 0;
            while (true) {
                int[] nArray = this.bits;
                if (n5 >= this.bits.length) break;
                nArray[n5] = nArray[n5] ^ bitArray.bits[n5];
                ++n5;
            }
            return;
        }
        throw new IllegalArgumentException("Sizes don't match");
    }

    public void toBytes(int n5, byte[] byArray, int n6, int n7) {
        for (int i5 = 0; i5 < n7; ++i5) {
            int n8 = 0;
            for (int i6 = 0; i6 < 8; ++i6) {
                if (this.get(n5)) {
                    n8 |= 1 << 7 - i6;
                }
                ++n5;
            }
            int n9 = n8;
            n8 = n6 + i5;
            byArray[n8] = (byte)n9;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int n5;
        int n6;
        BitArray bitArray = this;
        int[] nArray = new int[bitArray.bits.length];
        int n7 = (bitArray.size - 1) / 32;
        int n8 = n7 + 1;
        for (n6 = 0; n6 < n8; ++n6) {
            long l5 = this.bits[n6];
            l5 = l5 >> 1 & 0x55555555L | (l5 & 0x55555555L) << 1;
            l5 = l5 >> 2 & 0x33333333L | (l5 & 0x33333333L) << 2;
            l5 = l5 >> 4 & 0xF0F0F0FL | (l5 & 0xF0F0F0FL) << 4;
            l5 = l5 >> 8 & 0xFF00FFL | (l5 & 0xFF00FFL) << 8;
            n5 = n7 - n6;
            nArray[n5] = (int)(l5 >> 16 & 0xFFFFL | (l5 & 0xFFFFL) << 16);
        }
        n6 = this.size;
        n5 = n8 * 32;
        if (n6 != n5) {
            int n9;
            n6 = n5 - n6;
            n5 = 1;
            for (n9 = 0; n9 < 31 - n6; ++n9) {
                n5 = n5 << 1 | 1;
            }
            n9 = nArray[0] >> n6 & n5;
            for (int i5 = 1; i5 < n8; ++i5) {
                int n10 = nArray[i5];
                nArray[i5 - 1] = n9 |= n10 << 32 - n6;
                n9 = n10 >> n6 & n5;
            }
            nArray[n7] = n9;
        }
        this.bits = nArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitArray)) {
            return false;
        }
        object = (BitArray)object;
        return this.size == ((BitArray)object).size && Arrays.equals(this.bits, ((BitArray)object).bits);
    }

    public int hashCode() {
        return this.size * 31 + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.size);
        for (int i5 = 0; i5 < this.size; ++i5) {
            if ((i5 & 7) == 0) {
                stringBuilder2.append(' ');
            }
            char c6 = this.get(i5) ? (char)'X' : '.';
            stringBuilder2.append(c6);
        }
        return stringBuilder2.toString();
    }

    public BitArray clone() {
        BitArray bitArray = object;
        Object object = (int[])bitArray.bits.clone();
        return new BitArray((int[])object, bitArray.size);
    }
}

