/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;

public final class MonochromeRectangleDetector {
    private static final int MAX_MODULES = 32;
    private final BitMatrix image;

    public MonochromeRectangleDetector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private ResultPoint findCornerFromCenter(int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) throws NotFoundException {
        int[] nArray = null;
        int n14 = n5;
        int n15 = n9;
        while (n15 < n12 && n15 >= n11 && n14 < n8 && n14 >= n7) {
            int[] nArray2 = n6 == 0 ? this.blackWhiteRange(n15, n13, n7, n8, true) : this.blackWhiteRange(n14, n13, n11, n12, false);
            if (nArray2 == null) {
                if (nArray != null) {
                    if (n6 == 0) {
                        int n16 = n15 - n10;
                        n6 = nArray[0];
                        if (n6 < n5) {
                            n7 = nArray[1];
                            if (n7 > n5) {
                                ResultPoint resultPoint;
                                float f5 = n10 > 0 ? (float)n6 : (float)n7;
                                ResultPoint resultPoint2 = resultPoint;
                                resultPoint2(f5, n16);
                                return resultPoint2;
                            }
                            float f6 = n6;
                            return new ResultPoint(f6, n16);
                        }
                        float f7 = nArray[1];
                        return new ResultPoint(f7, n16);
                    }
                    int n17 = n14 - n6;
                    n5 = nArray[0];
                    if (n5 < n9) {
                        n7 = nArray[1];
                        if (n7 > n9) {
                            ResultPoint resultPoint;
                            float f8 = n17;
                            float f9 = n6 < 0 ? (float)n5 : (float)n7;
                            ResultPoint resultPoint3 = resultPoint;
                            resultPoint3(f8, f9);
                            return resultPoint3;
                        }
                        float f10 = n17;
                        return new ResultPoint(f10, n5);
                    }
                    float f11 = n17;
                    return new ResultPoint(f11, nArray[1]);
                }
                throw NotFoundException.getNotFoundInstance();
            }
            int n18 = n15 + n10;
            n15 = n14 + n6;
            nArray = nArray2;
            n14 = n15;
            n15 = n18;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private int[] blackWhiteRange(int n5, int n6, int n7, int n8, boolean bl) {
        int[] nArray;
        int n9;
        int n10;
        int n11;
        int n12 = n11 = (n7 + n8) / 2;
        while (n12 >= n7) {
            if (bl ? this.image.get(n12, n5) : this.image.get(n5, n12)) {
                --n12;
                continue;
            }
            n10 = n12;
            while ((n10 += -1) >= n7 && !(bl ? this.image.get(n10, n5) : this.image.get(n5, n10))) {
            }
            int n13 = n12 - n10;
            if (n10 < n7 || n13 > n6) break;
            n12 = n10;
        }
        n7 = n12 + 1;
        while (n11 < n8) {
            if (bl ? this.image.get(n11, n5) : this.image.get(n5, n11)) {
                ++n11;
                continue;
            }
            n12 = n11;
            while (++n12 < n8 && !(bl ? this.image.get(n12, n5) : this.image.get(n5, n12))) {
            }
            int n14 = n12;
            n10 = n14 - n11;
            if (n14 >= n8 || n10 > n6) break;
            n11 = n12;
        }
        if ((n9 = n11 + -1) > n7) {
            int[] nArray2 = new int[2];
            nArray = nArray2;
            nArray2[0] = n7;
            nArray2[1] = n9;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public ResultPoint[] detect() throws NotFoundException {
        int n5;
        MonochromeRectangleDetector monochromeRectangleDetector = this;
        int n6 = monochromeRectangleDetector.image.getHeight();
        int n7 = monochromeRectangleDetector.image.getWidth();
        int n8 = n6 / 2;
        int n9 = n7 / 2;
        int n10 = n5 = n9;
        int n11 = n5;
        int n12 = n5;
        int n13 = Math.max(1, n6 / 256);
        int n14 = Math.max(1, n7 / 256);
        int n15 = n5;
        int n16 = -n13;
        n5 = n15 / 2;
        int n17 = (int)this.findCornerFromCenter(n15, 0, 0, n7, n8, n16, 0, n6, n5).getY() - 1;
        int n18 = -n14;
        int n19 = n8 / 2;
        ResultPoint resultPoint = this.findCornerFromCenter(n12, n18, 0, n7, n8, 0, n17, n6, n19);
        int n20 = (int)resultPoint.getX() - 1;
        ResultPoint resultPoint2 = this.findCornerFromCenter(n11, n14, n20, n7, n8, 0, n17, n6, n19);
        n14 = (int)resultPoint2.getX() + 1;
        ResultPoint resultPoint3 = this.findCornerFromCenter(n10, 0, n20, n14, n8, n13, n17, n6, n5);
        n5 = (int)resultPoint3.getY() + 1;
        n13 = n9 / 4;
        ResultPoint resultPoint4 = monochromeRectangleDetector.findCornerFromCenter(n9, 0, n20, n14, n8, n16, n17, n5, n13);
        return new ResultPoint[]{resultPoint4, resultPoint, resultPoint2, resultPoint3};
    }
}

