/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.datamatrix.decoder.Decoder;
import com.dcloud.zxing2.datamatrix.detector.Detector;
import java.util.Map;

public final class DataMatrixReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder;

    public DataMatrixReader() {
        Decoder decoder;
        Decoder decoder2 = decoder;
        decoder = new Decoder();
        v1.decoder = decoder2;
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray != null && nArray2 != null) {
            int n5 = DataMatrixReader.moduleSize(nArray, bitMatrix);
            int n6 = nArray[1];
            int n7 = nArray2[1];
            int n8 = nArray[0];
            int n9 = (nArray2[0] - n8 + 1) / n5;
            n7 = (n7 - n6 + 1) / n5;
            if (n9 > 0 && n7 > 0) {
                BitMatrix bitMatrix2;
                int n10 = n8;
                int n11 = n6;
                n6 = n5 / 2;
                n8 = n11 + n6;
                n6 = n10 + n6;
                BitMatrix bitMatrix3 = bitMatrix2;
                bitMatrix2 = new BitMatrix(n9, n7);
                for (int i5 = 0; i5 < n7; ++i5) {
                    int n12 = n8 + i5 * n5;
                    for (int i6 = 0; i6 < n9; ++i6) {
                        if (!bitMatrix.get(n6 + i6 * n5, n12)) continue;
                        bitMatrix3.set(i6, i5);
                    }
                }
                return bitMatrix3;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n5;
        int n6 = bitMatrix.getWidth();
        int n7 = nArray[1];
        for (n5 = nArray[0]; n5 < n6 && bitMatrix.get(n5, n7); ++n5) {
        }
        if (n5 != n6) {
            int n8 = n5 - nArray[0];
            if (n8 != 0) {
                return n8;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        Result result;
        Object object3;
        if (object2 != null && object2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            DataMatrixReader dataMatrixReader = object3;
            object3 = DataMatrixReader.extractPureBits(object.getBlackMatrix());
            object3 = dataMatrixReader.decoder.decode((BitMatrix)object3);
            object = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(object.getBlackMatrix()).detect();
            object3 = ((DataMatrixReader)object3).decoder.decode(detectorResult.getBits());
            object = detectorResult.getPoints();
        }
        object2 = result;
        Object object4 = object3;
        String string2 = ((DecoderResult)object4).getText();
        BarcodeFormat barcodeFormat = BarcodeFormat.DATA_MATRIX;
        result = new Result(string2, ((DecoderResult)object4).getRawBytes(), (ResultPoint[])object, barcodeFormat);
        object = ((DecoderResult)object3).getByteSegments();
        if (object != null) {
            ((Result)object2).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object);
        }
        if ((object3 = ((DecoderResult)object3).getECLevel()) != null) {
            ((Result)object2).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, object3);
        }
        return object2;
    }

    @Override
    public void reset() {
    }
}

