/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitSource;
import com.dcloud.zxing2.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS;
    private static final char[] C40_SHIFT2_SET_CHARS;
    private static final char[] TEXT_BASIC_SET_CHARS;
    private static final char[] TEXT_SHIFT2_SET_CHARS;
    private static final char[] TEXT_SHIFT3_SET_CHARS;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray) throws FormatException {
        ArrayList<byte[]> arrayList;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        BitSource bitSource;
        BitSource bitSource2 = bitSource;
        bitSource = new BitSource(byArray);
        CharSequence charSequence = stringBuilder2;
        stringBuilder2 = new StringBuilder(100);
        StringBuilder stringBuilder3 = stringBuilder;
        stringBuilder = new StringBuilder(0);
        ArrayList<byte[]> arrayList2 = arrayList;
        arrayList = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        do {
            Mode mode2;
            if (mode == (mode2 = Mode.ASCII_ENCODE)) {
                mode = DecodedBitStreamParser.decodeAsciiSegment(bitSource2, charSequence, stringBuilder3);
                continue;
            }
            switch (1.$SwitchMap$com$dcloud$zxing2$datamatrix$decoder$DecodedBitStreamParser$Mode[mode.ordinal()]) {
                default: {
                    throw FormatException.getFormatInstance();
                }
                case 5: {
                    DecodedBitStreamParser.decodeBase256Segment(bitSource2, charSequence, arrayList2);
                    break;
                }
                case 4: {
                    DecodedBitStreamParser.decodeEdifactSegment(bitSource2, charSequence);
                    break;
                }
                case 3: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bitSource2, charSequence);
                    break;
                }
                case 2: {
                    DecodedBitStreamParser.decodeTextSegment(bitSource2, charSequence);
                    break;
                }
                case 1: {
                    DecodedBitStreamParser.decodeC40Segment(bitSource2, charSequence);
                }
            }
            mode = mode2;
        } while (mode != Mode.PAD_ENCODE && bitSource2.available() > 0);
        if (stringBuilder3.length() > 0) {
            charSequence.append(stringBuilder3);
        }
        charSequence = charSequence.toString();
        if (arrayList2.isEmpty()) {
            arrayList2 = null;
        }
        Object object = bitSource2;
        ((DecoderResult)object)(byArray, (String)charSequence, arrayList2, null);
        return object;
    }

    private static Mode decodeAsciiSegment(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws FormatException {
        int n5;
        boolean bl = false;
        while ((n5 = bitSource.readBits(8)) != 0) {
            if (n5 <= 128) {
                if (bl) {
                    n5 += 128;
                }
                stringBuilder.append((char)(n5 - 1));
                return Mode.ASCII_ENCODE;
            }
            if (n5 == 129) {
                return Mode.PAD_ENCODE;
            }
            if (n5 <= 229) {
                if ((n5 -= 130) < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n5);
            } else {
                if (n5 == 230) {
                    return Mode.C40_ENCODE;
                }
                if (n5 == 231) {
                    return Mode.BASE256_ENCODE;
                }
                if (n5 == 232) {
                    stringBuilder.append('\u001d');
                } else if (n5 != 233 && n5 != 234) {
                    if (n5 == 235) {
                        bl = true;
                    } else if (n5 == 236) {
                        stringBuilder.append("[)>\u001e05\u001d");
                        stringBuilder2.insert(0, "\u001e\u0004");
                    } else if (n5 == 237) {
                        stringBuilder.append("[)>\u001e06\u001d");
                        stringBuilder2.insert(0, "\u001e\u0004");
                    } else {
                        if (n5 == 238) {
                            return Mode.ANSIX12_ENCODE;
                        }
                        if (n5 == 239) {
                            return Mode.TEXT_ENCODE;
                        }
                        if (n5 == 240) {
                            return Mode.EDIFACT_ENCODE;
                        }
                        if (n5 != 241 && n5 >= 242 && (n5 != 254 || bitSource.available() != 0)) {
                            throw FormatException.getFormatInstance();
                        }
                    }
                }
            }
            if (bitSource.available() > 0) continue;
            return Mode.ASCII_ENCODE;
        }
        throw FormatException.getFormatInstance();
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeC40Segment(BitSource var0, StringBuilder var1_1) throws FormatException {
        var2_2 = false;
        var3_3 = new int[3];
        var4_4 = 0;
        do {
            if (var0.available() == 8) {
                return;
            }
            var5_7 = var0.readBits(8);
            if (var5_7 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(var5_7, var0.readBits(8), var3_3);
            block7: for (var5_7 = 0; var5_7 < 3; ++var5_7) {
                block15: {
                    var6_8 = var3_3[var5_7];
                    switch (var4_4) {
                        default: {
                            throw FormatException.getFormatInstance();
                        }
                        case 3: {
                            if (var2_2) {
                                var1_1.append((char)(var6_8 + 224));
                                var2_2 = false;
                            } else {
                                var1_1.append((char)(var6_8 + 96));
                            }
lbl24:
                            // 8 sources

                            while (true) {
                                var4_4 = 0;
                                continue block7;
                                break;
                            }
                        }
                        case 2: {
                            var4_5 = DecodedBitStreamParser.C40_SHIFT2_SET_CHARS;
                            if (var6_8 >= DecodedBitStreamParser.C40_SHIFT2_SET_CHARS.length) ** GOTO lbl39
                            var4_6 = var4_5[var6_8];
                            if (!var2_2) ** GOTO lbl36
                            var1_1.append((char)(var4_6 + 128));
                            var2_2 = false;
                            ** GOTO lbl24
lbl36:
                            // 1 sources

                            var1_1.append(var4_6);
                            ** GOTO lbl24
lbl39:
                            // 1 sources

                            if (var6_8 != '\u001b') ** GOTO lbl43
                            var1_1.append('\u001d');
                            ** GOTO lbl24
lbl43:
                            // 1 sources

                            if (var6_8 != '\u001e') ** GOTO lbl46
                            var2_2 = true;
                            ** GOTO lbl24
lbl46:
                            // 1 sources

                            throw FormatException.getFormatInstance();
                        }
                        case 1: {
                            if (!var2_2) ** GOTO lbl53
                            var1_1.append((char)(var6_8 + 128));
                            var2_2 = false;
                            ** GOTO lbl24
lbl53:
                            // 1 sources

                            var1_1.append(var6_8);
                            ** continue;
                        }
                        case 0: {
                            if (var6_8 < '\u0003') {
                                var4_4 = var6_8 + 1;
                                continue block7;
                            }
                            var7_9 = DecodedBitStreamParser.C40_BASIC_SET_CHARS;
                            if (var6_8 >= DecodedBitStreamParser.C40_BASIC_SET_CHARS.length) break block15;
                            var6_8 = var7_9[var6_8];
                            if (var2_2) {
                                var1_1.append((char)(var6_8 + 128));
                                var2_2 = false;
                                continue block7;
                            }
                            var1_1.append(var6_8);
                        }
                    }
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (var0.available() > 0);
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeTextSegment(BitSource var0, StringBuilder var1_1) throws FormatException {
        var2_2 = false;
        var3_3 = new int[3];
        var4_4 = 0;
        do {
            if (var0.available() == 8) {
                return;
            }
            var5_9 = var0.readBits(8);
            if (var5_9 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(var5_9, var0.readBits(8), var3_3);
            block7: for (var5_9 = 0; var5_9 < 3; ++var5_9) {
                block16: {
                    var6_10 = var3_3[var5_9];
                    switch (var4_4) {
                        default: {
                            throw FormatException.getFormatInstance();
                        }
                        case 3: {
                            var4_5 = DecodedBitStreamParser.TEXT_SHIFT3_SET_CHARS;
                            if (var6_10 < DecodedBitStreamParser.TEXT_SHIFT3_SET_CHARS.length) {
                                var4_6 = var4_5[var6_10];
                                if (var2_2) {
                                    var1_1.append((char)(var4_6 + 128));
                                    var2_2 = false;
                                } else {
                                    var1_1.append(var4_6);
                                }
lbl27:
                                // 8 sources

                                while (true) {
                                    var4_4 = 0;
                                    continue block7;
                                    break;
                                }
                            }
                            throw FormatException.getFormatInstance();
                        }
                        case 2: {
                            var4_7 = DecodedBitStreamParser.TEXT_SHIFT2_SET_CHARS;
                            if (var6_10 >= DecodedBitStreamParser.TEXT_SHIFT2_SET_CHARS.length) ** GOTO lbl43
                            var4_8 = var4_7[var6_10];
                            if (!var2_2) ** GOTO lbl40
                            var1_1.append((char)(var4_8 + 128));
                            var2_2 = false;
                            ** GOTO lbl27
lbl40:
                            // 1 sources

                            var1_1.append(var4_8);
                            ** GOTO lbl27
lbl43:
                            // 1 sources

                            if (var6_10 != '\u001b') ** GOTO lbl47
                            var1_1.append('\u001d');
                            ** GOTO lbl27
lbl47:
                            // 1 sources

                            if (var6_10 != '\u001e') ** GOTO lbl50
                            var2_2 = true;
                            ** GOTO lbl27
lbl50:
                            // 1 sources

                            throw FormatException.getFormatInstance();
                        }
                        case 1: {
                            if (!var2_2) ** GOTO lbl57
                            var1_1.append((char)(var6_10 + 128));
                            var2_2 = false;
                            ** GOTO lbl27
lbl57:
                            // 1 sources

                            var1_1.append(var6_10);
                            ** continue;
                        }
                        case 0: {
                            if (var6_10 < '\u0003') {
                                var4_4 = var6_10 + 1;
                                continue block7;
                            }
                            var7_11 = DecodedBitStreamParser.TEXT_BASIC_SET_CHARS;
                            if (var6_10 >= DecodedBitStreamParser.TEXT_BASIC_SET_CHARS.length) break block16;
                            var6_10 = var7_11[var6_10];
                            if (var2_2) {
                                var1_1.append((char)(var6_10 + 128));
                                var2_2 = false;
                                continue block7;
                            }
                            var1_1.append(var6_10);
                        }
                    }
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (var0.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n5 = bitSource.readBits(8);
            if (n5 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n5, bitSource.readBits(8), nArray);
            for (n5 = 0; n5 < 3; ++n5) {
                int n6 = nArray[n5];
                if (n6 == 0) {
                    stringBuilder.append('\r');
                    continue;
                }
                if (n6 == 1) {
                    stringBuilder.append('*');
                    continue;
                }
                if (n6 == 2) {
                    stringBuilder.append('>');
                    continue;
                }
                if (n6 == 3) {
                    stringBuilder.append(' ');
                    continue;
                }
                if (n6 < 14) {
                    stringBuilder.append((char)(n6 + 44));
                    continue;
                }
                if (n6 < 40) {
                    stringBuilder.append((char)(n6 + 51));
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (bitSource.available() > 0);
    }

    private static void parseTwoBytes(int n5, int n6, int[] nArray) {
        int n7 = (n5 << 8) + n6 - 1;
        nArray[0] = n5 = n7 / 1600;
        int n8 = n7 - n5 * 1600;
        nArray[1] = n5 = n8 / 40;
        nArray[2] = n8 - n5 * 40;
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i5 = 0; i5 < 4; ++i5) {
                int n5 = bitSource.readBits(6);
                if (n5 == 31) {
                    int n6 = 8 - bitSource.getBitOffset();
                    if (n6 != 8) {
                        bitSource.readBits(n6);
                    }
                    return;
                }
                if ((n5 & 0x20) == 0) {
                    n5 |= 0x40;
                }
                stringBuilder.append((char)n5);
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeBase256Segment(BitSource object, StringBuilder stringBuilder, Collection<byte[]> collection) throws FormatException {
        int n5;
        BitSource bitSource = object;
        int n6 = bitSource.getByteOffset();
        int n7 = n5 = n6 + 1;
        n5 = n6 + 2;
        int n8 = DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n7);
        if (n8 == 0) {
            n8 = ((BitSource)object).available() / 8;
        } else if (n8 >= 250) {
            int n9 = n5;
            n5 = n6 + 3;
            n8 = (n8 - 249) * 250 + DecodedBitStreamParser.unrandomize255State(((BitSource)object).readBits(8), n9);
        }
        if (n8 >= 0) {
            String string2;
            byte[] byArray = new byte[n8];
            for (int i5 = 0; i5 < n8; ++i5) {
                if (((BitSource)object).available() >= 8) {
                    byArray[i5] = (byte)DecodedBitStreamParser.unrandomize255State(((BitSource)object).readBits(8), n5++);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            collection.add(byArray);
            object = string2;
            try {
                string2 = new String(byArray, "ISO8859_1");
                stringBuilder.append((String)object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("Platform does not support required encoding: " + unsupportedEncodingException);
            }
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static int unrandomize255State(int n5, int n6) {
        if ((n5 -= n6 * 149 % 255 + 1) < 0) {
            n5 += 256;
        }
        return n5;
    }

    static {
        char[] cArray = new char[40];
        char[] cArray2 = cArray;
        cArray[0] = 42;
        cArray2[1] = 42;
        cArray2[2] = 42;
        cArray2[3] = 32;
        cArray2[4] = 48;
        cArray2[5] = 49;
        cArray2[6] = 50;
        cArray2[7] = 51;
        cArray2[8] = 52;
        cArray2[9] = 53;
        cArray2[10] = 54;
        cArray2[11] = 55;
        cArray2[12] = 56;
        cArray2[13] = 57;
        cArray2[14] = 65;
        cArray2[15] = 66;
        cArray2[16] = 67;
        cArray2[17] = 68;
        cArray2[18] = 69;
        cArray2[19] = 70;
        cArray2[20] = 71;
        cArray2[21] = 72;
        cArray2[22] = 73;
        cArray2[23] = 74;
        cArray2[24] = 75;
        cArray2[25] = 76;
        cArray2[26] = 77;
        cArray2[27] = 78;
        cArray2[28] = 79;
        cArray2[29] = 80;
        cArray2[30] = 81;
        cArray2[31] = 82;
        cArray2[32] = 83;
        cArray2[33] = 84;
        cArray2[34] = 85;
        cArray2[35] = 86;
        cArray2[36] = 87;
        cArray2[37] = 88;
        cArray2[38] = 89;
        cArray2[39] = 90;
        C40_BASIC_SET_CHARS = cArray2;
        char[] cArray3 = new char[27];
        cArray2 = cArray3;
        cArray3[0] = 33;
        cArray2[1] = 34;
        cArray2[2] = 35;
        cArray2[3] = 36;
        cArray2[4] = 37;
        cArray2[5] = 38;
        cArray2[6] = 39;
        cArray2[7] = 40;
        cArray2[8] = 41;
        cArray2[9] = 42;
        cArray2[10] = 43;
        cArray2[11] = 44;
        cArray2[12] = 45;
        cArray2[13] = 46;
        cArray2[14] = 47;
        cArray2[15] = 58;
        cArray2[16] = 59;
        cArray2[17] = 60;
        cArray2[18] = 61;
        cArray2[19] = 62;
        cArray2[20] = 63;
        cArray2[21] = 64;
        cArray2[22] = 91;
        cArray2[23] = 92;
        cArray2[24] = 93;
        cArray2[25] = 94;
        cArray2[26] = 95;
        C40_SHIFT2_SET_CHARS = cArray2;
        char[] cArray4 = new char[40];
        char[] cArray5 = cArray4;
        cArray4[0] = 42;
        cArray5[1] = 42;
        cArray5[2] = 42;
        cArray5[3] = 32;
        cArray5[4] = 48;
        cArray5[5] = 49;
        cArray5[6] = 50;
        cArray5[7] = 51;
        cArray5[8] = 52;
        cArray5[9] = 53;
        cArray5[10] = 54;
        cArray5[11] = 55;
        cArray5[12] = 56;
        cArray5[13] = 57;
        cArray5[14] = 97;
        cArray5[15] = 98;
        cArray5[16] = 99;
        cArray5[17] = 100;
        cArray5[18] = 101;
        cArray5[19] = 102;
        cArray5[20] = 103;
        cArray5[21] = 104;
        cArray5[22] = 105;
        cArray5[23] = 106;
        cArray5[24] = 107;
        cArray5[25] = 108;
        cArray5[26] = 109;
        cArray5[27] = 110;
        cArray5[28] = 111;
        cArray5[29] = 112;
        cArray5[30] = 113;
        cArray5[31] = 114;
        cArray5[32] = 115;
        cArray5[33] = 116;
        cArray5[34] = 117;
        cArray5[35] = 118;
        cArray5[36] = 119;
        cArray5[37] = 120;
        cArray5[38] = 121;
        cArray5[39] = 122;
        TEXT_BASIC_SET_CHARS = cArray5;
        TEXT_SHIFT2_SET_CHARS = cArray2;
        char[] cArray6 = new char[32];
        cArray2 = cArray6;
        cArray6[0] = 96;
        cArray2[1] = 65;
        cArray2[2] = 66;
        cArray2[3] = 67;
        cArray2[4] = 68;
        cArray2[5] = 69;
        cArray2[6] = 70;
        cArray2[7] = 71;
        cArray2[8] = 72;
        cArray2[9] = 73;
        cArray2[10] = 74;
        cArray2[11] = 75;
        cArray2[12] = 76;
        cArray2[13] = 77;
        cArray2[14] = 78;
        cArray2[15] = 79;
        cArray2[16] = 80;
        cArray2[17] = 81;
        cArray2[18] = 82;
        cArray2[19] = 83;
        cArray2[20] = 84;
        cArray2[21] = 85;
        cArray2[22] = 86;
        cArray2[23] = 87;
        cArray2[24] = 88;
        cArray2[25] = 89;
        cArray2[26] = 90;
        cArray2[27] = 123;
        cArray2[28] = 124;
        cArray2[29] = 125;
        cArray2[30] = 126;
        cArray2[31] = 127;
        TEXT_SHIFT3_SET_CHARS = cArray2;
    }

    private static enum Mode {
        PAD_ENCODE,
        ASCII_ENCODE,
        C40_ENCODE,
        TEXT_ENCODE,
        ANSIX12_ENCODE,
        EDIFACT_ENCODE,
        BASE256_ENCODE;

    }
}

