/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.common.GridSampler;
import com.dcloud.zxing2.common.detector.MathUtils;
import com.dcloud.zxing2.common.detector.WhiteRectangleDetector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Detector {
    private final BitMatrix image;
    private final WhiteRectangleDetector rectangleDetector;

    public Detector(BitMatrix bitMatrix) throws NotFoundException {
        WhiteRectangleDetector whiteRectangleDetector;
        ((Detector)((Object)whiteRectangleDetector2)).image = bitMatrix;
        WhiteRectangleDetector whiteRectangleDetector2 = whiteRectangleDetector;
        whiteRectangleDetector = new WhiteRectangleDetector(bitMatrix);
        v1.rectangleDetector = whiteRectangleDetector2;
    }

    private ResultPoint correctTopRightRectangular(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n5, int n6) {
        ResultPoint resultPoint5;
        ResultPoint resultPoint6;
        ResultPoint resultPoint7 = resultPoint4;
        float f5 = (float)Detector.distance(resultPoint, resultPoint2) / (float)n5;
        int n7 = Detector.distance(resultPoint3, resultPoint4);
        float f6 = n7;
        float f7 = (resultPoint7.getX() - resultPoint3.getX()) / f6;
        f6 = (resultPoint7.getY() - resultPoint3.getY()) / f6;
        ResultPoint resultPoint8 = resultPoint6;
        resultPoint6 = new ResultPoint(resultPoint4.getX() + f5 * f7, resultPoint4.getY() + f5 * f6);
        f5 = (float)Detector.distance(resultPoint, resultPoint3) / (float)n6;
        int n8 = Detector.distance(resultPoint2, resultPoint4);
        ResultPoint resultPoint9 = resultPoint4;
        float f8 = n8;
        f7 = (resultPoint9.getX() - resultPoint2.getX()) / f8;
        f8 = (resultPoint9.getY() - resultPoint2.getY()) / f8;
        ResultPoint resultPoint10 = resultPoint5;
        resultPoint5 = new ResultPoint(resultPoint4.getX() + f5 * f7, resultPoint4.getY() + f5 * f8);
        if (!this.isValid(resultPoint8)) {
            if (this.isValid(resultPoint10)) {
                return resultPoint10;
            }
            return null;
        }
        if (!this.isValid(resultPoint10)) {
            return resultPoint8;
        }
        if (Math.abs(n5 - this.transitionsBetween(resultPoint3, resultPoint8).getTransitions()) + Math.abs(n6 - this.transitionsBetween(resultPoint2, resultPoint8).getTransitions()) <= Math.abs(n5 - this.transitionsBetween(resultPoint3, resultPoint10).getTransitions()) + Math.abs(n6 - this.transitionsBetween(resultPoint2, resultPoint10).getTransitions())) {
            return resultPoint8;
        }
        return resultPoint10;
    }

    private ResultPoint correctTopRight(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n5) {
        ResultPoint resultPoint5;
        ResultPoint resultPoint6;
        ResultPoint resultPoint7 = resultPoint4;
        float f5 = n5;
        float f6 = (float)Detector.distance(resultPoint, resultPoint2) / f5;
        int n6 = Detector.distance(resultPoint3, resultPoint4);
        float f7 = n6;
        float f8 = (resultPoint7.getX() - resultPoint3.getX()) / f7;
        f7 = (resultPoint7.getY() - resultPoint3.getY()) / f7;
        ResultPoint resultPoint8 = resultPoint6;
        resultPoint6 = new ResultPoint(resultPoint4.getX() + f6 * f8, resultPoint4.getY() + f6 * f7);
        f5 = (float)Detector.distance(resultPoint, resultPoint3) / f5;
        int n7 = Detector.distance(resultPoint2, resultPoint4);
        ResultPoint resultPoint9 = resultPoint4;
        float f9 = n7;
        f7 = (resultPoint9.getX() - resultPoint2.getX()) / f9;
        f9 = (resultPoint9.getY() - resultPoint2.getY()) / f9;
        ResultPoint resultPoint10 = resultPoint5;
        resultPoint5 = new ResultPoint(resultPoint4.getX() + f5 * f7, resultPoint4.getY() + f5 * f9);
        if (!this.isValid(resultPoint8)) {
            if (this.isValid(resultPoint10)) {
                return resultPoint10;
            }
            return null;
        }
        if (!this.isValid(resultPoint10)) {
            return resultPoint8;
        }
        if (Math.abs(this.transitionsBetween(resultPoint3, resultPoint8).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint8).getTransitions()) > Math.abs(this.transitionsBetween(resultPoint3, resultPoint10).getTransitions() - this.transitionsBetween(resultPoint2, resultPoint10).getTransitions())) {
            resultPoint8 = resultPoint10;
        }
        return resultPoint8;
    }

    private boolean isValid(ResultPoint resultPoint) {
        return resultPoint.getX() >= 0.0f && resultPoint.getX() < (float)this.image.getWidth() && resultPoint.getY() > 0.0f && resultPoint.getY() < (float)this.image.getHeight();
    }

    private static int distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2));
    }

    private static void increment(Map<ResultPoint, Integer> map, ResultPoint resultPoint) {
        Integer n5 = map.get(resultPoint);
        n5 = n5 == null ? 1 : n5 + 1;
        map.put(resultPoint, n5);
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n5, int n6) throws NotFoundException {
        ResultPoint resultPoint5 = resultPoint2;
        ResultPoint resultPoint6 = resultPoint3;
        ResultPoint resultPoint7 = resultPoint4;
        ResultPoint resultPoint8 = resultPoint;
        float f5 = (float)n5 - 0.5f;
        float f6 = (float)n6 - 0.5f;
        float f7 = resultPoint8.getX();
        float f8 = resultPoint8.getY();
        float f9 = resultPoint7.getX();
        float f10 = resultPoint7.getY();
        float f11 = resultPoint6.getX();
        float f12 = resultPoint6.getY();
        float f13 = resultPoint5.getX();
        float f14 = resultPoint5.getY();
        return GridSampler.getInstance().sampleGrid(bitMatrix, n5, n6, 0.5f, 0.5f, f5, 0.5f, f5, f6, 0.5f, f6, f7, f8, f9, f10, f11, f12, f13, f14);
    }

    private ResultPointsAndTransitions transitionsBetween(ResultPoint resultPoint, ResultPoint resultPoint2) {
        ResultPoint resultPoint3 = resultPoint2;
        ResultPoint resultPoint4 = resultPoint;
        int n5 = (int)resultPoint4.getX();
        int n6 = (int)resultPoint4.getY();
        int n7 = (int)resultPoint3.getX();
        int n8 = (int)resultPoint3.getY();
        boolean bl = Math.abs(n8 - n6) > Math.abs(n7 - n5);
        if (bl) {
            int n9 = n8;
            int n10 = n6;
            n6 = n5;
            n8 = n7;
            n5 = n10;
            n7 = n9;
        }
        int n11 = n8;
        int n12 = Math.abs(n7 - n5);
        int n13 = Math.abs(n11 - n6);
        int n14 = -n12 / 2;
        int n15 = n6 < n11 ? 1 : -1;
        int n16 = n5 < n7 ? 1 : -1;
        int n17 = 0;
        BitMatrix bitMatrix = this.image;
        int n18 = bl ? n6 : n5;
        int n19 = bl ? n5 : n6;
        int n20 = bitMatrix.get(n18, n19);
        while (n5 != n7) {
            BitMatrix bitMatrix2 = this.image;
            n19 = bl ? n6 : n5;
            int n21 = bl ? n5 : n6;
            int n22 = bitMatrix2.get(n19, n21);
            n18 = n22;
            if (n22 != n20) {
                ++n17;
                n20 = n18;
            }
            if ((n14 += n13) > 0) {
                if (n6 == n8) break;
                n6 += n15;
                n14 -= n12;
            }
            n5 += n16;
        }
        return new ResultPointsAndTransitions(resultPoint, resultPoint2, n17);
    }

    public DetectorResult detect() throws NotFoundException {
        HashMap<ResultPoint, Integer> hashMap;
        ArrayList<ResultPointsAndTransitions> arrayList;
        ResultPoint[] resultPointArray = ((Detector)object3).rectangleDetector.detect();
        ResultPoint resultPoint = resultPointArray[0];
        ResultPoint resultPoint2 = resultPointArray[1];
        ResultPoint resultPoint3 = resultPointArray[2];
        ResultPoint resultPoint4 = resultPointArray[3];
        Object object = arrayList;
        ((ArrayList)object)(4);
        object.add(((Detector)object3).transitionsBetween(resultPoint, resultPoint2));
        object.add(((Detector)object3).transitionsBetween(resultPoint, resultPoint3));
        object.add(((Detector)object3).transitionsBetween(resultPoint2, resultPoint4));
        arrayList.add(((Detector)object3).transitionsBetween(resultPoint3, resultPoint4));
        Collections.sort(arrayList, new ResultPointsAndTransitionsComparator());
        object = (ResultPointsAndTransitions)arrayList.get(0);
        Object object2 = (ResultPointsAndTransitions)arrayList.get(1);
        HashMap<ResultPoint, Integer> hashMap2 = hashMap;
        hashMap2();
        Detector.increment(hashMap2, ((ResultPointsAndTransitions)object).getFrom());
        Detector.increment(hashMap2, ((ResultPointsAndTransitions)object).getTo());
        Detector.increment(hashMap2, ((ResultPointsAndTransitions)object2).getFrom());
        Detector.increment(hashMap, ((ResultPointsAndTransitions)object2).getTo());
        object = null;
        object2 = null;
        ResultPoint resultPoint5 = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            ResultPoint resultPoint6 = (ResultPoint)entry.getKey();
            if ((Integer)entry.getValue() == 2) {
                object2 = resultPoint6;
                continue;
            }
            if (object == null) {
                object = resultPoint6;
                continue;
            }
            resultPoint5 = resultPoint6;
        }
        if (object != null && object2 != null && resultPoint5 != null) {
            Object object3;
            int n5;
            ResultPoint[] resultPointArray2 = new ResultPoint[]{object, object2, resultPoint5};
            ResultPoint.orderBestPatterns(resultPointArray2);
            object = resultPointArray2[0];
            object2 = resultPointArray2[1];
            resultPoint5 = resultPointArray2[2];
            if (hashMap2.containsKey(resultPoint)) {
                resultPoint = !hashMap2.containsKey(resultPoint2) ? resultPoint2 : (!hashMap2.containsKey(resultPoint3) ? resultPoint3 : resultPoint4);
            }
            int n6 = ((Detector)object3).transitionsBetween(resultPoint5, resultPoint).getTransitions();
            int n7 = ((Detector)object3).transitionsBetween((ResultPoint)object, resultPoint).getTransitions();
            if ((n6 & 1) == 1) {
                ++n6;
            }
            n6 += 2;
            if ((n7 & 1) == 1) {
                ++n7;
            }
            if (n6 * 4 < (n7 += 2) * 7 && n7 * 4 < n6 * 7) {
                ResultPoint resultPoint7 = ((Detector)object3).correctTopRight((ResultPoint)object2, (ResultPoint)object, resultPoint5, resultPoint, n6 = Math.min(n7, n6));
                if (resultPoint7 != null) {
                    resultPoint = resultPoint7;
                }
                n5 = Math.max(((Detector)object3).transitionsBetween(resultPoint5, resultPoint).getTransitions(), ((Detector)object3).transitionsBetween((ResultPoint)object, resultPoint).getTransitions());
                n7 = n5 + 1;
                if ((n7 & 1) == 1) {
                    n7 = n5 + 2;
                }
                int n8 = n7;
                object3 = Detector.sampleGrid(((Detector)object3).image, resultPoint5, (ResultPoint)object2, (ResultPoint)object, resultPoint, n8, n8);
            } else {
                ResultPoint resultPoint8 = ((Detector)object3).correctTopRightRectangular((ResultPoint)object2, (ResultPoint)object, resultPoint5, resultPoint, n6, n7);
                if (resultPoint8 != null) {
                    resultPoint = resultPoint8;
                }
                n5 = ((Detector)object3).transitionsBetween(resultPoint5, resultPoint).getTransitions();
                n7 = ((Detector)object3).transitionsBetween((ResultPoint)object, resultPoint).getTransitions();
                if ((n5 & 1) == 1) {
                    ++n5;
                }
                if ((n7 & 1) == 1) {
                    ++n7;
                }
                object3 = Detector.sampleGrid(((Detector)object3).image, resultPoint5, (ResultPoint)object2, (ResultPoint)object, resultPoint, n5, n7);
            }
            ResultPoint[] resultPointArray3 = new ResultPoint[4];
            ResultPoint[] resultPointArray4 = resultPointArray3;
            resultPointArray3[0] = resultPoint5;
            resultPointArray3[1] = object2;
            resultPointArray3[2] = object;
            resultPointArray3[3] = resultPoint;
            return new DetectorResult((BitMatrix)object3, resultPointArray4);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static final class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        private ResultPointsAndTransitions(ResultPoint resultPoint, ResultPoint resultPoint2, int n5) {
            this.from = resultPoint;
            this.to = resultPoint2;
            this.transitions = n5;
        }

        ResultPoint getFrom() {
            return this.from;
        }

        ResultPoint getTo() {
            return this.to;
        }

        public int getTransitions() {
            return this.transitions;
        }

        public String toString() {
            return this.from + "/" + this.to + '/' + this.transitions;
        }
    }

    private static final class ResultPointsAndTransitionsComparator
    implements Comparator<ResultPointsAndTransitions>,
    Serializable {
        private ResultPointsAndTransitionsComparator() {
        }

        @Override
        public int compare(ResultPointsAndTransitions resultPointsAndTransitions, ResultPointsAndTransitions resultPointsAndTransitions2) {
            return resultPointsAndTransitions.getTransitions() - resultPointsAndTransitions2.getTransitions();
        }
    }
}

