/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.Dimension;
import com.dcloud.zxing2.datamatrix.encoder.SymbolInfo;
import com.dcloud.zxing2.datamatrix.encoder.SymbolShapeHint;
import java.nio.charset.Charset;

final class EncoderContext {
    private final String msg;
    private SymbolShapeHint shape;
    private Dimension minSize;
    private Dimension maxSize;
    private final StringBuilder codewords;
    int pos;
    private int newEncoding;
    private SymbolInfo symbolInfo;
    private int skipAtEnd;

    EncoderContext(String string2) {
        StringBuilder stringBuilder;
        byte[] byArray = string2.getBytes(Charset.forName("ISO-8859-1"));
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length);
        int n5 = byArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            char c6 = (char)(byArray[i5] & 0xFF);
            if (c6 == '?' && string2.charAt(i5) != '?') {
                throw new IllegalArgumentException("Message contains characters outside ISO-8859-1 encoding.");
            }
            stringBuilder2.append(c6);
        }
        EncoderContext encoderContext = this;
        encoderContext.msg = stringBuilder2.toString();
        encoderContext.shape = SymbolShapeHint.FORCE_NONE;
        encoderContext.codewords = new StringBuilder(string2.length());
        encoderContext.newEncoding = -1;
    }

    private int getTotalMessageCharCount() {
        return this.msg.length() - this.skipAtEnd;
    }

    public void setSymbolShape(SymbolShapeHint symbolShapeHint) {
        this.shape = symbolShapeHint;
    }

    public void setSizeConstraints(Dimension dimension, Dimension dimension2) {
        EncoderContext encoderContext = this;
        encoderContext.minSize = dimension;
        encoderContext.maxSize = dimension2;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setSkipAtEnd(int n5) {
        this.skipAtEnd = n5;
    }

    public char getCurrentChar() {
        return this.msg.charAt(this.pos);
    }

    public char getCurrent() {
        return this.msg.charAt(this.pos);
    }

    public StringBuilder getCodewords() {
        return this.codewords;
    }

    public void writeCodewords(String string2) {
        this.codewords.append(string2);
    }

    public void writeCodeword(char c6) {
        this.codewords.append(c6);
    }

    public int getCodewordCount() {
        return this.codewords.length();
    }

    public int getNewEncoding() {
        return this.newEncoding;
    }

    public void signalEncoderChange(int n5) {
        this.newEncoding = n5;
    }

    public void resetEncoderSignal() {
        this.newEncoding = -1;
    }

    public boolean hasMoreCharacters() {
        return this.pos < this.getTotalMessageCharCount();
    }

    public int getRemainingCharacters() {
        return this.getTotalMessageCharCount() - this.pos;
    }

    public SymbolInfo getSymbolInfo() {
        return this.symbolInfo;
    }

    public void updateSymbolInfo() {
        EncoderContext encoderContext = this;
        encoderContext.updateSymbolInfo(encoderContext.getCodewordCount());
    }

    public void updateSymbolInfo(int n5) {
        Object object = object2.symbolInfo;
        if (object == null || n5 > ((SymbolInfo)object).getDataCapacity()) {
            EncoderContext encoderContext = object2;
            EncoderContext encoderContext2 = object2;
            Object object2 = encoderContext2.shape;
            Dimension dimension = encoderContext2.minSize;
            object = encoderContext2.maxSize;
            encoderContext.symbolInfo = SymbolInfo.lookup(n5, (SymbolShapeHint)((Object)object2), dimension, (Dimension)object, true);
        }
    }

    public void resetSymbolInfo() {
        this.symbolInfo = null;
    }
}

