/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.maxicode.decoder;

import com.dcloud.zxing2.common.DecoderResult;
import java.text.DecimalFormat;
import java.text.NumberFormat;

final class DecodedBitStreamParser {
    private static final char SHIFTA = '\ufff0';
    private static final char SHIFTB = '\ufff1';
    private static final char SHIFTC = '\ufff2';
    private static final char SHIFTD = '\ufff3';
    private static final char SHIFTE = '\ufff4';
    private static final char TWOSHIFTA = '\ufff5';
    private static final char THREESHIFTA = '\ufff6';
    private static final char LATCHA = '\ufff7';
    private static final char LATCHB = '\ufff8';
    private static final char LOCK = '\ufff9';
    private static final char ECI = '\ufffa';
    private static final char NS = '\ufffb';
    private static final char PAD = '\ufffc';
    private static final char FS = '\u001c';
    private static final char GS = '\u001d';
    private static final char RS = '\u001e';
    private static final NumberFormat NINE_DIGITS = new DecimalFormat("000000000");
    private static final NumberFormat THREE_DIGITS = new DecimalFormat("000");
    private static final String[] SETS = new String[]{"\nABCDEFGHIJKLMNOPQRSTUVWXYZ\ufffa\u001c\u001d\u001e\ufffb \ufffc\"#$%&'()*+,-./0123456789:\ufff1\ufff2\ufff3\ufff4\ufff8", "`abcdefghijklmnopqrstuvwxyz\ufffa\u001c\u001d\u001e\ufffb{\ufffc}~\u007f;<=>?[\\]^_ ,./:@!|\ufffc\ufff5\ufff6\ufffc\ufff0\ufff2\ufff3\ufff4\ufff7", "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\ufffa\u001c\u001d\u001e\u00db\u00dc\u00dd\u00de\u00df\u00aa\u00ac\u00b1\u00b2\u00b3\u00b5\u00b9\u00ba\u00bc\u00bd\u00be\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\ufff7 \ufff9\ufff3\ufff4\ufff8", "\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\ufffa\u001c\u001d\u001e\ufffb\u00fb\u00fc\u00fd\u00fe\u00ff\u00a1\u00a8\u00ab\u00af\u00b0\u00b4\u00b7\u00b8\u00bb\u00bf\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\ufff7 \ufff2\ufff9\ufff4\ufff8", "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\ufffa\ufffc\ufffc\u001b\ufffb\u001c\u001d\u001e\u001f\u009f\u00a0\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a9\u00ad\u00ae\u00b6\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\ufff7 \ufff2\ufff3\ufff9\ufff8", "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?"};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray, int n5) {
        StringBuilder stringBuilder;
        CharSequence charSequence = stringBuilder;
        stringBuilder = new StringBuilder(144);
        switch (n5) {
            default: {
                break;
            }
            case 5: {
                ((StringBuilder)charSequence).append(DecodedBitStreamParser.getMessage(byArray, 1, 77));
                break;
            }
            case 4: {
                ((StringBuilder)charSequence).append(DecodedBitStreamParser.getMessage(byArray, 1, 93));
                break;
            }
            case 2: 
            case 3: {
                String string2;
                if (n5 == 2) {
                    int n6 = DecodedBitStreamParser.getPostCode2(byArray);
                    n6 = DecodedBitStreamParser.getPostCode2Length(byArray);
                    string2 = new DecimalFormat("0000000000".substring(0, n6)).format(n6);
                } else {
                    string2 = DecodedBitStreamParser.getPostCode3(byArray);
                }
                StringBuilder stringBuilder2 = charSequence;
                NumberFormat numberFormat = THREE_DIGITS;
                String string3 = numberFormat.format(DecodedBitStreamParser.getCountry(byArray));
                String string4 = numberFormat.format(DecodedBitStreamParser.getServiceClass(byArray));
                stringBuilder2.append(DecodedBitStreamParser.getMessage(byArray, 10, 84));
                if (stringBuilder2.toString().startsWith("[)>\u001e01\u001d")) {
                    ((StringBuilder)charSequence).insert(9, string2 + '\u001d' + string3 + '\u001d' + string4 + '\u001d');
                    break;
                }
                ((StringBuilder)charSequence).insert(0, string2 + '\u001d' + string3 + '\u001d' + string4 + '\u001d');
            }
        }
        String string5 = ((StringBuilder)charSequence).toString();
        charSequence = String.valueOf(n5);
        return new DecoderResult(byArray, string5, null, (String)charSequence);
    }

    private static int getBit(int n5, byte[] byArray) {
        return (byArray[(n5 += -1) / 6] & 1 << 5 - n5 % 6) == 0 ? 0 : 1;
    }

    private static int getInt(byte[] byArray, byte[] byArray2) {
        if (byArray2.length != 0) {
            int n5 = 0;
            for (int i5 = 0; i5 < byArray2.length; ++i5) {
                n5 += DecodedBitStreamParser.getBit(byArray2[i5], byArray) << byArray2.length - i5 - 1;
            }
            return n5;
        }
        throw new IllegalArgumentException();
    }

    private static int getCountry(byte[] byArray) {
        return DecodedBitStreamParser.getInt(byArray, new byte[]{53, 54, 43, 44, 45, 46, 47, 48, 37, 38});
    }

    private static int getServiceClass(byte[] byArray) {
        return DecodedBitStreamParser.getInt(byArray, new byte[]{55, 56, 57, 58, 59, 60, 49, 50, 51, 52});
    }

    private static int getPostCode2Length(byte[] byArray) {
        return DecodedBitStreamParser.getInt(byArray, new byte[]{39, 40, 41, 42, 31, 32});
    }

    private static int getPostCode2(byte[] byArray) {
        byte[] byArray2 = byArray;
        byte[] byArray3 = new byte[30];
        byArray = byArray3;
        byArray3[0] = 33;
        byArray[1] = 34;
        byArray[2] = 35;
        byArray[3] = 36;
        byArray[4] = 25;
        byArray[5] = 26;
        byArray[6] = 27;
        byArray[7] = 28;
        byArray[8] = 29;
        byArray[9] = 30;
        byArray[10] = 19;
        byArray[11] = 20;
        byArray[12] = 21;
        byArray[13] = 22;
        byArray[14] = 23;
        byArray[15] = 24;
        byArray[16] = 13;
        byArray[17] = 14;
        byArray[18] = 15;
        byArray[19] = 16;
        byArray[20] = 17;
        byArray[21] = 18;
        byArray[22] = 7;
        byArray[23] = 8;
        byArray[24] = 9;
        byArray[25] = 10;
        byArray[26] = 11;
        byArray[27] = 12;
        byArray[28] = 1;
        byArray[29] = 2;
        return DecodedBitStreamParser.getInt(byArray2, byArray);
    }

    private static String getPostCode3(byte[] byArray) {
        char c6 = SETS[0].charAt(DecodedBitStreamParser.getInt(byArray, new byte[]{39, 40, 41, 42, 31, 32}));
        char c7 = SETS[0].charAt(DecodedBitStreamParser.getInt(byArray, new byte[]{33, 34, 35, 36, 25, 26}));
        char c8 = SETS[0].charAt(DecodedBitStreamParser.getInt(byArray, new byte[]{27, 28, 29, 30, 19, 20}));
        char c9 = SETS[0].charAt(DecodedBitStreamParser.getInt(byArray, new byte[]{21, 22, 23, 24, 13, 14}));
        char c10 = SETS[0].charAt(DecodedBitStreamParser.getInt(byArray, new byte[]{15, 16, 17, 18, 7, 8}));
        char c11 = SETS[0].charAt(DecodedBitStreamParser.getInt(byArray, new byte[]{9, 10, 11, 12, 1, 2}));
        return String.valueOf(new char[]{c6, c7, c8, c9, c10, c11});
    }

    private static String getMessage(byte[] byArray, int n5, int n6) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        for (int i5 = n5; i5 < n5 + n6; ++i5) {
            char c6 = SETS[n8].charAt(byArray[i5]);
            switch (c6) {
                default: {
                    stringBuilder2.append(c6);
                    break;
                }
                case '\ufffb': {
                    stringBuilder2.append(NINE_DIGITS.format((byArray[i5 + 1] << 24) + (byArray[i5 + 2] << 18) + (byArray[i5 + 3] << 12) + (byArray[i5 + 4] << 6) + byArray[i5 += 5]));
                    break;
                }
                case '\ufff9': {
                    n7 = -1;
                    break;
                }
                case '\ufff8': {
                    n8 = 1;
                    n7 = -1;
                    break;
                }
                case '\ufff7': {
                    n8 = 0;
                    n7 = -1;
                    break;
                }
                case '\ufff6': {
                    n7 = 0;
                    int n10 = n9 = 3;
                    int n11 = n8;
                    n8 = n7;
                    n9 = n11;
                    n7 = n10;
                    break;
                }
                case '\ufff5': {
                    n7 = 0;
                    int n12 = n9 = 2;
                    int n13 = n8;
                    n8 = n7;
                    n9 = n13;
                    n7 = n12;
                    break;
                }
                case '\ufff0': 
                case '\ufff1': 
                case '\ufff2': 
                case '\ufff3': 
                case '\ufff4': {
                    n7 = c6 - 65520;
                    int n14 = n9 = 1;
                    int n15 = n8;
                    n8 = n7;
                    n9 = n15;
                    n7 = n14;
                }
            }
            int n16 = n7;
            n7 = n16 + -1;
            if (n16 != 0) continue;
            n8 = n9;
        }
        while (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3.charAt(stringBuilder3.length() - 1) != '\ufffc') break;
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.setLength(stringBuilder4.length() - 1);
        }
        return stringBuilder2.toString();
    }
}

